/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.protocols.snmp.AsnObjectIdentifier;
import com.avocent.protocols.snmp.MibConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class MibNode
implements Comparable {
    public static final int ROOT_ID = Integer.MIN_VALUE;
    public static final int TYPE_NODE = 0;
    public static final int TYPE_INTEGER = 1;
    public static final int TYPE_FLOAT = 2;
    public static final int TYPE_BYTE_ARRAY = 3;
    public static final int TYPE_SEQUENCE = 4;
    public static final int TYPE_SEQUENCE_OF_TYPE = 5;
    public static final int TYPE_ASCII_STRING = 6;
    public static final int TYPE_UTF8_STRING = 7;
    public static final int TYPE_IP_ADDRESS = 8;
    public static final int TYPE_MAC_ADDRESS = 9;
    public static final int TYPE_OTHER = 255;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_OPTIONAL = 1;
    public static final int STATUS_MANDATORY = 2;
    public static final int STATUS_CURRENT = 3;
    public static final int STATUS_DEPRECATED = 4;
    public static final int STATUS_OBSOLETE = 5;
    private static final LinkedHashMap ROOT_LOOKUP_CACHE = new LinkedHashMap(100, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 100;
        }
    };
    private static final MibNode MIB_ROOT = new MibNode();
    private static final Map STANDARD_OIDS;
    private MibNode m_parent = null;
    private Map m_mibs = new HashMap();
    private boolean m_bLoadedMultiple = false;
    private String m_szName = null;
    private String m_szDescription = null;
    private int m_nId;
    private int m_nType = 0;
    private Set m_children = new TreeSet();
    private Map m_symbols = new TreeMap();
    private Set m_constraints = new HashSet();
    private List m_indicies = new ArrayList();
    private int m_nStatus = 0;
    private boolean m_bReadable = false;
    private boolean m_bWriteable = false;
    private String m_szTypeSymbol = null;

    private MibNode() {
        this.m_nId = Integer.MIN_VALUE;
    }

    MibNode(int n) {
        this.m_nId = n;
        this.m_szName = "" + n;
    }

    public static MibNode getRoot() {
        return MIB_ROOT;
    }

    public static MibNode getNode(AsnObjectIdentifier asnObjectIdentifier) {
        return MibNode.getOrCreateNode(asnObjectIdentifier, false);
    }

    static MibNode createNode(AsnObjectIdentifier asnObjectIdentifier) {
        return MibNode.getOrCreateNode(asnObjectIdentifier, true);
    }

    private static MibNode getOrCreateNode(AsnObjectIdentifier asnObjectIdentifier, boolean bl) {
        int[] nArray = asnObjectIdentifier.getOidValue();
        MibNode mibNode = MibNode.getRoot();
        for (int i = 0; i < nArray.length; ++i) {
            MibNode mibNode2 = mibNode.getChild(nArray[i]);
            if (mibNode2 == null) {
                if (!bl) {
                    return null;
                }
                mibNode2 = new MibNode(nArray[i]);
                mibNode.addChild(mibNode2);
                String string = (String)STANDARD_OIDS.get(mibNode2.getOid().getStringValue());
                if (string != null) {
                    mibNode2.setName(string);
                }
                MibNode.invalidateCache();
            }
            mibNode = mibNode2;
        }
        return mibNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidateCache() {
        LinkedHashMap linkedHashMap = ROOT_LOOKUP_CACHE;
        synchronized (linkedHashMap) {
            ROOT_LOOKUP_CACHE.clear();
        }
    }

    void setType(int n) {
        this.m_nType = n;
    }

    void setDescription(String string) {
        this.m_szDescription = string;
    }

    void setTypeSymbol(String string) {
        this.m_szTypeSymbol = string;
    }

    void addChild(MibNode mibNode) {
        this.m_children.add(mibNode);
        mibNode.setParent(this);
    }

    void addSymbol(String string, Object object) {
        this.m_symbols.put(string, object);
    }

    void addConstraint(MibConstraint mibConstraint) {
        this.m_constraints.add(mibConstraint);
    }

    void addIndex(MibNode mibNode) {
        this.m_indicies.add(mibNode);
    }

    void setName(String string) {
        this.m_szName = string;
        MibNode.invalidateCache();
    }

    void addMib(String string, String string2) {
        this.m_mibs.put(string, string2);
    }

    void setStatus(int n) {
        this.m_nStatus = n;
    }

    void setReadable(boolean bl) {
        this.m_bReadable = bl;
    }

    void setWriteable(boolean bl) {
        this.m_bWriteable = bl;
    }

    private void setParent(MibNode mibNode) {
        this.m_parent = mibNode;
    }

    public String getTypeSymbol() {
        return this.m_szTypeSymbol;
    }

    public boolean isIndexed() {
        if (this.m_indicies.size() > 0) {
            return true;
        }
        MibNode mibNode = this.getParent();
        return mibNode != null && mibNode.isIndexed();
    }

    public boolean isLeaf() {
        int n = this.getType();
        return n != 0 && n != 5 && n != 4 && n != 255;
    }

    public int getSize() {
        int n = 1;
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            MibNode mibNode = (MibNode)iterator.next();
            n += mibNode.getSize();
        }
        return n;
    }

    public MibNode getChild(int n) {
        Iterator iterator = this.m_children.iterator();
        while (iterator.hasNext()) {
            MibNode mibNode = (MibNode)iterator.next();
            if (mibNode.getId() != n) continue;
            return mibNode;
        }
        return null;
    }

    public MibNode getChild(String string) {
        Iterator iterator = this.m_children.iterator();
        while (iterator.hasNext()) {
            MibNode mibNode = (MibNode)iterator.next();
            if (!mibNode.getName().equals(string) && !string.equals(mibNode.getId() + "")) continue;
            return mibNode;
        }
        return null;
    }

    public MibNode getParent() {
        return this.m_parent;
    }

    public Map getMibs() {
        return Collections.unmodifiableMap(this.m_mibs);
    }

    public String getName() {
        return this.m_szName;
    }

    public String getFullName() {
        MibNode mibNode = this.getParent();
        if (mibNode != null && mibNode.getId() != Integer.MIN_VALUE) {
            return mibNode.getFullName() + "." + this.getName();
        }
        return this.getName();
    }

    public int getId() {
        return this.m_nId;
    }

    public AsnObjectIdentifier getOid() {
        MibNode mibNode = this.getParent();
        if (mibNode == null) {
            return new AsnObjectIdentifier();
        }
        if (mibNode.getId() != Integer.MIN_VALUE) {
            int[] nArray = mibNode.getOid().getOidValue();
            int[] nArray2 = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray2[nArray2.length - 1] = this.getId();
            return new AsnObjectIdentifier(nArray2);
        }
        return new AsnObjectIdentifier(new int[]{this.getId()});
    }

    public Set getChildren() {
        return Collections.unmodifiableSet(this.m_children);
    }

    public String getDescription() {
        return this.m_szDescription;
    }

    public int getType() {
        return this.m_nType;
    }

    public int getStatus() {
        return this.m_nStatus;
    }

    public boolean isReadable() {
        return this.m_bReadable;
    }

    public boolean isWriteable() {
        return this.m_bWriteable;
    }

    public List getIndicies() {
        return Collections.unmodifiableList(this.m_indicies);
    }

    public Map getSymbols() {
        return Collections.unmodifiableMap(this.m_symbols);
    }

    public Set getConstraints() {
        return Collections.unmodifiableSet(this.m_constraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MibNode findChild(String string) {
        if (string.length() == 0) {
            return this;
        }
        LinkedHashMap linkedHashMap = ROOT_LOOKUP_CACHE;
        synchronized (linkedHashMap) {
            String string2 = "C" + this.getFullName() + "." + string;
            MibNode mibNode = (MibNode)ROOT_LOOKUP_CACHE.get(string2);
            if (!ROOT_LOOKUP_CACHE.containsKey(string2)) {
                mibNode = this.findNode(string, false);
                ROOT_LOOKUP_CACHE.put(string2, mibNode);
            }
            return mibNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MibNode findDescendent(String string) {
        if (string.length() == 0) {
            return this;
        }
        LinkedHashMap linkedHashMap = ROOT_LOOKUP_CACHE;
        synchronized (linkedHashMap) {
            String string2 = "D" + this.getFullName() + "." + string;
            MibNode mibNode = (MibNode)ROOT_LOOKUP_CACHE.get(string2);
            if (!ROOT_LOOKUP_CACHE.containsKey(string2)) {
                mibNode = this.findNode(string, true);
                ROOT_LOOKUP_CACHE.put(string2, mibNode);
            }
            return mibNode;
        }
    }

    private MibNode findNode(String string, boolean bl) {
        LinkedList<MibNode> linkedList = new LinkedList<MibNode>();
        int n = string.indexOf(91);
        if (n != -1) {
            string = string.substring(0, n);
        }
        MibNode mibNode = this;
        while (string.length() > 0) {
            n = string.indexOf(46);
            String string2 = string;
            if (n == -1) {
                string = "";
            } else {
                string2 = string2.substring(0, n);
                string = string.substring(n + 1);
            }
            linkedList.clear();
            linkedList.add(mibNode);
            MibNode mibNode2 = null;
            try {
                mibNode2 = mibNode.getChild(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            block3: while (linkedList.size() > 0 && mibNode2 == null) {
                MibNode mibNode3 = (MibNode)linkedList.removeFirst();
                Iterator iterator = mibNode3.getChildren().iterator();
                while (iterator.hasNext()) {
                    MibNode mibNode4 = (MibNode)iterator.next();
                    if (mibNode4.getName().equals(string2)) {
                        mibNode2 = mibNode4;
                        continue block3;
                    }
                    if (!bl) continue;
                    linkedList.addLast(mibNode4);
                }
            }
            if (mibNode2 == null) {
                return null;
            }
            mibNode = mibNode2;
        }
        return mibNode;
    }

    public MibNode findNodeIgnoreIndices(String string, boolean bl) {
        LinkedList<MibNode> linkedList = new LinkedList<MibNode>();
        int n = string.indexOf(91);
        if (n != -1) {
            string = string.substring(0, n);
        }
        MibNode mibNode = this;
        while (string.length() > 0) {
            n = string.indexOf(46);
            String string2 = string;
            if (n == -1) {
                string = "";
            } else {
                string2 = string2.substring(0, n);
                string = string.substring(n + 1);
            }
            linkedList.clear();
            linkedList.add(mibNode);
            MibNode mibNode2 = null;
            try {
                mibNode2 = mibNode.getChild(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            block3: while (linkedList.size() > 0 && mibNode2 == null) {
                MibNode mibNode3 = (MibNode)linkedList.removeFirst();
                if (mibNode3.isLeaf()) {
                    return mibNode3;
                }
                Iterator iterator = mibNode3.getChildren().iterator();
                while (iterator.hasNext()) {
                    MibNode mibNode4 = (MibNode)iterator.next();
                    if (mibNode4.getName().equals(string2)) {
                        mibNode2 = mibNode4;
                        continue block3;
                    }
                    if (!bl) continue;
                    linkedList.addLast(mibNode4);
                }
            }
            if (mibNode2 == null) {
                return null;
            }
            mibNode = mibNode2;
        }
        return mibNode;
    }

    public int compareTo(Object object) {
        MibNode mibNode = (MibNode)object;
        return this.getId() - mibNode.getId();
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        STANDARD_OIDS = Collections.unmodifiableMap(hashMap);
        hashMap.put("1", "iso");
        hashMap.put("1.3", "org");
        hashMap.put("1.3.6", "dod");
        hashMap.put("1.3.6.1", "internet");
        hashMap.put("1.3.6.1.4", "private");
        hashMap.put("1.3.6.1.4.1", "enterprises");
        hashMap.put("1.3.6.1.2", "mgmt");
    }
}

