/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.protocols.snmp.ByteArrayLengthMibConstraint;
import com.avocent.protocols.snmp.IntMibConstraint;
import com.avocent.protocols.snmp.IntRangeMibConstraint;
import com.avocent.protocols.snmp.MibNode;
import com.avocent.protocols.snmp.StringLengthMibConstraint;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;

public class MibXmlExporter {
    private boolean m_bDesc = true;
    private final StringBuffer sb = new StringBuffer();

    public void setExportDescriptions(boolean bl) {
        this.m_bDesc = bl;
    }

    public boolean getExportDescriptions() {
        return this.m_bDesc;
    }

    private String xmlEscape(String string) {
        this.sb.setLength(0);
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    this.sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    this.sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    this.sb.append("&quot;");
                    continue block7;
                }
                case '<': {
                    this.sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    this.sb.append("&gt;");
                    continue block7;
                }
                default: {
                    this.sb.append(c);
                }
            }
        }
        return this.sb.toString();
    }

    public void export(OutputStream outputStream) throws IOException {
        this.export(null, outputStream);
    }

    public synchronized void export(String string, OutputStream outputStream) throws IOException {
        MibNode mibNode = MibNode.getRoot();
        if (string != null) {
            mibNode = this.findRoot(mibNode, string);
        }
        if (mibNode == null) {
            return;
        }
        String string2 = (String)mibNode.getMibs().get(string);
        if (mibNode.getId() != Integer.MIN_VALUE) {
            mibNode = mibNode.getParent();
        }
        String string3 = "";
        if (mibNode.getId() != Integer.MIN_VALUE) {
            string3 = mibNode.getOid().getStringValue();
        }
        PrintStream printStream = new PrintStream(outputStream);
        printStream.println("<mib name=\"" + (string == null ? "GLOBAL" : this.xmlEscape(string)) + "\" rootOid=\"" + this.xmlEscape(string3) + "\" version=\"" + string2 + "\">");
        this.outputChildren("  ", string, mibNode, printStream);
        printStream.println("</mib>");
        printStream.flush();
    }

    private void outputNode(String string, String string2, MibNode mibNode, PrintStream printStream) throws IOException {
        Object object;
        Iterator<Object> iterator;
        String string3 = "other";
        switch (mibNode.getType()) {
            case 0: {
                string3 = "node";
                break;
            }
            case 1: {
                string3 = "int";
                break;
            }
            case 2: {
                string3 = "float";
                break;
            }
            case 3: {
                string3 = "byte[]";
                break;
            }
            case 6: {
                string3 = "ascii";
                break;
            }
            case 7: {
                string3 = "utf8";
                break;
            }
            case 8: {
                string3 = "ipAddress";
                break;
            }
            case 9: {
                string3 = "macAddress";
                break;
            }
            case 4: {
                string3 = "sequence";
            }
            case 5: {
                string3 = "sequenceOfType";
            }
        }
        String string4 = "na";
        if (mibNode.isReadable() && mibNode.isWriteable()) {
            string4 = "rw";
        } else if (mibNode.isReadable()) {
            string4 = "ro";
        } else if (mibNode.isWriteable()) {
            string4 = "wo";
        }
        String string5 = "unknown";
        if (mibNode.getStatus() == 2) {
            string5 = "mandatory";
        } else if (mibNode.getStatus() == 1) {
            string5 = "optional";
        } else if (mibNode.getStatus() == 3) {
            string5 = "current";
        } else if (mibNode.getStatus() == 4) {
            string5 = "deprecated";
        } else if (mibNode.getStatus() == 5) {
            string5 = "obsolete";
        }
        String string6 = mibNode.getTypeSymbol();
        string6 = string6 == null ? "" : " typeSymbol=\"" + this.xmlEscape(string6) + "\"";
        printStream.println(string + "<node id=\"" + mibNode.getId() + "\" name=\"" + this.xmlEscape(mibNode.getName()) + "\" type=\"" + string3 + "\" accessibility=\"" + string4 + "\" status=\"" + string5 + "\"" + string6 + ">");
        printStream.println();
        if (this.getExportDescriptions() && (iterator = mibNode.getDescription()) != null && ((String)((Object)iterator)).trim().length() > 0) {
            printStream.println(string + "  <description>");
            printStream.println(string + "    " + this.xmlEscape(((String)((Object)iterator)).trim()));
            printStream.println(string + "  </description>");
            printStream.println();
        }
        iterator = mibNode.getConstraints().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof IntMibConstraint) {
                printStream.println(string + "  <valueConstraint value=\"" + ((IntMibConstraint)object).getValue() + "\" />");
            } else if (object instanceof IntRangeMibConstraint) {
                printStream.println(string + "  <rangeConstraint min=\"" + ((IntRangeMibConstraint)object).getLow() + "\" max=\"" + ((IntRangeMibConstraint)object).getHigh() + "\" />");
            } else if (object instanceof StringLengthMibConstraint) {
                printStream.println(string + "  <sizeConstraint min=\"" + ((StringLengthMibConstraint)object).getMinLength() + "\" max=\"" + ((StringLengthMibConstraint)object).getMaxLength() + "\" />");
            } else if (object instanceof ByteArrayLengthMibConstraint) {
                printStream.println(string + "  <sizeConstraint min=\"" + ((ByteArrayLengthMibConstraint)object).getMinLength() + "\" max=\"" + ((ByteArrayLengthMibConstraint)object).getMaxLength() + "\" />");
            }
            if (iterator.hasNext()) continue;
            printStream.println();
        }
        iterator = mibNode.getIndicies().iterator();
        while (iterator.hasNext()) {
            object = (MibNode)iterator.next();
            printStream.println(string + "  <index oid=\"" + ((MibNode)object).getOid().getStringValue() + "\" />");
            if (iterator.hasNext()) continue;
            printStream.println();
        }
        iterator = mibNode.getSymbols().entrySet().iterator();
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            printStream.println(string + "  <symbol name=\"" + this.xmlEscape("" + object.getKey()) + "\" value=\"" + this.xmlEscape("" + object.getValue()) + "\" />");
            if (iterator.hasNext()) continue;
            printStream.println();
        }
        this.outputChildren(string + "  ", string2, mibNode, printStream);
        printStream.println();
        printStream.println(string + "</node>");
    }

    private void outputChildren(String string, String string2, MibNode mibNode, PrintStream printStream) throws IOException {
        Iterator iterator = mibNode.getChildren().iterator();
        while (iterator.hasNext()) {
            MibNode mibNode2 = (MibNode)iterator.next();
            if (!this.hasChild(mibNode2, string2)) continue;
            this.outputNode(string, string2, mibNode2, printStream);
        }
    }

    private boolean hasChild(MibNode mibNode, String string) {
        if (string == null) {
            return true;
        }
        if (mibNode.getMibs().containsKey(string)) {
            return true;
        }
        Iterator iterator = mibNode.getChildren().iterator();
        while (iterator.hasNext()) {
            if (!this.hasChild((MibNode)iterator.next(), string)) continue;
            return true;
        }
        return false;
    }

    private MibNode findRoot(MibNode mibNode, String string) {
        if (string == null) {
            return mibNode;
        }
        if (mibNode.getMibs().containsKey(string)) {
            return mibNode;
        }
        MibNode mibNode2 = null;
        Iterator iterator = mibNode.getChildren().iterator();
        while (iterator.hasNext()) {
            MibNode mibNode3 = (MibNode)iterator.next();
            MibNode mibNode4 = this.findRoot(mibNode3, string);
            if (mibNode2 == null) {
                mibNode2 = mibNode4;
                continue;
            }
            if (mibNode4 == null) continue;
            mibNode2 = this.findCommon(mibNode2, mibNode4);
        }
        return mibNode2;
    }

    private MibNode findCommon(MibNode mibNode, MibNode mibNode2) {
        int n;
        if (mibNode == mibNode2) {
            return mibNode;
        }
        char[] cArray = mibNode.getOid().getStringValue().toCharArray();
        char[] cArray2 = mibNode2.getOid().getStringValue().toCharArray();
        for (n = 0; n < cArray.length && n < cArray2.length && cArray[n] == cArray2[n]; ++n) {
        }
        String string = new String(cArray, 0, n);
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return MibNode.getRoot();
        }
        string = string.substring(0, n2);
        MibNode mibNode3 = mibNode;
        while (!mibNode3.getOid().getStringValue().equals(string)) {
            mibNode3 = mibNode3.getParent();
        }
        return mibNode3;
    }
}

