/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.protocols.snmp.AsnObjectIdentifier;
import com.avocent.protocols.snmp.ByteArrayLengthMibConstraint;
import com.avocent.protocols.snmp.IntMibConstraint;
import com.avocent.protocols.snmp.IntRangeMibConstraint;
import com.avocent.protocols.snmp.MibNode;
import com.avocent.protocols.snmp.StringLengthMibConstraint;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MibXmlLoader
extends DefaultHandler {
    private String m_szMib = null;
    private String m_szVersion = null;
    private AsnObjectIdentifier m_curOid = null;
    private ArrayList m_nodes = new ArrayList();
    private String m_szDescription = null;

    public static void loadMib(File file) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getName().endsWith(".mibxml")) continue;
                MibXmlLoader.loadMib(new FileInputStream(fileArray[i]));
            }
        } else {
            MibXmlLoader.loadMib(new FileInputStream(file));
        }
    }

    public static void loadMib(InputStream inputStream) throws IOException {
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(inputStream, (DefaultHandler)new MibXmlLoader());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new IOException(parserConfigurationException.toString());
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new IOException(sAXException.toString());
        }
        finally {
            inputStream.close();
        }
    }

    private MibXmlLoader() {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.equals("mib")) {
            this.m_szMib = attributes.getValue(attributes.getIndex("name"));
            String string4 = attributes.getValue(attributes.getIndex("rootOid"));
            this.m_szVersion = attributes.getValue(attributes.getIndex("version"));
            String[] stringArray = string4.split("\\.");
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
            this.m_curOid = new AsnObjectIdentifier(nArray);
        } else if (string3.equals("node")) {
            String string5;
            String string6;
            String string7;
            String string8;
            String string9 = attributes.getValue(attributes.getIndex("id"));
            int n = Integer.parseInt(string9);
            int[] nArray = this.m_curOid.getOidValue();
            int[] nArray2 = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray2[nArray2.length - 1] = n;
            this.m_curOid = new AsnObjectIdentifier(nArray2);
            this.m_nodes.add(MibNode.createNode(this.m_curOid));
            MibNode mibNode = (MibNode)this.m_nodes.get(this.m_nodes.size() - 1);
            mibNode.addMib(this.m_szMib, this.m_szVersion);
            String string10 = attributes.getValue(attributes.getIndex("name"));
            if (string10 != null) {
                mibNode.setName(string10);
            }
            if ((string8 = attributes.getValue(attributes.getIndex("type"))) != null) {
                if (string8.equals("node")) {
                    mibNode.setType(0);
                } else if (string8.equals("int")) {
                    mibNode.setType(1);
                } else if (string8.equals("float")) {
                    mibNode.setType(2);
                } else if (string8.equals("byte[]")) {
                    mibNode.setType(3);
                } else if (string8.equals("ipAddress")) {
                    mibNode.setType(8);
                } else if (string8.equals("macAddress")) {
                    mibNode.setType(9);
                } else if (string8.equals("ascii")) {
                    mibNode.setType(6);
                } else if (string8.equals("utf8")) {
                    mibNode.setType(7);
                } else if (string8.equals("sequence")) {
                    mibNode.setType(4);
                } else if (string8.equals("sequenceOfType")) {
                    mibNode.setType(5);
                } else {
                    mibNode.setType(255);
                }
            }
            if ((string7 = attributes.getValue(attributes.getIndex("accessibility"))) != null) {
                if (string7.equals("ro")) {
                    mibNode.setReadable(true);
                } else if (string7.equals("wo")) {
                    mibNode.setWriteable(true);
                } else if (string7.equals("rw")) {
                    mibNode.setReadable(true);
                    mibNode.setWriteable(true);
                }
            }
            if ((string6 = attributes.getValue(attributes.getIndex("typeSymbol"))) != null) {
                mibNode.setTypeSymbol(string6);
            }
            if ((string5 = attributes.getValue(attributes.getIndex("status"))) != null) {
                if (string5.equals("mandatory")) {
                    mibNode.setStatus(2);
                } else if (string5.equals("optional")) {
                    mibNode.setStatus(1);
                } else if (string5.equals("obsolete")) {
                    mibNode.setStatus(5);
                } else if (string5.equals("deprecated")) {
                    mibNode.setStatus(4);
                } else if (string5.equals("current")) {
                    mibNode.setStatus(3);
                }
            }
        } else if (string3.equals("description")) {
            this.m_szDescription = "";
        } else if (string3.equals("valueConstraint")) {
            MibNode mibNode = (MibNode)this.m_nodes.get(this.m_nodes.size() - 1);
            String string11 = attributes.getValue(attributes.getIndex("value"));
            int n = Integer.MIN_VALUE;
            if (string11 != null) {
                n = Integer.parseInt(string11);
            }
            mibNode.addConstraint(new IntMibConstraint(n));
        } else if (string3.equals("rangeConstraint")) {
            MibNode mibNode = (MibNode)this.m_nodes.get(this.m_nodes.size() - 1);
            String string12 = attributes.getValue(attributes.getIndex("min"));
            int n = Integer.MIN_VALUE;
            if (string12 != null) {
                n = Integer.parseInt(string12);
            }
            String string13 = attributes.getValue(attributes.getIndex("max"));
            int n2 = Integer.MAX_VALUE;
            if (string13 != null) {
                n2 = Integer.parseInt(string13);
            }
            mibNode.addConstraint(new IntRangeMibConstraint(n, n2));
        } else if (string3.equals("sizeConstraint")) {
            MibNode mibNode = (MibNode)this.m_nodes.get(this.m_nodes.size() - 1);
            String string14 = attributes.getValue(attributes.getIndex("min"));
            int n = Integer.MIN_VALUE;
            if (string14 != null) {
                n = Integer.parseInt(string14);
            }
            String string15 = attributes.getValue(attributes.getIndex("max"));
            int n3 = Integer.MAX_VALUE;
            if (string15 != null) {
                n3 = Integer.parseInt(string15);
            }
            if (mibNode.getType() == 6 || mibNode.getType() == 7) {
                mibNode.addConstraint(new StringLengthMibConstraint(n, n3));
            } else {
                mibNode.addConstraint(new ByteArrayLengthMibConstraint(n, n3));
            }
        } else if (string3.equals("index")) {
            MibNode mibNode = (MibNode)this.m_nodes.get(this.m_nodes.size() - 1);
            String string16 = attributes.getValue(attributes.getIndex("oid"));
            String[] stringArray = string16.split("\\.");
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
            mibNode.addIndex(MibNode.createNode(new AsnObjectIdentifier(nArray)));
        } else if (string3.equals("symbol")) {
            MibNode mibNode = (MibNode)this.m_nodes.get(this.m_nodes.size() - 1);
            String string17 = attributes.getValue(attributes.getIndex("name"));
            String string18 = attributes.getValue(attributes.getIndex("value"));
            mibNode.addSymbol(string17, string18);
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (string3.equals("node")) {
            this.m_nodes.remove(this.m_nodes.size() - 1);
            int[] nArray = this.m_curOid.getOidValue();
            int[] nArray2 = new int[nArray.length - 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
            this.m_curOid = new AsnObjectIdentifier(nArray2);
        } else if (string3.equals("description")) {
            ((MibNode)this.m_nodes.get(this.m_nodes.size() - 1)).setDescription(this.m_szDescription);
            this.m_szDescription = null;
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.m_szDescription != null) {
            this.m_szDescription = this.m_szDescription + new String(cArray, n, n2);
        }
    }
}

