/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.lib.debug.Trace;
import com.avocent.protocols.snmp.AsnObjectIdentifier;
import com.avocent.protocols.snmp.ByteArrayLengthMibConstraint;
import com.avocent.protocols.snmp.IntMibConstraint;
import com.avocent.protocols.snmp.IntRangeMibConstraint;
import com.avocent.protocols.snmp.MibNode;
import com.avocent.protocols.snmp.StringLengthMibConstraint;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpAccess;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.type.CompoundConstraint;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.RealType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.SequenceType;
import net.percederberg.mibble.type.SizeConstraint;
import net.percederberg.mibble.type.StringType;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.type.ValueRangeConstraint;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibbleLoader {
    private static MibLoader m_mibLoader = new MibLoader();

    public static void addReferencePath(File file) {
        m_mibLoader.addDir(file);
    }

    public static void addResourceReferencePath(String string) {
        m_mibLoader.addResourceDir(string);
    }

    public static void loadMib(File file) throws IOException {
        MibbleLoader.loadMib(file, false);
    }

    public static void loadMib(File file, boolean bl) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getName().endsWith(".asn")) continue;
                MibbleLoader.loadMib(fileArray[i], bl);
            }
        } else {
            try {
                Mib mib = m_mibLoader.load(file);
                MibbleLoader.processMib(mib);
            }
            catch (MibLoaderException mibLoaderException) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                mibLoaderException.getLog().printTo(printWriter);
                printWriter.flush();
                Trace.logError((String)"MibbleLoader:loadMib", (String)("Could Not Load Mib: " + file.getName() + " Log: " + stringWriter.getBuffer().toString()), (Throwable)mibLoaderException);
                if (bl) {
                    System.err.println("Could Not Load Mib: " + file.getName() + " Log: " + stringWriter.getBuffer().toString());
                }
                throw new IOException(mibLoaderException.toString());
            }
            catch (Exception exception) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.print(exception.getMessage());
                printWriter.flush();
                Trace.logError((String)"MibbleLoader:loadMib", (String)("Invalid Mib: " + file.getName() + " Message: " + stringWriter.getBuffer().toString()), (Throwable)exception);
                if (bl) {
                    System.err.println("Invalid Mib: " + file.getName() + " Message: " + stringWriter.getBuffer().toString());
                }
                throw new IOException(exception.toString());
            }
        }
    }

    private static AsnObjectIdentifier toAsnObjectIdentifier(ObjectIdentifierValue objectIdentifierValue) {
        ObjectIdentifierValue objectIdentifierValue2;
        int n = 0;
        for (objectIdentifierValue2 = objectIdentifierValue; objectIdentifierValue2 != null; objectIdentifierValue2 = objectIdentifierValue2.getParent()) {
            ++n;
        }
        int[] nArray = new int[n];
        for (objectIdentifierValue2 = objectIdentifierValue; objectIdentifierValue2 != null; objectIdentifierValue2 = objectIdentifierValue2.getParent()) {
            nArray[--n] = objectIdentifierValue2.getValue();
        }
        return new AsnObjectIdentifier(nArray);
    }

    private static void processMib(Mib mib) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = mib.getAllSymbols().iterator();
        while (iterator.hasNext()) {
            Object object;
            SnmpStatus snmpStatus;
            String string;
            MibType mibType;
            MibSymbol mibSymbol = (MibSymbol)iterator.next();
            if (!(mibSymbol instanceof MibValueSymbol)) continue;
            MibValueSymbol mibValueSymbol = (MibValueSymbol)mibSymbol;
            if (!(mibValueSymbol.getValue() instanceof ObjectIdentifierValue)) {
                Trace.logError((String)"MibbleLoader:processMib", (String)("No OID " + mibValueSymbol.getValue().getClass().getName() + " -> " + mibValueSymbol.getValue()));
                continue;
            }
            AsnObjectIdentifier asnObjectIdentifier = MibbleLoader.toAsnObjectIdentifier((ObjectIdentifierValue)mibValueSymbol.getValue());
            String string2 = asnObjectIdentifier.getStringValue();
            if (!hashSet.add(string2)) {
                Trace.logError((String)"MibbleLoader:processMib", (String)("Duplicate OID " + string2));
                throw new Exception("Duplicate OID [" + string2 + "] Name[" + mibValueSymbol.getName() + "]");
            }
            MibNode mibNode = MibNode.createNode(asnObjectIdentifier);
            boolean bl = mibNode.getMibs().size() == 0;
            String string3 = System.getProperties().getProperty("mib.version", "");
            mibNode.addMib(mibValueSymbol.getMib().getName(), string3);
            if (mibValueSymbol.getName() != null && mibNode.getName().equals("" + mibNode.getId())) {
                mibNode.setName(mibValueSymbol.getName());
            }
            if (!bl || !((mibType = mibValueSymbol.getType()) instanceof SnmpObjectType)) continue;
            SnmpObjectType snmpObjectType = (SnmpObjectType)mibType;
            SnmpAccess snmpAccess = snmpObjectType.getAccess();
            if (snmpAccess == SnmpAccess.READ_ONLY || snmpAccess == SnmpAccess.READ_CREATE || snmpAccess == SnmpAccess.READ_WRITE) {
                mibNode.setReadable(true);
            }
            if (snmpAccess == SnmpAccess.WRITE_ONLY || snmpAccess == SnmpAccess.READ_WRITE) {
                mibNode.setWriteable(true);
            }
            if ((string = snmpObjectType.getDescription()) != null) {
                mibNode.setDescription(string);
            }
            if ((snmpStatus = snmpObjectType.getStatus()) == SnmpStatus.CURRENT) {
                mibNode.setStatus(3);
            } else if (snmpStatus == SnmpStatus.DEPRECATED) {
                mibNode.setStatus(4);
            } else if (snmpStatus == SnmpStatus.MANDATORY) {
                mibNode.setStatus(2);
            } else if (snmpStatus == SnmpStatus.OBSOLETE) {
                mibNode.setStatus(5);
            } else if (snmpStatus == SnmpStatus.OPTIONAL) {
                mibNode.setStatus(1);
            }
            MibType mibType2 = snmpObjectType.getIndex().iterator();
            while (mibType2.hasNext()) {
                object = mibType2.next();
                if (object instanceof ObjectIdentifierValue) {
                    mibNode.addIndex(MibNode.createNode(MibbleLoader.toAsnObjectIdentifier((ObjectIdentifierValue)object)));
                    continue;
                }
                Trace.logError((String)"MibbleLoader", (String)"Could NOT Resolve Index");
            }
            mibType2 = snmpObjectType.getSyntax();
            if (mibType2 != null && (object = mibType2.getReferenceSymbol()) != null) {
                mibNode.setTypeSymbol(object.getName());
            }
            if (mibType2 instanceof IntegerType) {
                mibNode.setType(1);
                MibbleLoader.processSymbols(mibNode, ((IntegerType)mibType2).getAllSymbols());
                MibbleLoader.processConstraint(mibNode, ((IntegerType)mibType2).getConstraint());
                continue;
            }
            if (mibType2 instanceof RealType) {
                mibNode.setType(2);
                continue;
            }
            if (mibType2 instanceof StringType) {
                mibNode.setType(3);
                if (mibNode.getTypeSymbol() != null) {
                    if (mibNode.getTypeSymbol().equalsIgnoreCase("UTF8String")) {
                        mibNode.setType(7);
                    } else if (mibNode.getTypeSymbol().equalsIgnoreCase("DisplayString")) {
                        mibNode.setType(6);
                    } else if (mibNode.getTypeSymbol().equalsIgnoreCase("IpAddress")) {
                        mibNode.setType(8);
                    } else if (mibNode.getTypeSymbol().equalsIgnoreCase("PhysAddress")) {
                        mibNode.setType(9);
                    }
                }
                MibbleLoader.processConstraint(mibNode, ((StringType)mibType2).getConstraint());
                continue;
            }
            if (mibType2 instanceof SequenceType) {
                mibNode.setType(4);
                continue;
            }
            if (mibType2 instanceof SequenceOfType) {
                mibNode.setType(5);
                MibbleLoader.processConstraint(mibNode, ((SequenceOfType)mibType2).getConstraint());
                continue;
            }
            mibNode.setType(255);
        }
    }

    private static void processConstraint(MibNode mibNode, Constraint constraint) {
        if (constraint == null) {
            return;
        }
        if (constraint instanceof CompoundConstraint) {
            Iterator iterator = ((CompoundConstraint)constraint).getConstraintList().iterator();
            while (iterator.hasNext()) {
                MibbleLoader.processConstraint(mibNode, (Constraint)iterator.next());
            }
        } else if (constraint instanceof SizeConstraint) {
            ArrayList arrayList = ((SizeConstraint)constraint).getValues();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n;
                Constraint constraint2 = (Constraint)iterator.next();
                if (constraint2 instanceof ValueConstraint) {
                    n = Integer.parseInt(((ValueConstraint)constraint2).getValue().toString());
                    mibNode.addConstraint(new StringLengthMibConstraint(n, n));
                    continue;
                }
                if (!(constraint2 instanceof ValueRangeConstraint)) continue;
                n = Integer.parseInt(((ValueRangeConstraint)constraint2).getLowerBound().toString());
                int n2 = Integer.parseInt(((ValueRangeConstraint)constraint2).getUpperBound().toString());
                if (mibNode.getType() == 6 || mibNode.getType() == 7) {
                    mibNode.addConstraint(new StringLengthMibConstraint(n, n2));
                    continue;
                }
                mibNode.addConstraint(new ByteArrayLengthMibConstraint(n, n2));
            }
        } else if (constraint instanceof ValueConstraint) {
            int n = Integer.parseInt(((ValueConstraint)constraint).getValue().toString());
            mibNode.addConstraint(new IntMibConstraint(n));
        } else if (constraint instanceof ValueRangeConstraint) {
            long l = Integer.MIN_VALUE;
            try {
                l = Long.parseLong(((ValueRangeConstraint)constraint).getLowerBound().toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            long l2 = Integer.MAX_VALUE;
            try {
                l2 = Long.parseLong(((ValueRangeConstraint)constraint).getUpperBound().toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (l < Integer.MIN_VALUE) {
                l = Integer.MIN_VALUE;
            }
            if (l2 > Integer.MAX_VALUE) {
                l2 = Integer.MAX_VALUE;
            }
            mibNode.addConstraint(new IntRangeMibConstraint((int)l, (int)l2));
        } else {
            Trace.logError((String)"MibbleLoader:processConstraint", (String)"Unknown Constraint Type");
        }
    }

    private static void processSymbols(MibNode mibNode, MibValueSymbol[] mibValueSymbolArray) {
        if (mibValueSymbolArray == null) {
            return;
        }
        for (int i = 0; i < mibValueSymbolArray.length; ++i) {
            mibNode.addSymbol(mibValueSymbolArray[i].getName(), mibValueSymbolArray[i].getValue().toString());
        }
    }

    static {
        MibbleLoader.addResourceReferencePath("/mibs/ietf");
        MibbleLoader.addResourceReferencePath("/mibs/iana");
    }
}

