/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.protocols.snmp.AsnObjectIdentifier;
import com.avocent.protocols.snmp.ExceptionInvalidIndex;
import com.avocent.protocols.snmp.SnmpResponse;
import com.avocent.protocols.snmp.VarBind;
import com.avocent.protocols.snmp.VarBindList;

public class SnmpOperationException
extends Exception {
    private SnmpResponse m_response;

    public SnmpOperationException(String string, Throwable throwable) {
        super(SnmpOperationException.generateMessage(string, null, throwable), throwable);
    }

    public SnmpOperationException(String string, SnmpResponse snmpResponse, Throwable throwable) {
        super(SnmpOperationException.generateMessage(string, snmpResponse, throwable), throwable);
        this.m_response = snmpResponse;
    }

    public SnmpOperationException(String string, SnmpResponse snmpResponse) {
        super(SnmpOperationException.generateMessage(string, snmpResponse, null));
        this.m_response = snmpResponse;
    }

    public SnmpResponse getSnmpResponse() {
        return this.m_response;
    }

    private static String generateMessage(String string, SnmpResponse snmpResponse, Throwable throwable) {
        String string2 = "";
        if (throwable != null) {
            string2 = "  Throwable: " + throwable.getClass().getName() + "  Message: " + throwable.getMessage();
        }
        String string3 = "";
        if (snmpResponse != null) {
            String string4 = "[Unknown]";
            int n = snmpResponse.getErrorIndex();
            VarBindList varBindList = snmpResponse.getVarBindList();
            if (varBindList == null) {
                string4 = "[No VarBindList]";
            } else {
                VarBind varBind = null;
                try {
                    varBind = varBindList.varbindAt(n - 1);
                }
                catch (ExceptionInvalidIndex exceptionInvalidIndex) {
                    // empty catch block
                }
                if (varBind == null) {
                    string4 = "[No Such VarBind]";
                } else {
                    string4 = varBind.getName();
                    try {
                        AsnObjectIdentifier asnObjectIdentifier = varBind.getOidName();
                        string4 = string4 + "[" + asnObjectIdentifier.getStringValue() + "]";
                    }
                    catch (ExceptionNoValue exceptionNoValue) {
                        string4 = string4 + "[Unknown OID]";
                    }
                }
            }
            string3 = "  Status: " + snmpResponse.getErrorStatus() + "  Index: " + n + "  VarBind: " + string4;
        }
        return "The Snmp " + string + " Operation Failed Due To An Error.  " + string2 + string3;
    }
}

