/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.protocols.snmp.GetResponse;
import com.avocent.protocols.snmp.VarBindList;
import java.net.InetAddress;

public class SnmpRequest {
    private static int m_nNextRequestId = 0;
    protected InetAddress m_addr;
    protected String m_szCommunity;
    protected int m_nTimeout;
    protected int m_nRetries;
    protected VarBindList m_vblist;
    protected int m_nRequestType;
    protected int m_nRequestId;
    protected int m_nErrorStatus;
    protected int m_nErrorIndex;
    protected boolean m_bResponse;
    protected String m_szUsername = null;

    public SnmpRequest(VarBindList varBindList, InetAddress inetAddress, String string, int n, int n2, int n3) {
        this.m_addr = inetAddress;
        this.m_vblist = varBindList;
        this.m_szCommunity = string;
        this.m_nTimeout = n2;
        this.m_nRetries = n3;
        this.m_nRequestType = n;
        this.m_nRequestId = SnmpRequest.getNextRequestId();
        this.m_nErrorStatus = 0;
        this.m_nErrorIndex = 0;
        this.m_bResponse = false;
    }

    public int getErrorStatus() {
        return this.m_nErrorStatus;
    }

    public String getErrorStatusMessage() {
        switch (this.m_nErrorStatus) {
            case 0: {
                return "Success";
            }
            case 1: {
                return "SNMP packet is too big";
            }
            case 2: {
                return "SNMP No Such Name (Index=" + this.m_nErrorIndex;
            }
            case 3: {
                return "SNMP bad value (Index=" + this.m_nErrorIndex;
            }
            case 4: {
                return "SNMP read only error (Index=" + this.m_nErrorIndex;
            }
            case 5: {
                return "SNMP general error (Index=" + this.m_nErrorIndex;
            }
            case 100: {
                return "SNMP request timed out";
            }
            case 101: {
                return "Insufficient resources to complete request";
            }
        }
        return "SNMP Unknown Error (Index=" + this.m_nErrorIndex;
    }

    public void setErrorStatus(int n) {
        this.m_nErrorStatus = n;
    }

    public int getErrorIndex() {
        return this.m_nErrorIndex;
    }

    public void setErrorIndex(int n) {
        this.m_nErrorIndex = n;
    }

    public VarBindList getVarBindList() {
        return this.m_vblist;
    }

    public String getCommunity() {
        return this.m_szCommunity;
    }

    public InetAddress getAddress() {
        return this.m_addr;
    }

    public int getRequestId() {
        return this.m_nRequestId;
    }

    public int getRequestType() {
        return this.m_nRequestType;
    }

    public void setRequestType(int n) {
        this.m_nRequestType = n;
    }

    public int getTimeout() {
        return this.m_nTimeout;
    }

    public int getRetries() {
        return this.m_nRetries;
    }

    public void setNewVarBindList(VarBindList varBindList) {
        this.m_nRequestId = SnmpRequest.getNextRequestId();
        this.m_nErrorStatus = 0;
        this.m_nErrorIndex = 0;
        this.m_bResponse = false;
        this.m_vblist = varBindList;
    }

    public void setResponse(GetResponse getResponse) {
        this.m_nErrorStatus = getResponse.getErrorStatus();
        this.m_nErrorIndex = getResponse.getErrorIndex();
        this.m_vblist = getResponse.getVarBindList();
        this.m_bResponse = true;
    }

    public boolean isResponseAvailable() {
        return this.m_bResponse;
    }

    public String getUsername() {
        return this.m_szUsername;
    }

    public void setUsername(String string) {
        this.m_szUsername = string;
    }

    private static synchronized int getNextRequestId() {
        return m_nNextRequestId++;
    }
}

