/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.lib.debug.Assert;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.util.BlockingQueue;
import com.avocent.lib.util.ThreadContinuous;
import com.avocent.protocols.snmp.AsnInteger32;
import com.avocent.protocols.snmp.AsnObject;
import com.avocent.protocols.snmp.AsnObjectIdentifier;
import com.avocent.protocols.snmp.AsnOctetString;
import com.avocent.protocols.snmp.AsnSequence;
import com.avocent.protocols.snmp.ExceptionInvalidIndex;
import com.avocent.protocols.snmp.ExceptionSnmpInvalidMessage;
import com.avocent.protocols.snmp.GetResponse;
import com.avocent.protocols.snmp.SnmpRequest;
import com.avocent.protocols.snmp.VarBind;
import com.avocent.protocols.snmp.VarBindList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.NoSuchElementException;

public class ThreadSnmpService {
    public static final int MAX_DATAGRAM = 8192;
    private static final int SHUTDOWN_WAIT_TIMEOUT = 8000;
    private static final int SHUTDOWN_WAIT_TIMEOUT_SHORT = 1000;
    public static final int SNMP_REQUEST_PORT = 161;
    public static final int SNMP_TRAP_PORT = 162;
    private static final long QUEUE_WAIT_TIME = 1000L;
    private static ThreadSnmpService m_tssInstance = new ThreadSnmpService();
    private static MainThread m_mainThread;
    private static DatagramSocket m_socketSnmpRqst;

    private ThreadSnmpService() {
    }

    public static ThreadSnmpService getInstance() {
        return m_tssInstance;
    }

    public static synchronized void startup() throws SocketException {
        ThreadSnmpService.getInstance();
        if (m_mainThread == null) {
            ThreadSnmpService.getInstance();
            m_mainThread = new MainThread();
        }
    }

    public static synchronized void shutdown() {
        ThreadSnmpService.getInstance();
        if (m_mainThread != null) {
            ThreadSnmpService.getInstance();
            MainThread mainThread = m_mainThread;
            ThreadSnmpService.getInstance();
            m_mainThread = null;
            try {
                mainThread.stopThreadAndWait(8000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean request(SnmpRequest snmpRequest) {
        ThreadSnmpService.getInstance();
        MainThread mainThread = m_mainThread;
        if (mainThread == null) {
            snmpRequest.setErrorStatus(101);
            return false;
        }
        return mainThread.request(snmpRequest);
    }

    private static class RxThread
    extends ThreadContinuous {
        BlockingQueue m_queueRx = new BlockingQueue();

        RxThread() {
            super(0L);
            Trace.logInfo((String)"SNMP:Rx", (String)"SNMP RX thread started");
        }

        public GetResponse remove() throws InterruptedException, ExceptionNoValue {
            try {
                return (GetResponse)this.m_queueRx.remove(1000L);
            }
            catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                Trace.logError((String)"SNMP:Rx", (String)("Queue error - ExceptionInvalidArgument:" + exceptionInvalidArgument.getMessage()));
                throw new ExceptionNoValue();
            }
        }

        protected void performTask() {
            try {
                Assert.isNotEventDispatchThread();
                byte[] byArray = new byte[8192];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, 8192);
                m_socketSnmpRqst.receive(datagramPacket);
                Trace.logInfo((String)"SNMP:Rx", (String)"SNMP RX Received datagram packet");
                byte[] byArray2 = datagramPacket.getData();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                int n = AsnObject.decodeTag(dataInputStream);
                if (n != 48) {
                    Trace.logError((String)"SNMP:Rx", (String)"Error - INVALID SNMP MESSAGE != SEQUENCE");
                    return;
                }
                int n2 = AsnObject.decodeLength(dataInputStream);
                AsnSequence asnSequence = new AsnSequence();
                asnSequence.decodeValue(dataInputStream, n2);
                AsnInteger32 asnInteger32 = (AsnInteger32)asnSequence.asnobjectAt(0, 2);
                AsnOctetString asnOctetString = (AsnOctetString)asnSequence.asnobjectAt(1, 4);
                AsnSequence asnSequence2 = (AsnSequence)asnSequence.asnobjectAt(2, 162);
                AsnInteger32 asnInteger322 = (AsnInteger32)asnSequence2.asnobjectAt(0, 2);
                AsnInteger32 asnInteger323 = (AsnInteger32)asnSequence2.asnobjectAt(1, 2);
                AsnInteger32 asnInteger324 = (AsnInteger32)asnSequence2.asnobjectAt(2, 2);
                AsnSequence asnSequence3 = (AsnSequence)asnSequence2.asnobjectAt(3, 48);
                VarBindList varBindList = new VarBindList();
                for (int i = 0; i < asnSequence3.size(); ++i) {
                    AsnSequence asnSequence4 = (AsnSequence)asnSequence3.asnobjectAt(i, 48);
                    AsnObjectIdentifier asnObjectIdentifier = (AsnObjectIdentifier)asnSequence4.asnobjectAt(0, 6);
                    AsnObject asnObject = asnSequence4.asnobjectAt(1, 0);
                    VarBind varBind = new VarBind(asnObjectIdentifier, asnObject);
                    varBindList.addVarBind(varBind);
                }
                GetResponse getResponse = new GetResponse(varBindList, asnInteger322.getIntegerValue(), asnInteger323.getIntegerValue(), asnInteger324.getIntegerValue());
                Trace.logInfo((String)"SNMP:Rx", (String)("SNMP request " + getResponse.getRequestId() + " ready in receive queue"));
                this.m_queueRx.add((Object)getResponse);
            }
            catch (ExceptionSnmpInvalidMessage exceptionSnmpInvalidMessage) {
                Trace.logError((String)"SNMP:Rx", (String)("Error - ExceptionSnmpInvalidMessage:" + exceptionSnmpInvalidMessage.getMessage()));
            }
            catch (NoSuchElementException noSuchElementException) {
                Trace.logError((String)"SNMP:Rx", (String)("Error - NoSuchElementException:" + noSuchElementException.getMessage()));
            }
            catch (IOException iOException) {
                Trace.logError((String)"SNMP:Rx", (String)("Error - IOException:" + iOException.getMessage()));
            }
            catch (Exception exception) {
                Trace.logError((String)"SNMP:Rx", (String)("Error - Exception:" + exception.getMessage()));
            }
        }

        protected void cleanup() {
            try {
                Trace.logInfo((String)"SNMP:Rx", (String)"SNMP RX thread cleanup");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class TxThread
    extends ThreadContinuous {
        BlockingQueue m_queueTx = new BlockingQueue();

        TxThread() {
            super(0L);
            Trace.logInfo((String)"SNMP:Tx", (String)"SNMP transmit thread started");
        }

        public synchronized void addRequest(SnmpRequest snmpRequest) {
            Trace.logInfo((String)"SNMP:Tx", (String)("SNMP Request " + snmpRequest.getRequestId() + " added to Tx queue"));
            this.m_queueTx.add((Object)snmpRequest);
        }

        protected void performTask() {
            try {
                Object object;
                Object object2;
                Assert.isNotEventDispatchThread();
                SnmpRequest snmpRequest = (SnmpRequest)this.m_queueTx.remove(1000L);
                Trace.logInfo((String)"SNMP:Tx", (String)("Processing SNMP request " + snmpRequest.getRequestId() + " from Tx Queue"));
                AsnSequence asnSequence = new AsnSequence();
                asnSequence.add(new AsnInteger32(0));
                asnSequence.add(new AsnOctetString(snmpRequest.getCommunity()));
                Integer n = new Integer(snmpRequest.getRequestId());
                AsnSequence asnSequence2 = new AsnSequence(snmpRequest.getRequestType());
                asnSequence2.add(new AsnInteger32(n));
                asnSequence2.add(new AsnInteger32(0));
                asnSequence2.add(new AsnInteger32(0));
                asnSequence.add(asnSequence2);
                AsnSequence asnSequence3 = new AsnSequence();
                asnSequence2.add(asnSequence3);
                VarBindList varBindList = snmpRequest.getVarBindList();
                for (int i = 0; i < varBindList.size(); ++i) {
                    object2 = new AsnSequence();
                    asnSequence3.add((AsnObject)object2);
                    object = varBindList.varbindAt(i);
                    ((AsnSequence)object2).add(((VarBind)object).getOidName());
                    ((AsnSequence)object2).add(((VarBind)object).getAsnObject());
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                object2 = new DataOutputStream(byteArrayOutputStream);
                asnSequence.encodeTag((DataOutputStream)object2);
                AsnSequence.encodeLength((DataOutputStream)object2, asnSequence.getSizeOfValueField());
                asnSequence.encodeValue((DataOutputStream)object2);
                object = byteArrayOutputStream.toByteArray();
                DatagramPacket datagramPacket = new DatagramPacket((byte[])object, ((Object)object).length, snmpRequest.getAddress(), 161);
                Trace.logInfo((String)"SNMP:Tx", (String)("Sending SNMP datagram packet for Request " + snmpRequest.getRequestId()));
                m_socketSnmpRqst.send(datagramPacket);
            }
            catch (ExceptionNoValue exceptionNoValue) {
            }
            catch (IOException iOException) {
                Trace.logError((String)"SNMP:Tx", (String)("Error - IOException:" + iOException.getMessage()));
            }
            catch (ExceptionSnmpInvalidMessage exceptionSnmpInvalidMessage) {
                Trace.logError((String)"SNMP:Tx", (String)("Error - ExceptionSnmpInvalidMessage:" + exceptionSnmpInvalidMessage.getMessage()));
            }
            catch (ExceptionInvalidIndex exceptionInvalidIndex) {
                Trace.logError((String)"SNMP:Tx", (String)("Error - ExceptionInvalidIndex:" + exceptionInvalidIndex.getMessage()));
            }
            catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                Trace.logError((String)"SNMP:Tx", (String)("Error - ExceptionInvalidArgument:" + exceptionInvalidArgument.getMessage()));
            }
            catch (Exception exception) {
                Trace.logError((String)"SNMP:Tx", (String)("Error - Exception:" + exception.getMessage()));
            }
        }

        protected void cleanup() {
            try {
                Trace.logInfo((String)"SNMP:Tx", (String)"SNMP TX thread cleanup");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class MainThread
    extends ThreadContinuous {
        BlockingQueue m_queueRequests;
        TxThread m_threadTx;
        RxThread m_threadRx;

        private MainThread() throws SocketException {
            super(0L);
            m_socketSnmpRqst = new DatagramSocket();
            this.m_queueRequests = new BlockingQueue();
            this.m_threadTx = new TxThread();
            this.m_threadTx.setPriority(1);
            this.m_threadTx.setDaemon(true);
            this.m_threadTx.setName("SNMP Service Tx Thread");
            this.m_threadTx.start();
            this.m_threadRx = new RxThread();
            this.m_threadRx.setPriority(1);
            this.m_threadRx.setDaemon(true);
            this.m_threadRx.setName("SNMP Service Rx Thread");
            this.m_threadRx.start();
            this.setPriority(1);
            this.setDaemon(true);
            this.setName("SNMP Service Main Thread");
            this.start();
            Trace.logInfo((String)"SNMP:Main", (String)"SNMP main thread started");
        }

        protected void performTask() {
            try {
                Assert.isNotEventDispatchThread();
                GetResponse getResponse = this.m_threadRx.remove();
                Trace.logInfo((String)"SNMP:Main", (String)("Processing response " + getResponse.getRequestId() + " from Rx queue"));
                this.notifyRequestor(getResponse);
            }
            catch (ExceptionNoValue exceptionNoValue) {
            }
            catch (InterruptedException interruptedException) {
                Trace.logError((String)"SNMP:Main", (String)"SNMP main thread - InterruptedException");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyRequestor(GetResponse getResponse) {
            BlockingQueue blockingQueue = this.m_queueRequests;
            synchronized (blockingQueue) {
                for (int i = 0; i < this.m_queueRequests.size(); ++i) {
                    SnmpRequest snmpRequest = (SnmpRequest)this.m_queueRequests.elementAt(i);
                    if (snmpRequest.getRequestId() != getResponse.getRequestId()) continue;
                    SnmpRequest snmpRequest2 = snmpRequest;
                    synchronized (snmpRequest2) {
                        snmpRequest.setResponse(getResponse);
                        snmpRequest.notify();
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean request(SnmpRequest snmpRequest) {
            Assert.isNotEventDispatchThread();
            this.m_queueRequests.add((Object)snmpRequest);
            int n = 0;
            do {
                if (n > 0) {
                    Trace.logInfo((String)"SNMP:Main", (String)("SNMP Request " + snmpRequest.getRequestId() + " RETRY=" + n));
                }
                this.m_threadTx.addRequest(snmpRequest);
                try {
                    SnmpRequest snmpRequest2 = snmpRequest;
                    synchronized (snmpRequest2) {
                        Trace.logInfo((String)"SNMP:Main", (String)("SNMP waiting for request " + snmpRequest.getRequestId()));
                        snmpRequest.wait(snmpRequest.getTimeout());
                        if (snmpRequest.isResponseAvailable()) {
                            this.m_queueRequests.removeElement((Object)snmpRequest);
                            Trace.logInfo((String)"SNMP:Main", (String)("SNMP Request " + snmpRequest.getRequestId() + " Successful.  ErrorStatus=" + snmpRequest.getErrorStatus() + " ErrorIndex=" + snmpRequest.getErrorIndex()));
                            return true;
                        }
                        Trace.logInfo((String)"SNMP:Main", (String)("SNMP Request " + snmpRequest.getRequestId() + " TIMED OUT"));
                    }
                }
                catch (InterruptedException interruptedException) {
                    Trace.logError((String)"SNMP:Main", (String)"SNMP waiting for request - InterruptedException");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Trace.logError((String)"SNMP:Main", (String)"SNMP waiting for request - IllegalArgumentException");
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    Trace.logError((String)"SNMP:Main", (String)"SNMP waiting for request - IllegalMonitorStateException");
                }
            } while (n++ < snmpRequest.getRetries());
            this.m_queueRequests.removeElement((Object)snmpRequest);
            Trace.logError((String)"SNMP:Main", (String)("SNMP Request " + snmpRequest.getRequestId() + " Exceeded MAX RETRIES ERROR=TIMEOUT"));
            snmpRequest.setErrorStatus(100);
            return false;
        }

        protected void cleanup() {
            try {
                Assert.isNotEventDispatchThread();
                Trace.logInfo((String)"SNMP:Main", (String)"SNMP main thread cleanup");
                Trace.logInfo((String)"SNMP:Main", (String)"Stopping SNMP Transmit Thread");
                this.m_threadTx.stopThreadAndWait(8000L);
                Trace.logInfo((String)"SNMP:Main", (String)"Closing Socket");
                m_socketSnmpRqst.close();
                Trace.logInfo((String)"SNMP:Main", (String)"Stopping SNMP Receive Thread");
                this.m_threadRx.stopThreadAndWait(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

