/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.lib.net.IpAddress;
import com.avocent.lib.net.MacAddress;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;

public class TypeConversion {
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$com$avocent$lib$net$IpAddress;
    static /* synthetic */ Class class$com$avocent$lib$net$MacAddress;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;

    private TypeConversion() {
    }

    public static byte asByte(Object object) {
        return TypeConversion.asByte(object, (byte)0);
    }

    public static byte asByte(Object object, byte by) {
        Number number = TypeConversion.asNumber(object);
        if (number == null) {
            return by;
        }
        return number.byteValue();
    }

    public static char asChar(Object object) {
        return TypeConversion.asChar(object, '\u0000');
    }

    public static char asChar(Object object, char c) {
        String string = TypeConversion.asString(object);
        if (string == null || string.length() == 0) {
            return c;
        }
        return string.charAt(0);
    }

    public static short asShort(Object object) {
        return TypeConversion.asShort(object, (short)0);
    }

    public static short asShort(Object object, short s) {
        Number number = TypeConversion.asNumber(object);
        if (number == null) {
            return s;
        }
        return number.shortValue();
    }

    public static int asInt(Object object) {
        return TypeConversion.asInt(object, 0);
    }

    public static int asInt(Object object, int n) {
        Number number = TypeConversion.asNumber(object);
        if (number == null) {
            return n;
        }
        return number.intValue();
    }

    public static boolean asBoolean(Object object) {
        return TypeConversion.asBoolean(object, false);
    }

    public static boolean asBoolean(Object object, boolean bl) {
        String string = TypeConversion.asString(object);
        if (string != null && string.length() > 0) {
            char c = string.charAt(0);
            switch (c) {
                case 'T': 
                case 't': {
                    return true;
                }
                case 'F': 
                case 'f': {
                    return false;
                }
            }
        }
        return bl;
    }

    public static long asLong(Object object) {
        return TypeConversion.asLong(object, 0L);
    }

    public static long asLong(Object object, long l) {
        Number number = TypeConversion.asNumber(object);
        if (number == null) {
            return l;
        }
        return number.longValue();
    }

    public static float asFloat(Object object) {
        return TypeConversion.asFloat(object, 0.0f);
    }

    public static float asFloat(Object object, float f) {
        Number number = TypeConversion.asNumber(object);
        if (number == null) {
            return f;
        }
        return number.floatValue();
    }

    public static double asDouble(Object object) {
        return TypeConversion.asDouble(object, 0.0);
    }

    public static double asDouble(Object object, double d) {
        Number number = TypeConversion.asNumber(object);
        if (number == null) {
            return d;
        }
        return number.doubleValue();
    }

    public static BigInteger asBigInteger(Object object) {
        return TypeConversion.asBigInteger(object, BigInteger.ZERO);
    }

    public static BigInteger asBigInteger(Object object, BigInteger bigInteger) {
        Number number = TypeConversion.asNumber(object);
        if (number == null) {
            return bigInteger;
        }
        return new BigInteger(number.toString());
    }

    public static BigDecimal asBigDecimal(Object object) {
        return TypeConversion.asBigDecimal(object, BigDecimal.valueOf(0L));
    }

    public static BigDecimal asBigDecimal(Object object, BigDecimal bigDecimal) {
        Number number = TypeConversion.asNumber(object);
        if (number == null) {
            return bigDecimal;
        }
        return new BigDecimal(number.toString());
    }

    public static String asString(Object object) {
        return TypeConversion.asString(object, null);
    }

    public static String asString(Object object, String string) {
        if (object == null) {
            return string;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof byte[]) {
            try {
                return new String((byte[])object, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return string;
            }
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        if (object instanceof MacAddress) {
            return ((MacAddress)object).getString();
        }
        if (object instanceof IpAddress) {
            return ((IpAddress)object).getString();
        }
        return object.toString();
    }

    public static IpAddress asIpAddress(Object object) {
        return TypeConversion.asIpAddress(object, null);
    }

    public static IpAddress asIpAddress(Object object, IpAddress ipAddress) {
        try {
            if (object != null) {
                if (object instanceof IpAddress) {
                    return (IpAddress)object;
                }
                if (object instanceof InetAddress) {
                    return new IpAddress(((InetAddress)object).getAddress());
                }
                if (object instanceof byte[]) {
                    return new IpAddress((byte[])object);
                }
                if (object instanceof Number) {
                    return new IpAddress(((Number)object).longValue());
                }
                return new IpAddress(TypeConversion.asString(object, ""));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ipAddress;
    }

    public static MacAddress asMacAddress(Object object) {
        return TypeConversion.asMacAddress(object, null);
    }

    public static MacAddress asMacAddress(Object object, MacAddress macAddress) {
        try {
            if (object != null) {
                if (object instanceof MacAddress) {
                    return (MacAddress)object;
                }
                if (object instanceof byte[]) {
                    return new MacAddress((byte[])object);
                }
                return new MacAddress(TypeConversion.asString(object, ""));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return macAddress;
    }

    public static byte[] asByteArray(Object object) {
        return TypeConversion.asByteArray(object, null);
    }

    public static byte[] asByteArray(Object object, byte[] byArray) {
        if (object != null) {
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            if (object instanceof char[]) {
                byte[] byArray2 = new byte[((char[])object).length * 2];
                ByteBuffer.wrap(byArray2).asCharBuffer().put((char[])object);
                return byArray2;
            }
            if (object instanceof short[]) {
                byte[] byArray3 = new byte[((short[])object).length * 2];
                ByteBuffer.wrap(byArray3).asShortBuffer().put((short[])object);
                return byArray3;
            }
            if (object instanceof int[]) {
                byte[] byArray4 = new byte[((int[])object).length * 4];
                ByteBuffer.wrap(byArray4).asIntBuffer().put((int[])object);
                return byArray4;
            }
            if (object instanceof long[]) {
                byte[] byArray5 = new byte[((long[])object).length * 8];
                ByteBuffer.wrap(byArray5).asLongBuffer().put((long[])object);
                return byArray5;
            }
            if (object instanceof float[]) {
                byte[] byArray6 = new byte[((float[])object).length * 4];
                ByteBuffer.wrap(byArray6).asFloatBuffer().put((float[])object);
                return byArray6;
            }
            if (object instanceof double[]) {
                byte[] byArray7 = new byte[((double[])object).length * 8];
                ByteBuffer.wrap(byArray7).asDoubleBuffer().put((double[])object);
                return byArray7;
            }
            if (object instanceof InetAddress) {
                return ((InetAddress)object).getAddress();
            }
            if (object instanceof IpAddress) {
                return ((IpAddress)object).getBytes();
            }
            if (object instanceof MacAddress) {
                return ((MacAddress)object).getBytes();
            }
            String string = TypeConversion.asString(object);
            if (string == null) {
                return byArray;
            }
            try {
                return string.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return byArray;
    }

    public static Number asNumber(Object object) {
        return TypeConversion.asNumber(object, BigInteger.ZERO);
    }

    public static Number asNumber(Object object, Number number) {
        if (object != null) {
            if (object instanceof Number) {
                return (Number)object;
            }
            if (object instanceof byte[]) {
                return new BigInteger((byte[])object);
            }
            if (object instanceof Character) {
                return new Integer(((Character)object).charValue());
            }
            String string = TypeConversion.asString(object);
            if (string != null) {
                try {
                    return new BigInteger(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return number;
    }

    public static Object asObject(Object object, Class clazz) {
        return TypeConversion.asObject(object, null, clazz);
    }

    public static Object asObject(Object object, Object object2, Class clazz) {
        if (clazz.isInstance(object)) {
            return object;
        }
        if (clazz.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypeConversion.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return TypeConversion.asBigDecimal(object, TypeConversion.asBigDecimal(object2));
        }
        if (clazz.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = TypeConversion.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return TypeConversion.asBigInteger(object, TypeConversion.asBigInteger(object2));
        }
        if (clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeConversion.class$("java.lang.Boolean")) : class$java$lang$Boolean) || clazz.equals(Boolean.TYPE)) {
            return TypeConversion.asBoolean(object, TypeConversion.asBoolean(object2));
        }
        if (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = TypeConversion.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz.equals(Byte.TYPE)) {
            return new Byte(TypeConversion.asByte(object, TypeConversion.asByte(object2)));
        }
        if (clazz.equals(array$B == null ? (array$B = TypeConversion.class$("[B")) : array$B)) {
            return TypeConversion.asByteArray(object, TypeConversion.asByteArray(object2));
        }
        if (clazz.equals(class$java$lang$Character == null ? (class$java$lang$Character = TypeConversion.class$("java.lang.Character")) : class$java$lang$Character) || clazz.equals(Character.TYPE)) {
            return new Character(TypeConversion.asChar(object, TypeConversion.asChar(object2)));
        }
        if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = TypeConversion.class$("java.lang.Double")) : class$java$lang$Double) || clazz.equals(Double.TYPE)) {
            return new Double(TypeConversion.asDouble(object, TypeConversion.asDouble(object2)));
        }
        if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = TypeConversion.class$("java.lang.Float")) : class$java$lang$Float) || clazz.equals(Float.TYPE)) {
            return new Float(TypeConversion.asFloat(object, TypeConversion.asFloat(object2)));
        }
        if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = TypeConversion.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz.equals(Integer.TYPE)) {
            return new Integer(TypeConversion.asInt(object, TypeConversion.asInt(object2)));
        }
        if (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = TypeConversion.class$("java.lang.Long")) : class$java$lang$Long) || clazz.equals(Long.TYPE)) {
            return new Long(TypeConversion.asLong(object, TypeConversion.asLong(object2)));
        }
        if (clazz.equals(class$com$avocent$lib$net$IpAddress == null ? (class$com$avocent$lib$net$IpAddress = TypeConversion.class$("com.avocent.lib.net.IpAddress")) : class$com$avocent$lib$net$IpAddress)) {
            return TypeConversion.asIpAddress(object, TypeConversion.asIpAddress(object2));
        }
        if (clazz.equals(class$com$avocent$lib$net$MacAddress == null ? (class$com$avocent$lib$net$MacAddress = TypeConversion.class$("com.avocent.lib.net.MacAddress")) : class$com$avocent$lib$net$MacAddress)) {
            return TypeConversion.asMacAddress(object, TypeConversion.asMacAddress(object2));
        }
        if (clazz.equals(class$java$lang$Number == null ? (class$java$lang$Number = TypeConversion.class$("java.lang.Number")) : class$java$lang$Number)) {
            return TypeConversion.asNumber(object, TypeConversion.asNumber(object2));
        }
        if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = TypeConversion.class$("java.lang.Short")) : class$java$lang$Short) || clazz.equals(Short.TYPE)) {
            return new Short(TypeConversion.asShort(object, TypeConversion.asShort(object2)));
        }
        if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = TypeConversion.class$("java.lang.String")) : class$java$lang$String)) {
            return TypeConversion.asString(object, TypeConversion.asString(object2));
        }
        if (object2 == null) {
            return null;
        }
        return TypeConversion.asObject(object2, clazz);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

