/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.net.IpAddress;
import com.avocent.protocols.snmp.AsnCounter32;
import com.avocent.protocols.snmp.AsnGauge32;
import com.avocent.protocols.snmp.AsnInteger32;
import com.avocent.protocols.snmp.AsnIpAddress;
import com.avocent.protocols.snmp.AsnNull;
import com.avocent.protocols.snmp.AsnObject;
import com.avocent.protocols.snmp.AsnObjectIdentifier;
import com.avocent.protocols.snmp.AsnOctetString;
import com.avocent.protocols.snmp.AsnTimeTicks;
import com.avocent.protocols.snmp.ExceptionAsnBadValue;
import com.avocent.protocols.snmp.ExceptionUnknownMibName;
import com.avocent.protocols.snmp.ExceptionVarBindIncompatibleSyntax;
import com.avocent.protocols.snmp.ExceptionVarBindInvalidSyntax;
import com.avocent.protocols.snmp.Mib;

public class VarBind {
    AsnObjectIdentifier m_asnoidName = null;
    AsnObject m_asnobjValue = new AsnNull();

    public VarBind() {
        this.setNullValue();
    }

    public VarBind(String string) throws ExceptionUnknownMibName, ExceptionInvalidArgument {
        this.setName(string);
        this.setNullValue();
    }

    public VarBind(AsnObjectIdentifier asnObjectIdentifier, AsnObject asnObject) {
        this.m_asnoidName = asnObjectIdentifier;
        this.m_asnobjValue = asnObject;
    }

    public int getSyntax() {
        return this.m_asnobjValue.getSyntax();
    }

    public AsnObject getAsnObject() {
        return this.m_asnobjValue;
    }

    public String getName() {
        return Mib.OidToName(this.m_asnoidName);
    }

    public String getRelativeName() {
        return Mib.OidToRelativeName(this.m_asnoidName);
    }

    public AsnObjectIdentifier getOidName() throws ExceptionNoValue {
        if (this.m_asnoidName == null) {
            throw new ExceptionNoValue();
        }
        return this.m_asnoidName;
    }

    public void setName(String string) throws ExceptionUnknownMibName, ExceptionInvalidArgument {
        if (string == null) {
            throw new ExceptionInvalidArgument();
        }
        this.m_asnoidName = Mib.NameToOid(string);
    }

    public void setNullValue() {
        this.m_asnobjValue = new AsnNull();
    }

    public int getIntegerValue() throws ExceptionVarBindIncompatibleSyntax {
        switch (this.m_asnobjValue.getSyntax()) {
            case 2: {
                AsnInteger32 asnInteger32 = (AsnInteger32)this.m_asnobjValue;
                return asnInteger32.getIntegerValue();
            }
        }
        throw new ExceptionVarBindIncompatibleSyntax(this.m_asnobjValue.getSyntax());
    }

    public void setIntegerValue(int n) {
        this.m_asnobjValue = new AsnInteger32(n);
    }

    public long getUnsignedValue() throws ExceptionVarBindIncompatibleSyntax {
        switch (this.m_asnobjValue.getSyntax()) {
            case 67: {
                AsnTimeTicks asnTimeTicks = (AsnTimeTicks)this.m_asnobjValue;
                return asnTimeTicks.getUnsignedValue();
            }
            case 65: {
                AsnCounter32 asnCounter32 = (AsnCounter32)this.m_asnobjValue;
                return asnCounter32.getUnsignedValue();
            }
            case 66: {
                AsnGauge32 asnGauge32 = (AsnGauge32)this.m_asnobjValue;
                return asnGauge32.getUnsignedValue();
            }
        }
        throw new ExceptionVarBindIncompatibleSyntax(this.m_asnobjValue.getSyntax());
    }

    public void setUnsignedValue(long l, int n) throws ExceptionVarBindInvalidSyntax {
        l &= 0xFFFFFFFFL;
        switch (n) {
            case 66: {
                this.m_asnobjValue = new AsnGauge32(l);
                return;
            }
            case 65: {
                this.m_asnobjValue = new AsnCounter32(l);
                return;
            }
            case 67: {
                this.m_asnobjValue = new AsnTimeTicks(l);
                return;
            }
        }
        throw new ExceptionVarBindInvalidSyntax(n);
    }

    public String getStringValue() throws ExceptionVarBindIncompatibleSyntax {
        if (this.m_asnobjValue == null) {
            return "";
        }
        switch (this.m_asnobjValue.getSyntax()) {
            case 2: {
                AsnInteger32 asnInteger32 = (AsnInteger32)this.m_asnobjValue;
                return asnInteger32.getStringValue();
            }
            case 67: {
                AsnTimeTicks asnTimeTicks = (AsnTimeTicks)this.m_asnobjValue;
                return asnTimeTicks.getStringValue();
            }
            case 65: {
                AsnCounter32 asnCounter32 = (AsnCounter32)this.m_asnobjValue;
                return asnCounter32.getStringValue();
            }
            case 66: {
                AsnGauge32 asnGauge32 = (AsnGauge32)this.m_asnobjValue;
                return asnGauge32.getStringValue();
            }
            case 5: {
                AsnNull asnNull = (AsnNull)this.m_asnobjValue;
                return asnNull.getStringValue();
            }
            case 64: {
                AsnIpAddress asnIpAddress = (AsnIpAddress)this.m_asnobjValue;
                return asnIpAddress.getStringValue();
            }
            case 6: {
                AsnObjectIdentifier asnObjectIdentifier = (AsnObjectIdentifier)this.m_asnobjValue;
                return asnObjectIdentifier.getStringValue();
            }
            case 4: {
                AsnOctetString asnOctetString = (AsnOctetString)this.m_asnobjValue;
                return asnOctetString.getStringValue();
            }
        }
        throw new ExceptionVarBindIncompatibleSyntax(this.m_asnobjValue.getSyntax());
    }

    public byte[] getOctetStringValue() throws ExceptionVarBindIncompatibleSyntax {
        switch (this.m_asnobjValue.getSyntax()) {
            case 4: {
                AsnOctetString asnOctetString = (AsnOctetString)this.m_asnobjValue;
                return asnOctetString.getOctetStringValue();
            }
        }
        throw new ExceptionVarBindIncompatibleSyntax(this.m_asnobjValue.getSyntax());
    }

    public void setOctetStringValue(byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.m_asnobjValue = new AsnOctetString(byArray);
    }

    public void setStringValue(String string) {
        this.m_asnobjValue = new AsnOctetString(string);
    }

    public void setStringValue(String string, int n) throws ExceptionAsnBadValue, ExceptionVarBindInvalidSyntax {
        try {
            switch (n) {
                case 5: {
                    this.m_asnobjValue = new AsnNull();
                    break;
                }
                case 2: {
                    this.m_asnobjValue = new AsnInteger32(string);
                    break;
                }
                case 65: {
                    this.m_asnobjValue = new AsnCounter32(string);
                    break;
                }
                case 66: {
                    this.m_asnobjValue = new AsnGauge32(string);
                    break;
                }
                case 67: {
                    this.m_asnobjValue = new AsnTimeTicks(string);
                    break;
                }
                case 64: {
                    this.m_asnobjValue = new AsnIpAddress(string);
                    break;
                }
                case 4: {
                    this.m_asnobjValue = new AsnOctetString(string);
                    break;
                }
                case 6: {
                    this.m_asnobjValue = Mib.NameToOid(string);
                    break;
                }
                default: {
                    throw new ExceptionVarBindInvalidSyntax(n);
                }
            }
        }
        catch (Exception exception) {
            throw new ExceptionAsnBadValue();
        }
    }

    public IpAddress getIpAddressValue() throws ExceptionVarBindIncompatibleSyntax, ExceptionInvalidArgument {
        switch (this.m_asnobjValue.getSyntax()) {
            case 64: {
                AsnIpAddress asnIpAddress = (AsnIpAddress)this.m_asnobjValue;
                byte[] byArray = asnIpAddress.getIpAddressValue();
                IpAddress ipAddress = new IpAddress(byArray);
                return ipAddress;
            }
        }
        throw new ExceptionVarBindIncompatibleSyntax(this.m_asnobjValue.getSyntax());
    }

    public void setIpAddressValue(IpAddress ipAddress) throws ExceptionInvalidArgument {
        if (ipAddress == null) {
            throw new ExceptionInvalidArgument();
        }
        byte[] byArray = ipAddress.getBytes();
        if (byArray.length != 4) {
            throw new ExceptionInvalidArgument();
        }
        this.m_asnobjValue = new AsnIpAddress(byArray);
    }

    public int[] getOidValue() throws ExceptionVarBindIncompatibleSyntax {
        switch (this.m_asnobjValue.getSyntax()) {
            case 6: {
                AsnObjectIdentifier asnObjectIdentifier = (AsnObjectIdentifier)this.m_asnobjValue;
                return asnObjectIdentifier.getOidValue();
            }
        }
        throw new ExceptionVarBindIncompatibleSyntax(this.m_asnobjValue.getSyntax());
    }

    public void setOidValue(int[] nArray) throws ExceptionInvalidArgument {
        if (nArray == null) {
            throw new ExceptionInvalidArgument();
        }
        this.m_asnobjValue = new AsnObjectIdentifier(nArray);
    }

    public void copyFrom(VarBind varBind) throws ExceptionRequestFailed {
        if (varBind == null) {
            throw new ExceptionRequestFailed();
        }
        try {
            this.setName(varBind.getName());
            this.setStringValue(varBind.getStringValue(), varBind.getSyntax());
        }
        catch (Exception exception) {
            throw new ExceptionRequestFailed();
        }
    }
}

