/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp.tools;

import com.avocent.lib.debug.Trace;
import com.avocent.protocols.snmp.Mib;
import com.avocent.protocols.snmp.MibXmlExporter;
import com.avocent.protocols.snmp.MibbleLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;

public class AsnToMibXml {
    static /* synthetic */ Class class$com$avocent$protocols$snmp$tools$AsnToMibXml;

    private AsnToMibXml() {
    }

    private static void usage(int n) {
        System.out.println();
        System.out.println("ASN.1 To MIB XML Conversion Utility");
        System.out.println("--------------------------------------");
        System.out.println("Usage: java " + (class$com$avocent$protocols$snmp$tools$AsnToMibXml == null ? (class$com$avocent$protocols$snmp$tools$AsnToMibXml = AsnToMibXml.class$("com.avocent.protocols.snmp.tools.AsnToMibXml")) : class$com$avocent$protocols$snmp$tools$AsnToMibXml).getName() + " " + "[-full] [-ref REFERENCEPATHS]* [-resRef REFERENCEPATHS]* [MIBFILE] [-class CLASSNAME]");
        System.out.println("");
        System.out.println("-full    - Causes Output Files to Include Full MIB Information Including Descriptions.");
        System.out.println("-ref     - Specifies directories containing referenced MIBs.");
        System.out.println("-resRef  - Specifies paths to MIBs stored as resources.");
        System.out.println("-class   - Specifies to generate a stub class to load the MIB.");
        System.exit(n);
    }

    public static void main(String[] stringArray) throws Exception {
        Trace.startLogging(null);
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String[] stringArray2;
            String string3 = stringArray[i];
            if (string3.equals("-full")) {
                bl3 = true;
                System.out.println("Full Export Enabled");
                continue;
            }
            if (string3.equals("-class")) {
                bl4 = true;
                continue;
            }
            if (string3.equals("-ref")) {
                bl = true;
                continue;
            }
            if (string3.equals("-resRef")) {
                bl2 = true;
                continue;
            }
            if (string3.equals("-help")) {
                AsnToMibXml.usage(0);
                continue;
            }
            if (string3.equals("-?")) {
                AsnToMibXml.usage(0);
                continue;
            }
            if (string3.startsWith("-")) {
                System.out.println("ERROR: Invalid Option!");
                AsnToMibXml.usage(1);
                continue;
            }
            if (bl) {
                bl = false;
                stringArray2 = string3.split(File.pathSeparator);
                for (n = 0; n < stringArray2.length; ++n) {
                    if (stringArray2[n].length() <= 0) continue;
                    MibbleLoader.addReferencePath(new File(stringArray2[n]));
                    System.out.println("Added Reference Path: " + stringArray2[n]);
                }
                continue;
            }
            if (bl2) {
                bl = false;
                stringArray2 = string3.split(File.pathSeparator);
                for (n = 0; n < stringArray2.length; ++n) {
                    if (stringArray2[n].length() <= 0) continue;
                    MibbleLoader.addResourceReferencePath(stringArray2[n]);
                    System.out.println("Added Resource Reference Path: " + stringArray2[n]);
                }
                continue;
            }
            if (bl4) {
                bl4 = false;
                if (string2 != null) {
                    System.out.println("ERROR: Cannot Specify Multiple Class Files for Export");
                    AsnToMibXml.usage(1);
                }
                string2 = string3;
                continue;
            }
            if (string != null) {
                System.out.println("ERROR: Cannot Specify Multiple MIB Files for Import/Export");
                AsnToMibXml.usage(1);
            }
            string = string3;
        }
        if (string == null) {
            System.out.println("ERROR: No Mib Name Given!");
            AsnToMibXml.usage(1);
        }
        long l = System.currentTimeMillis();
        System.out.println("Loading Mib: " + string);
        MibbleLoader.loadMib(new File(string), true);
        long l2 = System.currentTimeMillis();
        System.out.println("Read ASN Files in " + (l2 - l) + "ms");
        Mib.dumpLoadedMibs(true);
        Map map = Mib.getAllMibs();
        Trace.logInfo((String)"AsnToMibXml:main", (String)("Loaded These Mibs: " + map));
        MibXmlExporter mibXmlExporter = new MibXmlExporter();
        mibXmlExporter.setExportDescriptions(bl3);
        l = System.currentTimeMillis();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            System.out.println("Exporting Mib: " + string4 + ".xml");
            FileOutputStream fileOutputStream = new FileOutputStream(string4 + ".xml");
            mibXmlExporter.export(string4, fileOutputStream);
            fileOutputStream.close();
            if (string2 == null) continue;
            System.out.println("Generating Class: " + string2);
            AsnToMibXml.generateClass(string2, string4 + ".xml");
        }
        l2 = System.currentTimeMillis();
        System.out.println("Exported XML File in " + (l2 - l) + "ms");
    }

    private static void generateClass(String string, String string2) throws IOException {
        String string3 = string.replace('.', File.separatorChar) + ".java";
        String string4 = null;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string4 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        File file = new File("." + File.separator + string3);
        file.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        printWriter.println("/*******************************************************************************");
        printWriter.println("* " + file.getName());
        printWriter.println("* ");
        printWriter.println("* Auto Generated");
        printWriter.println("* ");
        printWriter.println("* Copyright (c) 2004 Avocent Corporation");
        printWriter.println("******************************************************************************/");
        if (string4 != null) {
            printWriter.println("package " + string4 + ";");
        }
        printWriter.println("");
        printWriter.println("import java.io.*;");
        printWriter.println("");
        printWriter.println("import com.avocent.lib.debug.*;");
        printWriter.println("import com.avocent.protocols.snmp.*;");
        printWriter.println("");
        printWriter.println("/*******************************************************************************");
        printWriter.println("* <p>");
        printWriter.println("* Class to load the " + string2 + " MIB. This class was");
        printWriter.println("* automatically generated by the AsnToMibXml utility");
        printWriter.println("* </p>");
        printWriter.println("* ");
        printWriter.println("* @author Eduardo Fernandez");
        printWriter.println("*******************************************************************************/");
        printWriter.println("");
        printWriter.println("public final class " + string);
        printWriter.println("{");
        printWriter.println("");
        printWriter.println("   /***************************************************************************");
        printWriter.println("   * Static Initializer Loads the MIB XML as a Resource using MibXmlLoader ");
        printWriter.println("   ***************************************************************************/");
        printWriter.println("   static");
        printWriter.println("   {");
        printWriter.println("      try");
        printWriter.println("      {");
        printWriter.println("         Trace.logInfo( \"" + string + ":<clinit>\" , \"Loading MIB " + string2 + "\" );");
        printWriter.println("         InputStream is = " + string + ".class.getResourceAsStream( \"/" + string2 + "\");");
        printWriter.println("         MibXmlLoader.loadMib( is );");
        printWriter.println("         Trace.logInfo( \"" + string + ":<clinit>\" , \"Loaded MIB " + string2 + "\" );");
        printWriter.println("      }");
        printWriter.println("      catch ( IOException ioe )");
        printWriter.println("      {");
        printWriter.println("         Trace.logError( \"" + string + ":<clinit>\" , \"Could Not Load Mib: " + string2 + "\", ioe );");
        printWriter.println("      }");
        printWriter.println("      catch ( NullPointerException npe )");
        printWriter.println("      {");
        printWriter.println("         Trace.logError( \"" + string + ":<clinit>\" , \"Could Not Load Mib: " + string2 + "\", npe );");
        printWriter.println("      }");
        printWriter.println("   }");
        printWriter.println("}");
        printWriter.flush();
        fileOutputStream.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

