/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.socket;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.protocols.socket.SSLHandshakeCompletedListener;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class SSLHelper {
    private static final String TRACE_CONTEXT = "SSLHelper";
    private static SecureRandom m_sr = new SecureRandom();
    private static final int MAX_CONTEXT_CACHE_SIZE = Integer.getInteger("SSLHelper.MAX_CONTEXT_CACHE_SIZE", 50);
    private static final int SSL_HANDSHAKE_TIMEOUT = Integer.getInteger("SSLHelper.SSL_HANDSHAKE_TIMEOUT", 5000);
    private static Map m_sslContextCache = Collections.synchronizedMap(new LinkedHashMap(16, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() >= MAX_CONTEXT_CACHE_SIZE;
        }
    });
    private static final int TYPE_DNSNAME = 2;

    public static Certificate[] getCertificateChain(String string, int n) throws ExceptionRequestFailed {
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }
            }}, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
            sSLSocket.setSoTimeout(SSL_HANDSHAKE_TIMEOUT);
            Certificate[] certificateArray = sSLSocket.getSession().getPeerCertificates();
            sSLSocket.close();
            return certificateArray;
        }
        catch (Exception exception) {
            throw new ExceptionRequestFailed((Throwable)exception);
        }
    }

    public static SSLSocket createSSLSocket(String string, int n, int n2, boolean bl) throws ExceptionRequestFailed, SSLException {
        String[] stringArray = bl ? new String[]{"SSL_DH_anon_WITH_DES_CBC_SHA"} : new String[]{"SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "TLS_DH_anon_WITH_AES_128_CBC_SHA", "TLS_DH_DSS_WITH_AES_128_CBC_SHA", "TLS_DH_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA"};
        SSLSocket sSLSocket = null;
        Trace.logInfo((String)"SSLHelper:createSSLSocket", (String)"createSSLSocket() About to get the SSLSocketFactory");
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        sSLSocket = SSLHelper.createSSLSocket(null, string, n, n2, stringArray, sSLSocketFactory);
        return sSLSocket;
    }

    public static SSLSocket createSSLSocket(Socket socket, String string, int n, int n2, String string2, String string3, String string4) throws ExceptionRequestFailed, SSLException {
        return SSLHelper.createSSLSocket(socket, string, n, n2, string2, string3, string4, false);
    }

    public static SSLSocket createSSLSocket(Socket socket, String string, int n, int n2, String string2, String string3, String string4, boolean bl) throws ExceptionRequestFailed, SSLException {
        Trace.logInfo((String)"SSLHelper:createSSLSocket", (String)("Arguments given: socketTcpInetAddress=" + socket.getInetAddress() + ", nPort=" + n + ", nTimeout=" + n2 + ", szClientCertificateFile=" + string2 + ", szClientFilePassphrase=" + string3 + ", szCertAuthCertificateFile=" + string4 + " and bVerifyServerIpAddress=" + bl));
        if (string == null || socket == null) {
            Trace.logError((String)"SSLHelper:createSSLSocket", (String)"Invalid arguments. ");
            throw new ExceptionRequestFailed("Invalid arguments.");
        }
        SSLSocket sSLSocket = null;
        SSLSocketFactory sSLSocketFactory = null;
        Trace.logInfo((String)"SSLHelper:createSSLSocket", (String)"createSSLSocket() Determining set cipher suites to enable");
        String[] stringArray = SSLHelper.enableCipherSuites(string2 != null || string4 != null);
        try {
            sSLSocketFactory = SSLHelper.getSslSocketFactory(string2, string3, string4);
            sSLSocket = SSLHelper.createSSLSocket(socket, string, n, n2, stringArray, sSLSocketFactory);
            if (string4 != null && bl) {
                SSLHelper.verifyServerIpAddress(sSLSocket, string);
            }
        }
        catch (SSLException sSLException) {
            Trace.logError((String)"SSLHelper:createSSLSocket", (String)"Failed to establish SSL connection ", (Throwable)sSLException);
            throw sSLException;
        }
        catch (Exception exception) {
            Trace.logError((String)"SSLHelper:createSSLSocket", (String)"Failed to establish SSL connection ", (Throwable)exception);
            throw new ExceptionRequestFailed("Unable to connect to host");
        }
        return sSLSocket;
    }

    public static SSLSocket createSSLSocket(Socket socket, String string, int n, int n2, String[] stringArray, SSLSocketFactory sSLSocketFactory) throws ExceptionRequestFailed, SSLException {
        if (string == null || sSLSocketFactory == null || stringArray == null) {
            Trace.logError((String)"SSLHelper:createSSLSocket", (String)"Invalid arguments. ");
            throw new ExceptionRequestFailed("Invalid arguments.");
        }
        SSLSocket sSLSocket = null;
        try {
            String[] stringArray2;
            if (socket == null) {
                Trace.logInfo((String)"SSLHelper:createSSLSocket", (String)"No TCP Socket passed, creating one");
                stringArray2 = InetAddress.getByName(string);
                socket = new Socket();
                socket.connect(new InetSocketAddress((InetAddress)stringArray2, n), n2);
                Trace.logInfo((String)"SSLHelper:createSSLSocket", (String)"TCP Socket created.");
            }
            Trace.logInfo((String)"SSLHelper:createSSLSocket", (String)("createSSLSocket() About to create an SSLSocket over existing TCP socket=" + socket + " to Address=" + string + " and Port=" + n));
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string, n, true);
            sSLSocket.setEnabledCipherSuites(stringArray);
            stringArray2 = sSLSocket.getEnabledCipherSuites();
            Trace.logInfo((String)"SSLHelper:createSSLSocket", (String)"createSSLSocket() --- Enabled cipher suites list");
            for (int i = 0; i < stringArray2.length; ++i) {
                Trace.logInfo((String)"SSLHelper:createSSLSocket", (String)("    " + stringArray2[i]));
            }
            sSLSocket.setSoTimeout(n2);
            SSLHandshakeCompletedListener sSLHandshakeCompletedListener = new SSLHandshakeCompletedListener();
            Trace.logInfo((String)"SSLHelper:createSSLSocket", (String)"createSSLSocket() SSLSocket created, about to listen for handshake");
            sSLSocket.addHandshakeCompletedListener(sSLHandshakeCompletedListener);
            sSLSocket.startHandshake();
            int n3 = n2 / 100;
            for (int i = 0; !sSLHandshakeCompletedListener.isHandshakeCompleted() && i < n3; ++i) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!sSLHandshakeCompletedListener.isHandshakeCompleted()) {
                sSLSocket.close();
                Trace.logError((String)"SSLHelper:createSSLSocket", (String)"SSL handshake did not complete in timeout");
                throw new ExceptionRequestFailed();
            }
            sSLSocket.setSoTimeout(0);
            Trace.logInfo((String)"SSLHelper:createSSLSocket", (String)"The SSLSocket was created successfully and the handshake completed");
        }
        catch (SSLException sSLException) {
            Trace.logError((String)"SSLHelper:createSSLSocket", (String)"Failed to establish SSL connection ", (Throwable)sSLException);
            throw sSLException;
        }
        catch (Exception exception) {
            Trace.logError((String)"SSLHelper:createSSLSocket", (String)"Failed to establish SSL connection ", (Throwable)exception);
            throw new ExceptionRequestFailed("Unable to connect to host");
        }
        return sSLSocket;
    }

    public static SSLSocket createSSLSocket(Socket socket, String string, int n, int n2, PrivateKey privateKey, X509Certificate x509Certificate, X509Certificate x509Certificate2, boolean bl) throws ExceptionRequestFailed, SSLException {
        if (string == null || socket == null) {
            Trace.logError((String)"SSLHelper:createSSLSocket", (String)"Invalid arguments. ");
            throw new ExceptionRequestFailed("Invalid arguments.");
        }
        Trace.logInfo((String)"SSLHelper:createSSLSocket", (String)("Arguments given: socketTcpInetAddress=" + socket.getInetAddress() + ", nPort=" + n + ", nTimeout=" + n2 + ", pkClientPrivateKey=" + privateKey + ", x509ClientCertificate=" + x509Certificate + ", x509ServerCertificate=" + x509Certificate2 + " and bVerifyServerIpAddress=" + bl));
        SSLSocket sSLSocket = null;
        SSLSocketFactory sSLSocketFactory = null;
        Trace.logInfo((String)"SSLHelper:createSSLSocket", (String)"createSSLSocket() Determining set cipher suites to enable");
        String[] stringArray = SSLHelper.enableCipherSuites(privateKey != null || x509Certificate != null || x509Certificate2 != null);
        try {
            sSLSocketFactory = SSLHelper.getSSLSocketFactory(privateKey, new X509Certificate[]{x509Certificate}, x509Certificate2);
            sSLSocket = SSLHelper.createSSLSocket(socket, string, n, n2, stringArray, sSLSocketFactory);
            if (x509Certificate2 != null && bl) {
                SSLHelper.verifyServerIpAddress(sSLSocket, string);
            }
        }
        catch (SSLException sSLException) {
            Trace.logError((String)"SSLHelper:createSSLSocket", (String)"Failed to establish SSL connection ", (Throwable)sSLException);
            throw sSLException;
        }
        catch (Exception exception) {
            Trace.logError((String)"SSLHelper:createSSLSocket", (String)"Failed to establish SSL connection ", (Throwable)exception);
            throw new ExceptionRequestFailed("Unable to connect to host");
        }
        return sSLSocket;
    }

    public static SSLSocket createSSLSocket(Socket socket, String string, int n, int n2, String string2, byte[] byArray, X509Certificate x509Certificate, boolean bl) throws ExceptionRequestFailed, SSLException {
        if (string == null || socket == null) {
            Trace.logError((String)"SSLHelper:createSSLSocket", (String)"Invalid arguments. ");
            throw new ExceptionRequestFailed("Invalid arguments.");
        }
        Trace.logInfo((String)"SSLHelper:createSSLSocket", (String)("Arguments given: socketTcpInetAddress=" + socket.getInetAddress() + ", nPort=" + n + ", nTimeout=" + n2 + ", szPassPhrase=" + string2 + ", abyClientCertificate=" + byArray + ", x509ServerCertificate=" + x509Certificate + " and bVerifyServerIpAddress=" + bl));
        SSLSocket sSLSocket = null;
        SSLSocketFactory sSLSocketFactory = null;
        Trace.logInfo((String)"SSLHelper:createSSLSocket", (String)"createSSLSocket() Determining set cipher suites to enable");
        String[] stringArray = SSLHelper.enableCipherSuites(byArray != null || x509Certificate != null);
        try {
            sSLSocketFactory = SSLHelper.getSslSocketFactory(string2, byArray, x509Certificate);
            sSLSocket = SSLHelper.createSSLSocket(socket, string, n, n2, stringArray, sSLSocketFactory);
            if (x509Certificate != null && bl) {
                SSLHelper.verifyServerIpAddress(sSLSocket, string);
            }
        }
        catch (SSLException sSLException) {
            Trace.logError((String)"SSLHelper:createSSLSocket", (String)"Failed to establish SSL connection ", (Throwable)sSLException);
            throw sSLException;
        }
        catch (Exception exception) {
            Trace.logError((String)"SSLHelper:createSSLSocket", (String)"Failed to establish SSL connection ", (Throwable)exception);
            throw new ExceptionRequestFailed("Unable to connect to host");
        }
        return sSLSocket;
    }

    private static String[] enableCipherSuites(boolean bl) {
        String[] stringArray = null;
        stringArray = bl ? new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5"} : new String[]{"SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5"};
        return stringArray;
    }

    private static SSLSocketFactory getSslSocketFactory(String string, String string2, String string3) throws Exception {
        SSLSocketFactory sSLSocketFactory = null;
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        if (string != null || string3 != null) {
            KeyStore keyStore;
            Object object;
            Object object2;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyManagerFactory keyManagerFactory = null;
            TrustManagerFactory trustManagerFactory = null;
            if (string != null) {
                Trace.logInfo((String)"SSLHelper:getSslSocketFactory", (String)"Using client certificate to create KeyManager keystore.");
                object2 = null;
                if (string2 != null) {
                    object2 = string2.toCharArray();
                }
                object = new FileInputStream(string);
                keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load((InputStream)object, (char[])object2);
                keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyManagerFactory.init(keyStore, (char[])object2);
                Trace.logInfo((String)"SSLHelper:getSslSocketFactory", (String)"Closing client cert file input stream.");
                ((FileInputStream)object).close();
            }
            if (string3 != null) {
                Trace.logInfo((String)"SSLHelper:getSslSocketFactory", (String)"Using cert auth certificate to create TrustManager keystore.");
                object2 = new FileInputStream(string3);
                object = certificateFactory.generateCertificate((InputStream)object2);
                keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(null, null);
                keyStore.setCertificateEntry("CA alias", (Certificate)object);
                trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                trustManagerFactory.init(keyStore);
                Trace.logInfo((String)"SSLHelper:getSslSocketFactory", (String)"Closing cert auth file input stream.");
                ((FileInputStream)object2).close();
            }
            Trace.logInfo((String)"SSLHelper:getSslSocketFactory", (String)("Initializing SSL context with KeyManagerFactory=" + keyManagerFactory + " and TrustManagerFactory=" + trustManagerFactory + "."));
            sSLContext.init(keyManagerFactory == null ? null : keyManagerFactory.getKeyManagers(), trustManagerFactory == null ? null : trustManagerFactory.getTrustManagers(), null);
            Trace.logInfo((String)"SSLHelper:getSslSocketFactory", (String)"createSSLSocket() About to get the SSLSocketFactory");
            sSLSocketFactory = sSLContext.getSocketFactory();
        } else {
            Trace.logInfo((String)"SSLHelper:getSslSocketFactory", (String)"createSSLSocket() About to get the default SSLSocketFactory");
            sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        return sSLSocketFactory;
    }

    private static SSLSocketFactory getSslSocketFactory(String string, byte[] byArray, X509Certificate x509Certificate) throws Exception {
        SSLSocketFactory sSLSocketFactory = null;
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        if (byArray != null || x509Certificate != null) {
            Object object;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyManagerFactory keyManagerFactory = null;
            TrustManagerFactory trustManagerFactory = null;
            if (byArray != null) {
                Trace.logInfo((String)"SSLHelper:getSslSocketFactory", (String)"Using client cert bytes to create KeyManager keystore.");
                object = null;
                if (string != null) {
                    object = string.toCharArray();
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(byteArrayInputStream, (char[])object);
                keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyManagerFactory.init(keyStore, (char[])object);
            }
            if (x509Certificate != null) {
                Trace.logInfo((String)"SSLHelper:getSslSocketFactory", (String)"Using cert auth certificate to create TrustManager keystore.");
                object = KeyStore.getInstance("PKCS12");
                ((KeyStore)object).load(null, null);
                ((KeyStore)object).setCertificateEntry("CA alias", x509Certificate);
                trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                trustManagerFactory.init((KeyStore)object);
            }
            Trace.logInfo((String)"SSLHelper:getSslSocketFactory", (String)("Initializing SSL context with KeyManagerFactory=" + keyManagerFactory + " and TrustManagerFactory=" + trustManagerFactory + "."));
            sSLContext.init(keyManagerFactory == null ? null : keyManagerFactory.getKeyManagers(), trustManagerFactory == null ? null : trustManagerFactory.getTrustManagers(), null);
            Trace.logInfo((String)"SSLHelper:getSslSocketFactory", (String)"createSSLSocket() About to get the SSLSocketFactory");
            sSLSocketFactory = sSLContext.getSocketFactory();
        } else {
            Trace.logInfo((String)"SSLHelper:getSslSocketFactory", (String)"createSSLSocket() About to get the default SSLSocketFactory");
            sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        return sSLSocketFactory;
    }

    private static void verifyServerIpAddress(SSLSocket sSLSocket, String string) throws Exception {
        SSLSession sSLSession = sSLSocket.getSession();
        if (sSLSession != null) {
            Trace.logInfo((String)"SSLHelper:verifyServerIpAddress", (String)"Server authentication required.  Getting the server certificate chain from the SSL context, then verifying IP Address in the certificate matches the one we connected to...");
            Certificate[] certificateArray = sSLSession.getPeerCertificates();
            Trace.logInfo((String)"SSLHelper:verifyServerIpAddress", (String)("aPeerCerts=" + certificateArray));
            if (certificateArray != null && certificateArray.length > 0) {
                X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
                Trace.logInfo((String)"SSLHelper:verifyServerIpAddress", (String)("serverCert=" + x509Certificate + ", parsedServerCert=" + collection));
                if (collection != null) {
                    Iterator<List<?>> iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        List<?> list = iterator.next();
                        Integer n = (Integer)list.get(0);
                        if (n.longValue() != 2L) continue;
                        String string2 = (String)list.get(1);
                        Trace.logInfo((String)"SSLHelper:verifyServerIpAddress", (String)("Found  IP Address=" + string2 + " inside server certificate."));
                        if (string2.equals(string)) {
                            Trace.logError((String)"SSLHelper:verifyServerIpAddress", (String)"Server IP Address inside certificate matches the IP Address we connected to.  SSL Connection Succeeded.");
                            break;
                        }
                        Trace.logError((String)"SSLHelper:verifyServerIpAddress", (String)"Server IP Address inside certificate does not match the IP Address we connected to--dropping the connection.");
                        throw new ExceptionRequestFailed();
                    }
                }
            }
        }
    }

    public static SSLSocketFactory getSSLSocketFactory() throws IOException {
        return SSLHelper.getSSLContext(null, null, null).getSocketFactory();
    }

    public static SSLSocketFactory getSSLSocketFactory(X509Certificate x509Certificate) throws IOException {
        return SSLHelper.getSSLContext(null, null, new X509Certificate[]{x509Certificate}).getSocketFactory();
    }

    public static SSLSocketFactory getSSLSocketFactory(X509Certificate[] x509CertificateArray) throws IOException {
        return SSLHelper.getSSLContext(null, null, x509CertificateArray).getSocketFactory();
    }

    public static SSLSocketFactory getSSLSocketFactory(PrivateKey privateKey, X509Certificate[] x509CertificateArray) throws IOException {
        return SSLHelper.getSSLContext(privateKey, x509CertificateArray, null).getSocketFactory();
    }

    public static SSLSocketFactory getSSLSocketFactory(PrivateKey privateKey, X509Certificate[] x509CertificateArray, X509Certificate x509Certificate) throws IOException {
        return SSLHelper.getSSLContext(privateKey, x509CertificateArray, new X509Certificate[]{x509Certificate}).getSocketFactory();
    }

    public static SSLSocketFactory getSSLSocketFactory(PrivateKey privateKey, X509Certificate[] x509CertificateArray, X509Certificate[] x509CertificateArray2) throws IOException {
        return SSLHelper.getSSLContext(privateKey, x509CertificateArray, x509CertificateArray2).getSocketFactory();
    }

    public static SSLServerSocketFactory getSSLServerSocketFactory(PrivateKey privateKey, X509Certificate[] x509CertificateArray) throws IOException {
        return SSLHelper.getSSLContext(privateKey, x509CertificateArray, null).getServerSocketFactory();
    }

    public static SSLServerSocketFactory getSSLServerSocketFactory(PrivateKey privateKey, X509Certificate[] x509CertificateArray, X509Certificate x509Certificate) throws IOException {
        return SSLHelper.getSSLContext(privateKey, x509CertificateArray, new X509Certificate[]{x509Certificate}).getServerSocketFactory();
    }

    public static SSLServerSocketFactory getSSLServerSocketFactory(PrivateKey privateKey, X509Certificate[] x509CertificateArray, X509Certificate[] x509CertificateArray2) throws IOException {
        return SSLHelper.getSSLContext(privateKey, x509CertificateArray, x509CertificateArray2).getServerSocketFactory();
    }

    private static SSLContext getSSLContext(PrivateKey privateKey, X509Certificate[] x509CertificateArray, X509Certificate[] x509CertificateArray2) throws IOException {
        SSLContextKey sSLContextKey = new SSLContextKey(privateKey, x509CertificateArray, x509CertificateArray2);
        SSLContext sSLContext = null;
        sSLContext = (SSLContext)m_sslContextCache.get(sSLContextKey);
        if (sSLContext == null) {
            try {
                sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(new KeyManager[]{new SimpleKeyManager(privateKey, x509CertificateArray)}, new TrustManager[]{new SimpleTrustManager(x509CertificateArray2)}, m_sr);
                m_sslContextCache.put(sSLContextKey, sSLContext);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Unable to create SSL Context", (Throwable)noSuchAlgorithmException);
                throw new IOException("NoSuchAlgorithmException: " + noSuchAlgorithmException);
            }
            catch (KeyManagementException keyManagementException) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Unable to create SSL Context", (Throwable)keyManagementException);
                throw new IOException("KeyManagementException: " + keyManagementException);
            }
        }
        return sSLContext;
    }

    private static class SimpleTrustManager
    implements X509TrustManager {
        private X509Certificate[] m_ax509cTrusted;

        private SimpleTrustManager(X509Certificate[] x509CertificateArray) {
            if (x509CertificateArray != null && x509CertificateArray.length != 0 && (x509CertificateArray.length != 1 || x509CertificateArray[0] != null)) {
                this.m_ax509cTrusted = x509CertificateArray;
            }
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.checkServerTrusted(x509CertificateArray, string);
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this.m_ax509cTrusted == null) {
                return;
            }
            if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                throw new CertificateException("Empty Certificate Chain");
            }
            for (int i = 0; i < this.m_ax509cTrusted.length; ++i) {
                if (!x509CertificateArray[0].equals(this.m_ax509cTrusted[i])) continue;
                return;
            }
            throw new CertificateException("Could Not Find Matching Certificate in Chain");
        }

        public X509Certificate[] getAcceptedIssuers() {
            return this.m_ax509cTrusted;
        }
    }

    private static class SimpleKeyManager
    implements X509KeyManager {
        private X509Certificate[] m_acertificate;
        private PrivateKey m_privateKey;

        private SimpleKeyManager(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
            this.m_acertificate = x509CertificateArray;
            this.m_privateKey = privateKey;
        }

        public X509Certificate[] getCertificateChain(String string) {
            if (this.m_acertificate == null) {
                return new X509Certificate[0];
            }
            return this.m_acertificate;
        }

        public PrivateKey getPrivateKey(String string) {
            return this.m_privateKey;
        }

        public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
            return "default";
        }

        public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
            return "default";
        }

        public String[] getClientAliases(String string, Principal[] principalArray) {
            return new String[]{"default"};
        }

        public String[] getServerAliases(String string, Principal[] principalArray) {
            return new String[]{"default"};
        }
    }

    private static class SSLContextKey {
        private int m_hashCode = 0x55555555;
        private PrivateKey m_pkey;
        private X509Certificate[] m_clientCerts;
        private X509Certificate[] m_serverCerts;

        public SSLContextKey(PrivateKey privateKey, X509Certificate[] x509CertificateArray, X509Certificate[] x509CertificateArray2) {
            int n;
            this.m_pkey = privateKey;
            this.m_clientCerts = x509CertificateArray;
            this.m_serverCerts = x509CertificateArray2;
            if (privateKey != null) {
                this.m_hashCode ^= privateKey.hashCode();
            }
            if (x509CertificateArray != null) {
                for (n = 0; n < x509CertificateArray.length; ++n) {
                    if (x509CertificateArray[n] == null) continue;
                    this.m_hashCode ^= x509CertificateArray[n].hashCode();
                }
            }
            if (x509CertificateArray2 != null) {
                for (n = 0; n < x509CertificateArray2.length; ++n) {
                    if (x509CertificateArray2[n] == null) continue;
                    this.m_hashCode ^= x509CertificateArray2[n].hashCode();
                }
            }
        }

        public int hashCode() {
            return this.m_hashCode;
        }

        public boolean equals(Object object) {
            SSLContextKey sSLContextKey = (SSLContextKey)object;
            if (sSLContextKey.m_hashCode != this.m_hashCode) {
                return false;
            }
            if (!(this.m_pkey != null ? sSLContextKey.m_pkey != null && this.m_pkey.equals(sSLContextKey.m_pkey) : sSLContextKey.m_pkey == null)) {
                return false;
            }
            if (!Arrays.equals(this.m_clientCerts, sSLContextKey.m_clientCerts)) {
                return false;
            }
            return Arrays.equals(this.m_serverCerts, sSLContextKey.m_serverCerts);
        }
    }
}

