/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.debug;

import com.avocent.lib.debug.Assert;
import com.avocent.lib.debug.TraceDestination;
import com.avocent.lib.debug.TraceFilter;
import com.avocent.lib.debug.TraceFormat;
import com.avocent.lib.debug.TraceLevel;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Trace {
    private static TraceDestination m_tracedestination = new TraceDestination();
    private static TraceFormat m_traceformat = new TraceFormat();
    private static TraceLevel m_tracelevel = new TraceLevel();
    private static TraceFilter m_tracefilter = new TraceFilter();
    private static PrintWriter m_pwConsole = null;
    private static PrintWriter m_pwFile = null;
    private static SimpleDateFormat m_sdfDateFormatter = null;
    private static SimpleDateFormat m_sdfTimeFormatter = null;
    private static Pattern m_streamPattern = null;
    private static SimpleDateFormat m_sdfStreamFormat = new SimpleDateFormat(".MM-dd-yy-HH-mm-ss");

    public static void startLogging(Properties properties) {
        try {
            Object object;
            Object object2;
            Object object3;
            Comparable<File> comparable;
            Trace.stopLogging();
            if (properties == null) {
                try {
                    comparable = new File("trace.properties");
                    object3 = new FileInputStream((File)comparable);
                    properties = new Properties();
                    properties.load((InputStream)object3);
                    ((FileInputStream)object3).close();
                }
                catch (Exception exception) {
                    return;
                }
            }
            comparable = new Boolean(properties.getProperty("LogToConsole", "false").trim());
            m_tracedestination.enableConsoleOutput((Boolean)comparable);
            object3 = new Boolean(properties.getProperty("LogToFile", "false").trim());
            Boolean bl = new Boolean(properties.getProperty("AppendLogFile", "true").trim());
            m_tracedestination.enableFileOutput((Boolean)object3, bl);
            Boolean bl2 = new Boolean(properties.getProperty("LogInfo", "false").trim());
            m_tracelevel.enableInfo(bl2);
            Boolean bl3 = new Boolean(properties.getProperty("LogError", "false").trim());
            m_tracelevel.enableError(bl3);
            Boolean bl4 = new Boolean(properties.getProperty("LogStack", "false").trim());
            m_tracelevel.enableStackTrace(bl4);
            Boolean bl5 = new Boolean(properties.getProperty("LogAssert", "false").trim());
            Assert.setEnabled(bl5);
            String string = properties.getProperty("OutputFields", "DATE TIME CLASS METHOD").trim();
            String string2 = properties.getProperty("ContextWidth", "0").trim();
            try {
                m_traceformat.setContextWidth(Integer.parseInt(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string.indexOf("DATE") != -1) {
                m_traceformat.enableDate(true);
            } else {
                m_traceformat.enableDate(false);
            }
            if (string.indexOf("TIME") != -1) {
                m_traceformat.enableTime(true);
            } else {
                m_traceformat.enableTime(false);
            }
            if (string.indexOf("THREAD") != -1) {
                m_traceformat.enableThread(true);
            } else {
                m_traceformat.enableThread(false);
            }
            if (string.indexOf("CONTEXT") != -1) {
                m_traceformat.enableContext(true);
            } else {
                m_traceformat.enableContext(false);
            }
            boolean bl6 = false;
            boolean bl7 = false;
            String string3 = properties.getProperty("FilterType", "None").trim();
            if (string3.equalsIgnoreCase("inclusive")) {
                bl6 = true;
                bl7 = false;
            } else if (string3.equalsIgnoreCase("exclusive")) {
                bl6 = true;
                bl7 = true;
            }
            m_tracefilter.enableFilter(bl6, bl7);
            m_tracefilter.setContextFilter(properties.getProperty("FilterContextContains", "").trim());
            m_tracefilter.setMessageFilter(properties.getProperty("FilterMessageContains", "").trim());
            String string4 = properties.getProperty("TraceStreams");
            try {
                if (string4 != null) {
                    m_streamPattern = Pattern.compile(string4);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Trace.log("Error in TraceStreams: " + patternSyntaxException);
            }
            if (((Boolean)comparable).booleanValue() && m_pwConsole == null) {
                object2 = new OutputStreamWriter(System.out);
                object = new BufferedWriter((Writer)object2);
                m_pwConsole = new PrintWriter((Writer)object, true);
            }
            if (((Boolean)object3).booleanValue() && m_pwFile == null) {
                try {
                    object2 = new FileOutputStream("trace.log", (boolean)bl);
                    object = new BufferedOutputStream((OutputStream)object2);
                    m_pwFile = new PrintWriter((OutputStream)object, true);
                }
                catch (Exception exception) {
                    m_pwFile = null;
                }
            }
            if (m_sdfDateFormatter == null) {
                m_sdfDateFormatter = new SimpleDateFormat("MM/dd/yyyy", Locale.getDefault());
            }
            if (m_sdfTimeFormatter == null) {
                m_sdfTimeFormatter = new SimpleDateFormat("hh:mm:ss:SSSSS", Locale.getDefault());
            }
            Trace.log("==============================================================================");
            object2 = new Date();
            Trace.log("TRACE DEBUG LOGGING STARTED - " + m_sdfDateFormatter.format((Date)object2));
            Trace.log("==============================================================================");
            Trace.log("Platform Information:");
            Trace.log("-----------------------------------------");
            Trace.log("   - OS           : " + System.getProperty("os.name"));
            Trace.log("   - Version      : " + System.getProperty("os.version"));
            Trace.log("   - Platform     : " + System.getProperty("os.arch"));
            Trace.log("   - JDK Version  : " + System.getProperty("java.version"));
            Trace.log("   - JDK Vendor   : " + System.getProperty("java.vendor"));
            Trace.log("");
            Trace.log("Debug Settings:");
            Trace.log("-----------------------------------------");
            Trace.log("   - LogToConsole : " + ((Boolean)comparable).toString());
            Trace.log("   - LogToFile    : " + ((Boolean)object3).toString());
            Trace.log("   - AppendLogFile: " + bl.toString());
            Trace.log("   - LogInfo      : " + bl2.toString());
            Trace.log("   - LogError     : " + bl3.toString());
            Trace.log("   - LogStack     : " + bl4.toString());
            Trace.log("   - Filter       : " + m_tracefilter.isEnabled());
            if (m_tracefilter.isEnabled()) {
                object = m_tracefilter.isFilterExclusive() ? "Exclusive" : "Inclusive";
                Trace.log("        Mode      : " + (String)object);
                Trace.log("        Context   : " + m_tracefilter.getContextFilter());
                Trace.log("        Message   : " + m_tracefilter.getMessageFilter());
            }
            Trace.log("   - Streams      : " + (m_streamPattern == null ? "" : m_streamPattern.pattern()));
            Trace.log("==============================================================================");
            Trace.log("Trace Information :");
            Trace.log("==============================================================================");
        }
        catch (Exception exception) {}
    }

    public static String getFullStreamName(String string, Object object) {
        return Trace.getStreamName(string, object) + m_sdfStreamFormat.format(new Date());
    }

    private static String getStreamName(String string, Object object) {
        if (object == null) {
            return string;
        }
        if (object instanceof Socket) {
            Socket socket = (Socket)object;
            return string + "-" + socket.getLocalAddress().getHostAddress() + "_" + socket.getLocalPort() + "-" + socket.getInetAddress().getHostAddress() + "_" + socket.getPort();
        }
        return string + "-" + object;
    }

    public static boolean isStreamLogged(String string, Object object) {
        return Trace.isTraceEnabled() && !Trace.isFiltered(string, "") && m_streamPattern != null && m_streamPattern.matcher(Trace.getStreamName(string, object)).matches();
    }

    public static void stopLogging() {
        try {
            Trace.log("==============================================================================");
            Date date = new Date();
            Trace.log("TRACE DEBUG LOGGING STOPPED - " + m_sdfDateFormatter.format(date));
            Trace.log("==============================================================================");
            Trace.log("");
            if (m_pwFile != null) {
                m_pwFile.close();
                m_pwFile = null;
            }
            if (m_pwConsole != null) {
                m_pwConsole = null;
            }
            m_tracedestination.enableConsoleOutput(false);
            m_tracedestination.enableFileOutput(false, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        m_tracedestination.enableConsoleOutput(false);
        m_tracedestination.enableFileOutput(false, false);
    }

    private static void log(String string, String string2, boolean bl, Throwable throwable) {
        block20: {
            try {
                if (!m_tracedestination.isEnabled()) {
                    return;
                }
                if (!m_tracelevel.isInfoEnabled()) {
                    return;
                }
                if (string == null || string2 == null) {
                    return;
                }
                Date date = new Date();
                StringBuffer stringBuffer = new StringBuffer();
                if (m_traceformat.isDateEnabled()) {
                    stringBuffer.append(m_sdfDateFormatter.format(date));
                    stringBuffer.append(" ");
                }
                if (m_traceformat.isTimeEnabled()) {
                    stringBuffer.append(m_sdfTimeFormatter.format(date));
                    stringBuffer.append(" ");
                }
                if (m_traceformat.isThreadEnabled()) {
                    stringBuffer.append(Thread.currentThread().getName());
                    stringBuffer.append(" ");
                }
                if (m_traceformat.isContextEnabled()) {
                    int n = m_traceformat.getContextWidth();
                    if (n > 5) {
                        if (string.length() > n) {
                            string = string.substring(0, n - 2);
                            string = string + "..";
                        }
                        if (string.length() < n) {
                            while (string.length() < n) {
                                string = string + " ";
                            }
                        }
                    }
                    stringBuffer.append("(");
                    stringBuffer.append(string);
                    stringBuffer.append(") ");
                }
                String string3 = "";
                if (bl) {
                    stringBuffer.append("# ### ");
                    stringBuffer.append(Trace.getPrintable(string2.toUpperCase()));
                    stringBuffer.append(" ### ");
                    if (m_tracelevel.isStackTraceEnabled()) {
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        if (throwable == null) {
                            throwable = new Throwable();
                        }
                        throwable.printStackTrace(printWriter);
                        string3 = "# ### " + stringWriter.toString() + " ### ";
                    }
                } else {
                    stringBuffer.append("> ");
                    stringBuffer.append(Trace.getPrintable(string2));
                }
                if (m_pwConsole != null && m_tracedestination.isConsoleOutputEnabled()) {
                    m_pwConsole.println(stringBuffer.toString());
                    if (string3.length() > 0) {
                        m_pwConsole.println(string3);
                    }
                }
                if (m_pwFile == null || !m_tracedestination.isFileOutputEnabled()) break block20;
                m_pwFile.println(stringBuffer.toString());
                if (string3.length() > 0) {
                    m_pwFile.println(string3);
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void logInfo(String string, String string2) {
        if (!m_tracedestination.isEnabled()) {
            return;
        }
        if (!m_tracelevel.isInfoEnabled()) {
            return;
        }
        if (Trace.isFiltered(string, string2)) {
            return;
        }
        Trace.log(string, string2, false, null);
    }

    public static void logError(String string, String string2, Throwable throwable) {
        if (!m_tracedestination.isEnabled()) {
            return;
        }
        if (!m_tracelevel.isErrorEnabled()) {
            return;
        }
        if (Trace.isFiltered(string, string2)) {
            return;
        }
        Trace.log(string, string2, true, throwable);
    }

    public static void logError(String string, String string2) {
        Trace.logError(string, string2, null);
    }

    private static void log(String string) {
        Trace.log("", string, false, null);
    }

    private static boolean isFiltered(String string, String string2) {
        if (!m_tracefilter.isEnabled()) {
            return false;
        }
        String string3 = m_tracefilter.getContextFilter().trim().toUpperCase();
        String string4 = m_tracefilter.getMessageFilter().trim().toUpperCase();
        boolean bl = m_tracefilter.isFilterExclusive();
        boolean bl2 = false;
        if (string3.length() > 0 && string.trim().toUpperCase().indexOf(string3) != -1) {
            bl2 = true;
        }
        boolean bl3 = false;
        if (string4.length() > 0 && string2.trim().toUpperCase().indexOf(string4) != -1) {
            bl3 = true;
        }
        if (bl) {
            if (string3.length() > 0 && string4.length() > 0) {
                return string.trim().toUpperCase().indexOf(string3) != -1 && string2.trim().toUpperCase().indexOf(string4) != -1;
            }
            if (string3.length() > 0) {
                return string.trim().toUpperCase().indexOf(string3) != -1;
            }
            if (string4.length() > 0) {
                return string2.trim().toUpperCase().indexOf(string4) != -1;
            }
            return false;
        }
        if (string3.length() > 0 && string4.length() > 0) {
            return string.trim().toUpperCase().indexOf(string3) == -1 || string2.trim().toUpperCase().indexOf(string4) == -1;
        }
        if (string3.length() > 0) {
            return string.trim().toUpperCase().indexOf(string3) == -1;
        }
        if (string4.length() > 0) {
            return string2.trim().toUpperCase().indexOf(string4) == -1;
        }
        return false;
    }

    private static String getPrintable(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            int n2 = string.charAt(n);
            if ((n2 &= 0xFF) < 32 || n2 >= 127) {
                String string2 = Integer.toHexString(n2);
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                stringBuffer.append("<0x");
                stringBuffer.append(string2.toUpperCase());
                stringBuffer.append(">");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String getCaller() {
        try {
            int n;
            String string;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            Throwable throwable = new Throwable();
            throwable.printStackTrace(printWriter);
            String string2 = stringWriter.toString();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
            String string3 = "";
            while ((string = bufferedReader.readLine()) != null) {
                string3 = string;
            }
            if (string3.length() != 0 && (string3 = string3.trim()).startsWith("at ") && (n = (string3 = string3.substring(2)).indexOf("(")) != -1) {
                string3 = string3.substring(0, n);
                return string3;
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getPackage(String string) {
        int n = string.lastIndexOf(".");
        if (n <= 0) {
            return "";
        }
        int n2 = string.lastIndexOf(".", n - 1);
        if (n2 == -1) {
            return "";
        }
        return string.substring(0, n2);
    }

    private static String getClass(String string) {
        int n = string.lastIndexOf(".");
        if (n <= 0) {
            return string;
        }
        int n2 = string.lastIndexOf(".", n - 1);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1, n);
    }

    private static String getMethod(String string) {
        int n = string.lastIndexOf(".");
        if (n <= 0) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static boolean isTraceEnabled() {
        return m_tracedestination.isEnabled() && m_tracelevel.isInfoEnabled();
    }
}

