/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.debug;

import com.avocent.lib.debug.Trace;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class TraceInputStream
extends InputStream {
    static final byte[] NULL_DATA = new byte[1024];
    InputStream m_in;
    FileOutputStream m_fos;
    String m_szName;
    private long m_lMarkOff;
    private boolean m_bMarked;

    public TraceInputStream(String string, Object object, InputStream inputStream) {
        block2: {
            this.m_in = null;
            this.m_fos = null;
            this.m_lMarkOff = 0L;
            this.m_bMarked = false;
            this.m_in = inputStream;
            if (!Trace.isStreamLogged(string, object)) break block2;
            this.m_szName = Trace.getFullStreamName(string, object) + ".istream";
            try {
                this.m_fos = new FileOutputStream(this.m_szName);
                Trace.logInfo("TraceInputStream:<init>", "Opened Log: " + this.m_szName);
            }
            catch (IOException iOException) {
                Trace.logError("TraceInputStream:<init>", "Could Not Open Log: " + this.m_szName, iOException);
            }
        }
    }

    public int available() throws IOException {
        return this.m_in.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.m_in.close();
        }
        finally {
            if (this.m_fos != null) {
                try {
                    this.m_fos.close();
                    this.m_fos = null;
                    Trace.logInfo("TraceInputStream:close", "Closed Log: " + this.m_szName);
                }
                catch (IOException iOException) {
                    Trace.logError("TraceInputStream:close", "Could Not Close Log: " + this.m_szName, iOException);
                }
            }
        }
    }

    public void mark(int n) {
        this.m_in.mark(n);
        this.m_bMarked = true;
        this.m_lMarkOff = 0L;
    }

    public boolean markSupported() {
        return this.m_in.markSupported();
    }

    public int read() throws IOException {
        int n;
        block7: {
            n = this.m_in.read();
            if (this.m_fos == null || n == -1) break block7;
            if (!this.m_bMarked && this.m_lMarkOff > 0L) {
                --this.m_lMarkOff;
            } else {
                if (this.m_bMarked) {
                    ++this.m_lMarkOff;
                }
                try {
                    this.m_fos.write(n);
                }
                catch (IOException iOException) {
                    Trace.logError("TraceInputStream:read", "Error Writing to Log: " + this.m_szName, iOException);
                    try {
                        this.m_fos.close();
                        this.m_fos = null;
                        Trace.logInfo("TraceInputStream:read", "Closed Log: " + this.m_szName);
                    }
                    catch (IOException iOException2) {
                        Trace.logError("TraceInputStream:read", "Could Not Close Log: " + this.m_szName, iOException2);
                    }
                }
            }
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n;
        block8: {
            n = this.m_in.read(byArray);
            if (this.m_fos == null || n == -1) break block8;
            if (!this.m_bMarked && this.m_lMarkOff > (long)n) {
                this.m_lMarkOff -= (long)n;
            } else {
                if (this.m_bMarked) {
                    this.m_lMarkOff += (long)n;
                }
                int n2 = n;
                int n3 = 0;
                if (!this.m_bMarked) {
                    n2 = (int)((long)n2 - this.m_lMarkOff);
                    n3 += n - n2;
                    this.m_lMarkOff = 0L;
                }
                try {
                    this.m_fos.write(byArray, n3, n2);
                }
                catch (IOException iOException) {
                    Trace.logError("TraceInputStream:read", "Error Writing to Log: " + this.m_szName, iOException);
                    try {
                        this.m_fos.close();
                        this.m_fos = null;
                        Trace.logInfo("TraceInputStream:read", "Closed Log: " + this.m_szName);
                    }
                    catch (IOException iOException2) {
                        Trace.logError("TraceInputStream:read", "Could Not Close Log: " + this.m_szName, iOException2);
                    }
                }
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block8: {
            n3 = this.m_in.read(byArray, n, n2);
            if (this.m_fos == null || n3 == -1) break block8;
            if (!this.m_bMarked && this.m_lMarkOff > (long)n3) {
                this.m_lMarkOff -= (long)n3;
            } else {
                if (this.m_bMarked) {
                    this.m_lMarkOff += (long)n3;
                }
                int n4 = n3;
                if (!this.m_bMarked) {
                    n4 = (int)((long)n4 - this.m_lMarkOff);
                    n += n3 - n4;
                    this.m_lMarkOff = 0L;
                }
                try {
                    this.m_fos.write(byArray, n, n4);
                }
                catch (IOException iOException) {
                    Trace.logError("TraceInputStream:read", "Error Writing to Log: " + this.m_szName, iOException);
                    try {
                        this.m_fos.close();
                        this.m_fos = null;
                        Trace.logInfo("TraceInputStream:read", "Closed Log: " + this.m_szName);
                    }
                    catch (IOException iOException2) {
                        Trace.logError("TraceInputStream:read", "Could Not Close Log: " + this.m_szName, iOException2);
                    }
                }
            }
        }
        return n3;
    }

    public void reset() throws IOException {
        this.m_in.reset();
        this.m_bMarked = false;
    }

    public long skip(long l) throws IOException {
        block9: {
            if ((l = this.m_in.skip(l)) <= 0L || this.m_fos == null) break block9;
            if (!this.m_bMarked && this.m_lMarkOff > l) {
                this.m_lMarkOff -= l;
            } else {
                long l2 = l;
                if (this.m_bMarked) {
                    this.m_lMarkOff += l;
                } else {
                    l2 -= this.m_lMarkOff;
                    this.m_lMarkOff = 0L;
                }
                try {
                    while (l2 > (long)NULL_DATA.length) {
                        this.m_fos.write(NULL_DATA);
                        l2 -= (long)NULL_DATA.length;
                    }
                    this.m_fos.write(NULL_DATA, 0, (int)l2);
                }
                catch (IOException iOException) {
                    Trace.logError("TraceInputStream:skip", "Error Writing to Log: " + this.m_szName, iOException);
                    try {
                        this.m_fos.close();
                        this.m_fos = null;
                        Trace.logInfo("TraceInputStream:skip", "Closed Log: " + this.m_szName);
                    }
                    catch (IOException iOException2) {
                        Trace.logError("TraceInputStream:skip", "Could Not Close Log: " + this.m_szName, iOException2);
                    }
                }
            }
        }
        return l;
    }

    static {
        Arrays.fill(NULL_DATA, (byte)85);
    }
}

