/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.debug;

import com.avocent.lib.debug.Trace;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public class TraceReader
extends Reader {
    static final char[] NULL_DATA = new char[1024];
    Reader m_in;
    FileWriter m_fw;
    String m_szName;
    private long m_lMarkOff;
    private boolean m_bMarked;

    public TraceReader(String string, Object object, Reader reader) {
        block2: {
            this.m_in = null;
            this.m_fw = null;
            this.m_lMarkOff = 0L;
            this.m_bMarked = false;
            this.m_in = reader;
            if (!Trace.isStreamLogged(string, object)) break block2;
            this.m_szName = Trace.getFullStreamName(string, object) + ".reader";
            try {
                this.m_fw = new FileWriter(this.m_szName);
                Trace.logInfo("TraceReader:<init>", "Opened Log: " + this.m_szName);
            }
            catch (IOException iOException) {
                Trace.logError("TraceReader:<init>", "Could Not Open Log: " + this.m_szName, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.m_in.close();
        }
        finally {
            if (this.m_fw != null) {
                try {
                    this.m_fw.close();
                    this.m_fw = null;
                    Trace.logInfo("TraceReader:close", "Closed Log: " + this.m_szName);
                }
                catch (IOException iOException) {
                    Trace.logError("TraceReader:close", "Could Not Close Log: " + this.m_szName, iOException);
                }
            }
        }
    }

    public boolean ready() throws IOException {
        return this.m_in.ready();
    }

    public void mark(int n) throws IOException {
        this.m_in.mark(n);
        this.m_bMarked = true;
        this.m_lMarkOff = 0L;
    }

    public boolean markSupported() {
        return this.m_in.markSupported();
    }

    public int read() throws IOException {
        int n;
        block7: {
            n = this.m_in.read();
            if (this.m_fw == null || n == -1) break block7;
            if (!this.m_bMarked && this.m_lMarkOff > 0L) {
                --this.m_lMarkOff;
            } else {
                if (this.m_bMarked) {
                    ++this.m_lMarkOff;
                }
                try {
                    this.m_fw.write(n);
                }
                catch (IOException iOException) {
                    Trace.logError("TraceReader:read", "Error Writing to Log: " + this.m_szName, iOException);
                    try {
                        this.m_fw.close();
                        this.m_fw = null;
                        Trace.logInfo("TraceReader:read", "Closed Log: " + this.m_szName);
                    }
                    catch (IOException iOException2) {
                        Trace.logError("TraceReader:read", "Could Not Close Log: " + this.m_szName, iOException2);
                    }
                }
            }
        }
        return n;
    }

    public int read(char[] cArray) throws IOException {
        int n;
        block8: {
            n = this.m_in.read(cArray);
            if (this.m_fw == null || n == -1) break block8;
            if (!this.m_bMarked && this.m_lMarkOff > (long)n) {
                this.m_lMarkOff -= (long)n;
            } else {
                if (this.m_bMarked) {
                    this.m_lMarkOff += (long)n;
                }
                int n2 = n;
                int n3 = 0;
                if (!this.m_bMarked) {
                    n2 = (int)((long)n2 - this.m_lMarkOff);
                    n3 += n - n2;
                    this.m_lMarkOff = 0L;
                }
                try {
                    this.m_fw.write(cArray, n3, n2);
                }
                catch (IOException iOException) {
                    Trace.logError("TraceReader:read", "Error Writing to Log: " + this.m_szName, iOException);
                    try {
                        this.m_fw.close();
                        this.m_fw = null;
                        Trace.logInfo("TraceReader:read", "Closed Log: " + this.m_szName);
                    }
                    catch (IOException iOException2) {
                        Trace.logError("TraceReader:read", "Could Not Close Log: " + this.m_szName, iOException2);
                    }
                }
            }
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        block8: {
            n3 = this.m_in.read(cArray, n, n2);
            if (this.m_fw == null || n3 == -1) break block8;
            if (!this.m_bMarked && this.m_lMarkOff > (long)n3) {
                this.m_lMarkOff -= (long)n3;
            } else {
                if (this.m_bMarked) {
                    this.m_lMarkOff += (long)n3;
                }
                int n4 = n3;
                if (!this.m_bMarked) {
                    n4 = (int)((long)n4 - this.m_lMarkOff);
                    n += n3 - n4;
                    this.m_lMarkOff = 0L;
                }
                try {
                    this.m_fw.write(cArray, n, n4);
                }
                catch (IOException iOException) {
                    Trace.logError("TraceReader:read", "Error Writing to Log: " + this.m_szName, iOException);
                    try {
                        this.m_fw.close();
                        this.m_fw = null;
                        Trace.logInfo("TraceReader:read", "Closed Log: " + this.m_szName);
                    }
                    catch (IOException iOException2) {
                        Trace.logError("TraceReader:read", "Could Not Close Log: " + this.m_szName, iOException2);
                    }
                }
            }
        }
        return n3;
    }

    public void reset() throws IOException {
        this.m_in.reset();
        this.m_bMarked = false;
    }

    public long skip(long l) throws IOException {
        block9: {
            if ((l = this.m_in.skip(l)) <= 0L || this.m_fw == null) break block9;
            if (!this.m_bMarked && this.m_lMarkOff > l) {
                this.m_lMarkOff -= l;
            } else {
                long l2 = l;
                if (this.m_bMarked) {
                    this.m_lMarkOff += l;
                } else {
                    l2 -= this.m_lMarkOff;
                    this.m_lMarkOff = 0L;
                }
                try {
                    while (l2 > (long)NULL_DATA.length) {
                        this.m_fw.write(NULL_DATA);
                        l2 -= (long)NULL_DATA.length;
                    }
                    this.m_fw.write(NULL_DATA, 0, (int)l2);
                }
                catch (IOException iOException) {
                    Trace.logError("TraceReader:skip", "Error Writing to Log: " + this.m_szName, iOException);
                    try {
                        this.m_fw.close();
                        this.m_fw = null;
                        Trace.logInfo("TraceReader:skip", "Closed Log: " + this.m_szName);
                    }
                    catch (IOException iOException2) {
                        Trace.logError("TraceReader:skip", "Could Not Close Log: " + this.m_szName, iOException2);
                    }
                }
            }
        }
        return l;
    }

    static {
        Arrays.fill(NULL_DATA, 'U');
    }
}

