/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.security;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.util.StringUtilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.security.pkcs.PKCS10;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.Extension;
import sun.security.x509.X500Name;
import sun.security.x509.X500Signer;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class PKIHelper {
    private static SecureRandom m_sr = new SecureRandom();
    private static final int MAX_KEYPAIRS = Integer.getInteger("keyPair.cache", 10);
    private static KeyPairGen m_keyPairGen = new KeyPairGen();
    static /* synthetic */ Class class$java$security$spec$RSAPrivateCrtKeySpec;

    private PKIHelper() {
    }

    public static KeyPair getKeyPair() {
        return PKIHelper.m_keyPairGen.getKeyPair();
    }

    public static void recycleKeyPair(KeyPair keyPair) {
        PKIHelper.m_keyPairGen.addKeyPair(keyPair);
    }

    public static X509Certificate generateCertificate(String string, KeyPair keyPair) {
        return PKIHelper.generateSignedCertificate(string, keyPair, keyPair.getPrivate(), null);
    }

    public static X509Certificate generateCertificate(String string, KeyPair keyPair, Map map) {
        return PKIHelper.generateSignedCertificate(string, keyPair, keyPair.getPrivate(), map);
    }

    public static X509Certificate generateSignedCertificate(String string, KeyPair keyPair, PrivateKey privateKey) {
        return PKIHelper.generateSignedCertificate(string, keyPair, privateKey, null);
    }

    public static X509Certificate generateSignedCertificate(String string, KeyPair keyPair, PrivateKey privateKey, Map map) {
        try {
            DerEncoder derEncoder;
            X500Name x500Name = new X500Name(string);
            Signature signature = Signature.getInstance("MD5WithRSA");
            signature.initSign(privateKey);
            X500Signer x500Signer = new X500Signer(signature, x500Name);
            CertificateValidity certificateValidity = new CertificateValidity(new Date(), new Date(System.currentTimeMillis() + 315360000000L));
            X509CertInfo x509CertInfo = new X509CertInfo();
            x509CertInfo.set("version", new CertificateVersion(2));
            x509CertInfo.set("serialNumber", new CertificateSerialNumber((int)(System.currentTimeMillis() / 1000L)));
            AlgorithmId algorithmId = x500Signer.getAlgorithmId();
            x509CertInfo.set("algorithmID", new CertificateAlgorithmId(algorithmId));
            x509CertInfo.set("subject", new CertificateSubjectName(x500Name));
            x509CertInfo.set("key", new CertificateX509Key(keyPair.getPublic()));
            x509CertInfo.set("validity", certificateValidity);
            x509CertInfo.set("issuer", new CertificateIssuerName(x500Signer.getSigner()));
            if (map != null && map.size() > 0) {
                derEncoder = new CertificateExtensions();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    DerOutputStream derOutputStream = new DerOutputStream();
                    if (entry.getValue() instanceof byte[]) {
                        derOutputStream.putOctetString((byte[])entry.getValue());
                    } else {
                        derOutputStream.putOctetString(((String)entry.getValue()).getBytes("UTF-8"));
                    }
                    derEncoder.set((String)entry.getKey(), new Extension(new ObjectIdentifier((String)entry.getKey()), false, derOutputStream.toByteArray()));
                }
                x509CertInfo.set("extensions", derEncoder);
            }
            derEncoder = new X509CertImpl(x509CertInfo);
            derEncoder.sign(privateKey, "MD5WithRSA");
            return derEncoder;
        }
        catch (GeneralSecurityException generalSecurityException) {
            Trace.logError("PKIHelper:generateCertificate", "Security exception", generalSecurityException);
        }
        catch (IOException iOException) {
            Trace.logError("PKIHelper:generateCertificate", "IOException", iOException);
        }
        return null;
    }

    public static byte[] getCertificateExtensionValue(X509Certificate x509Certificate, String string) throws IOException {
        byte[] byArray = x509Certificate.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        return derInputStream.getOctetString();
    }

    public static String getCertificateExtensionUTFValue(X509Certificate x509Certificate, String string) throws IOException {
        byte[] byArray = PKIHelper.getCertificateExtensionValue(x509Certificate, string);
        if (byArray == null) {
            return null;
        }
        return new String(byArray, "UTF-8");
    }

    public static String getCertificateSubjectCommonName(X509Certificate x509Certificate) {
        String string = x509Certificate.getSubjectDN().getName();
        Matcher matcher = Pattern.compile(".*,\\s*[Cc][Nn]\\s*=\\s*((\"([^\"]*)\")|([^,]*)).*").matcher("," + string);
        if (matcher.matches()) {
            return matcher.group(3) == null ? matcher.group(4) : matcher.group(3);
        }
        return null;
    }

    public static PKCS10 generateCSR(X509Certificate x509Certificate, PrivateKey privateKey) throws NoSuchAlgorithmException, CertificateException, InvalidKeyException, SignatureException, IOException {
        Trace.logInfo("PKIHelper:generateCSR", "Getting private key algorithm of existing certificate");
        String string = privateKey.getAlgorithm();
        String string2 = "";
        if (string.equalsIgnoreCase("DSA") || string.equalsIgnoreCase("DSS")) {
            string2 = "SHA1WithDSA";
        } else if (string.equalsIgnoreCase("RSA")) {
            string2 = "MD5WithRSA";
        } else {
            throw new NoSuchAlgorithmException("Unsupported private key algorithm" + string2);
        }
        Trace.logInfo("PKIHelper:generateCSR", "Private key algorithm=" + string);
        PKCS10 pKCS10 = new PKCS10(x509Certificate.getPublicKey());
        Trace.logInfo("PKIHelper:generateCSR", "Signing and encoding the PKCS10 request");
        Signature signature = Signature.getInstance(string2);
        signature.initSign(privateKey);
        X500Name x500Name = new X500Name(x509Certificate.getSubjectDN().toString());
        X500Signer x500Signer = new X500Signer(signature, x500Name);
        pKCS10.encodeAndSign(x500Signer);
        return pKCS10;
    }

    private static void writeAsnLength(OutputStream outputStream, int n) throws IOException {
        if (n <= 127) {
            outputStream.write(n);
            return;
        }
        BigInteger bigInteger = new BigInteger(n + "");
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            outputStream.write(0x80 | byArray.length - 1 & 0xFF);
            outputStream.write(byArray, 1, byArray.length - 1);
        } else {
            outputStream.write(0x80 | byArray.length & 0xFF);
            outputStream.write(byArray);
        }
    }

    private static void writeAsnInt(OutputStream outputStream, BigInteger bigInteger) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        outputStream.write(2);
        PKIHelper.writeAsnLength(outputStream, byArray.length);
        outputStream.write(byArray);
    }

    public static String createRSAPrivateKeyPEM(RSAPrivateKey rSAPrivateKey) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)KeyFactory.getInstance(rSAPrivateKey.getAlgorithm()).getKeySpec(rSAPrivateKey, class$java$security$spec$RSAPrivateCrtKeySpec == null ? (class$java$security$spec$RSAPrivateCrtKeySpec = PKIHelper.class$("java.security.spec.RSAPrivateCrtKeySpec")) : class$java$security$spec$RSAPrivateCrtKeySpec);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PKIHelper.writeAsnInt(byteArrayOutputStream, BigInteger.ZERO);
        PKIHelper.writeAsnInt(byteArrayOutputStream, rSAPrivateCrtKeySpec.getModulus());
        PKIHelper.writeAsnInt(byteArrayOutputStream, rSAPrivateCrtKeySpec.getPublicExponent());
        PKIHelper.writeAsnInt(byteArrayOutputStream, rSAPrivateCrtKeySpec.getPrivateExponent());
        PKIHelper.writeAsnInt(byteArrayOutputStream, rSAPrivateCrtKeySpec.getPrimeP());
        PKIHelper.writeAsnInt(byteArrayOutputStream, rSAPrivateCrtKeySpec.getPrimeQ());
        PKIHelper.writeAsnInt(byteArrayOutputStream, rSAPrivateCrtKeySpec.getPrimeExponentP());
        PKIHelper.writeAsnInt(byteArrayOutputStream, rSAPrivateCrtKeySpec.getPrimeExponentQ());
        PKIHelper.writeAsnInt(byteArrayOutputStream, rSAPrivateCrtKeySpec.getCrtCoefficient());
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(48);
        PKIHelper.writeAsnLength(byteArrayOutputStream, byArray.length);
        byteArrayOutputStream.write(byArray);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        char[] cArray = StringUtilities.encodeAsBase64(byArray2).toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-----BEGIN RSA PRIVATE KEY-----\n");
        int n = 0;
        int n2 = 64;
        while (n + n2 < cArray.length) {
            stringBuffer.append(cArray, n, n2);
            stringBuffer.append('\n');
            n += n2;
        }
        stringBuffer.append(cArray, n, cArray.length - n);
        stringBuffer.append('\n');
        stringBuffer.append("-----END RSA PRIVATE KEY-----\n");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class KeyPairGen
    implements Runnable {
        private LinkedList m_llPairs = new LinkedList();

        private KeyPairGen() {
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setPriority(1);
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private KeyPair getKeyPair() {
            LinkedList linkedList = this.m_llPairs;
            synchronized (linkedList) {
                while (this.m_llPairs.size() == 0) {
                    try {
                        this.m_llPairs.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                KeyPair keyPair = (KeyPair)this.m_llPairs.removeFirst();
                this.m_llPairs.notify();
                return keyPair;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addKeyPair(KeyPair keyPair) {
            LinkedList linkedList = this.m_llPairs;
            synchronized (linkedList) {
                this.m_llPairs.addLast(keyPair);
                this.m_llPairs.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            KeyPairGenerator keyPairGenerator = null;
            try {
                keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Trace.logError("KeyPairGen:run", "Failed to get an RSA KeyPairGenerator", noSuchAlgorithmException);
                return;
            }
            keyPairGenerator.initialize(1024, m_sr);
            while (true) {
                KeyPair keyPair;
                try {
                    keyPair = keyPairGenerator.generateKeyPair();
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(exception.getMessage());
                }
                LinkedList linkedList = this.m_llPairs;
                synchronized (linkedList) {
                    while (this.m_llPairs.size() >= MAX_KEYPAIRS) {
                        try {
                            this.m_llPairs.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.addKeyPair(keyPair);
                }
            }
        }
    }
}

