/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.security;

import java.math.BigInteger;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public class RSAEncodedPublicKeySpec
implements KeySpec {
    private BigInteger modulus;
    private BigInteger publicExponent;

    public RSAEncodedPublicKeySpec(BigInteger bigInteger, BigInteger bigInteger2) {
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
    }

    public RSAEncodedPublicKeySpec(byte[] byArray) {
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream.getSequence(0);
            this.modulus = derValueArray[0].getBigInteger();
            this.publicExponent = derValueArray[1].getBigInteger();
        }
        catch (Exception exception) {
            this.modulus = new BigInteger("3");
            this.publicExponent = new BigInteger("41000");
        }
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public RSAPublicKeySpec getKeySpec() {
        return new RSAPublicKeySpec(this.modulus, this.publicExponent);
    }
}

