/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.util;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;

public class DefaultComboBoxModelStringStore
extends DefaultComboBoxModel {
    private int m_nMaxStrings = 0;
    private File m_File = null;

    public DefaultComboBoxModelStringStore(String string, boolean bl) throws ExceptionInvalidArgument, IOException {
        this(string, bl, 0);
    }

    public DefaultComboBoxModelStringStore(String string, boolean bl, int n) throws ExceptionInvalidArgument, IOException {
        if (string == null) {
            throw new ExceptionInvalidArgument();
        }
        if ((string = string.trim()).equals("")) {
            throw new ExceptionInvalidArgument();
        }
        this.m_nMaxStrings = n;
        this.m_File = new File(string);
        if (bl) {
            this.read();
        }
    }

    public synchronized int read() throws IOException {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        this.removeAllElements();
        try {
            String string;
            fileReader = new FileReader(this.m_File);
            bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).equals("")) continue;
                this.insert(string, -1);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Trace.logError("StringStoreModel:read", "Problem reading " + this.m_File.getName() + " file.");
            throw iOException;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
                bufferedReader = null;
            }
            if (fileReader != null) {
                fileReader.close();
                fileReader = null;
            }
        }
        return this.getSize();
    }

    public synchronized void write() throws IOException {
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileWriter = new FileWriter(this.m_File);
            bufferedWriter = new BufferedWriter(fileWriter);
            int n = 0;
            while (n < this.getSize()) {
                bufferedWriter.write(this.getElementAt(n).toString());
                bufferedWriter.newLine();
                ++n;
            }
        }
        catch (IOException iOException) {
            Trace.logError("StringStoreModel:write", "Problem writing " + this.m_File.getName() + " file.");
            throw iOException;
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
                bufferedWriter = null;
            }
            if (fileWriter != null) {
                fileWriter.close();
                fileWriter = null;
            }
        }
    }

    public synchronized void addElement(Object object) {
        if (object == null) {
            return;
        }
        this.insert(object.toString(), -1);
    }

    public synchronized void insertElementAt(Object object, int n) {
        if (object == null) {
            return;
        }
        this.insert(object.toString(), n);
    }

    public synchronized void removeElement(Object object) {
        if (object == null) {
            return;
        }
        int n = this.findElement(object.toString());
        if (n >= 0) {
            this.removeElementAt(n);
        }
    }

    private synchronized int findElement(String string) {
        int n = 0;
        while (n < this.getSize()) {
            if (string.equals((String)this.getElementAt(n))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private synchronized boolean insert(String string, int n) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).equals("")) {
            return false;
        }
        int n2 = this.findElement(string);
        if (n2 >= 0) {
            if (n < 0 || n2 < n) {
                return true;
            }
            this.removeElementAt(n2);
        }
        if (this.m_nMaxStrings > 0 && this.getSize() >= this.m_nMaxStrings) {
            if (n < 0) {
                return true;
            }
            this.removeElementAt(this.m_nMaxStrings - 1);
        }
        if (n < 0) {
            super.addElement(string);
        } else {
            super.insertElementAt(string, n);
        }
        return true;
    }

    public synchronized String toString() {
        return this.m_File.getName() + ":" + super.toString();
    }
}

