/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.util;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionFileNotFound;
import com.avocent.lib.exceptions.ExceptionFileNotReadable;
import com.avocent.lib.exceptions.ExceptionNotAFile;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.ThreadContinuous;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ExecuteCmd {
    public static final String CNAME = "ExecuteCmd";
    static ResourceManager res = ResourceManager.getManager("com.avocent.lib.util.Res");
    private static String m_szOsName = System.getProperty("os.name");
    private static final String TRACE_CONTEXT = "ExecuteCmd";
    private static final String COMMAND_ARGUMENT = "%C%";

    public static int execute(String string, String string2, boolean bl, boolean bl2) throws ExceptionRequestFailed, ExceptionFileNotFound, ExceptionNotAFile, ExceptionFileNotReadable {
        int n = 0;
        if (string == null || string.length() <= 0) {
            throw new ExceptionFileNotFound("Invalid Cmd Argument", new File(""));
        }
        if (string2 == null) {
            string2 = "";
        }
        Trace.logInfo("ExecuteCmd", "execute Cmd[" + string + "] Args[" + string2 + "]");
        ExecuteCmd.verify(string);
        ThreadContinuous threadContinuous = null;
        try {
            Process process = null;
            if (bl) {
                Trace.logInfo("ExecuteCmd", "Executing command on " + m_szOsName);
                process = m_szOsName.startsWith("Windows") ? ExecuteCmd.executeInCmdWindowOnWindows(string, string2) : (m_szOsName.startsWith("Linux") ? ExecuteCmd.executeInCmdWindowOnLinux(string, string2) : ExecuteCmd.executeInCmdWindowOnUnix(string, string2));
            } else {
                String string3 = ExecuteCmd.buildFullCommand(string, string2, false);
                Trace.logInfo("ExecuteCmd", "full Command[" + string3 + "]");
                process = Runtime.getRuntime().exec(string3);
            }
            try {
                threadContinuous = new ThreadReadOutputStreamsOnProcess(process, bl2);
                threadContinuous.start();
                Trace.logInfo("ExecuteCmd", "Successfully created thread to read stdout and stderr on the process");
            }
            catch (ExceptionConstructorFailed exceptionConstructorFailed) {
                Trace.logError("ExecuteCmd", "Failed to create a thread to read stdout and stderr on the process");
            }
            n = process.waitFor();
            Trace.logInfo("ExecuteCmd", "execute(" + string + ") exited with value " + n);
        }
        catch (Exception exception) {
            Trace.logError("ExecuteCmd", "Failed to execute command ", exception);
            if (threadContinuous != null) {
                threadContinuous.stopThread();
                threadContinuous = null;
            }
            throw new ExceptionRequestFailed(exception);
        }
        if (threadContinuous != null) {
            threadContinuous.stopThread();
            threadContinuous = null;
        }
        return n;
    }

    private static Process executeInCmdWindowOnWindows(String string, String string2) throws IOException {
        String string3 = ExecuteCmd.buildFullCommand(string, string2, true);
        Trace.logInfo("ExecuteCmd", "executeInCmdWindowOnWindows FullCmd[" + string3 + "]");
        Process process = Runtime.getRuntime().exec("cmd /C \"start /WAIT " + string3 + "\"");
        return process;
    }

    private static Process executeInCmdWindowOnUnix(String string, String string2) throws IOException {
        String string3 = ExecuteCmd.buildFullCommand(string, string2, false);
        Trace.logInfo("ExecuteCmd", "executeInCmdWindowOnUnix FullCmd[" + string3 + "]");
        String string4 = res.getString("ExecuteCmd_UnixCmdTool").replaceAll(COMMAND_ARGUMENT, string3);
        Trace.logInfo("ExecuteCmd", "executeInCmdWindowOnUnix FullCmd in CmdWindow[" + string4 + "]");
        Process process = Runtime.getRuntime().exec(string4);
        return process;
    }

    private static Process executeInCmdWindowOnLinux(String string, String string2) throws IOException {
        String string3 = ExecuteCmd.buildFullCommand(string, string2, false);
        Trace.logInfo("ExecuteCmd", "executeInCmdWindowOnLinux FullCmd[" + string3 + "]");
        String string4 = res.getString("ExecuteCmd_LinuxCmdTool").replaceAll(COMMAND_ARGUMENT, string3);
        Trace.logInfo("ExecuteCmd", "executeInCmdWindowOnLinux FullCmd in CmdWindow[" + string4 + "]");
        Process process = Runtime.getRuntime().exec(string4);
        return process;
    }

    private static String buildFullCommand(String string, String string2, boolean bl) {
        if (bl && string.indexOf(32) >= 0) {
            int n = string.indexOf(58);
            if (n >= 0) {
                String string3 = string.substring(0, n + 1);
                string = string.length() > n + 1 ? string3 + "\"" + string.substring(n + 1) + "\"" : string3;
            } else {
                string = "\"" + string + "\"";
            }
        }
        String string4 = string + " " + string2;
        return string4;
    }

    public static void verify(String string) throws ExceptionRequestFailed, ExceptionFileNotFound, ExceptionNotAFile, ExceptionFileNotReadable {
        Trace.logInfo("ExecuteCmd", "verify cmd[" + string + "]");
        File file = new File(string);
        if (!file.isAbsolute()) {
            Trace.logInfo("ExecuteCmd", "Not an absolute path, cannot verify");
            return;
        }
        if (!file.exists()) {
            Trace.logInfo("ExecuteCmd", "Invalid Command: not found [" + string + "]");
            throw new ExceptionFileNotFound("Invalid command, not found", file);
        }
        if (!file.isFile()) {
            Trace.logInfo("ExecuteCmd", "Invalid Command: not a file [" + string + "]");
            throw new ExceptionNotAFile("Invalid command, not a file", file);
        }
        if (!file.canRead()) {
            Trace.logInfo("ExecuteCmd", "Invalid Command: not readable [" + string + "]");
            throw new ExceptionFileNotReadable("Invalid command, not readable", file);
        }
    }

    private static class ThreadReadOutputStreamsOnProcess
    extends ThreadContinuous {
        InputStream m_isStdOut;
        InputStream m_isStdErr;
        private boolean m_bLogOutput = true;

        public ThreadReadOutputStreamsOnProcess(Process process, boolean bl) throws ExceptionConstructorFailed {
            super(5L);
            try {
                this.m_isStdOut = process.getInputStream();
                this.m_isStdErr = process.getErrorStream();
            }
            catch (Exception exception) {
                throw new ExceptionConstructorFailed();
            }
        }

        public void performTask() {
            block7: {
                String string;
                byte[] byArray;
                try {
                    if (this.m_isStdOut.available() != 0) {
                        byArray = new byte[this.m_isStdOut.available()];
                        this.m_isStdOut.read(byArray);
                        if (this.m_bLogOutput) {
                            string = new String(byArray);
                            Trace.logInfo("ExecuteCmd", "stdout:" + string);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.m_isStdErr.available() == 0) break block7;
                    byArray = new byte[this.m_isStdErr.available()];
                    this.m_isStdErr.read(byArray);
                    if (this.m_bLogOutput) {
                        string = new String(byArray);
                        Trace.logInfo("ExecuteCmd", "stderr:" + string);
                    }
                }
                catch (Exception exception) {}
            }
        }

        protected void cleanup() {
            Trace.logInfo("ExecuteCmd", "ThreadReadOutputStreamsOnProcess stopped");
        }
    }
}

