/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.util;

import com.avocent.lib.debug.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FlashFileHeader {
    private final int FLASH_VERSION_OFFSET = 120;
    private final int FLASH_VERSION_LENGTH = 32;
    private final int FLASH_DATE_OFFSET = 6;
    private final int FLASH_DATE_LENGTH = 10;
    private final int FLASH_TIME_OFFSET = 16;
    private final int FLASH_TIME_LENGTH = 10;
    private final int FLASH_TYPE_OFFSET = 56;
    private final int FLASH_TYPE_LENGTH = 1;
    private final int FLASH_EXT_RECORD_DEFINE_OFFSET = 152;
    private final int FLASH_EXT_RECORD_DEFINE_LENGTH = 4;
    private final int FLASH_EXT_RECORD_LENGTH_DEFINE_OFFSET = 156;
    private final int FLASH_EXT_RECORD_LENGTH_DEFINE_LENGTH = 4;
    private final int FLASH_EXT_RECORDS_LENGTH = 16;
    private final int FLASH_HEADER_LENGTH = 160;
    private final int FLASH_COUNTRY_OFFSET = 59;
    private final int FLASH_COUNTRY_LENGTH = 2;
    private final int FLASH_LANGUAGE_OFFSET = 61;
    private final int FLASH_LANGUAGE_LENGTH = 3;
    private final int OEM_EXTENSION_RECORD = 1;
    private final String APPLICATION_TYPE = "A";
    private final String BOOT_TYPE = "B";
    private final String APPLICATION_4850_TYPE = "D";
    private final String BOOT_4850_TYPE = "E";
    private final String APPLICATION_x50_TYPE = "F";
    private final String BOOT_x50_TYPE = "G";
    private final int FLASH_BOOT_TYPE = 1;
    private final int FLASH_APPLIANCE_TYPE = 2;
    private String m_szVersion;
    private String m_szCountry;
    private String m_szLanguage;
    private Date m_createDateTime;
    private int m_nProductFamilyCode;
    private int m_nProductOEMCode;
    private int m_nFlashType;

    public FlashFileHeader(InputStream inputStream) throws IOException {
        Trace.logInfo("FlashFileHeader", "getting header information");
        byte[] byArray = this.getHeaderData(inputStream);
        this.m_szVersion = this.convertBytesToString(this.getByteHeaderData(120, 32, byArray));
        Trace.logInfo("FlashFileHeader", "version = " + this.m_szVersion);
        this.m_szCountry = this.convertBytesToString(this.getByteHeaderData(59, 2, byArray));
        Trace.logInfo("FlashFileHeader", "country = " + this.m_szCountry);
        this.m_szLanguage = this.convertBytesToString(this.getByteHeaderData(61, 3, byArray));
        Trace.logInfo("FlashFileHeader", "language = " + this.m_szLanguage);
        String string = this.getStringHeaderData(byArray, 6, 10);
        String string2 = this.getStringHeaderData(byArray, 16, 10);
        String string3 = string.trim() + " " + string2.trim();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
        this.m_createDateTime = simpleDateFormat.parse(string3, new ParsePosition(0));
        byte[] byArray2 = this.getByteHeaderData(152, 4, byArray);
        int n = this.getInt(byArray2);
        Trace.logInfo("FlashFileHeader", "extension record offset = " + n);
        byte[] byArray3 = this.getByteHeaderData(156, 4, byArray);
        int n2 = this.getInt(byArray3);
        Trace.logInfo("FlashFileHeader", "extension record length = " + n2);
        if (n2 != 16) {
            Trace.logInfo("FlashFileHeader", "length of extension records not correct, invalid flash file");
            throw new StreamCorruptedException();
        }
        byte[] byArray4 = new byte[n2];
        inputStream.skip(n - 160);
        inputStream.read(byArray4);
        int n3 = ((byArray4[0] & 0xFF) << 8) + (byArray4[1] & 0xFF);
        int n4 = 0;
        if (n3 == 1) {
            this.m_nProductOEMCode = ((byArray4[n4 + 4] & 0xFF) << 8) + (byArray4[n4 + 5] & 0xFF);
            Trace.logInfo("FlashFileHeader", "product oem code = " + this.m_nProductOEMCode);
            n4 = ((byArray4[2] & 0xFF) << 8) + (byArray4[3] & 0xFF) + 4;
        }
        this.m_nProductFamilyCode = ((byArray4[n4 + 4] & 0xFF) << 8) + (byArray4[n4 + 5] & 0xFF);
        Trace.logInfo("FlashFileHeader", "product family code = " + this.m_nProductFamilyCode);
        String string4 = this.convertBytesToString(this.getByteHeaderData(56, 1, byArray));
        if (string4.equalsIgnoreCase("A") || string4.equalsIgnoreCase("D") || string4.equalsIgnoreCase("F")) {
            this.m_nFlashType = 2;
        } else if (string4.equalsIgnoreCase("B") || string4.equalsIgnoreCase("E") || string4.equalsIgnoreCase("G")) {
            this.m_nFlashType = 1;
        } else {
            Trace.logInfo("FlashFileHeader", "image type extension records not correct, invalid flash file");
            throw new StreamCorruptedException();
        }
        Trace.logInfo("FlashFileHeader", "flash type = " + this.m_nFlashType);
    }

    public String getVersion() throws IOException {
        return this.m_szVersion;
    }

    public String getCountry() throws IOException {
        return this.m_szCountry;
    }

    public String getLanguage() throws IOException {
        return this.m_szLanguage;
    }

    public Date getCreateDateTime() throws IOException {
        return this.m_createDateTime;
    }

    public int getProductFamilyCode() throws IOException {
        return this.m_nProductFamilyCode;
    }

    public int getProductOEMCode() throws IOException {
        return this.m_nProductOEMCode;
    }

    public int getFlashFileType() throws IOException {
        return this.m_nFlashType;
    }

    private byte[] getHeaderData(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[160];
        int n = inputStream.read(byArray);
        if (n != 160) {
            Trace.logError("FlashFileHeader:getHeaderData()", "The flash file header is not the correct length, length = " + n);
            throw new StreamCorruptedException();
        }
        return byArray;
    }

    private String getStringHeaderData(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2 && byArray[n + n3] != 0) {
            ++n3;
        }
        Trace.logInfo("FlashFileHeader", "getStringHeaderData, returning " + new String(byArray, n, n3));
        return new String(byArray, n, n3, "US-ASCII");
    }

    private byte[] getByteHeaderData(int n, int n2, byte[] byArray) throws IOException {
        Trace.logInfo("FlashFileHeader:getByteHeaderData", "nLength = " + n2 + " nOffset = " + n);
        if (n2 > 160) {
            Trace.logInfo("FlashFileHeader:getByteHeaderData", "length requested for header info is too large to be valid");
            throw new StreamCorruptedException();
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    private String convertBytesToString(byte[] byArray) throws IOException {
        return new String(byArray, "US-ASCII").trim();
    }

    private int getInt(byte[] byArray) throws IOException {
        return ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
    }
}

