/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.util;

import com.avocent.lib.debug.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PBEIOStreamFactory {
    public static final String TRACE_CONTEXT = "PBEIOStreamFactory";
    public static final int SALT_LENGTH = 8;

    public static InputStream getInputStream(char[] cArray, InputStream inputStream) throws IOException, Exception {
        try {
            byte[][] byArray = new byte[1][8];
            if (inputStream.read(byArray[0]) != 8) {
                IOException iOException = new IOException();
                Trace.logError(TRACE_CONTEXT, "Unable to read salt from encrypted input stream.", iOException);
                throw iOException;
            }
            Cipher cipher = PBEIOStreamFactory.createCipher(cArray, byArray, false);
            CipherInputStream cipherInputStream = new CipherInputStream(inputStream, cipher);
            return cipherInputStream;
        }
        catch (IOException iOException) {
            Trace.logError(TRACE_CONTEXT, "Exception while creating password encrypted input stream.", iOException);
            throw iOException;
        }
        catch (Throwable throwable) {
            Trace.logError(TRACE_CONTEXT, "Error while creating PBE input stream.", throwable);
            throw new Exception();
        }
    }

    public static OutputStream getOutputStream(char[] cArray, OutputStream outputStream) throws Exception {
        try {
            byte[][] byArray = new byte[1][0];
            Cipher cipher = PBEIOStreamFactory.createCipher(cArray, byArray, true);
            outputStream.write(byArray[0]);
            CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, cipher);
            return cipherOutputStream;
        }
        catch (Throwable throwable) {
            Trace.logError(TRACE_CONTEXT, "Error while creating PBE output stream.", throwable);
            throw new Exception();
        }
    }

    static Cipher createCipher(char[] cArray, byte[][] byArray, boolean bl) throws Exception {
        Object object;
        if (bl && (byArray == null || byArray.length == 0)) {
            throw new Exception();
        }
        if (bl) {
            byte[] byArray2 = new byte[8];
            object = new Random();
            ((Random)object).nextBytes(byArray2);
            byArray[0] = byArray2;
        }
        int n = 1000;
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        object = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey secretKey = ((SecretKeyFactory)object).generateSecret(pBEKeySpec);
        Cipher cipher = Cipher.getInstance("PBEWithMD5AndDES");
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray[0], n);
        int n2 = bl ? 1 : 2;
        cipher.init(n2, (Key)secretKey, pBEParameterSpec);
        return cipher;
    }
}

