/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.util;

import com.avocent.lib.debug.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;

public class PropertiesCompare {
    private static final String TRACE_CONTEXT = "PropertiesCompare";
    private String m_szNewProperties;
    private String m_szOldProperties;
    private boolean m_bDetailedOutput = true;
    private boolean m_bShowAdded = true;
    private boolean m_bShowDeleted = true;
    private boolean m_bShowDifferences = true;
    private int m_nDifferences = 0;

    public PropertiesCompare() {
        this("new.properties", "old.properties", true, true, true, true);
    }

    public PropertiesCompare(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.m_szNewProperties = string;
        this.m_szOldProperties = string2;
        this.m_bDetailedOutput = bl;
        this.m_bShowAdded = bl2;
        this.m_bShowDeleted = bl3;
        this.m_bShowDifferences = bl4;
    }

    public void performCompare() {
        FileInputStream fileInputStream;
        File file;
        Properties properties = null;
        Properties properties2 = null;
        this.showHeader();
        try {
            file = new File(this.m_szNewProperties);
            fileInputStream = new FileInputStream(file);
            properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            Trace.logError(TRACE_CONTEXT, "Unable to build New Properties for " + this.m_szNewProperties);
            properties = null;
        }
        try {
            file = new File(this.m_szOldProperties);
            fileInputStream = new FileInputStream(file);
            properties2 = new Properties();
            properties2.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            Trace.logError(TRACE_CONTEXT, "Unable to build Old Properties for " + this.m_szOldProperties);
            properties2 = null;
        }
        if (!this.showPropertyStatus(properties, properties2)) {
            return;
        }
        this.showAddedDifferences(properties, properties2);
        this.showDeleted(properties, properties2);
        if (this.m_nDifferences > 0) {
            System.out.println("** Differences Found=" + this.m_nDifferences);
        } else {
            System.out.println("** No Differences Found");
        }
    }

    private void showHeader() {
        System.out.println("************************************");
        System.out.println("* Comparing Properties");
        System.out.println("*   New Property File=" + this.m_szNewProperties);
        System.out.println("*   Old Property File=" + this.m_szOldProperties);
        System.out.println("*   Detailed Report=" + String.valueOf(this.m_bDetailedOutput));
        System.out.println("*   Show Added=" + String.valueOf(this.m_bShowAdded));
        System.out.println("*   Show Deleted=" + String.valueOf(this.m_bShowDeleted));
        System.out.println("*   Show Differences=" + String.valueOf(this.m_bShowDifferences));
        System.out.println("************************************");
    }

    private boolean showPropertyStatus(Properties properties, Properties properties2) {
        System.out.println(" ");
        if (properties != null) {
            System.out.println("** New Property File Size=" + properties.size());
        }
        if (properties2 != null) {
            System.out.println("** Old Property File Size=" + properties2.size());
        }
        if (properties != null && properties2 == null) {
            System.out.println("** Property file added. New file, previously did not exist");
        } else if (properties == null && properties2 != null) {
            System.out.println("** Property file removed. No longer needed.");
        } else if (properties == null && properties2 == null) {
            System.out.println("** Property files do not exits (old or new)");
        }
        return properties != null && properties2 != null;
    }

    private void showAddedDifferences(Properties properties, Properties properties2) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)properties.get(string);
            if (string2 == null) {
                System.out.println(string + " Not found in new file, should be there");
                return;
            }
            String string3 = (String)properties2.get(string);
            this.showData(string, string2, string3);
        }
    }

    private void showDeleted(Properties properties, Properties properties2) {
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)properties2.get(string);
            if (string2 == null) {
                System.out.println(string + " Not found in old file, should be there");
                return;
            }
            String string3 = (String)properties.get(string);
            if (string3 != null) continue;
            this.showData(string, string3, string2);
        }
    }

    private void showData(String string, String string2, String string3) {
        if (string2 != null) {
            string2 = string2.replaceAll("\n", "\\\\n");
        }
        if (string3 != null) {
            string3 = string3.replaceAll("\n", "\\\\n");
        }
        if (string2 == null) {
            ++this.m_nDifferences;
            if (!this.m_bShowDeleted) {
                return;
            }
            if (this.m_bDetailedOutput) {
                System.out.println("** Deleted ** " + string + "=" + string3);
            } else {
                System.out.println("** Deleted ** " + string);
            }
        } else if (string3 == null) {
            ++this.m_nDifferences;
            if (!this.m_bShowAdded) {
                return;
            }
            if (this.m_bDetailedOutput) {
                System.out.println("** Added ** " + string + "=" + string2);
            } else {
                System.out.println("** Added ** " + string);
            }
        } else if (!string2.equals(string3)) {
            ++this.m_nDifferences;
            if (!this.m_bShowDifferences) {
                return;
            }
            if (this.m_bDetailedOutput) {
                System.out.println("** Changed ** " + string);
                System.out.println("      New[" + string2 + "]");
                System.out.println("      Old[" + string3 + "]");
            } else {
                System.out.println("** Changed ** " + string);
            }
        }
    }

    public static void main(String[] stringArray) {
        PropertiesCompare propertiesCompare = null;
        if (stringArray != null && stringArray.length == 6) {
            propertiesCompare = new PropertiesCompare(stringArray[0], stringArray[1], Boolean.valueOf(stringArray[2]), Boolean.valueOf(stringArray[3]), Boolean.valueOf(stringArray[4]), Boolean.valueOf(stringArray[5]));
        } else if (stringArray != null && stringArray.length == 3) {
            propertiesCompare = new PropertiesCompare(stringArray[0], stringArray[1], Boolean.valueOf(stringArray[2]), true, true, true);
        } else if (stringArray != null && stringArray.length == 2) {
            propertiesCompare = new PropertiesCompare(stringArray[0], stringArray[1], true, true, true, true);
        } else if (stringArray == null || stringArray.length <= 0) {
            propertiesCompare = new PropertiesCompare();
        } else {
            return;
        }
        propertiesCompare.performCompare();
    }
}

