/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.util;

import com.avocent.lib.debug.Trace;
import java.util.HashMap;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceManager {
    private static HashMap m_Map = new HashMap();
    private String m_szName;
    private ResourceBundle m_rbResources;
    static /* synthetic */ Class class$com$avocent$lib$util$ResourceManager;

    public static ResourceManager getManager(String string) {
        return ResourceManager.getManager(string, Locale.getDefault());
    }

    public static ResourceManager getManager(String string, Locale locale) {
        ResourceManager resourceManager = (ResourceManager)m_Map.get(string);
        if (resourceManager == null) {
            resourceManager = new ResourceManager(string, locale);
            m_Map.put(string, resourceManager);
        }
        return resourceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResourceManager(String string, Locale locale) {
        block7: {
            block6: {
                block5: {
                    this.m_szName = string;
                    String string2 = locale.getVariant();
                    if ("".equals(string2)) {
                        locale = new Locale(locale.getLanguage(), locale.getCountry(), "avct");
                    }
                    try {
                        this.m_rbResources = this.loadResources(string, locale);
                        if (!(this.m_rbResources instanceof EmptyResourceBundle) && this.m_rbResources.getLocale().equals(locale)) {
                            Object var7_4 = null;
                            break block5;
                        }
                        Locale locale2 = new Locale(locale.getLanguage(), "", locale.getVariant());
                        this.m_rbResources = this.loadResources(string, locale2);
                        if (!(this.m_rbResources instanceof EmptyResourceBundle) && this.m_rbResources.getLocale().equals(locale2)) {
                            break block6;
                        }
                        Locale locale3 = new Locale(Locale.ENGLISH.getLanguage(), "", locale.getVariant());
                        this.m_rbResources = this.loadResources(string, locale3);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        Trace.logInfo("ResourceManager", "ResourceManager for " + string + " will use " + this.m_rbResources.getLocale());
                        throw throwable;
                    }
                }
                Trace.logInfo("ResourceManager", "ResourceManager for " + string + " will use " + this.m_rbResources.getLocale());
                return;
            }
            Object var7_5 = null;
            Trace.logInfo("ResourceManager", "ResourceManager for " + string + " will use " + this.m_rbResources.getLocale());
            return;
        }
        Object var7_6 = null;
        Trace.logInfo("ResourceManager", "ResourceManager for " + string + " will use " + this.m_rbResources.getLocale());
    }

    private ResourceBundle loadResources(String string, Locale locale) {
        try {
            return ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            return new EmptyResourceBundle(string, locale);
        }
    }

    public String getString(String string) {
        try {
            return this.m_rbResources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            Trace.logError("ResourceManager", this.m_szName + "{" + string + "}", missingResourceException);
            return ">>>>> " + string + " <<<<<";
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            ResourceManager.usage();
        }
        String string = stringArray[0];
        ResourceManager resourceManager = ResourceManager.getManager(string);
        System.out.println("\n");
        System.out.println("ResourceManager(" + string + ")");
        System.out.println("Default Locale:  " + Locale.getDefault());
        System.out.println("Supported Locale:" + resourceManager.m_rbResources.getLocale());
        System.out.println("----------------------------");
        int n = 1;
        while (n < stringArray.length) {
            System.out.println(stringArray[n] + " = \"" + resourceManager.getString(stringArray[n]) + "\"");
            ++n;
        }
        System.out.println("\n");
        System.exit(0);
    }

    private static void usage() {
        System.out.println("\njava [jvmargs] " + (class$com$avocent$lib$util$ResourceManager == null ? (class$com$avocent$lib$util$ResourceManager = ResourceManager.class$("com.avocent.lib.util.ResourceManager")) : class$com$avocent$lib$util$ResourceManager).getName() + " bundlename [resource,...]\n");
        System.exit(1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class EmptyResourceBundle
    extends ListResourceBundle {
        private String szName;
        private Locale locale;

        public EmptyResourceBundle(String string, Locale locale) {
            this.szName = string;
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public Object[][] getContents() {
            return new Object[0][0];
        }
    }
}

