/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.util;

import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class StringUtilities {
    private static final String BASE64_DICTIONARY = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    public static String toTwoByteAsciiHex(String string) throws ExceptionInvalidArgument {
        if (string == null || string.length() == 0) {
            throw new ExceptionInvalidArgument();
        }
        return StringUtilities.toTwoByteAsciiHex(string.getBytes());
    }

    public static String toTwoByteAsciiHex(byte[] byArray) throws ExceptionInvalidArgument {
        if (byArray == null || byArray.length == 0) {
            throw new ExceptionInvalidArgument();
        }
        byte[] byArray2 = new byte[byArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2];
            int n4 = ((n3 &= 0xFF) & 0xF0) >> 4;
            n4 = n4 >= 10 ? n4 - 10 + 65 : (n4 += 48);
            int n5 = n3 & 0xF;
            n5 = n5 >= 10 ? n5 - 10 + 65 : (n5 += 48);
            byArray2[n++] = (byte)n4;
            byArray2[n++] = (byte)n5;
            ++n2;
        }
        return new String(byArray2);
    }

    public static String fromTwoByteAsciiHex(String string) throws ExceptionInvalidArgument {
        if (string == null || string.length() == 0) {
            throw new ExceptionInvalidArgument();
        }
        try {
            byte[] byArray = string.getBytes();
            byte[] byArray2 = new byte[byArray.length / 2];
            int n = 0;
            int n2 = 0;
            while (n2 < byArray.length) {
                int n3 = byArray[n2];
                if (n3 >= 65 && n3 <= 70) {
                    n3 = n3 - 65 + 10;
                } else if (n3 >= 48 && n3 <= 57) {
                    n3 -= 48;
                } else {
                    throw new ExceptionInvalidArgument();
                }
                n3 = n3 << 4 & 0xF0;
                int n4 = byArray[++n2];
                if (n4 >= 65 && n4 <= 70) {
                    n4 = n4 - 65 + 10;
                } else if (n4 >= 48 && n4 <= 57) {
                    n4 -= 48;
                } else {
                    throw new ExceptionInvalidArgument();
                }
                byArray2[n++] = (byte)(n3 | (n4 &= 0xF));
                ++n2;
            }
            return new String(byArray2);
        }
        catch (Exception exception) {
            throw new ExceptionInvalidArgument();
        }
    }

    public static boolean stringsEqual(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    public static String arrayToString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n = 0;
        while (n < objectArray.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(objectArray[n]);
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static int findStringInArray(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.trim().length() > 0;
    }

    public static String toSystemString(Object object) {
        if (object == null) {
            return String.valueOf(object);
        }
        String string = object.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1) + "@" + Integer.toHexString(object.hashCode());
    }

    public static byte[] getShaHash(String string) throws ExceptionRequestFailed, ExceptionInvalidArgument {
        if (string == null || string.length() == 0) {
            throw new ExceptionInvalidArgument();
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(string.getBytes());
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ExceptionRequestFailed();
        }
    }

    public static String getShaHashAsHexString(String string) throws ExceptionRequestFailed, ExceptionInvalidArgument {
        if (string == null || string.length() == 0) {
            throw new ExceptionInvalidArgument();
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(string.getBytes());
            byte[] byArray = messageDigest.digest();
            return StringUtilities.toTwoByteAsciiHex(byArray);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            throw new ExceptionRequestFailed();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ExceptionRequestFailed();
        }
    }

    public static byte[] decodeBase64(String string) throws ExceptionInvalidArgument {
        string = string.trim();
        while (string.length() > 0 && string.charAt(string.length() - 1) == '=') {
            string = string.substring(0, string.length() - 1);
        }
        int n = string.length() * 3 / 4;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 < byArray.length) {
            int n6;
            if ((n6 = BASE64_DICTIONARY.indexOf(string.charAt(n5++))) == -1) {
                throw new ExceptionInvalidArgument();
            }
            n2 = n2 << 6 | n6 & 0x3F;
            if ((n3 += 6) < 8) continue;
            byArray[n4++] = (byte)(n2 >> n3 - 8);
            n3 -= 8;
        }
        return byArray;
    }

    public static String encodeAsBase64(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            n = n << 8 | byArray[n3++] & 0xFF;
            n2 += 8;
            while (n2 >= 6) {
                stringBuffer.append(BASE64_DICTIONARY.charAt(n >> n2 - 6 & 0x3F));
                n2 -= 6;
            }
        }
        int n4 = n2;
        while (n2 != 0) {
            n <<= 8;
            n2 += 8;
            while (n2 >= 6) {
                int n5 = n >> n2 - 6 & 0x3F;
                if (n5 == 0 && n4 <= 0) {
                    stringBuffer.append('=');
                } else {
                    stringBuffer.append(BASE64_DICTIONARY.charAt(n5));
                }
                n2 -= 6;
                n4 -= 6;
            }
        }
        return stringBuffer.toString();
    }
}

