/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.util;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNotSupported;

public abstract class ThreadContinuous
extends Thread {
    protected boolean m_bStop = false;
    protected long m_lSleepTime = 0L;
    protected boolean m_bInterrupted = false;
    protected boolean m_bBusy = false;

    public ThreadContinuous(long l) {
        this.m_lSleepTime = l;
    }

    public ThreadContinuous(String string, long l) {
        super(string);
        this.m_lSleepTime = l;
    }

    public ThreadContinuous(ThreadGroup threadGroup, String string, long l) {
        super(threadGroup, string);
        this.m_lSleepTime = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            this.startUp();
            while (true) lbl-1000:
            // 4 sources

            {
                block14: {
                    if (this.m_bStop) ** break;
                    var1_1 = this;
                    // MONITORENTER : var1_1
                    this.m_bBusy = true;
                    // MONITOREXIT : var1_1
                    this.performTask();
                    var2_3 = this;
                    // MONITORENTER : var2_3
                    this.m_bBusy = false;
                    if (!this.m_bStop) break block14;
                    // MONITOREXIT : var2_3
                    var5_4 = null;
                    this.cleanup();
                    return;
                }
                try {
                    if (this.m_bInterrupted) {
                        this.m_bInterrupted = false;
                        // MONITOREXIT : var2_3
                    }
                    if (this.m_lSleepTime == 0L) {
                        this.wait(1L);
                    } else {
                        this.wait(this.m_lSleepTime);
                    }
                    this.m_bInterrupted = false;
                    // MONITOREXIT : var2_3
                }
                catch (InterruptedException var1_2) {
                    if (this.m_bStop) ** break;
                    continue;
                    var5_5 = null;
                    this.cleanup();
                    return;
                }
                break;
            }
            ** GOTO lbl-1000
            var5_6 = null;
            this.cleanup();
            return;
        }
        catch (Throwable var4_8) {
            var5_7 = null;
            this.cleanup();
            throw var4_8;
        }
    }

    protected void startUp() {
    }

    protected abstract void performTask();

    protected void cleanup() {
    }

    public final void stopThread() {
        this.m_bStop = true;
        this.interrupt();
    }

    public final void stopThreadAndWait() {
        Trace.logInfo("ThreadContinuous", "Stopping Thread...");
        this.stopThread();
        Trace.logInfo("ThreadContinuous", "Interrupt Thread...");
        this.interrupt();
        try {
            Trace.logInfo("ThreadContinuous", "Join Thread Wait Infinate");
            this.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    public final void stopThreadAndWait(long l) throws ExceptionInvalidArgument {
        if (l == 0L) {
            Trace.logError("ThreadContinuous", "Invalid Wait Time=0");
            throw new ExceptionInvalidArgument("Invalid wait time specified");
        }
        Trace.logInfo("ThreadContinuous", "Stopping Thread...");
        this.stopThread();
        Trace.logInfo("ThreadContinuous", "Interrupt Thread...");
        this.interrupt();
        try {
            Trace.logInfo("ThreadContinuous", "Join Thread Wait " + Long.toString(l) + " mSec...");
            this.join(l);
            Trace.logInfo("ThreadContinuous", "Stopped");
        }
        catch (InterruptedException interruptedException) {
            Trace.logInfo("ThreadContinuous", "Join Interrupted");
            Trace.logInfo("ThreadContinuous", interruptedException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interrupt() {
        ThreadContinuous threadContinuous = this;
        synchronized (threadContinuous) {
            this.m_bInterrupted = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isInterrupted() {
        ThreadContinuous threadContinuous = this;
        synchronized (threadContinuous) {
            return this.m_bInterrupted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isBusy() {
        ThreadContinuous threadContinuous = this;
        synchronized (threadContinuous) {
            return this.m_bBusy;
        }
    }

    public final void destroy() {
        new ExceptionNotSupported().printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSleepTime(long l) {
        ThreadContinuous threadContinuous = this;
        synchronized (threadContinuous) {
            this.m_lSleepTime = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSleepTime() {
        ThreadContinuous threadContinuous = this;
        synchronized (threadContinuous) {
            return this.m_lSleepTime;
        }
    }
}

