/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class ThreadLocalization {
    private static final ThreadLocal m_localizations = new ThreadLocal();
    private Locale[] m_locales = null;
    private TimeZone m_timeZone = null;
    private static Map m_bundleLoaderCache = new HashMap();

    public static void setLocale(Locale locale) {
        Locale[] localeArray;
        if (locale == null) {
            localeArray = null;
        } else {
            Locale[] localeArray2 = new Locale[1];
            localeArray = localeArray2;
            localeArray2[0] = locale;
        }
        ThreadLocalization.setLocales(localeArray);
    }

    public static void setLocales(Locale[] localeArray) {
        ThreadLocalization threadLocalization = (ThreadLocalization)m_localizations.get();
        if (threadLocalization == null) {
            threadLocalization = new ThreadLocalization();
            m_localizations.set(threadLocalization);
        }
        threadLocalization.setThreadLocales(localeArray);
    }

    public static void setTimeZone(TimeZone timeZone) {
        ThreadLocalization threadLocalization = (ThreadLocalization)m_localizations.get();
        if (threadLocalization == null) {
            threadLocalization = new ThreadLocalization();
            m_localizations.set(threadLocalization);
        }
        threadLocalization.setThreadTimeZone(timeZone);
    }

    public static Locale getLocale() {
        ThreadLocalization threadLocalization = (ThreadLocalization)m_localizations.get();
        if (threadLocalization == null) {
            return Locale.getDefault();
        }
        return threadLocalization.getThreadLocales()[0];
    }

    public static Locale[] getLocales() {
        ThreadLocalization threadLocalization = (ThreadLocalization)m_localizations.get();
        if (threadLocalization == null) {
            return new Locale[]{Locale.getDefault()};
        }
        return threadLocalization.getThreadLocales();
    }

    public static TimeZone getTimeZone() {
        ThreadLocalization threadLocalization = (ThreadLocalization)m_localizations.get();
        if (threadLocalization == null) {
            return TimeZone.getDefault();
        }
        return threadLocalization.getThreadTimeZone();
    }

    public static ResourceBundle getBundle(String string) {
        return ThreadLocalization.getBundle(string, Thread.currentThread().getContextClassLoader());
    }

    public static ResourceBundle getBundle(String string, ClassLoader classLoader) {
        return new ThreadResourceBundle(string, ThreadLocalization.getLocales(), classLoader);
    }

    private ThreadLocalization() {
    }

    private TimeZone getThreadTimeZone() {
        if (this.m_timeZone != null) {
            return this.m_timeZone;
        }
        return TimeZone.getDefault();
    }

    private Locale[] getThreadLocales() {
        if (this.m_locales != null) {
            return this.m_locales;
        }
        return new Locale[]{Locale.getDefault()};
    }

    private void setThreadTimeZone(TimeZone timeZone) {
        if (timeZone == null || timeZone.equals(TimeZone.getDefault())) {
            this.m_timeZone = null;
            if (this.m_locales == null) {
                m_localizations.set(null);
            }
        }
        this.m_timeZone = timeZone;
    }

    private void setThreadLocales(Locale[] localeArray) {
        if (localeArray == null || localeArray.length == 0 || localeArray.length == 1 && localeArray[0].equals(Locale.getDefault())) {
            this.m_locales = null;
            if (this.m_timeZone == null) {
                m_localizations.set(null);
            }
        }
        this.m_locales = localeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static ResourceBundle fetchBundle(String string, ClassLoader classLoader) {
        Object object;
        ResourceBundle resourceBundle;
        HashMap<String, ResourceBundle> hashMap;
        block25: {
            Map map = m_bundleLoaderCache;
            synchronized (map) {
                hashMap = (HashMap<String, ResourceBundle>)m_bundleLoaderCache.get(classLoader);
                if (hashMap == null) {
                    hashMap = new HashMap<String, ResourceBundle>();
                    m_bundleLoaderCache.put(classLoader, hashMap);
                }
            }
            HashMap<String, ResourceBundle> hashMap2 = hashMap;
            synchronized (hashMap2) {
                if (hashMap.containsKey(string)) {
                    return (ResourceBundle)hashMap.get(string);
                }
            }
            resourceBundle = null;
            if (resourceBundle == null) {
                try {
                    resourceBundle = (ResourceBundle)classLoader.loadClass(string).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (resourceBundle == null) {
                block24: {
                    string = string.replace('.', '/') + ".properties";
                    object = null;
                    object = classLoader.getResourceAsStream(string);
                    if (object == null) {
                        object = classLoader.getResourceAsStream("/" + string);
                    }
                    if (object == null) break block24;
                    resourceBundle = new PropertyResourceBundle((InputStream)object);
                }
                Object var9_10 = null;
                try {
                    ((InputStream)object).close();
                }
                catch (Exception exception) {}
                break block25;
                {
                    catch (IOException iOException) {
                        Object var9_11 = null;
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        object = hashMap;
        synchronized (object) {
            hashMap.put(string, resourceBundle);
        }
        return resourceBundle;
    }

    private static class ThreadResourceBundle
    extends ResourceBundle {
        private final int m_nBundles;
        private final String[] m_bundleNames;
        private final ResourceBundle[] m_bundles;
        private final String m_szBaseName;
        private final ClassLoader m_loader;

        public ThreadResourceBundle(String string, Locale[] localeArray, ClassLoader classLoader) {
            this.m_szBaseName = string;
            this.m_loader = classLoader;
            this.m_bundles = new ResourceBundle[localeArray.length * 3 + 1];
            this.m_bundleNames = new String[localeArray.length * 3 + 1];
            int n = 0;
            boolean bl = false;
            int n2 = 0;
            while (n2 < localeArray.length) {
                if (localeArray[n2].getVariant() != null && localeArray[n2].getVariant().length() > 0) {
                    this.m_bundleNames[n++] = string + "_" + localeArray[n2].getLanguage() + "_" + localeArray[n2].getCountry() + "_" + localeArray[n2].getVariant();
                }
                if (localeArray[n2].getCountry() != null && localeArray[n2].getCountry().length() > 0) {
                    this.m_bundleNames[n++] = string + "_" + localeArray[n2].getLanguage() + "_" + localeArray[n2].getCountry();
                }
                this.m_bundleNames[n++] = string + "_" + localeArray[n2].getLanguage();
                if (localeArray[n2].getLanguage().equals("en")) {
                    this.m_bundleNames[n++] = string;
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                this.m_bundleNames[n++] = string;
            }
            this.m_nBundles = n;
        }

        public Enumeration getKeys() {
            return new Enumeration(this){
                private int m_nBundleIdx;
                private Enumeration m_enum;
                private final /* synthetic */ ThreadResourceBundle this$0;
                {
                    this.this$0 = threadResourceBundle;
                    this.m_nBundleIdx = 0;
                    this.m_enum = null;
                }

                public boolean hasMoreElements() {
                    while (!(this.m_nBundleIdx >= ThreadResourceBundle.access$000(this.this$0) || this.m_enum != null && this.m_enum.hasMoreElements())) {
                        ResourceBundle resourceBundle;
                        this.m_enum = (resourceBundle = ThreadResourceBundle.access$100(this.this$0, this.m_nBundleIdx++)) == null ? null : resourceBundle.getKeys();
                    }
                    if (this.m_enum == null) {
                        return false;
                    }
                    return this.m_enum.hasMoreElements();
                }

                public Object nextElement() {
                    if (this.hasMoreElements()) {
                        return this.m_enum.nextElement();
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        protected Object handleGetObject(String string) {
            int n = 0;
            while (n < this.m_nBundles) {
                ResourceBundle resourceBundle = this.getLinkedBundle(n);
                if (resourceBundle != null) {
                    try {
                        return resourceBundle.getObject(string);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
                ++n;
            }
            throw new MissingResourceException("Resource Could Not Be Found", this.m_szBaseName, string);
        }

        private ResourceBundle getLinkedBundle(int n) {
            ResourceBundle resourceBundle = this.m_bundles[n];
            if (resourceBundle == null) {
                String string = this.m_bundleNames[n];
                if (string == null) {
                    return null;
                }
                resourceBundle = ThreadLocalization.fetchBundle(string, this.m_loader);
                this.m_bundleNames[n] = null;
                this.m_bundles[n] = resourceBundle;
            }
            return resourceBundle;
        }

        static /* synthetic */ int access$000(ThreadResourceBundle threadResourceBundle) {
            return threadResourceBundle.m_nBundles;
        }

        static /* synthetic */ ResourceBundle access$100(ThreadResourceBundle threadResourceBundle, int n) {
            return threadResourceBundle.getLinkedBundle(n);
        }
    }
}

