/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.win32;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.awt.Rectangle;

public class Win32Library {
    private static boolean m_bAvctWin32LibLoaded = false;

    public native String GetDesktopWorkArea();

    public native String GetDefaultBrowser();

    public native String GetSpecialFolderPath(int var1);

    public Rectangle getDesktopWorkArea() throws ExceptionRequestFailed {
        if (!m_bAvctWin32LibLoaded) {
            Trace.logError("Win32Library", "GetWorkArea Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        try {
            Trace.logInfo("Win32Library", "Calling avctUtil.dll to get Work Area");
            String string = this.GetDesktopWorkArea();
            Trace.logInfo("Win32Library", "Successful. WorkArea=" + string);
            int n = string.indexOf(",");
            if (n == -1) {
                throw new ExceptionRequestFailed();
            }
            String string2 = string.substring(0, n);
            string = string.substring(n + 1);
            Trace.logInfo("Win32Library", "Left=" + string2);
            int n2 = Integer.parseInt(string2);
            n = string.indexOf(",");
            if (n == -1) {
                throw new ExceptionRequestFailed();
            }
            String string3 = string.substring(0, n);
            string = string.substring(n + 1);
            Trace.logInfo("Win32Library", "Top=" + string3);
            int n3 = Integer.parseInt(string3);
            n = string.indexOf(",");
            if (n == -1) {
                throw new ExceptionRequestFailed();
            }
            String string4 = string.substring(0, n);
            string = string.substring(n + 1);
            Trace.logInfo("Win32Library", "Right=" + string4);
            int n4 = Integer.parseInt(string4);
            String string5 = string;
            Trace.logInfo("Win32Library", "Bottom=" + string5);
            int n5 = Integer.parseInt(string5);
            Rectangle rectangle = new Rectangle(n2, n3, n4 - n2, n5 - n3);
            Trace.logInfo("Win32Library", "Returning Work Area " + rectangle.toString());
            return rectangle;
        }
        catch (Exception exception) {
            Trace.logError("Win32Library", "GetWorkArea Failed", exception);
            throw new ExceptionRequestFailed();
        }
    }

    public String getSpecialFolderPath(int n) throws ExceptionRequestFailed {
        try {
            Trace.logInfo("Win32Library", "Calling avctUtil.dll to get FolderPath");
            String string = this.GetSpecialFolderPath(n);
            Trace.logInfo("Win32Library", "Successful. FolderPath=" + string);
            return string;
        }
        catch (Exception exception) {
            Trace.logError("Win32Library", "FolderPath Failed", exception);
            throw new ExceptionRequestFailed();
        }
    }

    public String getDefaultBrowser() throws ExceptionRequestFailed {
        if (!m_bAvctWin32LibLoaded) {
            Trace.logError("Win32Library", "GetDefaultBrowser Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        try {
            Trace.logInfo("Win32Library", "Calling avctUtil.dll to get Default Browser");
            String string = this.GetDefaultBrowser();
            Trace.logInfo("Win32Library", "GetDefaultBrowser Successful. Return=" + string);
            return string;
        }
        catch (Exception exception) {
            Trace.logError("Win32Library", "GetDefaultBrowser Failed", exception);
            throw new ExceptionRequestFailed();
        }
    }

    public static boolean isWin32LibLoaded() {
        return m_bAvctWin32LibLoaded;
    }

    static {
        Trace.logInfo("Win32Library", "Loading avctUtil.dll");
        try {
            System.loadLibrary("avctUtil");
            m_bAvctWin32LibLoaded = true;
            Trace.logInfo("Win32Library", "avctUtil.dll Loaded successfully");
        }
        catch (LinkageError linkageError) {
            Trace.logError("Win32Library", "LinkageError");
        }
        catch (SecurityException securityException) {
            Trace.logError("Win32Library", "SecurityException");
        }
        catch (Exception exception) {
            Trace.logError("Win32Library", " FAILED to load avctUtil.dll", exception);
        }
    }
}

