/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.panels.BackgroundImage;
import java.awt.Color;
import java.awt.Image;
import java.awt.Insets;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;

public class AVWorksBranding {
    public static final String APPLICATION_ICON_KEY = "ApplicationIcon";
    public static final String PRODUCT_NAME_KEY = "ProductName";
    public static final String DBASE_DIRECTORY_NAME_KEY = "DBaseDirectoryName";
    public static final String PRODUCT_SPLASH_COPYRIGHT_GRAPHIC_KEY = "ProductSplashCopyrightGraphic";
    public static final String PRODUCT_UPDATE_URL_KEY = "ProductUpdateUrl";
    public static final String LICENSE_MANAGER_ENABLED_KEY = "LicenseManagerEnabled";
    public static final String ABOUT_IMAGE_KEY = "AboutImage";
    public static final String VSP_STYLE_KEY = "vspStyle";
    public static final String VSP_BACKGROUND_COLOR_KEY = "vspBackgroundColor";
    public static final String VSP_IMAGE_KEY = "vspImage";
    public static final String VSP_SELECTOR_POSITION_KEY = "vspSelectorPosition";
    public static final String VSP_SELECTOR_INSETS_KEY = "vspSelectorInsets";
    public static final String VSP_CONTROL_TEXT_COLOR_NORMAL_KEY = "vspControlTextColorNormal";
    public static final String VSP_CONTROL_TEXT_COLOR_SELECTED_KEY = "vspControlTextColorSelected";
    public static final String VSP_TAB_BACKGROUND_NORMAL_KEY = "vspTabBackgroundNormal";
    public static final String VSP_TAB_BACKGROUND_SELECTED_KEY = "vspTabBackgroundSelected";
    public static final String VSP_TAB_HIGHLIGHT_KEY = "vspTabHighlight";
    public static final String VSP_TAB_SHADOW_KEY = "vspTabShadow";
    public static final String VSP_APPLIANCES_IMAGE_NORMAL_KEY = "vspAppliancesImageNormal";
    public static final String VSP_APPLIANCES_IMAGE_SELECTED_KEY = "vspAppliancesImageSelected";
    public static final String VSP_SERVERS_IMAGE_NORMAL_KEY = "vspServersImageNormal";
    public static final String VSP_SERVERS_IMAGE_SELECTED_KEY = "vspServersImageSelected";
    public static final String VSP_SITES_IMAGE_NORMAL_KEY = "vspSitesImageNormal";
    public static final String VSP_SITES_IMAGE_SELECTED_KEY = "vspSitesImageSelected";
    public static final String VSP_FOLDERS_IMAGE_NORMAL_KEY = "vspFoldersImageNormal";
    public static final String VSP_FOLDERS_IMAGE_SELECTED_KEY = "vspFoldersImageSelected";
    public static final String USP_TITLE_BACKGROUND_COLOR_KEY = "uspTitleBackgroundColor";
    public static final String USP_TITLE_TEXT_COLOR_KEY = "uspTitleTextColor";
    public static final String GSP_BACKGROUND_COLOR_KEY = "gspBackgroundColor";
    public static final String GSP_IMAGE_KEY = "gspImage";
    public static final String GSP_TREE_TEXT_COLOR_NORMAL_KEY = "gspTreeTextColorNormal";
    public static final String GSP_TREE_TEXT_COLOR_SELECTED_KEY = "gspTreeTextColorSelected";
    public static final String GSP_TREE_TEXT_BACKGROUND_COLOR_SELECTED_KEY = "gspTreeTextBackgroundColorSelected";
    public static final String GSP_TREE_INSETS_KEY = "gspTreeInsets";
    public static final String GSP_APPLIANCES_ENABLED_KEY = "gspAppliancesEnabled";
    public static final String GSP_SERVERS_ENABLED_KEY = "gspServersEnabled";
    public static final String GSP_TREE_VIEW_OPEN_ICON_KEY = "gspTreeViewOpenIcon";
    public static final String GSP_TREE_VIEW_CLOSED_ICON_KEY = "gspTreeViewClosedIcon";
    public static final String GSP_TREE_VIEW_LEAF_ICON_KEY = "gspTreeViewLeafIcon";
    public static final String GSP_TREE_VIEW_ROOT_VISIBLE_KEY = "gspTreeViewRootVisible";
    public static final String GSP_TREE_VIEW_SHOWS_ROOT_HANDLES_KEY = "gspTreeViewShowsRootHandles";
    public static final String APPLIANCE_NAME_SINGULAR_KEY = "ApplianceNameSingular";
    public static final String APPLIANCE_NAME_PLURAL_KEY = "ApplianceNamePlural";
    public static final String APPLIANCE_NAME_MNEMONIC_KEY = "ApplianceNameMnemonic";
    public static final String SERVER_NAME_SINGULAR_KEY = "ServerNameSingular";
    public static final String SERVER_NAME_PLURAL_KEY = "ServerNamePlural";
    public static final String SERVER_NAME_MNEMONIC_KEY = "ServerNameMnemonic";
    public static final String DSR_IQ_NAME_SINGULAR_KEY = "DsrIqNameSingular";
    public static final String DSR_IQ_NAME_PLURAL_KEY = "DsrIqNamePlural";
    public static final String CASCADE_SWITCH_NAME_SINGULAR_KEY = "CascadeSwitchNameSingular";
    public static final String CASCADE_SWITCH_NAME_PLURAL_KEY = "CascadeSwitchNamePlural";
    public static final String DEFAULT_MACRO_GROUPS_KEY = "DefaultMacroGroups";
    public static final String DEFAULT_DIRECT_DRAW_KEY = "DefaultDirectDraw";
    public static final String DEFAULT_DISCOVER_WIZARD_ADDRESS_RANGE_KEY = "DefaultDiscoverWizardAddressRange";
    public static final String MANAGE_APPLIANCE_TASK_KEY = "ManageApplianceTask";
    public static final String MANAGE_APPLIANCE_TIP_KEY = "ManageApplianceTip";
    public static final String CONNECT_VIDEO_TASK_KEY = "ConnectVideoTask";
    public static final String CONNECT_VIDEO_TIP_KEY = "ConnectVideoTip";
    public static final String CONNECT_SERIAL_TASK_KEY = "ConnectSerialTask";
    public static final String CONNECT_SERIAL_LABEL_KEY = "ConnectSerialLabel";
    public static final String CONNECT_SERIAL_TIP_KEY = "ConnectSerialTip";
    public static final String EXCLUDE_DEFAULT_NAMES_VALUE_KEY = "ExcludeDefaultNamesValue";
    public static final String SHOW_EXCLUDE_DEFAULT_NAMES_KEY = "ShowExcludeDefaultNames";
    public static final String MANAGE_APPLIANCE_KEY = "ManageAppliance";
    public static final String SCAN_VIDEO_TASK_KEY = "ScanVideoTask";
    public static final String SCAN_VIDEO_TIP_KEY = "ScanVideoTip";
    public static final String SCV_APPLICATION_ICON_KEY = "scvApplicationIcon";
    public static final String SCV_PRODUCT_NAME_KEY = "scvProductName";
    public static final String VSV_PRODUCT_NAME_KEY = "vsvProductName";
    public static final String TELNET_APPLICATION_ICON_KEY = "telnetApplicationIcon";
    public static final String TELNET_PRODUCT_NAME_KEY = "telnetProductName";
    public static final String PRODUCT_GENERIC_APPLIANCE_NAME_KEY = "productGenericApplianceName";
    public static final String TELNET_ACTION_ICON_KEY = "telnetActionIcon";
    public static final String BROWSE_ACTION_ICON_KEY = "browseActionIcon";
    public static final String SERIAL_ACTION_ICON_KEY = "serialActionIcon";
    public static final String ASSIGNTO_ACTION_ICON_KEY = "assigntoActionIcon";
    public static final String MANAGEAPPLIANCE_ACTION_ICON_KEY = "manageapplianceActionIcon";
    public static final String PROPERTIES_ACTION_ICON_KEY = "propertiesActionIcon";
    public static final String NEWAPPLIANCE_ACTION_ICON_KEY = "newapplianceActionIcon";
    public static final String VIDEO_ACTION_ICON_KEY = "videoActionIcon";
    public static final String SCANVIDEO_ACTION_ICON_KEY = "scanvideoActionIcon";
    public static final String VIDEO_APPLICATION_ICON_KEY = "videoApplicationIcon";
    public static final String VIRTUAL_MEDIA_APPLICATION_ICON_KEY = "vmApplicationIcon";
    public static final String TELNET_FEATURE_KEY = "TelnetFeature";
    public static final String VIRTUAL_CONNECTION_SUPPORT_KEY = "VirtualConnectionSupport";
    public static final String AVR_RESYNC_REPLACE_KEY = "AvrResyncReplace";
    public static final String LICENSED_OPTIONS_SUPPORT = "LicensedOptionsSupport";
    public static final String LICENSED_OPTION_KEY_SEGMENTS = "LicensedOptionsKeySegments";
    public static final String LICENSED_OPTION_KEY_LENGTH = "LicensedOptionsKeyLength";
    public static final String LDAP_AUTHENTICATION_SUPPORT = "LDAPAuthenticationSupport";
    public static final String LDAP_AUTHENTICATION_ONLY = "LDAPAuthenticationOnly";
    public static final String LDAP_SCHEMA_EXTENSIONS = "LDAPSchemaExtensions";
    public static final String LDAP_SIMPLE_OPTIONS = "LDAPSimpleOptions";
    public static final String CCM_LDAP_AUTHENTICATION_SUPPORT = "CCMLDAPAuthenticationSupport";
    public static final String CCM_LDAP_AUTHENTICATION_ONLY = "CCMLDAPAuthenticationOnly";
    public static final String CCM_LDAP_SCHEMA_EXTENSIONS = "CCMLDAPSchemaExtensions";
    public static final String MINDTERM_COPYRIGHT_KEY = "MindtermCopyright";
    public static final int MAX_BRANDING_IMAGES = 50;
    static ResourceBundle m_resourcebundle = null;
    public static final String CLEAR_OFFLINE_RIPS_KEY = "ClearOfflineRips";
    public static final String INTEROPERABILITY_FEATURE_KEY = "InteroperabilityFeature";
    public static final String PREEMPTIONWARNING_FEATURE_KEY = "PreemptionWarningFeature";
    public static final String CASCADE_SWITCH_FILTER_CLASS = "CascadeSwitchFilterClass";
    public static final String VIDEO_VIEWER_MACRO_KEY = "VideoViewerMacro";
    public static final String VIDEO_VIEWER_MACRO_EDITOR_KEY = "VideoViewerMacroEditor";
    public static final String COPYRIGHT_NOTICE = "CopyrightNotice";
    public static final String OVERRIDE_ADMIN_USER = "OverrideAdminUser";
    public static final String CONFIGURE_DNS_SERVERS = "ConfigureDNSServers";
    public static final String BRANDING_AUTH_METHOD_SINGLE_SELECT = "singleAuthMethodSelection";
    public static final String BRANDING_LOCAL_AUTH_ALWAYS_ON = "localAuthAlwaysOn";
    public static final String CONFIGURE_CACHE_CREDENTIALS = "ConfigureCacheCredentials";
    public static final String CONNECTION_SHARING = "ConnectionSharing";
    public static final String VIDEO_ENCRYPTION = "VideoEncryption";
    public static final String VM_SUPPORT = "VirtualMediaSupport";
    public static final String RIP_INTEROPERABILITY_SUPPORT = "RipInteroperabilityFeature";
    public static final String PS2_RESET_IN_VIEWER = "Ps2ResetButtonAvailableViewer";
    public static final String CCM_OVERRIDE_ADMIN_USER = "CCMOverrideAdminUser";
    public static final String CCM_DEFAULT_2_DIGIT_PORT_NUMBERS = "CCMDefault2DigitPortNumbers";
    public static final String AVR_BOOTP_ONLY = "AVR_BOOTP_ONLY";
    public static final String SEND_CERTIFICATE_ALLOWED = "SendCertificateAllowed";
    public static final String LOGIN_TIMEOUT_SUPPORT = "LoginTimeoutSupport";
    public static final String AVR_LDAP_THEN_LOCAL_AUTHENTICATION = "AvrLdapWithLocalAlwaysSelectionMethod";
    public static final String AVR_NTP_SUPPORT = "AvrNtpSupport";

    public static String getString(String string, String string2) {
        try {
            return m_resourcebundle.getString(string);
        }
        catch (Exception exception) {
            Trace.logInfo((String)"Branding", (String)"NOTE: Default string returned");
            return string2;
        }
    }

    public static Color getColor(String string, Color color) {
        try {
            String string2 = m_resourcebundle.getString(string);
            return Color.decode(string2);
        }
        catch (Exception exception) {
            Trace.logInfo((String)"Branding", (String)"NOTE: Default color returned");
            return color;
        }
    }

    public static boolean getBoolean(String string, boolean bl) {
        try {
            String string2 = m_resourcebundle.getString(string);
            return Boolean.valueOf(string2);
        }
        catch (Exception exception) {
            Trace.logInfo((String)"Branding", (String)"NOTE: Default boolean returned");
            return bl;
        }
    }

    public static int getInteger(String string, int n) {
        try {
            String string2 = m_resourcebundle.getString(string);
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            Trace.logInfo((String)"Branding", (String)"NOTE: Default value returned");
            return n;
        }
    }

    public static Insets getInset(String string, Insets insets) {
        try {
            String string2 = m_resourcebundle.getString(string);
            Insets insets2 = new Insets(0, 0, 0, 0);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                switch (n++) {
                    case 0: {
                        insets2.top = Integer.parseInt(string3);
                        break;
                    }
                    case 1: {
                        insets2.left = Integer.parseInt(string3);
                        break;
                    }
                    case 2: {
                        insets2.bottom = Integer.parseInt(string3);
                        break;
                    }
                    case 3: {
                        insets2.right = Integer.parseInt(string3);
                    }
                }
            }
            if (n != 4) {
                throw new ExceptionRequestFailed();
            }
            return insets2;
        }
        catch (Exception exception) {
            Trace.logInfo((String)"Branding", (String)"NOTE: Default Insets returned");
            return insets;
        }
    }

    public static ImageIcon getImage(String string, ImageIcon imageIcon) {
        try {
            URL uRL;
            String string2 = m_resourcebundle.getString(string);
            if (!string2.startsWith("/")) {
                string2 = "/com/avocent/avworks/branding/" + string2;
            }
            if ((uRL = AVWorksBranding.class.getResource(string2)) == null) {
                throw new ExceptionRequestFailed();
            }
            ImageIcon imageIcon2 = new ImageIcon(uRL);
            return imageIcon2;
        }
        catch (Exception exception) {
            Trace.logInfo((String)"Branding", (String)"NOTE: Default image returned");
            return imageIcon;
        }
    }

    public static BackgroundImage[] getBackgroundImages(String string) {
        Trace.logInfo((String)"Branding", (String)"getBackgroundImages");
        Vector<BackgroundImage> vector = new Vector<BackgroundImage>();
        for (int i = 0; i < 50; ++i) {
            String string2 = string + i;
            Trace.logInfo((String)"Branding", (String)("Getting key " + string2));
            try {
                String string3 = m_resourcebundle.getString(string2);
                Trace.logInfo((String)"Branding", (String)("Found Entry=" + string3));
                if (string3.length() == 0) break;
                int n = string3.indexOf(44);
                if (n == -1) continue;
                String string4 = string3.substring(0, n).trim();
                String string5 = string3.substring(n + 1).trim();
                if ((n = string5.indexOf(44)) == -1) continue;
                String string6 = string5.substring(0, n).trim();
                String string7 = string5.substring(n + 1).trim();
                if (!string4.startsWith("/")) {
                    string4 = "/com/avocent/avworks/branding/" + string4;
                }
                Trace.logInfo((String)"Branding", (String)("ImageURL=" + string4));
                URL uRL = (class$com$avocent$avworks$services$AVWorksBranding == null ? AVWorksBranding.class$("com.avocent.avworks.services.AVWorksBranding") : class$com$avocent$avworks$services$AVWorksBranding).getResource(string4);
                if (uRL == null) {
                    Trace.logInfo((String)"Branding", (String)"ImageURL NOT FOUND ");
                    throw new ExceptionRequestFailed();
                }
                Trace.logInfo((String)"Branding", (String)"Loading Image");
                ImageIcon imageIcon = new ImageIcon(uRL);
                int n2 = 1;
                if (string6.equalsIgnoreCase("TILED")) {
                    n2 = 3;
                } else if (string6.equalsIgnoreCase("STRETCHED")) {
                    n2 = 2;
                } else if (string6.equalsIgnoreCase("NORMAL")) {
                    n2 = 1;
                } else {
                    Trace.logInfo((String)"Branding", (String)("Invalid Image Entry. Bad Style " + string6));
                    continue;
                }
                int n3 = 0;
                if (string7.equalsIgnoreCase("NORTH")) {
                    n3 = 1;
                } else if (string7.equalsIgnoreCase("NORTH_EAST")) {
                    n3 = 2;
                } else if (string7.equalsIgnoreCase("EAST")) {
                    n3 = 3;
                } else if (string7.equalsIgnoreCase("SOUTH_EAST")) {
                    n3 = 4;
                } else if (string7.equalsIgnoreCase("SOUTH")) {
                    n3 = 5;
                } else if (string7.equalsIgnoreCase("SOUTH_WEST")) {
                    n3 = 6;
                } else if (string7.equalsIgnoreCase("WEST")) {
                    n3 = 7;
                } else if (string7.equalsIgnoreCase("NORTH_WEST")) {
                    n3 = 8;
                } else if (string7.equalsIgnoreCase("CENTER")) {
                    n3 = 0;
                } else {
                    Trace.logInfo((String)"Branding", (String)("Invalid Image Entry. Bad Position" + string7));
                    continue;
                }
                BackgroundImage backgroundImage = new BackgroundImage(imageIcon, n2, n3);
                vector.addElement(backgroundImage);
                continue;
            }
            catch (MissingResourceException missingResourceException) {
                Trace.logInfo((String)"Branding", (String)"No more entries");
                break;
            }
            catch (Exception exception) {
                Trace.logInfo((String)"Branding", (String)"Invalid Image Entry");
            }
        }
        Object[] objectArray = new BackgroundImage[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static ImageIcon getApplicationIcon() {
        ImageIcon imageIcon = new ImageIcon(AVWorksBranding.class.getResource("compass16.gif"));
        return AVWorksBranding.getImage(APPLICATION_ICON_KEY, imageIcon);
    }

    public static String getProductName() {
        return AVWorksBranding.getString(PRODUCT_NAME_KEY, "Avocent AVWorks");
    }

    public static String getLicensedOptionsSupport() {
        return AVWorksBranding.getString(LICENSED_OPTIONS_SUPPORT, "false");
    }

    public static int getLicensedOptionKeySegments() {
        return AVWorksBranding.getInteger(LICENSED_OPTION_KEY_SEGMENTS, 5);
    }

    public static int getLicensedOptionKeyLength() {
        return AVWorksBranding.getInteger(LICENSED_OPTION_KEY_LENGTH, 4);
    }

    public static String getLDAPAuthenticationSupport() {
        return AVWorksBranding.getString(LDAP_AUTHENTICATION_SUPPORT, "false");
    }

    public static String getLDAPAuthenticationOnly() {
        return AVWorksBranding.getString(LDAP_AUTHENTICATION_ONLY, "false");
    }

    public static String getApplianceName(boolean bl) {
        if (bl) {
            return AVWorksBranding.getString(APPLIANCE_NAME_SINGULAR_KEY, "Appliance");
        }
        return AVWorksBranding.getString(APPLIANCE_NAME_PLURAL_KEY, "Appliances");
    }

    public static String getServerName(boolean bl) {
        if (bl) {
            return AVWorksBranding.getString(SERVER_NAME_SINGULAR_KEY, "Server");
        }
        return AVWorksBranding.getString(SERVER_NAME_PLURAL_KEY, "Servers");
    }

    public static String getDsrIqName(boolean bl) {
        if (bl) {
            return AVWorksBranding.getString(DSR_IQ_NAME_SINGULAR_KEY, "DSRIQ");
        }
        return AVWorksBranding.getString(DSR_IQ_NAME_PLURAL_KEY, "DSRIQs");
    }

    public static String getCascadeSwitchName(boolean bl) {
        if (bl) {
            return AVWorksBranding.getString(CASCADE_SWITCH_NAME_SINGULAR_KEY, "Cascade Switch");
        }
        return AVWorksBranding.getString(CASCADE_SWITCH_NAME_PLURAL_KEY, "Cascade Switches");
    }

    public static String[] getDefaultMacroGroups(boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(AVWorksBranding.getString(DEFAULT_MACRO_GROUPS_KEY, "Windows Sun"), " ,");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String getDBaseDirectoryName() {
        return AVWorksBranding.getString(DBASE_DIRECTORY_NAME_KEY, "Avocent AVWorks");
    }

    public static boolean getDefaultDirectDraw() {
        boolean bl = true;
        return AVWorksBranding.getBoolean(DEFAULT_DIRECT_DRAW_KEY, bl);
    }

    public static boolean getDefaultAddressRange() {
        boolean bl = true;
        return AVWorksBranding.getBoolean(DEFAULT_DISCOVER_WIZARD_ADDRESS_RANGE_KEY, bl);
    }

    public static boolean getDisplaySearchNetworkAddressRange() {
        String string = "DisplaySearchNetworkAddressRange";
        boolean bl = false;
        return AVWorksBranding.getBoolean(string, bl);
    }

    public static String getCascadeSwitchFilterClass() {
        String string = AVWorksBranding.getString(CASCADE_SWITCH_FILTER_CLASS, "");
        return string.equals("") ? null : string;
    }

    public static boolean getClearOfflineRips() {
        boolean bl = false;
        return AVWorksBranding.getBoolean(CLEAR_OFFLINE_RIPS_KEY, bl);
    }

    public static boolean getInteroperabilityFeature() {
        boolean bl = false;
        return AVWorksBranding.getBoolean(INTEROPERABILITY_FEATURE_KEY, bl);
    }

    public static boolean getPreemptionWarningFeature() {
        boolean bl = false;
        return AVWorksBranding.getBoolean(PREEMPTIONWARNING_FEATURE_KEY, bl);
    }

    public static String getCopyrightNotice() {
        return AVWorksBranding.getString(COPYRIGHT_NOTICE, "Copyright \u00a9 1996-2006 Avocent Corporation");
    }

    public static boolean isVideoViewerMacroEditorEnabled() {
        return AVWorksBranding.getBoolean(VIDEO_VIEWER_MACRO_EDITOR_KEY, true);
    }

    public static String[][] getBrandableVideoMacros() {
        Object object;
        int n = 0;
        String string = AVWorksBranding.getString(VIDEO_VIEWER_MACRO_KEY + n, null);
        Vector<String[]> vector = new Vector<String[]>();
        while (string != null) {
            String[] stringArray = string.split("(?<!\\\\);");
            if (stringArray.length != 3) {
                object = new Exception("Invalid macro definition VideoViewerMacro" + n + "=" + string);
                Trace.logError((String)"Branding", (String)"Invalid VideoMacro syntax", (Throwable)object);
                break;
            }
            vector.add(stringArray);
            string = AVWorksBranding.getString(VIDEO_VIEWER_MACRO_KEY + ++n, null);
        }
        int n2 = vector.size();
        object = new String[n2][];
        for (n = 0; n < n2; ++n) {
            object[n] = (String[])vector.get(n);
        }
        return object;
    }

    public static String getOverrideAdminFeature() {
        return AVWorksBranding.getString(OVERRIDE_ADMIN_USER, "false");
    }

    public static boolean isCacheCredSupported() {
        return AVWorksBranding.getBoolean(CONFIGURE_CACHE_CREDENTIALS, false);
    }

    public static void main(String[] stringArray) {
        Trace.startLogging(null);
        Color color = AVWorksBranding.getColor(VSP_BACKGROUND_COLOR_KEY, new Color(255, 255, 255));
        Trace.logInfo((String)"Branding", (String)("Red=" + color.getRed()));
        Trace.logInfo((String)"Branding", (String)("Green=" + color.getGreen()));
        Trace.logInfo((String)"Branding", (String)("Blue=" + color.getBlue()));
        BackgroundImage[] backgroundImageArray = AVWorksBranding.getBackgroundImages(VSP_IMAGE_KEY);
        Trace.logInfo((String)"Branding", (String)("Found " + backgroundImageArray.length + "images"));
        for (int i = 0; i < backgroundImageArray.length; ++i) {
            Image image = backgroundImageArray[i].getImage();
            Trace.logInfo((String)"Branding", (String)("Image " + i + "is " + image.toString()));
        }
        AVWorksBranding.getBrandableVideoMacros();
    }

    static {
        try {
            Trace.logInfo((String)"Branding", (String)"Loading Brand.properties resource bundle");
            m_resourcebundle = ResourceBundle.getBundle("com.avocent.avworks.branding.Brand");
            Trace.logInfo((String)"Branding", (String)"Successfully loaoded Brand.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)"Branding", (String)"FAILED TO LOAD com.avocent.avworks.branding.Brand");
        }
    }
}

