/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksEventBroadcasterRegisteredListener;
import com.avocent.avworks.services.InterfaceAVWorksEventBroadcasterListener;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.util.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;

public class AVWorksEventBroadcaster {
    private static Vector m_vListeners = new Vector();
    public static final int DATABASE_SERVERS_MODIFIED = 2;
    public static final int DATABASE_APPLIANCES_MODIFIED = 3;
    public static final int DATABASE_CUSTOM_FIELD_LABELS_MODIFIED = 4;
    public static final int DATABASE_LOADED = 5;
    public static final int DATABASE_APPLIANCES_DELETED = 6;
    public static final int DATABASE_APPLIANCES_ADDED = 7;
    public static final int DATABASE_SERVERS_DELETED = 8;
    public static final int DATABASE_SERVERS_ADDED = 9;
    public static final int APPLIANCE_RESYNCHRONIZED = 10;
    public static final int DATABASE_UNITS_MODIFIED = 11;
    public static final int DATABASE_FOLDER_MODIFIED = 12;
    public static final int DATABASE_SERVERS_MERGED = 13;
    public static final String[] EVENT_DESC = new String[]{"", "DATABASE_MODIFIED", "DATABASE_SERVERS_MODIFIED", "DATABASE_APPLIANCES_MODIFIED", "DATABASE_CUSTOM_FIELD_LABELS_MODIFIED", "DATABASE_LOADED", "DATABASE_APPLIANCES_DELETED", "DATABASE_APPLIANCES_ADDED", "DATABASE_SERVERS_DELETED", "DATABASE_SERVERS_ADDED", "APPLIANCE_RESYNCHRONIZED", "DATABASE_UNITS_MODIFIED", "DATABASE_FOLDER_MODIFIED", "DATABASE_SERVERS_MERGED"};
    private static ArrayList m_alAppliancesDeleted;
    private static ArrayList m_alServersDeleted;

    public static synchronized void addListener(InterfaceAVWorksEventBroadcasterListener interfaceAVWorksEventBroadcasterListener, int[] nArray) throws ExceptionInvalidArgument {
        if (interfaceAVWorksEventBroadcasterListener == null || nArray == null || nArray.length == 0) {
            Trace.logError((String)"AVWorksEventBroadcaster:addListener()", (String)"invalid parameter");
            throw new ExceptionInvalidArgument();
        }
        m_vListeners.addElement(new AVWorksEventBroadcasterRegisteredListener(interfaceAVWorksEventBroadcasterListener, nArray));
        Trace.logInfo((String)"AVWorksEventBroadcaster:addListener()", (String)"added an event listener");
    }

    public static synchronized void addListener(InterfaceAVWorksEventBroadcasterListener interfaceAVWorksEventBroadcasterListener, int n) throws ExceptionInvalidArgument {
        if (interfaceAVWorksEventBroadcasterListener == null) {
            Trace.logError((String)"AVWorksEventBroadcaster:addListener()", (String)"invalid parameter");
            throw new ExceptionInvalidArgument();
        }
        int[] nArray = new int[]{n};
        m_vListeners.addElement(new AVWorksEventBroadcasterRegisteredListener(interfaceAVWorksEventBroadcasterListener, nArray));
        Trace.logInfo((String)"AVWorksEventBroadcaster:addListener()", (String)"added an event listener");
    }

    public static synchronized void removeListener(InterfaceAVWorksEventBroadcasterListener interfaceAVWorksEventBroadcasterListener) throws ExceptionInvalidArgument {
        if (interfaceAVWorksEventBroadcasterListener == null) {
            Trace.logError((String)"AVWorksEventBroadcaster:removeListener()", (String)"invalid parameter");
            throw new ExceptionInvalidArgument();
        }
        for (int i = 0; i < m_vListeners.size(); ++i) {
            AVWorksEventBroadcasterRegisteredListener aVWorksEventBroadcasterRegisteredListener = (AVWorksEventBroadcasterRegisteredListener)m_vListeners.elementAt(i);
            if (aVWorksEventBroadcasterRegisteredListener.getListener() != interfaceAVWorksEventBroadcasterListener) continue;
            m_vListeners.removeElement(aVWorksEventBroadcasterRegisteredListener);
            Trace.logInfo((String)"AVWorksEventBroadcaster:removeListener()", (String)"removed an event listener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireEvent(Object object, int n) {
        Vector vector = null;
        Vector vector2 = m_vListeners;
        synchronized (vector2) {
            vector = (Vector)m_vListeners.clone();
        }
        block3: for (int i = 0; i < vector.size(); ++i) {
            AVWorksEventBroadcasterRegisteredListener aVWorksEventBroadcasterRegisteredListener = (AVWorksEventBroadcasterRegisteredListener)vector.elementAt(i);
            int[] nArray = aVWorksEventBroadcasterRegisteredListener.getEventList();
            for (int j = 0; j < nArray.length; ++j) {
                if (n != nArray[j]) continue;
                final Object object2 = object;
                final int n2 = n;
                final InterfaceAVWorksEventBroadcasterListener interfaceAVWorksEventBroadcasterListener = aVWorksEventBroadcasterRegisteredListener.getListener();
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        interfaceAVWorksEventBroadcasterListener.doHandleEvent(object2, n2);
                    }
                });
                thread.start();
                Trace.logInfo((String)"AVWorksEventBroadcaster:fireEvent()", (String)("fired " + EVENT_DESC[n2]));
                continue block3;
            }
        }
    }

    public static void fireDatabaseModifiedEvent() {
    }

    public static void fireDatabaseLoadedEvent() {
        AVWorksEventBroadcaster.fireEvent(null, 5);
    }

    public static void fireDatabaseAppliancesModifiedEvent(UnitInfo[] unitInfoArray) {
        if (unitInfoArray != null && unitInfoArray.length > 0) {
            AVWorksEventBroadcaster.fireEvent(unitInfoArray, 3);
        }
    }

    public static void fireDatabaseServersModifiedEvent(UnitInfo[] unitInfoArray) {
        if (unitInfoArray != null && unitInfoArray.length > 0) {
            AVWorksEventBroadcaster.fireEvent(unitInfoArray, 2);
        }
    }

    public static void fireDatabaseCustomFieldLabelsModifiedEvent(int[] nArray) throws ExceptionInvalidArgument {
        if (nArray == null || nArray.length == 0) {
            Trace.logError((String)"AVWorksEventBroadcaster:fireDatabaseCustomFieldLabelsModifiedEvent", (String)"invalid parameter");
            throw new ExceptionInvalidArgument();
        }
        AVWorksEventBroadcaster.fireEvent(nArray, 4);
    }

    public static synchronized void fireDatabaseAppliancesDeletedEvent() {
        if (m_alAppliancesDeleted != null && m_alAppliancesDeleted.size() > 0) {
            UnitInfo[] unitInfoArray = m_alAppliancesDeleted.toArray(new UnitInfo[0]);
            AVWorksEventBroadcaster.fireEvent(unitInfoArray, 6);
        }
        m_alAppliancesDeleted = null;
    }

    private static synchronized void startDeletedAppliancesEvent() {
        if (m_alAppliancesDeleted == null) {
            m_alAppliancesDeleted = new ArrayList();
        }
    }

    public static synchronized void appendDeletedAppliances(UnitInfo[] unitInfoArray) {
        if (m_alAppliancesDeleted == null) {
            AVWorksEventBroadcaster.startDeletedAppliancesEvent();
        }
        m_alAppliancesDeleted.addAll(Arrays.asList(unitInfoArray));
    }

    public static void fireDatabaseAppliancesAddedEvent(UnitInfo[] unitInfoArray) {
        if (unitInfoArray != null && unitInfoArray.length > 0) {
            AVWorksEventBroadcaster.fireEvent(unitInfoArray, 7);
        }
    }

    public static synchronized void fireDatabaseServersDeletedEvent() {
        Trace.logInfo((String)"EventBroadcaster", (String)("deleting servers " + m_alServersDeleted));
        if (m_alServersDeleted != null && m_alServersDeleted.size() > 0) {
            Object[] objectArray = m_alServersDeleted.toArray(new UnitInfo[0]);
            Trace.logInfo((String)"EventBroadcaster", (String)("deleting servers " + StringUtilities.arrayToString((Object[])objectArray)));
            AVWorksEventBroadcaster.fireEvent(objectArray, 8);
        }
        m_alServersDeleted = null;
    }

    private static synchronized void startDeletedServersEvent() {
        if (m_alServersDeleted == null) {
            m_alServersDeleted = new ArrayList();
        }
    }

    public static synchronized void appendDeletedServers(UnitInfo[] unitInfoArray) {
        if (m_alServersDeleted == null) {
            AVWorksEventBroadcaster.startDeletedServersEvent();
        }
        m_alServersDeleted.addAll(Arrays.asList(unitInfoArray));
    }

    public static void fireDatabaseServersAddedEvent(UnitInfo[] unitInfoArray) {
        if (unitInfoArray != null && unitInfoArray.length > 0) {
            AVWorksEventBroadcaster.fireEvent(unitInfoArray, 9);
        }
    }

    public static void fireDatabaseApplianceResynchedEvent(UnitInfo unitInfo) {
        if (unitInfo == null) {
            Trace.logError((String)"AVWorksEventBroadcaster:fireDatabaseServersDeletedEvent", (String)"invalid parameter");
        } else {
            AVWorksEventBroadcaster.fireEvent(unitInfo, 10);
        }
    }

    public static void fireDatabaseUnitsModifiedEvent(UnitInfo[] unitInfoArray) {
        if (unitInfoArray != null && unitInfoArray.length > 0) {
            AVWorksEventBroadcaster.fireEvent(unitInfoArray, 11);
        }
    }

    public static void fireDatabaseFolderModifiedEvent(String string) {
        AVWorksEventBroadcaster.fireEvent(string, 12);
    }

    public static void fireApplianceOrServerModifiedEvent(UnitInfo unitInfo) {
        if (unitInfo != null) {
            UnitInfo[] unitInfoArray = new UnitInfo[]{unitInfo};
            if (unitInfo.isAppliance()) {
                AVWorksEventBroadcaster.fireDatabaseAppliancesModifiedEvent(unitInfoArray);
            } else {
                AVWorksEventBroadcaster.fireDatabaseServersModifiedEvent(unitInfoArray);
            }
        }
    }

    public static void fireDatabaseServersMergedEvent(Map map) {
        AVWorksEventBroadcaster.fireEvent(map, 13);
    }
}

