/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.lib.database.DBaseRequest;
import com.avocent.lib.database.ThreadDBaseService;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.util.ResourceManager;
import com.avocent.protocols.snmp.SnmpRequest;
import com.avocent.protocols.snmp.ThreadSnmpService;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class AVWorksService {
    public static final String CNAME = "AVWorksService";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.services.Res");
    protected static ThreadSnmpService m_snmp;
    protected static ThreadDBaseService m_dbaseservice;
    private static boolean m_bStop;
    private static final int SHUTDOWN_WAIT_TIMEOUT = 8000;
    private static final int DBASE_SHUTDOWN_WAIT_TIMEOUT = 30000;
    private static boolean m_bDbaseStarted;
    private static String m_szOsName;
    private static String szDBaseDriver;
    private static String szDBaseUrl;
    private static String szDBaseUserName;
    private static String szDBasePassword;
    private static String m_szDBasePath;

    public static void start() throws ExceptionRequestFailed {
        Trace.logInfo((String)"AVWorksService:start", (String)"Starting the View Plus services");
        try {
            Trace.logInfo((String)"AVWorksService:start", (String)"Starting the SNMP service thread...");
            m_snmp = ThreadSnmpService.getInstance();
            m_snmp.startup();
            Trace.logInfo((String)"AVWorksService:start", (String)"The SNMP service thread started successfully");
        }
        catch (Exception exception) {
            Trace.logError((String)"AVWorksService:start", (String)"Unable to start the SNMP service thread ");
            Trace.logError((String)"AVWorksService:start", (String)("Reason = " + exception.getMessage()));
            throw new ExceptionRequestFailed(res.getString("AVWorksService_Unable_To_Start_Snmp"));
        }
        String string = AVWorksService.getDBasePath();
        szDBaseUrl = szDBaseUrl + string;
        szDBaseUrl = szDBaseUrl + "/vpdbase";
        try {
            Trace.logInfo((String)"AVWorksService:start", (String)"Starting the Database service thread...");
            m_dbaseservice = new ThreadDBaseService(szDBaseDriver, szDBaseUrl, szDBaseUserName, szDBasePassword);
            m_dbaseservice.start();
            Trace.logInfo((String)"AVWorksService:start", (String)"The Database service started successfully");
            m_bDbaseStarted = true;
        }
        catch (SQLException sQLException) {
            Trace.logError((String)"AVWorksService:start", (String)"Unable to start the database service thread ");
            Trace.logError((String)"AVWorksService:start", (String)("Reason = " + sQLException.getMessage()));
            throw new ExceptionRequestFailed(res.getString("AVWorksService_Unable_To_Start_DBase"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.logError((String)"AVWorksService:start", (String)"Unable to start the database service thread ");
            Trace.logError((String)"AVWorksService:start", (String)("Reason = " + classNotFoundException.getMessage()));
            throw new ExceptionRequestFailed(res.getString("AVWorksService_Unable_To_Start_DBase"));
        }
        Trace.logInfo((String)"AVWorksService:start", (String)"The View Plus services were started successfully");
    }

    public static void shutdown() {
        Trace.logInfo((String)"AVWorksService:shutdown", (String)"Shutting down the View Plus Service");
        Trace.logInfo((String)"AVWorksService:shutdown", (String)"Stopping the SNMP service thread...");
        m_snmp.shutdown();
        Trace.logInfo((String)"AVWorksService:shutdown", (String)"SNMP service thread stopped successfully");
        try {
            if (m_dbaseservice != null) {
                Trace.logInfo((String)"AVWorksService:shutdown", (String)"Stopping the Database service thread...");
                m_dbaseservice.stopThreadAndWait(30000L);
                Trace.logInfo((String)"AVWorksService:shutdown", (String)"Database service thread stopped successfully");
            }
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Trace.logError((String)"AVWorksService:shutdown", (String)("DBase Shutdown error - Invalid Argument:" + exceptionInvalidArgument.getMessage()));
        }
        Trace.logInfo((String)"AVWorksService:shutdown", (String)"The View Plus service was shutdown successfully");
    }

    public static boolean requestSnmp(SnmpRequest snmpRequest) {
        return m_snmp.request(snmpRequest);
    }

    public static boolean requestDatabase(DBaseRequest dBaseRequest) {
        if (!m_bDbaseStarted) {
            dBaseRequest.setErrorStatus(5);
            return false;
        }
        return m_dbaseservice.request(dBaseRequest);
    }

    public static void shutdownDBase() {
        try {
            Trace.logInfo((String)"AVWorksService:shutdownDBase", (String)"Stopping the Database service thread...");
            m_dbaseservice.stopThreadAndWait(30000L);
            Trace.logInfo((String)"AVWorksService:shutdown", (String)"Database service thread stopped successfully");
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Trace.logError((String)"AVWorksService:shutdownDBase", (String)("DBase Shutdown error - Invalid Argument:" + exceptionInvalidArgument.getMessage()));
        }
        m_dbaseservice = null;
        m_bDbaseStarted = false;
        Trace.logInfo((String)"AVWorksService:shutdownDBase", (String)"The View Plus service was shutdown successfully");
    }

    public static void restartDBase() throws ExceptionRequestFailed {
        try {
            Trace.logInfo((String)"AVWorksService:restartDBase", (String)"Starting the Database service thread...");
            m_dbaseservice = new ThreadDBaseService(szDBaseDriver, szDBaseUrl, szDBaseUserName, szDBasePassword);
            m_dbaseservice.start();
            Trace.logInfo((String)"AVWorksService:restartDBase", (String)"The Database service started successfully");
            m_bDbaseStarted = true;
        }
        catch (SQLException sQLException) {
            Trace.logError((String)"AVWorksService:restartDBase", (String)"Unable to start the database service thread ");
            Trace.logError((String)"AVWorksService:start", (String)("Reason = " + sQLException.getMessage()));
            throw new ExceptionRequestFailed(res.getString("AVWorksService_Unable_To_Start_DBase"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.logError((String)"AVWorksService:restartDBase", (String)"Unable to start the database service thread ");
            Trace.logError((String)"AVWorksService:start", (String)("Reason = " + classNotFoundException.getMessage()));
            throw new ExceptionRequestFailed(res.getString("AVWorksService_Unable_To_Start_DBase"));
        }
        Trace.logInfo((String)"AVWorksService:restartDBase", (String)"The View Plus database services was started successfully");
    }

    public static String getDBasePath() throws ExceptionRequestFailed {
        if (m_szDBasePath.length() != 0) {
            return m_szDBasePath;
        }
        String string = null;
        try {
            string = AVWorksService.getUserDefinedDBasePath();
            if (new File(string).exists()) {
                m_szDBasePath = string;
                Trace.logInfo((String)"AVWorksService:getDBasePath", (String)("Database Directory=" + m_szDBasePath));
                return m_szDBasePath;
            }
            Trace.logInfo((String)"AVWorksService:getDBasePath", (String)("The user defined directory " + string + " does not exist"));
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            // empty catch block
        }
        try {
            string = AVWorksService.getDefaultDBasePath();
            Trace.logInfo((String)"AVWorksService:getDBasePath", (String)("Database Directory=" + string));
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            throw new ExceptionRequestFailed(res.getString("AVWorksService_Unable_To_Find_DBase_Dir"));
        }
        File file = new File(string);
        if (!file.exists()) {
            Trace.logInfo((String)"AVWorksService:getDBasePath", (String)(string + " does not exist, will create it now"));
            if (!file.mkdir()) {
                Trace.logError((String)"AVWorksService:getDBasePath", (String)("Failed to create " + string));
                throw new ExceptionRequestFailed(res.getString("AVWorksService_Unable_To_Create_DBase_Dir"));
            }
        }
        m_szDBasePath = string;
        Trace.logInfo((String)"AVWorksService:getDBasePath", (String)("Database Directory=" + m_szDBasePath));
        return m_szDBasePath;
    }

    private static String getUserDefinedDBasePath() throws ExceptionRequestFailed {
        Trace.logInfo((String)"AVWorksService:getUserDefinedDBasePath", (String)"Checking for the existence of the database.properties file");
        File file = new File("database.properties");
        if (!file.exists()) {
            Trace.logInfo((String)"AVWorksService:getUserDefinedDBasePath", (String)"database.properties file does not exist");
            throw new ExceptionRequestFailed();
        }
        try {
            Trace.logInfo((String)"AVWorksService:getUserDefinedDBasePath", (String)"database.properties file exists, now loading it...");
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            Trace.logInfo((String)"AVWorksService:getUserDefinedDBasePath", (String)"Successfully loaded database.properties file");
            String string = System.getProperty("user.name");
            Trace.logInfo((String)"AVWorksService:getUserDefinedDBasePath", (String)("user.name=" + string));
            String string2 = properties.getProperty(string);
            if (string2 == null || string2.length() == 0) {
                string2 = properties.getProperty("DBaseDirectory");
            }
            if (string2 != null && string2.length() != 0) {
                Trace.logInfo((String)"AVWorksService:getUserDefinedDBasePath", (String)("Database Directory=" + string2));
                return string2;
            }
            throw new ExceptionRequestFailed();
        }
        catch (Exception exception) {
            Trace.logError((String)"AVWorksService:getUserDefinedDBasePath", (String)"Failed to get the database directory from database.properties file", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    private static String getDefaultDBasePath() throws ExceptionRequestFailed {
        try {
            Trace.logInfo((String)"AVWorksService:getDefaultDBasePath", (String)"Getting the user.home property");
            String string = System.getProperty("user.home");
            Trace.logInfo((String)"AVWorksService:getDefaultDBasePath", (String)("user.home=" + string));
            String string2 = AVWorksBranding.getDBaseDirectoryName();
            Trace.logInfo((String)"AVWorksService:getDefaultDBasePath", (String)("Operating System=" + m_szOsName));
            if (!m_szOsName.startsWith("Windows")) {
                string2 = string2.replace(' ', '_');
            }
            Trace.logInfo((String)"AVWorksService:getDefaultDBasePath", (String)("Brandable database directory name=" + string2));
            string = string + "/" + string2;
            return string;
        }
        catch (Exception exception) {
            Trace.logError((String)"AVWorksService:getDefaultDBasePath", (String)"Failed to determine the default database path", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    public static Connection getConnection() {
        return m_dbaseservice.getConnection();
    }

    public static void main(String[] stringArray) {
        Trace.startLogging(null);
        try {
            AVWorksService aVWorksService = new AVWorksService();
            aVWorksService.start();
            String string = AVWorksService.getDBasePath();
            aVWorksService.shutdown();
        }
        catch (Exception exception) {
            Trace.logError((String)"AVWorksService:main", (String)("Unit Test Error : " + exception.getMessage()));
        }
        System.exit(0);
    }

    static {
        m_bStop = false;
        m_bDbaseStarted = false;
        m_szOsName = System.getProperty("os.name");
        szDBaseDriver = "org.hsqldb.jdbcDriver";
        szDBaseUrl = "jdbc:hsqldb:";
        szDBaseUserName = "sa";
        szDBasePassword = "";
        m_szDBasePath = "";
    }
}

