/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksWindow;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.gui.InterfaceWindowManager;
import com.avocent.lib.win32.Win32Library;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Vector;

public class AVWorksWindowManager {
    private static Vector m_vWindowList = new Vector();
    private static WinMgrWindowListener m_windowListener = new WinMgrWindowListener();
    private static final short DELAY = 50;

    public static void registerWindow(String string, String string2, int n, Window window) {
        AVWorksWindow aVWorksWindow = new AVWorksWindow(string, string2, n, window);
        m_vWindowList.addElement(aVWorksWindow);
        window.addWindowListener(m_windowListener);
        Trace.logInfo((String)"AVWorksWindowManager", (String)(window + " was registered"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unRegisterWindow(Window window) {
        Vector vector = m_vWindowList;
        synchronized (vector) {
            for (int i = 0; i < m_vWindowList.size(); ++i) {
                AVWorksWindow aVWorksWindow = (AVWorksWindow)m_vWindowList.elementAt(i);
                if (aVWorksWindow.getWindow() != window) continue;
                m_vWindowList.removeElementAt(i);
                Trace.logInfo((String)"AVWorksWindowManager", (String)(window + " was unregistered"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean closeAllWindows() {
        Serializable serializable;
        Object object;
        int n;
        int n2;
        Vector<Window> vector = new Vector<Window>();
        Vector<Window> vector2 = new Vector<Window>();
        Vector<Window> vector3 = new Vector<Window>();
        Vector vector4 = m_vWindowList;
        synchronized (vector4) {
            n2 = m_vWindowList.size();
            for (n = 0; n < n2; ++n) {
                object = (AVWorksWindow)m_vWindowList.elementAt(n);
                serializable = ((AVWorksWindow)object).getWindow();
                if (serializable instanceof InterfaceWindowManager) {
                    vector3.add((Window)serializable);
                    continue;
                }
                if (serializable instanceof Dialog) {
                    vector.addElement((Window)serializable);
                    continue;
                }
                vector2.addElement((Window)serializable);
            }
        }
        int n3 = vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Window window = (Window)vector.elementAt(n2);
            object = new WindowEvent(window, 201);
            window.dispatchEvent((AWTEvent)object);
            Trace.logInfo((String)"AVWorksWindowManager", (String)(window + " was sent a WINDOW_CLOSING event"));
        }
        n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            object = (Window)vector2.elementAt(n);
            serializable = new WindowEvent((Window)object, 201);
            ((Component)object).dispatchEvent((AWTEvent)serializable);
            Trace.logInfo((String)"AVWorksWindowManager", (String)(object + " was sent a WINDOW_CLOSING event"));
        }
        for (n = 0; n < vector3.size(); ++n) {
            object = (InterfaceWindowManager)vector3.get(n);
            boolean bl = object.closeWindow();
            if (bl) continue;
            Trace.logInfo((String)"AVWorksWindowManager", (String)"Viewer window did not close, cancel the shutdown of AVWorls.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AVWorksWindow[] getRegisteredWindows(boolean bl) {
        Vector<AVWorksWindow> vector = new Vector<AVWorksWindow>();
        Object[] objectArray = m_vWindowList;
        synchronized (m_vWindowList) {
            int n = m_vWindowList.size();
            for (int i = 0; i < n; ++i) {
                AVWorksWindow aVWorksWindow = (AVWorksWindow)m_vWindowList.elementAt(i);
                Window window = aVWorksWindow.getWindow();
                if (bl) {
                    if (!window.isVisible()) continue;
                    vector.addElement(aVWorksWindow);
                    continue;
                }
                vector.addElement(aVWorksWindow);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            objectArray = new AVWorksWindow[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    }

    public static AVWorksWindow[] findWindowsByType(int n, boolean bl) {
        return AVWorksWindowManager.findWindowsByTypes(new int[]{n}, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AVWorksWindow[] findWindowsByTypes(int[] nArray, boolean bl) {
        Vector<AVWorksWindow> vector = new Vector<AVWorksWindow>();
        Object[] objectArray = m_vWindowList;
        synchronized (m_vWindowList) {
            int n = m_vWindowList.size();
            for (int i = 0; i < n; ++i) {
                AVWorksWindow aVWorksWindow = (AVWorksWindow)m_vWindowList.elementAt(i);
                Window window = aVWorksWindow.getWindow();
                boolean bl2 = false;
                for (int j = 0; j < nArray.length; ++j) {
                    if (aVWorksWindow.getWindowType() != nArray[j]) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) continue;
                if (bl) {
                    if (!window.isVisible()) continue;
                    vector.addElement(aVWorksWindow);
                    continue;
                }
                vector.addElement(aVWorksWindow);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            objectArray = new AVWorksWindow[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AVWorksWindow[] findWindowsByID(String string, boolean bl) {
        Vector<AVWorksWindow> vector = new Vector<AVWorksWindow>();
        Object[] objectArray = m_vWindowList;
        synchronized (m_vWindowList) {
            int n = m_vWindowList.size();
            for (int i = 0; i < n; ++i) {
                AVWorksWindow aVWorksWindow = (AVWorksWindow)m_vWindowList.elementAt(i);
                Window window = aVWorksWindow.getWindow();
                if (aVWorksWindow.getWindowID().compareTo(string) != 0) continue;
                if (bl) {
                    if (!window.isVisible()) continue;
                    vector.addElement(aVWorksWindow);
                    continue;
                }
                vector.addElement(aVWorksWindow);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            objectArray = new AVWorksWindow[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AVWorksWindow[] findWindowsByName(String string, boolean bl) {
        Vector<AVWorksWindow> vector = new Vector<AVWorksWindow>();
        Object[] objectArray = m_vWindowList;
        synchronized (m_vWindowList) {
            int n = m_vWindowList.size();
            for (int i = 0; i < n; ++i) {
                AVWorksWindow aVWorksWindow = (AVWorksWindow)m_vWindowList.elementAt(i);
                Window window = aVWorksWindow.getWindow();
                if (aVWorksWindow.getWindowName().compareTo(string) != 0) continue;
                if (bl) {
                    if (!window.isVisible()) continue;
                    vector.addElement(aVWorksWindow);
                    continue;
                }
                vector.addElement(aVWorksWindow);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            objectArray = new AVWorksWindow[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    }

    public static AVWorksWindow findWindowsByNameType(String string, int n) {
        AVWorksWindow[] aVWorksWindowArray = AVWorksWindowManager.findWindowsByType(n, false);
        for (int i = 0; i < aVWorksWindowArray.length; ++i) {
            if (!aVWorksWindowArray[i].getWindowName().equals(string)) continue;
            return aVWorksWindowArray[i];
        }
        return null;
    }

    public static void tileWindows(AVWorksWindow[] aVWorksWindowArray) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        try {
            Win32Library win32Library = new Win32Library();
            rectangle = win32Library.getDesktopWorkArea();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Trace.logInfo((String)"Tile", (String)("Screen Work Area = " + rectangle.toString()));
        double d = Math.sqrt(aVWorksWindowArray.length);
        double d2 = Math.ceil(d);
        double d3 = Math.ceil((double)aVWorksWindowArray.length / d2);
        int n = (int)d2;
        int n2 = (int)d3;
        int n3 = 0;
        int n4 = rectangle.width / n;
        int n5 = rectangle.height / n2;
        for (int i = 0; i < n && n3 < aVWorksWindowArray.length; ++i) {
            for (int j = 0; j < n2; ++j) {
                AVWorksWindow aVWorksWindow;
                Window window;
                Point point = new Point(rectangle.x + i * n4, rectangle.y + j * n5);
                Point point2 = new Point(rectangle.x + (i + 1) * n4, rectangle.y + (j + 1) * n5);
                if (!((window = (aVWorksWindow = aVWorksWindowArray[n3++]).getWindow()) instanceof InterfaceWindowManager)) continue;
                InterfaceWindowManager interfaceWindowManager = (InterfaceWindowManager)aVWorksWindow.getWindow();
                Dimension dimension2 = interfaceWindowManager.inquireNewSize(new Dimension(n4, n5));
                interfaceWindowManager.setNewSize(new Rectangle(point.x, point.y, (int)dimension2.getWidth(), (int)dimension2.getHeight()));
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void cascadeWindows(AVWorksWindow[] aVWorksWindowArray) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        try {
            Win32Library win32Library = new Win32Library();
            rectangle = win32Library.getDesktopWorkArea();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Trace.logInfo((String)"Cascade", (String)("Screen Work Area = " + rectangle.toString()));
        int n = 640;
        int n2 = 480;
        int n3 = 22;
        int n4 = 22;
        if (rectangle.width <= 640) {
            Trace.logInfo((String)"Cascade", (String)"Screen Size is less than 640x480");
            double d = (double)rectangle.width * 0.75;
            double d2 = (double)rectangle.height * 0.75;
            n = (int)d;
            n2 = (int)d2;
            Trace.logInfo((String)"Cascade", (String)("Make cascade window Width=" + n + " Height=" + n2));
        }
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        for (int i = 0; i < aVWorksWindowArray.length; ++i) {
            AVWorksWindow aVWorksWindow = aVWorksWindowArray[i];
            Window window = aVWorksWindow.getWindow();
            if (window instanceof InterfaceWindowManager) {
                InterfaceWindowManager interfaceWindowManager = (InterfaceWindowManager)aVWorksWindow.getWindow();
                Dimension dimension2 = interfaceWindowManager.inquireNewSize(new Dimension(n, n2));
                interfaceWindowManager.setNewSize(new Rectangle(n5, n6, (int)dimension2.getWidth(), (int)dimension2.getHeight()));
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((n5 += n3) <= rectangle.width - n && (n6 += n4) <= rectangle.height - n2) continue;
            n5 = 0;
            n6 = 0;
        }
    }

    static class WinMgrWindowListener
    extends WindowAdapter {
        WinMgrWindowListener() {
        }

        public void windowClosed(WindowEvent windowEvent) {
            AVWorksWindowManager.unRegisterWindow((Window)windowEvent.getSource());
        }
    }
}

