/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.util.ResourceManager;
import java.text.MessageFormat;
import javax.swing.ImageIcon;

public class ActionItem {
    public static final String CNAME = "ActionItem";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.services.Res");
    public static final int COMMON_ACTION_ID_BASE = 0;
    public static final int MANAGE_APPLIANCE_ACTION_ID = -1;
    public static final int BROWSE_ACTION_ID = -2;
    public static final int TELNET_ACTION_ID = -3;
    private int m_nActionID;
    private int m_nNmmID;
    private ImageIcon m_iiAction;
    private String m_szText;
    private String m_szTooltip;
    private boolean m_bPrimaryAction;
    private boolean m_bMenuItem;
    private boolean m_bTaskButton;

    public ActionItem(int n, int n2, ImageIcon imageIcon, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        this.m_nActionID = n;
        this.m_nNmmID = n2;
        this.m_iiAction = imageIcon;
        this.m_szText = string;
        this.m_szTooltip = string2;
        this.m_bPrimaryAction = bl;
        this.m_bMenuItem = bl2;
        this.m_bTaskButton = bl3;
    }

    public ActionItem(int n, int n2, boolean bl) throws ExceptionConstructorFailed {
        switch (n) {
            case -1: {
                this.m_nActionID = n;
                this.m_nNmmID = n2;
                this.m_iiAction = AVWorksBranding.getImage("manageapplianceActionIcon", null);
                this.m_szText = AVWorksBranding.getString("ManageApplianceTask", res.getString("ActionItem_ManageApplianceAction"));
                this.m_szTooltip = AVWorksBranding.getString("ManageApplianceTip", res.getString("ActionItem_ManageApplianceActionTip"));
                this.m_bPrimaryAction = bl;
                this.m_bMenuItem = true;
                this.m_bTaskButton = true;
                break;
            }
            case -2: {
                this.m_nActionID = n;
                this.m_nNmmID = n2;
                this.m_iiAction = AVWorksBranding.getImage("browseActionIcon", null);
                this.m_szText = res.getString("ActionItem_BrowseAction");
                this.m_szTooltip = MessageFormat.format(res.getString("ActionItem_BrowseActionTip"), AVWorksBranding.getApplianceName(true));
                this.m_bPrimaryAction = bl;
                this.m_bMenuItem = true;
                this.m_bTaskButton = true;
                break;
            }
            case -3: {
                this.m_nActionID = n;
                this.m_nNmmID = n2;
                this.m_iiAction = AVWorksBranding.getImage("telnetActionIcon", null);
                this.m_szText = res.getString("ActionItem_TelnetAction");
                this.m_szTooltip = MessageFormat.format(res.getString("ActionItem_TelnetActionTip"), AVWorksBranding.getApplianceName(true));
                this.m_bPrimaryAction = bl;
                this.m_bMenuItem = true;
                this.m_bTaskButton = true;
                break;
            }
            default: {
                Trace.logError((String)"ActionItem:constructor", (String)("Unsupported action id [" + n + "]"));
                throw new ExceptionConstructorFailed();
            }
        }
    }

    public int getActionID() {
        return this.m_nActionID;
    }

    public int getNmmID() {
        return this.m_nNmmID;
    }

    public ImageIcon getIcon() {
        return this.m_iiAction;
    }

    public String getText() {
        return this.m_szText;
    }

    public String getTooltip() {
        return this.m_szTooltip;
    }

    public boolean isPrimaryAction() {
        return this.m_bPrimaryAction;
    }

    public boolean isMenuItem() {
        return this.m_bMenuItem;
    }

    public boolean isTaskButton() {
        return this.m_bTaskButton;
    }

    public boolean equals(Object object) {
        try {
            if (this.getActionID() == ((ActionItem)object).getActionID()) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.getActionID();
    }

    public String toString() {
        return this.getText();
    }
}

