/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AppliancePropertiesDb;
import com.avocent.avworks.services.CommonDatabasePropertyKeys;
import com.avocent.avworks.services.InterfaceAVWorksNMM;
import com.avocent.avworks.services.NmmDb;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionNotSupported;
import com.avocent.lib.exceptions.ExceptionRequestFailed;

public class ApplianceInfo
extends UnitInfo
implements CommonDatabasePropertyKeys {
    public static final String DEFAULT_ICON = "/com/avocent/avworks/explorer/defaultappliance16.gif";
    private int m_nProductID;
    private int m_nNmmID;
    private boolean m_bAmpSupported;
    private String m_szSnmpReadCommunity;
    private String m_szSnmpWriteCommunity;

    public ApplianceInfo(int n, String string, String string2, int n2, String string3, String string4, String string5, String string6, int n3, boolean bl) {
        this(n, string, string2, n2, string3, string4, string5, string6, n3, bl, "");
    }

    public ApplianceInfo(int n, String string, String string2, int n2, String string3, String string4, String string5, String string6, int n3, boolean bl, String string7) {
        super(n, string, string2, string3, string4, string7);
        this.m_nProductID = n2;
        this.m_szSnmpReadCommunity = string5;
        this.m_szSnmpWriteCommunity = string6;
        this.m_nNmmID = n3;
        this.m_bAmpSupported = bl;
    }

    public ApplianceInfo(ApplianceInfo applianceInfo) {
        super(applianceInfo, DEFAULT_ICON);
        this.m_nNmmID = applianceInfo.getNmmID();
        this.m_nProductID = applianceInfo.getProductID();
        this.m_bAmpSupported = applianceInfo.isAmpSupported();
        this.m_szSnmpReadCommunity = applianceInfo.getReadCommunity();
        this.m_szSnmpWriteCommunity = applianceInfo.getWriteCommunity();
    }

    public boolean isAppliance() {
        return true;
    }

    protected String getDefaultIcon() {
        return DEFAULT_ICON;
    }

    public String getBrowserURL() {
        try {
            return AppliancePropertiesDb.getStringValue(this.getID(), "BROWSER_URL", "");
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ApplianceInfo.getBrowserURL", (String)(exceptionRequestFailed.getMessage() + ": returning ''"));
            return "";
        }
    }

    public void setBrowserURL(String string) throws ExceptionRequestFailed {
        super.setBrowserURL(string);
        AppliancePropertiesDb.setValue(this.getID(), "BROWSER_URL", string);
    }

    public void setType(String string) {
        this.doSetType(string);
    }

    public int getProductID() {
        return this.m_nProductID;
    }

    public void setProductID(int n) {
        this.m_nProductID = n;
    }

    public String getReadCommunity() {
        return this.m_szSnmpReadCommunity;
    }

    public String getWriteCommunity() {
        return this.m_szSnmpWriteCommunity;
    }

    public int getNmmID() {
        return this.m_nNmmID;
    }

    public boolean isAmpSupported() {
        return this.m_bAmpSupported;
    }

    public int getTelnetPort() {
        try {
            return AppliancePropertiesDb.getIntegerValue(this.getID(), "TELNET_PORT", 0);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.logInfo((String)"ApplianceInfo.getTelnetPort", (String)("found bogus port# " + numberFormatException.getMessage() + ": returning 0"));
            return 0;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ApplianceInfo.getTelnetPort", (String)(exceptionRequestFailed.getMessage() + ": returning 0"));
            return 0;
        }
    }

    public void setTelnetPort(int n) throws ExceptionRequestFailed {
        if (n == 0) {
            AppliancePropertiesDb.removeValue(this.getID(), "TELNET_PORT");
        } else {
            AppliancePropertiesDb.setValue(this.getID(), "TELNET_PORT", n);
        }
    }

    public boolean getUseDefaultTelnet() {
        try {
            return AppliancePropertiesDb.getBooleanValue(this.getID(), "TELNET_USE_DEFAULT", true);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ApplianceInfo.getUseDefaultTelnet", (String)"DB Request failed: returning true by default");
            return true;
        }
    }

    public void setUseDefaultTelnet(boolean bl) throws ExceptionRequestFailed {
        AppliancePropertiesDb.setValue(this.getID(), "TELNET_USE_DEFAULT", bl);
    }

    public boolean getUseBuiltinTelnet() {
        try {
            return AppliancePropertiesDb.getBooleanValue(this.getID(), "TELNET_USE_BUILTIN", true);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ApplianceInfo.getUseBuiltintTelnet", (String)"DB Request failed: returning true by default");
            return true;
        }
    }

    public void setUseBuiltinTelnet(boolean bl) throws ExceptionRequestFailed {
        AppliancePropertiesDb.setValue(this.getID(), "TELNET_USE_BUILTIN", bl);
    }

    public boolean getTelnetLoginWindow() {
        try {
            return AppliancePropertiesDb.getBooleanValue(this.getID(), "TELNET_SHOW_LOGIN_WINDOW", false);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ApplianceInfo.getUseBuiltintTelnet", (String)"DB Request failed: returning false by default");
            return false;
        }
    }

    public void setTelnetLoginWindow(boolean bl) throws ExceptionRequestFailed {
        AppliancePropertiesDb.setValue(this.getID(), "TELNET_SHOW_LOGIN_WINDOW", bl);
    }

    public String getTelnetApplicationPath() {
        try {
            return AppliancePropertiesDb.getStringValue(this.getID(), "TELNET_APPLICATION", null);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ApplianceInfo.getTelnetApplicationPath", (String)"DB Request failed: returning null by default");
            return null;
        }
    }

    public void setTelnetApplicationPath(String string) throws ExceptionRequestFailed {
        AppliancePropertiesDb.setValue(this.getID(), "TELNET_APPLICATION", string);
    }

    public String getTelnetCommandLineArgs() {
        try {
            return AppliancePropertiesDb.getStringValue(this.getID(), "TELNET_APPLICATION_ARGS", null);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ApplianceInfo.getTelnetCommandLineArgs", (String)"DB Request failed: returning null by default");
            return null;
        }
    }

    public void setTelnetCommandLineArgs(String string) throws ExceptionRequestFailed {
        AppliancePropertiesDb.setValue(this.getID(), "TELNET_APPLICATION_ARGS", string);
    }

    public boolean getTelnetLaunchCommandWindow() {
        try {
            return AppliancePropertiesDb.getBooleanValue(this.getID(), "TELNET_LAUNCH_IN_WINDOW", false);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ApplianceInfo.getTelnetLaunchCommandWindow", (String)"DB Request failed: returning false by default");
            return false;
        }
    }

    public void setTelnetLaunchCommandWindow(boolean bl) throws ExceptionRequestFailed {
        AppliancePropertiesDb.setValue(this.getID(), "TELNET_LAUNCH_IN_WINDOW", bl);
    }

    public boolean isPropertySupported(String string) {
        try {
            InterfaceAVWorksNMM interfaceAVWorksNMM = NmmDb.getNmm(this.m_nNmmID);
            return interfaceAVWorksNMM.isPropertySupported(this.getID(), "Appliance", string);
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logError((String)"JPanelPropertiesNetworkTab", (String)("Unable to load NMM with id " + this.getID()), (Throwable)exceptionNoValue);
            return false;
        }
        catch (ExceptionNotSupported exceptionNotSupported) {
            Trace.logError((String)"JPanelPropertiesNetworkTab", (String)exceptionNotSupported.getMessage(), (Throwable)exceptionNotSupported);
            return false;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"JPanelPropertiesNetworkTab", (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
            return false;
        }
    }
}

