/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.avworks.services.Unit;
import com.avocent.lib.database.DBaseRequestQueryResults;
import com.avocent.lib.database.DatabaseUtilities;
import com.avocent.lib.database.DefaultTableDefinition;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.database.TableDefinition;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.sql.Connection;
import java.util.Vector;

public class AppliancesDb {
    public static final String TRACE_CTXT = "ApplianceDb";
    protected static DefaultTableDefinition m_tdTableDefinition = new DefaultTableDefinition("APPLIANCES");
    public static final String APPLIANCES = "APPLIANCES";
    public static final String ID = "ID";
    public static final String NAME = "NAME";
    public static final String TYPE = "TYPE";
    public static final String PRODUCT_ID = "PRODUCT_ID";
    public static final String ICON = "ICON";
    public static final String CUSTOM_FIELD1 = "CUSTOM_FIELD1";
    public static final String CUSTOM_FIELD2 = "CUSTOM_FIELD2";
    public static final String CUSTOM_FIELD3 = "CUSTOM_FIELD3";
    public static final String ADDRESS = "ADDRESS";
    public static final String NMM = "NMM";
    public static final String AMP = "AMP";
    public static final String SNMP_READ_COM = "SNMP_READ_COM";
    public static final String SNMP_WRITE_COM = "SNMP_WRITE_COM";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String CONTACT = "CONTACT";
    public static final String CONTACT_PHONE = "CONTACT_PHONE";
    public static final String COMMENT = "COMMENT";
    public static final String BROWSER_URL = "BROWSER_URL";
    public static final String CACHED_CRED = "CACHED_CRED";
    public static final int DB_NULL = -1;
    public static final int MAX_LEN_NAME = 32;
    public static final int MAX_LEN_TYPE = 32;
    public static final int MAX_LEN_ICON = 128;
    public static final int MAX_LEN_CUSTOM_FIELD_1 = 32;
    public static final int MAX_LEN_CUSTOM_FIELD_2 = 32;
    public static final int MAX_LEN_CUSTOM_FIELD_3 = 32;
    public static final int MAX_LEN_ADDRESS = 128;
    public static final int MAX_LEN_SNMP_READ_COM = 32;
    public static final int MAX_LEN_SNMP_WRITE_COM = 32;
    public static final int MAX_LEN_DESCRIPTION = 128;
    public static final int MAX_LEN_CONTACT = 128;
    public static final int MAX_LEN_CONTACT_PHONE = 64;
    public static final int MAX_LEN_COMMENT = 128;

    public static TableDefinition getTableDefinition() {
        return m_tdTableDefinition;
    }

    public static int add(ApplianceInfo applianceInfo) throws ExceptionRequestFailed {
        if (applianceInfo == null) {
            Trace.logError((String)"AppliancesDb:add", (String)"Invalid argument");
            throw new ExceptionRequestFailed();
        }
        Trace.logInfo((String)"AppliancesDb:add", (String)("Appliance=" + applianceInfo.getName()));
        Trace.logInfo((String)"AppliancesDb:add", (String)("Type=" + applianceInfo.getType()));
        Trace.logInfo((String)"AppliancesDb:add", (String)("Address=" + applianceInfo.getAddress()));
        String string = Unit.getUniqueName(applianceInfo.getName());
        if (!string.equals(applianceInfo.getName())) {
            applianceInfo.setName(string);
        }
        Trace.logInfo((String)"AppliancesDb:add", (String)("Unique Appliance Name=" + string));
        int n = 1;
        try {
            n = AppliancesDb.getMaxID() + 1;
            Trace.logInfo((String)"AppliancesDb:add", (String)("Maximum Appliance ID is " + n));
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"AppliancesDb:add", (String)"NOTE: Unable to obtain max ID");
        }
        for (int i = n; i < n + 5; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer.append("INSERT INTO ").append(APPLIANCES);
                stringBuffer.append(" ( ");
                stringBuffer.append(ID).append(", ");
                stringBuffer.append(NAME).append(", ");
                stringBuffer.append(TYPE).append(", ");
                stringBuffer.append(PRODUCT_ID).append(", ");
                stringBuffer.append(ICON).append(", ");
                stringBuffer.append(CUSTOM_FIELD1).append(", ");
                stringBuffer.append(CUSTOM_FIELD2).append(", ");
                stringBuffer.append(CUSTOM_FIELD3).append(", ");
                stringBuffer.append(ADDRESS).append(", ");
                stringBuffer.append(NMM).append(", ");
                stringBuffer.append(AMP).append(", ");
                stringBuffer.append(SNMP_READ_COM).append(", ");
                stringBuffer.append(SNMP_WRITE_COM).append(", ");
                stringBuffer.append(DESCRIPTION).append(", ");
                stringBuffer.append(CONTACT).append(", ");
                stringBuffer.append(CONTACT_PHONE).append(", ");
                stringBuffer.append(COMMENT).append(", ");
                stringBuffer.append(BROWSER_URL).append(", ");
                stringBuffer.append(CACHED_CRED);
                stringBuffer.append(") ");
                stringBuffer.append("VALUES");
                stringBuffer.append("( ");
                stringBuffer.append(Integer.toString(i) + ", ");
                stringBuffer.append(SqlCmd.quote((String)string) + ", ");
                stringBuffer.append(SqlCmd.quote((String)applianceInfo.getType()) + ", ");
                stringBuffer.append(Integer.toString(applianceInfo.getProductID()) + ", ");
                stringBuffer.append(SqlCmd.quote((String)applianceInfo.getIcon()) + ", ");
                stringBuffer.append(SqlCmd.quote((String)applianceInfo.getCustomField(1)) + ", ");
                stringBuffer.append(SqlCmd.quote((String)applianceInfo.getCustomField(2)) + ", ");
                stringBuffer.append(SqlCmd.quote((String)applianceInfo.getCustomField(3)) + ", ");
                stringBuffer.append(SqlCmd.quote((String)applianceInfo.getAddress()) + ", ");
                stringBuffer.append(Integer.toString(applianceInfo.getNmmID()) + ", ");
                stringBuffer.append(Integer.toString(applianceInfo.isAmpSupported() ? 1 : 0) + ", ");
                stringBuffer.append(SqlCmd.quote((String)applianceInfo.getReadCommunity()) + ", ");
                stringBuffer.append(SqlCmd.quote((String)applianceInfo.getWriteCommunity()) + ", ");
                stringBuffer.append(SqlCmd.quote((String)applianceInfo.getDescription()) + ", ");
                stringBuffer.append(SqlCmd.quote((String)applianceInfo.getContact()) + ", ");
                stringBuffer.append(SqlCmd.quote((String)applianceInfo.getContactPhone()) + ", ");
                stringBuffer.append(SqlCmd.quote((String)applianceInfo.getComment()) + ", ");
                stringBuffer.append(SqlCmd.quote((String)applianceInfo.getBrowserURL()) + ", ");
                stringBuffer.append(Integer.toString(applianceInfo.getCredentialsCacheMode()) + " ");
                stringBuffer.append(");");
            }
            catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                Trace.logError((String)"AppliancesDb:add", (String)"ERROR : Invalid Argument");
                continue;
            }
            Trace.logInfo((String)"AppliancesDb:add", (String)("Execute SQL=" + stringBuffer.toString()));
            int n2 = DatabaseSession.executeUpdate(stringBuffer.toString());
            if (n2 != 1) continue;
            return i;
        }
        Trace.logError((String)"AppliancesDb:add", (String)"ERROR : Exceeded maximum retries");
        throw new ExceptionRequestFailed();
    }

    public static int getCount() throws ExceptionRequestFailed {
        String string = "SELECT COUNT(ID) FROM APPLIANCES";
        int n = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logError((String)"AppliancesDb:getCount", (String)"ERROR:Unable to read maximum appliance ID");
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        return n2;
    }

    public static int getMaxID() throws ExceptionRequestFailed {
        String string = "SELECT MAX(ID) FROM APPLIANCES";
        int n = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        return n2;
    }

    public static boolean isNameDefined(String string) throws ExceptionRequestFailed {
        return AppliancesDb.isNameDefined(0, string);
    }

    public static boolean isNameDefined(int n, String string) throws ExceptionRequestFailed {
        Trace.logInfo((String)"AppliancesDb:isNameDefined", (String)("Name    =" + string));
        Trace.logInfo((String)"AppliancesDb:isNameDefined", (String)("IgnoreID=" + n));
        if (string == null || string.length() == 0) {
            Trace.logError((String)"AppliancesDb:isNameDefined", (String)"ERROR : Invalid name argument");
            throw new ExceptionRequestFailed();
        }
        String string2 = "SELECT NAME FROM APPLIANCES WHERE (UPPER(NAME)=" + SqlCmd.quote((String)string.toUpperCase()) + ")" + " AND" + " (" + ID + "!=" + Integer.toString(n) + ");";
        Trace.logInfo((String)"AppliancesDb:isNameDefined", (String)("Execute SQL=" + string2));
        int n2 = DatabaseSession.executeQuery(string2);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() > 0) {
            Trace.logInfo((String)"AppliancesDb:isNameDefined", (String)"YES - Name exists");
            return true;
        }
        Trace.logInfo((String)"AppliancesDb:isNameDefined", (String)"NO - Name DOES NOT exist");
        return false;
    }

    public static boolean isAddressDefined(String string) throws ExceptionRequestFailed {
        Trace.logInfo((String)"AppliancesDb:isAddressDefined", (String)("Address=" + string));
        if (string == null || string.length() == 0) {
            Trace.logError((String)"AppliancesDb:isAddressDefined", (String)"ERROR : Invalid address argument");
            throw new ExceptionRequestFailed();
        }
        String string2 = "SELECT NAME FROM APPLIANCES WHERE (UPPER(ADDRESS)=" + SqlCmd.quote((String)string.toUpperCase()) + ");";
        Trace.logInfo((String)"AppliancesDb:isAddressDefined", (String)("Execute SQL=" + string2));
        int n = DatabaseSession.executeQuery(string2);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() > 0) {
            Trace.logInfo((String)"AppliancesDb:isAddressDefined", (String)"YES - Address IS defined");
            return true;
        }
        Trace.logInfo((String)"AppliancesDb:isAddressDefined", (String)"NO - Address IS NOT defined");
        return false;
    }

    public static void setIPAddress(int n, String string) throws ExceptionRequestFailed {
        Trace.logInfo((String)TRACE_CTXT, (String)("Set appliance accress to: " + string));
        if (string == null || string.length() == 0) {
            Trace.logError((String)TRACE_CTXT, (String)"Missing address argument");
            throw new ExceptionRequestFailed();
        }
        String string2 = "UPDATE APPLIANCES SET ADDRESS=" + SqlCmd.quote((String)string.toUpperCase()) + " WHERE " + ID + "=" + n + ";";
        int n2 = DatabaseSession.executeUpdate(string2);
        if (n2 < 1) {
            Trace.logError((String)TRACE_CTXT, (String)("Datebase updated failed: IP address may not have been set to: " + string));
            throw new ExceptionRequestFailed();
        }
    }

    public static void setApplianceName(int n, String string) throws ExceptionRequestFailed {
        String string2;
        int n2;
        Trace.logInfo((String)TRACE_CTXT, (String)("Set appliance accress to: " + string));
        if (string == null) {
            string = "";
        }
        if ((n2 = DatabaseSession.executeUpdate(string2 = "UPDATE APPLIANCES SET NAME=" + SqlCmd.quote((String)string) + " WHERE " + ID + "=" + n + ";")) < 1) {
            Trace.logError((String)TRACE_CTXT, (String)("Datebase updated failed: Appliance name may not have been set to: " + string));
            throw new ExceptionRequestFailed();
        }
    }

    public static boolean delete(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM APPLIANCES WHERE ID IN ( ");
        StringBuffer stringBuffer2 = new StringBuffer("DELETE FROM APPLIANCE_CUSTOM_FOLDER_MAP WHERE APPLIANCE_ID IN ( ");
        StringBuffer stringBuffer3 = new StringBuffer("DELETE FROM APPLIANCE_PROPERTIES WHERE APPLIANCE_ID IN ( ");
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (stringBuffer2.length() >= 118 || i == nArray.length - 1) {
                stringBuffer.append(nArray[i]);
                stringBuffer.append(" );");
                stringBuffer2.append(nArray[i]);
                stringBuffer2.append(" );");
                stringBuffer3.append(nArray[i]);
                stringBuffer3.append(" );");
                try {
                    Trace.logInfo((String)"AppliancesDb:delete", (String)"Deleting Appliances ");
                    Trace.logInfo((String)"AppliancesDb:delete", (String)stringBuffer.toString());
                    int n = DatabaseSession.executeUpdate(stringBuffer.toString());
                    Trace.logInfo((String)"AppliancesDb:delete", (String)("Appliances Deleted =" + n));
                    if (n > 0) {
                        try {
                            Trace.logInfo((String)"AppliancesDb:delete", (String)"Deleting Appliance Folder Mappings");
                            Trace.logInfo((String)"AppliancesDb:delete", (String)stringBuffer2.toString());
                            n = DatabaseSession.executeUpdate(stringBuffer2.toString());
                            Trace.logInfo((String)"AppliancesDb:delete", (String)("Folder Mappings Deleted =" + n));
                            Trace.logInfo((String)"AppliancesDb:delete", (String)"Deleting Properties associated with appliance");
                            Trace.logInfo((String)"AppliancesDb:delete", (String)stringBuffer3.toString());
                            n = DatabaseSession.executeUpdate(stringBuffer3.toString());
                            Trace.logInfo((String)"AppliancesDb:delete", (String)("Appliance Properties Deleted =" + n));
                        }
                        catch (Exception exception) {
                            Trace.logInfo((String)"AppliancesDb:delete", (String)"Failed Server Information Delete");
                        }
                    } else {
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    Trace.logError((String)"AppliancesDb:delete", (String)"Failed Server Delete", (Throwable)exception);
                    return false;
                }
                stringBuffer = null;
                stringBuffer = new StringBuffer("DELETE FROM APPLIANCES WHERE ID IN ( ");
                stringBuffer2 = null;
                stringBuffer2 = new StringBuffer("DELETE FROM APPLIANCE_CUSTOM_FOLDER_MAP WHERE APPLIANCE_ID IN ( ");
                stringBuffer3 = null;
                stringBuffer3 = new StringBuffer("DELETE FROM APPLIANCE_PROPERTIES WHERE APPLIANCE_ID IN ( ");
                continue;
            }
            stringBuffer.append(nArray[i]);
            stringBuffer.append(", ");
            stringBuffer2.append(nArray[i]);
            stringBuffer2.append(", ");
            stringBuffer3.append(nArray[i]);
            stringBuffer3.append(", ");
        }
        return bl;
    }

    public static void modify(ApplianceInfo applianceInfo) throws ExceptionRequestFailed {
        Trace.logInfo((String)"AppliancesDb:modify", (String)("ID =" + applianceInfo.getID()));
        Trace.logInfo((String)"AppliancesDb:modify", (String)("Appliance=" + applianceInfo.getName()));
        Trace.logInfo((String)"AppliancesDb:modify", (String)("Type=" + applianceInfo.getType()));
        Trace.logInfo((String)"AppliancesDb:modify", (String)("Address=" + applianceInfo.getAddress()));
        if (applianceInfo == null) {
            Trace.logError((String)"AppliancesDb:add", (String)"Invalid argument");
            throw new ExceptionRequestFailed();
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("UPDATE APPLIANCES SET ");
            stringBuffer.append("NAME=" + SqlCmd.quote((String)applianceInfo.getName()) + ",");
            stringBuffer.append("TYPE=" + SqlCmd.quote((String)applianceInfo.getType()) + ",");
            stringBuffer.append("PRODUCT_ID=" + Integer.toString(applianceInfo.getProductID()) + ",");
            stringBuffer.append("ICON=" + SqlCmd.quote((String)applianceInfo.getIcon()) + ",");
            stringBuffer.append("CUSTOM_FIELD1=" + SqlCmd.quote((String)applianceInfo.getCustomField(1)) + ",");
            stringBuffer.append("CUSTOM_FIELD2=" + SqlCmd.quote((String)applianceInfo.getCustomField(2)) + ",");
            stringBuffer.append("CUSTOM_FIELD3=" + SqlCmd.quote((String)applianceInfo.getCustomField(3)) + ",");
            stringBuffer.append("ADDRESS=" + SqlCmd.quote((String)applianceInfo.getAddress()) + ",");
            stringBuffer.append("NMM=" + Integer.toString(applianceInfo.getNmmID()) + ",");
            stringBuffer.append("AMP=" + (applianceInfo.isAmpSupported() ? "1" : "0") + ",");
            stringBuffer.append("SNMP_READ_COM=" + SqlCmd.quote((String)applianceInfo.getReadCommunity()) + ",");
            stringBuffer.append("SNMP_WRITE_COM=" + SqlCmd.quote((String)applianceInfo.getWriteCommunity()) + ",");
            stringBuffer.append("DESCRIPTION=" + SqlCmd.quote((String)applianceInfo.getDescription()) + ",");
            stringBuffer.append("CONTACT=" + SqlCmd.quote((String)applianceInfo.getContact()) + ",");
            stringBuffer.append("CONTACT_PHONE=" + SqlCmd.quote((String)applianceInfo.getContactPhone()) + ",");
            stringBuffer.append("COMMENT=" + SqlCmd.quote((String)applianceInfo.getComment()) + ", ");
            stringBuffer.append("CACHED_CRED=" + Integer.toString(applianceInfo.getCredentialsCacheMode()) + ", ");
            stringBuffer.append(BROWSER_URL).append("=").append(SqlCmd.quote((String)applianceInfo.getBrowserURL())).append(" ");
            stringBuffer.append(" WHERE (ID=" + Integer.toString(applianceInfo.getID()) + ");");
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Trace.logError((String)"AppliancesDb:modify", (String)"ERROR : Invalid Argument");
            throw new ExceptionRequestFailed();
        }
        int n = DatabaseSession.executeUpdate(stringBuffer.toString());
        if (n >= 1) {
            return;
        }
        Trace.logError((String)"AppliancesDb.modify", (String)"ERROR : The appliance was not found");
        throw new ExceptionRequestFailed();
    }

    public static void rename(int n, String string) throws ExceptionRequestFailed {
        if (string == null) {
            Trace.logError((String)"AppliancesDb:rename", (String)"ERROR:Invalid name argument");
            throw new ExceptionRequestFailed();
        }
        String string2 = "UPDATE APPLIANCES SET NAME=" + SqlCmd.quote((String)string) + " WHERE (ID=" + Integer.toString(n) + ");";
        int n2 = DatabaseSession.executeUpdate(string2);
        if (n2 >= 1) {
            return;
        }
        Trace.logError((String)"AppliancesDb:rename", (String)"ERROR:The old name was not found");
        throw new ExceptionRequestFailed();
    }

    public static ApplianceInfo getApplianceInfo(int n) throws ExceptionRequestFailed, ExceptionNoValue {
        String string = "SELECT * FROM APPLIANCES WHERE (ID=" + Integer.toString(n) + ");";
        int n2 = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logInfo((String)"AppliancesDb:getApplianceInfo", (String)"NOTE : No value was available");
            throw new ExceptionNoValue();
        }
        dBaseRequestQueryResults.nextRow();
        return AppliancesDb.createApplianceInfo(dBaseRequestQueryResults);
    }

    public static ApplianceInfo createApplianceInfo(DBaseRequestQueryResults dBaseRequestQueryResults) throws ExceptionRequestFailed {
        int n = dBaseRequestQueryResults.getInt(ID);
        String string = dBaseRequestQueryResults.getString(NAME);
        String string2 = dBaseRequestQueryResults.getString(TYPE);
        int n2 = dBaseRequestQueryResults.getInt(PRODUCT_ID);
        String string3 = dBaseRequestQueryResults.getString(ICON);
        String string4 = dBaseRequestQueryResults.getString(ADDRESS);
        String string5 = dBaseRequestQueryResults.getString(SNMP_READ_COM);
        String string6 = dBaseRequestQueryResults.getString(SNMP_WRITE_COM);
        int n3 = dBaseRequestQueryResults.getInt(NMM);
        int n4 = dBaseRequestQueryResults.getInt(AMP);
        boolean bl = n4 == 1;
        int n5 = dBaseRequestQueryResults.getInt(CACHED_CRED);
        String string7 = dBaseRequestQueryResults.getString(CUSTOM_FIELD1, "");
        String string8 = dBaseRequestQueryResults.getString(CUSTOM_FIELD2, "");
        String string9 = dBaseRequestQueryResults.getString(CUSTOM_FIELD3, "");
        String string10 = dBaseRequestQueryResults.getString(DESCRIPTION, "");
        String string11 = dBaseRequestQueryResults.getString(CONTACT, "");
        String string12 = dBaseRequestQueryResults.getString(CONTACT_PHONE, "");
        String string13 = dBaseRequestQueryResults.getString(COMMENT, "");
        String string14 = dBaseRequestQueryResults.getString(BROWSER_URL, "");
        ApplianceInfo applianceInfo = new ApplianceInfo(n, string, string2, n2, string3, string4, string5, string6, n3, bl, string14);
        try {
            applianceInfo.setCustomField(1, string7);
            applianceInfo.setCustomField(2, string8);
            applianceInfo.setCustomField(3, string9);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            throw new ExceptionRequestFailed();
        }
        applianceInfo.setDescription(string10);
        applianceInfo.setContact(string11);
        applianceInfo.setContactPhone(string12);
        applianceInfo.setComment(string13);
        applianceInfo.setCredentialsCacheMode(n5);
        return applianceInfo;
    }

    public static String getBrowserUrl(int n) throws ExceptionRequestFailed {
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        stringBuffer.append(BROWSER_URL).append(" FROM APPLIANCES WHERE (ID=").append(Integer.toString(n)).append(");");
        int n2 = DatabaseSession.executeQuery(stringBuffer.toString());
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            return null;
        }
        dBaseRequestQueryResults.nextRow();
        String string = dBaseRequestQueryResults.getString(BROWSER_URL);
        return string;
    }

    public static void setBrowserUrl(int n, String string) throws ExceptionRequestFailed {
        StringBuffer stringBuffer = new StringBuffer("UPDATE ");
        stringBuffer.append(APPLIANCES).append(" SET ").append(BROWSER_URL).append("=").append(SqlCmd.quote((String)string)).append(" WHERE (ID=").append(Integer.toString(n)).append(");");
        int n2 = DatabaseSession.executeUpdate(stringBuffer.toString());
        if (n2 != 1) {
            throw new ExceptionRequestFailed("Unable to save browser URL value to APPLIANCES table.");
        }
    }

    public static ApplianceInfo[] getAllAppliances() throws ExceptionRequestFailed, ExceptionNoValue {
        return AppliancesDb.getAllAppliances(null);
    }

    public static ApplianceInfo[] getAllAppliances(String string) throws ExceptionRequestFailed, ExceptionNoValue {
        Object[] objectArray;
        int n;
        Vector<ApplianceInfo> vector = new Vector<ApplianceInfo>();
        String string2 = string == null || string.length() == 0 ? "SELECT * FROM APPLIANCES;" : "SELECT * FROM APPLIANCES " + string + ";";
        int n2 = DatabaseSession.executeQuery(string2);
        while ((n = (objectArray = DatabaseSession.getQueryResults(n2, 3)).getRowCount()) != 0) {
            for (int i = 1; i <= n; ++i) {
                objectArray.nextRow();
                int n3 = objectArray.getInt(ID);
                String string3 = objectArray.getString(NAME);
                String string4 = objectArray.getString(TYPE);
                int n4 = objectArray.getInt(PRODUCT_ID);
                String string5 = objectArray.getString(ICON);
                String string6 = objectArray.getString(ADDRESS);
                String string7 = objectArray.getString(SNMP_READ_COM);
                String string8 = objectArray.getString(SNMP_WRITE_COM);
                int n5 = objectArray.getInt(NMM);
                int n6 = objectArray.getInt(AMP);
                boolean bl = n6 == 1;
                int n7 = objectArray.getInt(CACHED_CRED);
                String string9 = objectArray.getString(CUSTOM_FIELD1, "");
                String string10 = objectArray.getString(CUSTOM_FIELD2, "");
                String string11 = objectArray.getString(CUSTOM_FIELD3, "");
                String string12 = objectArray.getString(DESCRIPTION, "");
                String string13 = objectArray.getString(CONTACT, "");
                String string14 = objectArray.getString(CONTACT_PHONE, "");
                String string15 = objectArray.getString(COMMENT, "");
                String string16 = objectArray.getString(BROWSER_URL, "");
                ApplianceInfo applianceInfo = new ApplianceInfo(n3, string3, string4, n4, string5, string6, string7, string8, n5, bl, string16);
                try {
                    applianceInfo.setCustomField(1, string9);
                    applianceInfo.setCustomField(2, string10);
                    applianceInfo.setCustomField(3, string11);
                }
                catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                    throw new ExceptionRequestFailed();
                }
                applianceInfo.setDescription(string12);
                applianceInfo.setContact(string13);
                applianceInfo.setContactPhone(string14);
                applianceInfo.setComment(string15);
                applianceInfo.setCredentialsCacheMode(n7);
                vector.add(applianceInfo);
            }
            if (objectArray.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n2);
        if (vector.size() == 0) {
            Trace.logInfo((String)"AppliancesDb:getAllAppliances", (String)"NOTE : No values were available");
            throw new ExceptionNoValue();
        }
        objectArray = new ApplianceInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static ApplianceInfo[] getManagedAppliances() throws ExceptionRequestFailed, ExceptionNoValue {
        return AppliancesDb.getManagedAppliances(null);
    }

    public static ApplianceInfo[] getManagedAppliances(String string) throws ExceptionRequestFailed, ExceptionNoValue {
        Object[] objectArray;
        int n;
        Vector<ApplianceInfo> vector = new Vector<ApplianceInfo>();
        String string2 = string == null || string.length() == 0 ? "SELECT * FROM APPLIANCES WHERE AMP=1;" : "SELECT * FROM APPLIANCES " + string + " AND AMP=1;";
        int n2 = DatabaseSession.executeQuery(string2);
        while ((n = (objectArray = DatabaseSession.getQueryResults(n2, 3)).getRowCount()) != 0) {
            for (int i = 1; i <= n; ++i) {
                objectArray.nextRow();
                int n3 = objectArray.getInt(ID);
                String string3 = objectArray.getString(NAME);
                String string4 = objectArray.getString(TYPE);
                int n4 = objectArray.getInt(PRODUCT_ID);
                String string5 = objectArray.getString(ICON);
                String string6 = objectArray.getString(ADDRESS);
                String string7 = objectArray.getString(SNMP_READ_COM);
                String string8 = objectArray.getString(SNMP_WRITE_COM);
                int n5 = objectArray.getInt(NMM);
                int n6 = objectArray.getInt(AMP);
                boolean bl = n6 == 1;
                int n7 = objectArray.getInt(CACHED_CRED);
                String string9 = objectArray.getString(CUSTOM_FIELD1, "");
                String string10 = objectArray.getString(CUSTOM_FIELD2, "");
                String string11 = objectArray.getString(CUSTOM_FIELD3, "");
                String string12 = objectArray.getString(DESCRIPTION, "");
                String string13 = objectArray.getString(CONTACT, "");
                String string14 = objectArray.getString(CONTACT_PHONE, "");
                String string15 = objectArray.getString(COMMENT, "");
                String string16 = objectArray.getString(BROWSER_URL, "");
                ApplianceInfo applianceInfo = new ApplianceInfo(n3, string3, string4, n4, string5, string6, string7, string8, n5, bl, string16);
                try {
                    applianceInfo.setCustomField(1, string9);
                    applianceInfo.setCustomField(2, string10);
                    applianceInfo.setCustomField(3, string11);
                }
                catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                    throw new ExceptionRequestFailed();
                }
                applianceInfo.setDescription(string12);
                applianceInfo.setContact(string13);
                applianceInfo.setContactPhone(string14);
                applianceInfo.setComment(string15);
                applianceInfo.setCredentialsCacheMode(n7);
                vector.add(applianceInfo);
            }
            if (objectArray.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n2);
        if (vector.size() == 0) {
            Trace.logInfo((String)"AppliancesDb:getManagedAppliances", (String)"NOTE : No values were available");
            throw new ExceptionNoValue();
        }
        objectArray = new ApplianceInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean createAppliancesTable() {
        try {
            Trace.logInfo((String)"AppliancesDb", (String)"Creating APPLIANCES table");
            DatabaseUtilities.createTable((TableDefinition)m_tdTableDefinition, (Connection)AVWorksService.getConnection());
            return true;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"AppliancesDb", (String)"Failed to create APPLIANCES table");
            return false;
        }
    }

    public static void setCacheMode(int n, int n2) throws ExceptionRequestFailed {
        StringBuffer stringBuffer = new StringBuffer("UPDATE APPLIANCES SET ");
        stringBuffer.append(CACHED_CRED).append("=").append(Integer.toString(n2));
        if (n != -1) {
            stringBuffer.append(" WHERE (ID=").append(Integer.toString(n)).append(");");
        }
        Trace.logInfo((String)"AppliancesDb:setCacheMode", (String)("query: " + stringBuffer.toString()));
        int n3 = DatabaseSession.executeQuery(stringBuffer.toString());
        if (n3 < 1) {
            Trace.logError((String)"AppliancesDb:setCacheMode", (String)"Failed to set cache mode for all appliances!");
            throw new ExceptionRequestFailed();
        }
    }

    static {
        m_tdTableDefinition.addColumn(ID, "INTEGER", null, true);
        m_tdTableDefinition.addColumn(NAME, "VARCHAR", null);
        m_tdTableDefinition.addColumn(TYPE, "VARCHAR", null);
        m_tdTableDefinition.addColumn(PRODUCT_ID, "INTEGER", null);
        m_tdTableDefinition.addColumn(ICON, "VARCHAR", null);
        m_tdTableDefinition.addColumn(CUSTOM_FIELD1, "VARCHAR", null);
        m_tdTableDefinition.addColumn(CUSTOM_FIELD2, "VARCHAR", null);
        m_tdTableDefinition.addColumn(CUSTOM_FIELD3, "VARCHAR", null);
        m_tdTableDefinition.addColumn(ADDRESS, "VARCHAR", null);
        m_tdTableDefinition.addColumn(NMM, "INTEGER", null);
        m_tdTableDefinition.addColumn(AMP, "INTEGER", null);
        m_tdTableDefinition.addColumn(SNMP_READ_COM, "VARCHAR", null);
        m_tdTableDefinition.addColumn(SNMP_WRITE_COM, "VARCHAR", null);
        m_tdTableDefinition.addColumn(DESCRIPTION, "VARCHAR", null);
        m_tdTableDefinition.addColumn(CONTACT, "VARCHAR", null);
        m_tdTableDefinition.addColumn(CONTACT_PHONE, "VARCHAR", null);
        m_tdTableDefinition.addColumn(COMMENT, "VARCHAR", null);
        m_tdTableDefinition.addColumn(BROWSER_URL, "VARCHAR", null);
        m_tdTableDefinition.addColumn(CACHED_CRED, "INTEGER", (Object)new Integer(1));
    }
}

