/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.avworks.services.OptionsDb;
import com.avocent.avworks.services.ServersDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionFileNotFound;
import com.avocent.lib.exceptions.ExceptionFileNotReadable;
import com.avocent.lib.exceptions.ExceptionNotAFile;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.LaunchBrowser;
import com.avocent.lib.gui.LaunchBrowserHelp;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JFrame;

public class BrowserHelper {
    public static final String CNAME = "BrowserHelper";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.services.Res");
    private static final String TRACE_CONTEXT = "BrowserHelper";
    protected Frame m_fParent = null;
    protected String m_szUrl;

    public BrowserHelper(Frame frame, String string) {
        this.m_fParent = frame;
        this.m_szUrl = string;
    }

    public BrowserHelper(Frame frame, int n, String string) throws ExceptionConstructorFailed {
        Object var4_4 = null;
        try {
            if ("Device".equals(string)) {
                this.m_szUrl = ServersDb.getBrowserUrl(n);
            } else if ("Appliance".equals(string)) {
                this.m_szUrl = AppliancesDb.getBrowserUrl(n);
            } else {
                Trace.logError((String)"BrowserHelper", (String)("Unexpected unit type: " + string));
            }
        }
        catch (Exception exception) {
            throw new ExceptionConstructorFailed("Unable to get browser URL.", (Throwable)exception);
        }
        if (this.m_szUrl == null) {
            throw new ExceptionConstructorFailed("Database does not have a browser url for the specified unit id/unit type: " + n + "/" + string);
        }
        this.m_fParent = frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int launchBrowser() {
        String string = null;
        try {
            this.m_fParent.setCursor(Cursor.getPredefinedCursor(3));
            boolean bl = OptionsDb.getBooleanValue("BROWSER_USE_DEFAULT", true);
            if (bl) {
                Trace.logInfo((String)"BrowserHelper", (String)("About to launch default browser to " + this.m_szUrl));
                this.m_fParent.setCursor(Cursor.getPredefinedCursor(0));
                LaunchBrowser.launchDefaultBrowser((String)this.m_szUrl, (String)res.getString("BrowserHelper_NoDefaultBrowserMsg"));
                Trace.logInfo((String)"BrowserHelper", (String)"--- launched default browser ");
            } else {
                string = OptionsDb.getStringValue("BROWSER_APPLICATION", null);
                Trace.logInfo((String)"BrowserHelper", (String)("About to launch specified browser to " + this.m_szUrl));
                this.m_fParent.setCursor(Cursor.getPredefinedCursor(0));
                LaunchBrowser.launchBrowser((String)this.m_szUrl, (String)string);
                Trace.logInfo((String)"BrowserHelper", (String)"--- launched specified browser to ");
            }
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"BrowserHelper", (String)"ERROR : Unable to launch Browser", (Throwable)exceptionRequestFailed);
            if (string == null) {
                Message.invokeLater((Component)this.m_fParent, (String)res.getString("BrowserHelper_Unable_to_launch_browser"));
            } else {
                this.showUnableToLaunch("BrowserHelper_UnableToPerform_ErrorEncountered", new File(string));
            }
        }
        catch (ExceptionFileNotFound exceptionFileNotFound) {
            Trace.logError((String)"BrowserHelper", (String)"ERROR : Command not found", (Throwable)exceptionFileNotFound);
            this.showUnableToLaunch("BrowserHelper_UnableToPerform_FileNotFound", exceptionFileNotFound.getFile());
        }
        catch (ExceptionNotAFile exceptionNotAFile) {
            Trace.logError((String)"BrowserHelper", (String)"ERROR : Command not a file", (Throwable)exceptionNotAFile);
            this.showUnableToLaunch("BrowserHelper_UnableToPerform_NotAFile", exceptionNotAFile.getFile());
        }
        catch (ExceptionFileNotReadable exceptionFileNotReadable) {
            Trace.logError((String)"BrowserHelper", (String)"ERROR : Command file not readable", (Throwable)exceptionFileNotReadable);
            this.showUnableToLaunch("BrowserHelper_UnableToPerform_FileNotReadable", exceptionFileNotReadable.getFile());
        }
        finally {
            this.m_fParent.setCursor(Cursor.getPredefinedCursor(0));
        }
        return 0;
    }

    private void showUnableToLaunch(String string, File file) {
        Trace.logInfo((String)"BrowserHelper", (String)"Problem launching Browser via Browser Helper");
        if (string == null || file == null) {
            Message.invokeLater((Component)this.m_fParent, (String)res.getString("BrowserHelper_Unable_to_launch_browser"));
            return;
        }
        String string2 = res.getString(string);
        Object[] objectArray = new Object[]{res.getString("BrowserHelper_BrowseAction"), file.getPath()};
        string2 = MessageFormat.format(string2, objectArray);
        Message.invokeLater((Component)this.m_fParent, (String)string2);
    }

    public static void showHelpPage(JFrame jFrame, String string) {
        String string2 = LaunchBrowserHelp.pageToURLStr((String)string);
        Trace.logInfo((String)"BrowserHelper", (String)("showHelpPage(frame," + string + ") -- URL is " + string2));
        if (string2 != null) {
            BrowserHelper browserHelper = new BrowserHelper(jFrame, string2);
            browserHelper.launchBrowser();
        }
    }

    public static void setBrowserSystemProperty() {
        try {
            String string = "";
            boolean bl = OptionsDb.getBooleanValue("BROWSER_USE_DEFAULT", true);
            if (!bl) {
                string = OptionsDb.getStringValue("BROWSER_APPLICATION", "");
            }
            System.setProperty("avct.browser.path", string);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"BrowserHelper", (String)"Unable to set system property \"avct.browser.path\"", (Throwable)exceptionRequestFailed);
        }
    }

    public static void main(String[] stringArray) {
        try {
            AVWorksService.start();
            Trace.startLogging(null);
            DatabaseSession.verifyDatabaseStructure();
            OptionsDb.setValue("BROWSER_USE_DEFAULT", true);
            AppliancesDb.setBrowserUrl(1, "http://172.26.4.176");
            AppliancesDb.setBrowserUrl(2, "http://172.26.4.176");
            BrowserHelper browserHelper = new BrowserHelper(null, 1, "Appliance");
            browserHelper.launchBrowser();
            String string = "C:\\Program Files\\Netscape\\Netscape\\netscp";
            OptionsDb.setValue("BROWSER_APPLICATION", string);
            OptionsDb.setValue("BROWSER_USE_DEFAULT", false);
            BrowserHelper browserHelper2 = new BrowserHelper(null, 2, "Appliance");
            browserHelper2.launchBrowser();
            System.out.println(" Finished launching web browsers.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

