/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.ApplianceInterface;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.InterfaceInfo;
import com.avocent.avworks.services.InterfacesDb;
import com.avocent.avworks.services.ServerInfo;
import com.avocent.avworks.services.ServersDb;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.text.CollationKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class ConnectionPath {
    public static final String CONN_PATH_SEP = "\u27a1";

    public static String[] getConnectionPaths(int n, int n2) throws ExceptionNoValue {
        try {
            Vector<String> vector = new Vector<String>();
            ServerInfo serverInfo = ServersDb.getServerInfo(n);
            String string = "WHERE (CONN_ID=" + Integer.toString(n) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(1) + ")";
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList(string);
            for (int i = 0; i < interfaceInfoArray.length; ++i) {
                InterfaceInfo interfaceInfo = interfaceInfoArray[i];
                int n3 = interfaceInfo.getApplianceID();
                ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo(n3);
                if (applianceInfo.getNmmID() != n2) continue;
                Vector vector2 = ConnectionPath.getUpstreamConnectionPaths(n3);
                if (vector2.size() > 0) {
                    for (int j = 0; j < vector2.size(); ++j) {
                        String string2 = (String)vector2.elementAt(j);
                        String string3 = ConnectionPath.parseSwitchName(applianceInfo.getName());
                        String string4 = string2 + string3 + CONN_PATH_SEP + interfaceInfo.getName() + CONN_PATH_SEP + serverInfo.getName();
                        vector.add(string4);
                    }
                    continue;
                }
                String string5 = null;
                string5 = applianceInfo.getNmmID() != 2 ? applianceInfo.getName() + "(" + applianceInfo.getAddress() + ")" + CONN_PATH_SEP + ConnectionPath.getPortNumForConnPath(interfaceInfo) + interfaceInfo.getName() + CONN_PATH_SEP + serverInfo.getName() : applianceInfo.getName() + "(" + applianceInfo.getAddress() + ")" + CONN_PATH_SEP + interfaceInfo.getName() + CONN_PATH_SEP + serverInfo.getName();
                vector.add(string5);
            }
            if (vector.size() == 0) {
                throw new ExceptionNoValue();
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            Trace.logError((String)"ConnectionPath:getConnectionPaths", (String)"Unable to get connection paths.");
            throw new ExceptionNoValue();
        }
    }

    public static String[] getConnectionPaths(int n) throws ExceptionRequestFailed {
        try {
            ServerInfo serverInfo = ServersDb.getServerInfo(n);
            Set set = ConnectionPath.getUpstreamAppliances(serverInfo);
            ArrayList arrayList = new ArrayList(set);
            if (arrayList.size() > 1) {
                Collections.sort(arrayList, new Comparator(){

                    public int compare(Object object, Object object2) {
                        ApplianceInfo applianceInfo = (ApplianceInfo)object;
                        ApplianceInfo applianceInfo2 = (ApplianceInfo)object2;
                        CollationKey collationKey = applianceInfo.getNameKey();
                        CollationKey collationKey2 = applianceInfo2.getNameKey();
                        if (collationKey != null && collationKey2 != null) {
                            return applianceInfo.getNameKey().compareTo(applianceInfo2.getNameKey());
                        }
                        return applianceInfo.getName().compareTo(applianceInfo2.getName());
                    }
                });
            }
            ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ApplianceInfo applianceInfo = (ApplianceInfo)iterator.next();
                arrayList2.add(applianceInfo.getName());
            }
            return arrayList2.toArray(new String[arrayList2.size()]);
        }
        catch (ExceptionNoValue exceptionNoValue) {
            return new String[0];
        }
    }

    private static Set getUpstreamAppliances(UnitInfo unitInfo) throws ExceptionRequestFailed {
        HashSet<ApplianceInfo> hashSet = new HashSet<ApplianceInfo>();
        try {
            int n = unitInfo.isAppliance() ? 2 : 1;
            String string = "WHERE (CONN_ID=" + Integer.toString(unitInfo.getID()) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(n) + ")";
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList(string);
            for (int i = 0; i < interfaceInfoArray.length; ++i) {
                int n2 = interfaceInfoArray[i].getApplianceID();
                ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo(n2);
                Set set = ConnectionPath.getUpstreamAppliances(applianceInfo);
                if (set.size() > 0) {
                    hashSet.addAll(set);
                    continue;
                }
                hashSet.add(applianceInfo);
            }
        }
        catch (ExceptionNoValue exceptionNoValue) {
            // empty catch block
        }
        return hashSet;
    }

    protected static Vector getUpstreamConnectionPaths(int n) throws ExceptionRequestFailed {
        Vector<String> vector = new Vector<String>();
        try {
            String string = "WHERE (CONN_ID=" + Integer.toString(n) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(2) + ")";
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList(string);
            for (int i = 0; i < interfaceInfoArray.length; ++i) {
                InterfaceInfo interfaceInfo = interfaceInfoArray[i];
                int n2 = interfaceInfo.getApplianceID();
                ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo(n2);
                Vector vector2 = ConnectionPath.getUpstreamConnectionPaths(n2);
                if (vector2.size() > 0) {
                    for (int j = 0; j < vector2.size(); ++j) {
                        String string2 = (String)vector2.elementAt(j);
                        String string3 = ConnectionPath.parseSwitchName(applianceInfo.getName());
                        String string4 = string2 + string3 + CONN_PATH_SEP;
                        if (ConnectionPath.doesPathExist(vector, string4)) continue;
                        vector.add(string4);
                    }
                    continue;
                }
                String string5 = applianceInfo.getName() + "(" + applianceInfo.getAddress() + ")" + CONN_PATH_SEP + ConnectionPath.getPortNumForConnPath(interfaceInfo) + interfaceInfo.getName() + CONN_PATH_SEP;
                if (ConnectionPath.doesPathExist(vector, string5)) continue;
                vector.add(string5);
            }
            return vector;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            return vector;
        }
    }

    public static String[] getConnectionPaths(int n, boolean bl, int n2) throws ExceptionNoValue {
        try {
            Vector<String> vector = new Vector<String>();
            ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo(n);
            if (applianceInfo.getNmmID() != n2) {
                Trace.logError((String)"ConnectionPath:getConnectionPaths", (String)"Appliance not supported by NMM.");
                throw new ExceptionNoValue();
            }
            String string = "WHERE APPLIANCE_ID=" + Integer.toString(n);
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList(string);
            for (int i = 0; i < interfaceInfoArray.length; ++i) {
                int n3;
                Vector vector2;
                String string2;
                InterfaceInfo interfaceInfo = interfaceInfoArray[i];
                if (interfaceInfo.getConnType() == 0) {
                    string2 = null;
                    string2 = applianceInfo.getNmmID() != 2 ? applianceInfo.getName() + "(" + applianceInfo.getAddress() + ")" + CONN_PATH_SEP + ConnectionPath.getPortNumForConnPath(interfaceInfo) + interfaceInfo.getName() : applianceInfo.getName() + "(" + applianceInfo.getAddress() + ")" + CONN_PATH_SEP + interfaceInfo.getName();
                    vector.add(string2);
                    continue;
                }
                if (interfaceInfo.getConnType() == 1 && bl) {
                    ServerInfo serverInfo = ServersDb.getServerInfo(interfaceInfo.getConnID());
                    string2 = applianceInfo.getNmmID() != 2 ? applianceInfo.getName() + "(" + applianceInfo.getAddress() + ")" + CONN_PATH_SEP + ConnectionPath.getPortNumForConnPath(interfaceInfo) + interfaceInfo.getName() + CONN_PATH_SEP + serverInfo.getName() : applianceInfo.getName() + "(" + applianceInfo.getAddress() + ")" + CONN_PATH_SEP + interfaceInfo.getName() + CONN_PATH_SEP + serverInfo.getName();
                    vector.add(string2);
                    continue;
                }
                if (interfaceInfo.getConnType() != 2 || (vector2 = ConnectionPath.getDownstreamConnectionPaths(n3 = interfaceInfo.getConnID(), bl)).size() <= 0) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    string2 = (String)vector2.elementAt(j);
                    String string3 = applianceInfo.getName() + "(" + applianceInfo.getAddress() + ")" + CONN_PATH_SEP + ConnectionPath.getPortNumForConnPath(interfaceInfo) + string2;
                    if (ConnectionPath.doesPathExist(vector, string3)) continue;
                    vector.add(string3);
                }
            }
            if (vector.size() == 0) {
                throw new ExceptionNoValue();
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            Trace.logError((String)"ConnectionPath:getConnectionPaths", (String)"Unable to get connection paths.");
            throw new ExceptionNoValue();
        }
    }

    protected static Vector getDownstreamConnectionPaths(int n, boolean bl) throws ExceptionRequestFailed {
        Vector<String> vector = new Vector<String>();
        ApplianceInfo applianceInfo = null;
        try {
            applianceInfo = AppliancesDb.getApplianceInfo(n);
            String string = "WHERE APPLIANCE_ID=" + Integer.toString(n);
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList(string);
            for (int i = 0; i < interfaceInfoArray.length; ++i) {
                int n2;
                Object object;
                String string2;
                InterfaceInfo interfaceInfo = interfaceInfoArray[i];
                if (interfaceInfo.getConnType() == 0) {
                    String string3 = ConnectionPath.parseSwitchName(applianceInfo.getName());
                    string2 = string3 + CONN_PATH_SEP + interfaceInfo.getName();
                    vector.add(string2);
                    continue;
                }
                if (interfaceInfo.getConnType() == 1 && bl) {
                    ServerInfo serverInfo = ServersDb.getServerInfo(interfaceInfo.getConnID());
                    object = ConnectionPath.parseSwitchName(applianceInfo.getName());
                    string2 = (String)object + CONN_PATH_SEP + interfaceInfo.getName() + CONN_PATH_SEP + serverInfo.getName();
                    vector.add(string2);
                    continue;
                }
                if (interfaceInfo.getConnType() != 2 || ((Vector)(object = ConnectionPath.getDownstreamConnectionPaths(n2 = interfaceInfo.getConnID(), bl))).size() <= 0) continue;
                for (int j = 0; j < ((Vector)object).size(); ++j) {
                    string2 = (String)((Vector)object).elementAt(j);
                    String string4 = ConnectionPath.parseSwitchName(applianceInfo.getName());
                    String string5 = string4 + CONN_PATH_SEP + string2;
                    if (ConnectionPath.doesPathExist(vector, string5)) continue;
                    vector.add(string5);
                }
            }
            return vector;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logError((String)"ConnectionPath:getDownstreamConnectionPaths", (String)"Unable to get connection paths.");
            return vector;
        }
    }

    public static void setConnectionPath(String string, int n) throws ExceptionRequestFailed {
        ApplianceInterface applianceInterface = ConnectionPath.getApplianceInterface(string);
        try {
            String string2 = "WHERE NAME=" + SqlCmd.quote((String)applianceInterface.getApplianceName());
            ApplianceInfo[] applianceInfoArray = AppliancesDb.getAllAppliances(string2);
            if (applianceInfoArray.length != 1) {
                throw new ExceptionRequestFailed();
            }
            int n2 = applianceInfoArray[0].getID();
            String string3 = "WHERE (APPLIANCE_ID=" + Integer.toString(n2) + ")" + " AND" + " (NAME=" + SqlCmd.quote((String)applianceInterface.getInterfaceName()) + ")";
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList(string3);
            if (interfaceInfoArray.length != 1) {
                throw new ExceptionRequestFailed();
            }
            ServerInfo serverInfo = ServersDb.getServerInfo(n);
            interfaceInfoArray[0].setConnType(1);
            interfaceInfoArray[0].setConnID(n);
            InterfacesDb.modify(interfaceInfoArray[0]);
        }
        catch (Exception exception) {
            Trace.logError((String)"ConnectionPath:setConnectionPath", (String)"Unable to set connection path");
            throw new ExceptionRequestFailed();
        }
    }

    public static void removeConnectionPath(String string, int n) throws ExceptionRequestFailed {
        ApplianceInterface applianceInterface = ConnectionPath.getApplianceInterface(string);
        try {
            String string2 = "WHERE NAME=" + SqlCmd.quote((String)applianceInterface.getApplianceName());
            ApplianceInfo[] applianceInfoArray = AppliancesDb.getAllAppliances(string2);
            int n2 = applianceInfoArray[0].getID();
            String string3 = "WHERE (APPLIANCE_ID=" + Integer.toString(n2) + ")" + " AND" + " (NAME=" + SqlCmd.quote((String)applianceInterface.getInterfaceName()) + ")" + " AND" + " (CONN_ID=" + Integer.toString(n) + ")";
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList(string3);
            interfaceInfoArray[0].setConnType(0);
            interfaceInfoArray[0].setConnID(0);
            InterfacesDb.modify(interfaceInfoArray[0]);
        }
        catch (Exception exception) {
            Trace.logError((String)"ConnectionPath:removeConnectionPath", (String)"Unable to remove connection path");
            throw new ExceptionRequestFailed();
        }
    }

    protected static boolean doesPathExist(Vector vector, String string) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static ApplianceInterface getApplianceInterface(String string) throws ExceptionRequestFailed {
        String string2 = "";
        String string3 = "";
        try {
            Object object;
            int n = string.lastIndexOf(CONN_PATH_SEP);
            if (n == -1) {
                Trace.logError((String)"ConnectionPath:getApplianceInterface", (String)"Error parsing path.");
                throw new ExceptionRequestFailed();
            }
            string2 = string.substring(0, n).trim();
            string3 = string.substring(n + 1).trim();
            if (string2.length() == 0 || string3.length() == 0) {
                Trace.logError((String)"ConnectionPath:getApplianceInterface", (String)"Empty Names.");
                throw new ExceptionRequestFailed();
            }
            n = string2.lastIndexOf(CONN_PATH_SEP);
            if (n != -1) {
                object = string2.substring(0, n).trim();
                string2 = string2.substring(n + 1).trim();
                n = ((String)object).lastIndexOf(CONN_PATH_SEP);
                if (n != -1) {
                    object = ((String)object).substring(n + 1).trim();
                }
                int n2 = ((String)object).indexOf("(");
                String string4 = ((String)object).substring(0, n2);
                String string5 = "WHERE NAME=" + SqlCmd.quote((String)string4);
                ApplianceInfo[] applianceInfoArray = AppliancesDb.getAllAppliances(string5);
                if (applianceInfoArray.length != 1) {
                    throw new ExceptionRequestFailed();
                }
                int n3 = applianceInfoArray[0].getID();
                string2 = n3 + ":" + string2;
            }
            object = new ApplianceInterface(string2, string3);
            return object;
        }
        catch (Exception exception) {
            Trace.logError((String)"ConnectionPath:getApplianceInterface", (String)"Error parsing path.");
            throw new ExceptionRequestFailed();
        }
    }

    protected static String getPortNumForConnPath(InterfaceInfo interfaceInfo) {
        String string = "";
        int n = interfaceInfo.getPortNum();
        if (n > 0) {
            string = "P" + n + CONN_PATH_SEP;
        }
        return string;
    }

    public static String parseSwitchName(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(n + 1).trim();
        return string2;
    }

    public static int parseSwitchNameForParentID(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return 0;
        }
        String string2 = string.substring(0, n).trim();
        return Integer.parseInt(string2);
    }
}

