/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.lib.database.DBaseRequestQueryResults;
import com.avocent.lib.database.DatabaseUtilities;
import com.avocent.lib.database.DefaultTableDefinition;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.database.TableDefinition;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.util.ResourceManager;
import java.sql.Connection;

public class CustomFieldLabelsDb {
    public static final String CNAME = "CustomFieldLabelsDb";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.services.Res");
    protected static DefaultTableDefinition m_tdTableDefinition = new DefaultTableDefinition("CUSTOM_FIELD_LABELS");
    public static final String CUSTOM_FIELD_LABELS = "CUSTOM_FIELD_LABELS";
    public static final String ID = "ID";
    public static final String SINGULAR = "SINGULAR";
    public static final String PLURAL = "PLURAL";
    public static final int CUSTOM_FIELD_LABEL_1 = 1;
    public static final int CUSTOM_FIELD_LABEL_2 = 2;
    public static final int CUSTOM_FIELD_LABEL_3 = 3;

    public static TableDefinition getTableDefinition() {
        return m_tdTableDefinition;
    }

    public static void add(int n, String string, String string2) throws ExceptionRequestFailed {
        if (string == null || string2 == null) {
            Trace.logError((String)"CustomFieldLabelsDb.add", (String)"Invalid string argument");
            throw new ExceptionRequestFailed();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO CUSTOM_FIELD_LABELS ");
        stringBuffer.append("( ");
        stringBuffer.append("ID, ");
        stringBuffer.append("SINGULAR, ");
        stringBuffer.append("PLURAL ");
        stringBuffer.append(") ");
        stringBuffer.append("VALUES");
        stringBuffer.append("( ");
        stringBuffer.append(Integer.toString(n) + ", ");
        stringBuffer.append(SqlCmd.quote((String)string) + ", ");
        stringBuffer.append(SqlCmd.quote((String)string2) + " ");
        stringBuffer.append(");");
        int n2 = DatabaseSession.executeUpdate(stringBuffer.toString());
        if (n2 != 1) {
            Trace.logError((String)"CustomFieldLabelsDb.add", (String)"Failed to add");
            throw new ExceptionRequestFailed();
        }
    }

    public static boolean isLabelDefined(int n) throws ExceptionRequestFailed {
        String string = "SELECT SINGULAR FROM CUSTOM_FIELD_LABELS WHERE (ID=" + Integer.toString(n) + ");";
        int n2 = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        return dBaseRequestQueryResults.getRowCount() > 0;
    }

    public static void setSingular(int n, String string) throws ExceptionRequestFailed {
        if (string == null) {
            Trace.logError((String)"CustomFieldLabelsDb.setSingular", (String)"Invalid string argument");
            throw new ExceptionRequestFailed();
        }
        if (!CustomFieldLabelsDb.isLabelDefined(n)) {
            Trace.logInfo((String)"CustomFieldLabelsDb.setSingular", (String)"Label does not exist - Calling add");
            CustomFieldLabelsDb.add(n, "", "");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE CUSTOM_FIELD_LABELS SET ");
        stringBuffer.append("SINGULAR=" + SqlCmd.quote((String)string) + " ");
        stringBuffer.append(" WHERE (ID=" + Integer.toString(n) + ");");
        int n2 = DatabaseSession.executeUpdate(stringBuffer.toString());
        if (n2 >= 1) {
            return;
        }
    }

    public static String getSingular(int n) throws ExceptionRequestFailed {
        String string = "SELECT * FROM CUSTOM_FIELD_LABELS WHERE (ID=" + Integer.toString(n) + ");";
        int n2 = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logInfo((String)"CustomFieldLabelsDb.getSingular", (String)("NOTE : No value was available for ID=" + n + " returning the default"));
            switch (n) {
                case 1: {
                    return res.getString("CustomFieldLabelsDb_Site");
                }
                case 2: {
                    return res.getString("CustomFieldLabelsDb_Department");
                }
                case 3: {
                    return res.getString("CustomFieldLabelsDb_Location");
                }
            }
            Trace.logInfo((String)"CustomFieldLabelDb.getSingular", (String)("NOTE: A default is not defined for ID=" + n));
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        String string2 = dBaseRequestQueryResults.getString(SINGULAR);
        return string2;
    }

    public static void setPlural(int n, String string) throws ExceptionRequestFailed {
        if (string == null) {
            Trace.logError((String)"CustomFieldLabelsDb.setPlural", (String)"Invalid string argument");
            throw new ExceptionRequestFailed();
        }
        if (!CustomFieldLabelsDb.isLabelDefined(n)) {
            Trace.logInfo((String)"CustomFieldLabelsDb.setPlural", (String)"Label does not exist - Calling add");
            CustomFieldLabelsDb.add(n, "", "");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE CUSTOM_FIELD_LABELS SET ");
        stringBuffer.append("PLURAL=" + SqlCmd.quote((String)string) + " ");
        stringBuffer.append(" WHERE (ID=" + Integer.toString(n) + ");");
        int n2 = DatabaseSession.executeUpdate(stringBuffer.toString());
        if (n2 >= 1) {
            return;
        }
    }

    public static String getPlural(int n) throws ExceptionRequestFailed {
        String string = "SELECT * FROM CUSTOM_FIELD_LABELS WHERE (ID=" + Integer.toString(n) + ");";
        int n2 = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logInfo((String)"CustomFieldLabelsDb.getPlural", (String)("NOTE : No value was available for ID=" + n + " returning the default"));
            switch (n) {
                case 1: {
                    return res.getString("CustomFieldLabelsDb_Sites");
                }
                case 2: {
                    return res.getString("CustomFieldLabelsDb_Departments");
                }
                case 3: {
                    return res.getString("CustomFieldLabelsDb_Locations");
                }
            }
            Trace.logInfo((String)"CustomFieldLabelDb.getPlural", (String)("NOTE: A default is not defined for ID=" + n));
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        String string2 = dBaseRequestQueryResults.getString(PLURAL);
        return string2;
    }

    public static boolean createCustomFieldLabelsTable() {
        Trace.logInfo((String)CNAME, (String)"Creating CUSTOM_FIELD_LABELS table");
        try {
            DatabaseUtilities.createTable((TableDefinition)m_tdTableDefinition, (Connection)AVWorksService.getConnection());
            return true;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)CNAME, (String)"Failed to create CUSTOM_FIELD_LABELS table");
            return false;
        }
    }

    static {
        m_tdTableDefinition.addColumn(ID, "INTEGER", null, true);
        m_tdTableDefinition.addColumn(SINGULAR, "VARCHAR", null);
        m_tdTableDefinition.addColumn(PLURAL, "VARCHAR", null);
    }
}

