/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.lib.database.DBaseRequestQueryResults;
import com.avocent.lib.database.DatabaseUtilities;
import com.avocent.lib.database.DefaultTableDefinition;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.database.TableDefinition;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionAlreadyExists;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.sql.Connection;

public class CustomFoldersDb {
    protected static DefaultTableDefinition m_tdCustomFolders = new DefaultTableDefinition("CUSTOM_FOLDERS");
    protected static DefaultTableDefinition m_tdApplianceCustomFolders;
    protected static DefaultTableDefinition m_tdServerCustomFolders;
    public static final String CUSTOM_FOLDERS = "CUSTOM_FOLDERS";
    public static final String APPLIANCE_CUSTOM_FOLDER_MAP = "APPLIANCE_CUSTOM_FOLDER_MAP";
    public static final String SERVER_CUSTOM_FOLDER_MAP = "SERVER_CUSTOM_FOLDER_MAP";
    public static final String ID = "ID";
    public static final String FOLDER_ID = "FOLDER_ID";
    public static final String NAME = "NAME";
    public static final String PARENT_ID = "PARENT_ID";
    public static final String APPLIANCE_ID = "APPLIANCE_ID";
    public static final String SERVER_ID = "SERVER_ID";

    public static int add(int n, String string) throws ExceptionRequestFailed {
        if (string == null) {
            Trace.logError((String)"CustomFoldersDb.add", (String)"Invalid string argument");
            throw new ExceptionRequestFailed();
        }
        Trace.logInfo((String)"CustomFoldersDb.add", (String)("ParentID=" + n));
        Trace.logInfo((String)"CustomFoldersDb.add", (String)("Name    =" + string));
        int n2 = 1;
        try {
            n2 = CustomFoldersDb.getMaxID() + 1;
            Trace.logInfo((String)"CustomFoldersDb:add", (String)("Maximum Folder ID is " + n2));
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"CustomFoldersDb:add", (String)"NOTE: Unable to obtain max ID");
        }
        for (int i = n2; i < n2 + 5; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO CUSTOM_FOLDERS ");
            stringBuffer.append("( ");
            stringBuffer.append("ID, ");
            stringBuffer.append("NAME, ");
            stringBuffer.append("PARENT_ID ");
            stringBuffer.append(") ");
            stringBuffer.append("VALUES");
            stringBuffer.append("( ");
            stringBuffer.append(Integer.toString(i) + ", ");
            stringBuffer.append(SqlCmd.quote((String)string) + ", ");
            stringBuffer.append(Integer.toString(n) + " ");
            stringBuffer.append(");");
            Trace.logInfo((String)"CustomFoldersDb:add", (String)("Execute SQL=" + stringBuffer.toString()));
            int n3 = DatabaseSession.executeUpdate(stringBuffer.toString());
            if (n3 != 1) continue;
            return i;
        }
        Trace.logError((String)"CustomFoldersDb:add", (String)"ERROR : Exceeded maximum IDs");
        throw new ExceptionRequestFailed();
    }

    public static int getCount() throws ExceptionRequestFailed {
        String string = "SELECT COUNT(ID) FROM CUSTOM_FOLDERS";
        int n = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logError((String)"CustomFoldersDb:getCount", (String)"ERROR:Unable to read maximum folder ID");
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        return n2;
    }

    public static int getMaxID() throws ExceptionRequestFailed {
        String string = "SELECT MAX(ID) FROM CUSTOM_FOLDERS";
        int n = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        return n2;
    }

    public static boolean delete(int n, boolean bl) {
        Trace.logInfo((String)"CustomFoldersDb:delete", (String)("Delete folder ID=" + n));
        try {
            int n2;
            String string;
            if (bl) {
                string = "DELETE FROM CUSTOM_FOLDERS WHERE PARENT_ID=" + n + ";";
                Trace.logInfo((String)"CustomFoldersDb:delete", (String)"Deleting Children");
                n2 = DatabaseSession.executeUpdate(string);
                Trace.logInfo((String)"CustomFoldersDb:delete", (String)(n2 + " children were deleted"));
            } else {
                Trace.logInfo((String)"CustomFoldersDb:delete", (String)"Removing parent for children");
                string = "UPDATE CUSTOM_FOLDERS SET PARENT_ID=0 WHERE PARENT_ID=" + n + ";";
                n2 = DatabaseSession.executeUpdate(string);
                Trace.logInfo((String)"CustomFoldersDb:delete", (String)(n2 + " children were updated"));
            }
            string = "DELETE FROM CUSTOM_FOLDERS WHERE ID=" + n + ";";
            n2 = DatabaseSession.executeUpdate(string);
            if (n2 > 0) {
                string = "DELETE FROM APPLIANCE_CUSTOM_FOLDER_MAP WHERE FOLDER_ID=" + n + ";";
                DatabaseSession.executeUpdate(string);
                string = "DELETE FROM SERVER_CUSTOM_FOLDER_MAP WHERE FOLDER_ID=" + n + ";";
                DatabaseSession.executeUpdate(string);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isApplianceMapDefined(int n, int n2) throws ExceptionRequestFailed {
        String string = "SELECT FOLDER_ID FROM APPLIANCE_CUSTOM_FOLDER_MAP WHERE (FOLDER_ID=" + n + ")" + " AND" + " (APPLIANCE_ID=" + n2 + ");";
        int n3 = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n3, 1);
        DatabaseSession.closeQuery(n3);
        return dBaseRequestQueryResults.getRowCount() > 0;
    }

    public static void mapAppliance(int n, int n2) throws ExceptionRequestFailed, ExceptionAlreadyExists {
        Trace.logInfo((String)"CustomFieldLabelsDb.mapAppliance", (String)("Map Appliance " + n2 + " to Folder " + n));
        if (!CustomFoldersDb.isApplianceMapDefined(n, n2)) {
            Trace.logInfo((String)"CustomFieldLabelsDb.mapAppliance", (String)"Appliance map does not exist - adding...");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO APPLIANCE_CUSTOM_FOLDER_MAP ");
            stringBuffer.append("( FOLDER_ID, APPLIANCE_ID ) VALUES (" + n + ", " + n2 + " );");
            int n3 = DatabaseSession.executeUpdate(stringBuffer.toString());
            if (n3 >= 1) {
                Trace.logInfo((String)"CustomFieldLabelsDb.mapAppliance", (String)"Appliance successfully mapped to Folder");
                return;
            }
            Trace.logError((String)"CustomFieldLabelsDb.mapAppliance", (String)"Error mapping appliance to folder");
            throw new ExceptionRequestFailed();
        }
        Trace.logError((String)"CustomFieldLabelsDb.mapAppliance", (String)"Appliance already mapped to folder");
        throw new ExceptionAlreadyExists();
    }

    public static void unmapAppliance(int n, int n2) throws ExceptionRequestFailed, ExceptionNoValue {
        Trace.logInfo((String)"CustomFieldLabelsDb.unmapAppliance", (String)("UnMap Appliance " + n2 + " from Folder " + n));
        if (CustomFoldersDb.isApplianceMapDefined(n, n2)) {
            Trace.logInfo((String)"CustomFieldLabelsDb.unmapAppliance", (String)"Appliance map exists - removing...");
            String string = "DELETE FROM APPLIANCE_CUSTOM_FOLDER_MAP  WHERE (FOLDER_ID=" + n + ")" + " AND" + " (APPLIANCE_ID=" + n2 + ");";
            int n3 = DatabaseSession.executeUpdate(string);
            if (n3 >= 1) {
                Trace.logInfo((String)"CustomFieldLabelsDb.unmapAppliance", (String)"Successfully removed appliance mapping to Folder");
                return;
            }
            Trace.logError((String)"CustomFieldLabelsDb.unmapAppliance", (String)"Error removing appliance to folder mapping");
            throw new ExceptionRequestFailed();
        }
        Trace.logError((String)"CustomFieldLabelsDb.unmapAppliance", (String)"Appliance is not mapped to folder given");
        throw new ExceptionNoValue();
    }

    public static boolean isServerMapDefined(int n, int n2) throws ExceptionRequestFailed {
        String string = "SELECT FOLDER_ID FROM SERVER_CUSTOM_FOLDER_MAP WHERE (FOLDER_ID=" + n + ")" + " AND" + " (SERVER_ID=" + n2 + ");";
        int n3 = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n3, 1);
        DatabaseSession.closeQuery(n3);
        return dBaseRequestQueryResults.getRowCount() > 0;
    }

    public static void mapServer(int n, int n2) throws ExceptionRequestFailed, ExceptionAlreadyExists {
        Trace.logInfo((String)"CustomFieldLabelsDb.mapServer", (String)("Map Server " + n2 + " to Folder " + n));
        if (!CustomFoldersDb.isServerMapDefined(n, n2)) {
            Trace.logInfo((String)"CustomFieldLabelsDb.mapServer", (String)"Server map does not exist - adding...");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO SERVER_CUSTOM_FOLDER_MAP ");
            stringBuffer.append("( FOLDER_ID, SERVER_ID ) VALUES (" + n + ", " + n2 + " );");
            int n3 = DatabaseSession.executeUpdate(stringBuffer.toString());
            if (n3 >= 1) {
                Trace.logInfo((String)"CustomFieldLabelsDb.mapServer", (String)"Server successfully mapped to Folder");
                return;
            }
            Trace.logError((String)"CustomFieldLabelsDb.mapServer", (String)"Error mapping server to folder");
            throw new ExceptionRequestFailed();
        }
        Trace.logError((String)"CustomFieldLabelsDb.mapServer", (String)"Server already mapped to folder");
        throw new ExceptionAlreadyExists();
    }

    public static void unmapServer(int n, int n2) throws ExceptionRequestFailed, ExceptionNoValue {
        Trace.logInfo((String)"CustomFieldLabelsDb.unmapServer", (String)("UnMap Server " + n2 + " from Folder " + n));
        if (CustomFoldersDb.isServerMapDefined(n, n2)) {
            Trace.logInfo((String)"CustomFieldLabelsDb.unmapServer", (String)"Server map exists - removing...");
            String string = "DELETE FROM SERVER_CUSTOM_FOLDER_MAP  WHERE (FOLDER_ID=" + n + ")" + " AND" + " (SERVER_ID=" + n2 + ");";
            int n3 = DatabaseSession.executeUpdate(string);
            if (n3 >= 1) {
                Trace.logInfo((String)"CustomFieldLabelsDb.unmapServer", (String)"Successfully removed server mapping to Folder");
                return;
            }
            Trace.logError((String)"CustomFieldLabelsDb.unmapServer", (String)"Error removing server to folder mapping");
            throw new ExceptionRequestFailed();
        }
        Trace.logError((String)"CustomFieldLabelsDb.unmapServer", (String)"Server is not mapped to folder given");
        throw new ExceptionNoValue();
    }

    public static boolean createFolderTables() {
        try {
            Trace.logError((String)"CustomFoldersDb", (String)"Creating CUSTOM_FOLDERS table");
            DatabaseUtilities.createTable((TableDefinition)m_tdCustomFolders, (Connection)AVWorksService.getConnection());
            Trace.logError((String)"CustomFoldersDb", (String)"Creating APPLIANCE_CUSTOM_FOLDER_MAP table");
            DatabaseUtilities.createTable((TableDefinition)m_tdApplianceCustomFolders, (Connection)AVWorksService.getConnection());
            Trace.logError((String)"CustomFoldersDb", (String)"Creating SERVER_CUSTOM_FOLDER_MAP table");
            DatabaseUtilities.createTable((TableDefinition)m_tdServerCustomFolders, (Connection)AVWorksService.getConnection());
            return true;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"CustomFoldersDb", (String)"Failed to create Folder tables");
            return false;
        }
    }

    public static boolean isNameDefined(int n, String string) throws ExceptionRequestFailed {
        return CustomFoldersDb.isNameDefined(0, n, string);
    }

    public static boolean isNameDefined(int n, int n2, String string) throws ExceptionRequestFailed {
        Trace.logInfo((String)"CustomFoldersDb:isNameDefined", (String)("Name      =" + string));
        Trace.logInfo((String)"CustomFoldersDb:isNameDefined", (String)("Parent ID =" + n2));
        Trace.logInfo((String)"CustomFoldersDb:isNameDefined", (String)("Ignore ID =" + n));
        if (string == null || string.length() == 0) {
            Trace.logError((String)"CustomFoldersDb:isNameDefined", (String)"ERROR : Invalid name argument");
            throw new ExceptionRequestFailed();
        }
        String string2 = "SELECT NAME FROM CUSTOM_FOLDERS WHERE (UPPER(NAME)=" + SqlCmd.quote((String)string.toUpperCase()) + ")" + " AND" + " (PARENT_ID=" + Integer.toString(n2) + ")" + " AND" + " (ID!=" + Integer.toString(n) + ");";
        Trace.logInfo((String)"CustomFoldersDb:isNameDefined", (String)("Execute SQL=" + string2));
        int n3 = DatabaseSession.executeQuery(string2);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n3, 1);
        DatabaseSession.closeQuery(n3);
        if (dBaseRequestQueryResults.getRowCount() > 0) {
            Trace.logInfo((String)"CustomFoldersDb:isNameDefined", (String)"YES - Name exists");
            return true;
        }
        Trace.logInfo((String)"CustomFoldersDb:isNameDefined", (String)"NO - Name DOES NOT exist");
        return false;
    }

    public static TableDefinition getCustomFolderTableDefinition() {
        return m_tdCustomFolders;
    }

    public static TableDefinition getApplianceCustomFolderTableDefinition() {
        return m_tdApplianceCustomFolders;
    }

    public static TableDefinition getServerCustomFolderTableDefinition() {
        return m_tdServerCustomFolders;
    }

    static {
        m_tdCustomFolders.addColumn(ID, "INTEGER", null, true);
        m_tdCustomFolders.addColumn(NAME, "VARCHAR", null);
        m_tdCustomFolders.addColumn(PARENT_ID, "INTEGER", null);
        m_tdApplianceCustomFolders = new DefaultTableDefinition(APPLIANCE_CUSTOM_FOLDER_MAP);
        m_tdApplianceCustomFolders.addColumn(FOLDER_ID, "INTEGER", null);
        m_tdApplianceCustomFolders.addColumn(NAME, "INTEGER", null);
        m_tdApplianceCustomFolders.addColumn(APPLIANCE_ID, "INTEGER", null);
        m_tdServerCustomFolders = new DefaultTableDefinition(SERVER_CUSTOM_FOLDER_MAP);
        m_tdServerCustomFolders.addColumn(FOLDER_ID, "INTEGER", null);
        m_tdServerCustomFolders.addColumn(NAME, "INTEGER", null);
        m_tdServerCustomFolders.addColumn(SERVER_ID, "INTEGER", null);
    }
}

