/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.AppliancePropertiesDb;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.CustomFieldLabelsDb;
import com.avocent.avworks.services.CustomFoldersDb;
import com.avocent.avworks.services.InterfacesDb;
import com.avocent.avworks.services.NmmDb;
import com.avocent.avworks.services.OptionsDb;
import com.avocent.avworks.services.ProductsDb;
import com.avocent.avworks.services.ServerPropertiesDb;
import com.avocent.avworks.services.ServersDb;
import com.avocent.lib.database.DBaseRequest;
import com.avocent.lib.database.DBaseRequestCloseQuery;
import com.avocent.lib.database.DBaseRequestExecuteQuery;
import com.avocent.lib.database.DBaseRequestExecuteUpdate;
import com.avocent.lib.database.DBaseRequestQueryResults;
import com.avocent.lib.database.DatabaseUtilities;
import com.avocent.lib.database.DefaultTableDefinition;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.database.TableDefinition;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.sql.Connection;

public class DatabaseSession {
    protected static DefaultTableDefinition m_tdVersionTable = new DefaultTableDefinition("DBASEVERSION");
    public static final String DBASEVERSION = "DBASEVERSION";
    public static final String VERSION = "VERSION";
    public static final String VERSION_1_0_OLDSTYLE = "1.0";
    public static final String VERSION_TEST_1 = "System Test 1";
    public static final String VERSION_1_0 = "Version 1.0";
    public static final String VERSION_1_1 = "Version 1.1";
    public static final String VERSION_1_3 = "Version 1.3";
    public static final String VERSION_1_4 = "Version 1.4";
    public static final String VERSION_1_5 = "Version 1.5";
    public static final String CURRENT_DATABASE_VERSION = "Version 1.5";

    public static int executeQuery(String string) throws ExceptionRequestFailed {
        DBaseRequestExecuteQuery dBaseRequestExecuteQuery = new DBaseRequestExecuteQuery("", string);
        if (!AVWorksService.requestDatabase((DBaseRequest)dBaseRequestExecuteQuery)) {
            throw new ExceptionRequestFailed();
        }
        int n = dBaseRequestExecuteQuery.getQueryHandle();
        return n;
    }

    public static DBaseRequestQueryResults getQueryResults(int n, int n2) throws ExceptionRequestFailed {
        DBaseRequestQueryResults dBaseRequestQueryResults = new DBaseRequestQueryResults(n, n2);
        if (!AVWorksService.requestDatabase((DBaseRequest)dBaseRequestQueryResults)) {
            throw new ExceptionRequestFailed();
        }
        return dBaseRequestQueryResults;
    }

    public static void closeQuery(int n) throws ExceptionRequestFailed {
        DBaseRequestCloseQuery dBaseRequestCloseQuery = new DBaseRequestCloseQuery(n);
        if (!AVWorksService.requestDatabase((DBaseRequest)dBaseRequestCloseQuery)) {
            throw new ExceptionRequestFailed();
        }
    }

    public static int executeUpdate(String string) throws ExceptionRequestFailed {
        DBaseRequestExecuteUpdate dBaseRequestExecuteUpdate = new DBaseRequestExecuteUpdate("", string);
        if (!AVWorksService.requestDatabase((DBaseRequest)dBaseRequestExecuteUpdate)) {
            throw new ExceptionRequestFailed();
        }
        int n = dBaseRequestExecuteUpdate.getRowsUpdated();
        return n;
    }

    public static void verifyDatabaseStructure() throws ExceptionRequestFailed {
        try {
            int n;
            TableDefinition[] tableDefinitionArray = new TableDefinition[]{NmmDb.getTableDefinition(), ProductsDb.getTableDefinition(), AppliancesDb.getTableDefinition(), ServersDb.getTableDefinition(), InterfacesDb.getTableDefinition(), CustomFieldLabelsDb.getTableDefinition(), CustomFoldersDb.getCustomFolderTableDefinition(), CustomFoldersDb.getApplianceCustomFolderTableDefinition(), CustomFoldersDb.getServerCustomFolderTableDefinition(), OptionsDb.getTableDefinition(), ServerPropertiesDb.getTableDefinition(), AppliancePropertiesDb.getTableDefinition()};
            Connection connection = AVWorksService.getConnection();
            for (n = 0; n < tableDefinitionArray.length; ++n) {
                int n2 = DatabaseUtilities.verifyTableDefinition((Connection)connection, (TableDefinition)tableDefinitionArray[n]);
                if (n2 != 99) continue;
                throw new ExceptionRequestFailed("Failed to update database structure.");
            }
            n = DatabaseUtilities.verifyTableDefinition((Connection)connection, (TableDefinition)m_tdVersionTable);
            Trace.logInfo((String)"DatabaseSession.verifyDatabaseStructure", (String)("Building DBASEVERSION table returned " + n));
            if (n == 99) {
                throw new ExceptionRequestFailed("Failed to update database structure.");
            }
            if (n == 1) {
                DefaultTableDefinition defaultTableDefinition = m_tdVersionTable;
                String[] stringArray = new String[]{defaultTableDefinition.getColumnNameAt(0)};
                String[] stringArray2 = new String[]{SqlCmd.quote((String)"Version 1.5")};
                DatabaseUtilities.insert((Connection)connection, (String)defaultTableDefinition.getTableName(), (String[])stringArray, (String[])stringArray2);
            }
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            throw exceptionRequestFailed;
        }
        catch (Exception exception) {
            Trace.logError((String)"DatabaseSession", (String)"Unable to verify database structure.", (Throwable)exception);
            throw new ExceptionRequestFailed("Unable to verify database structure.", (Throwable)exception);
        }
    }

    public static void setDatabaseVersion(String string) throws ExceptionRequestFailed {
        String string2 = "UPDATE DBASEVERSION SET VERSION = " + SqlCmd.quote((String)string) + ";";
        DatabaseSession.executeUpdate(string2);
    }

    static {
        m_tdVersionTable.addColumn(VERSION, "VARCHAR", (Object)VERSION_1_3);
    }
}

