/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.lib.debug.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FlashFileHeader {
    private final int FLASH_VERSION_OFFSET = 120;
    private final int FLASH_VERSION_LENGTH = 32;
    private final int FLASH_DATE_OFFSET = 6;
    private final int FLASH_DATE_LENGTH = 10;
    private final int FLASH_TIME_OFFSET = 16;
    private final int FLASH_TIME_LENGTH = 10;
    private final int FLASH_TYPE_OFFSET = 56;
    private final int FLASH_TYPE_LENGTH = 1;
    private final int FLASH_EXT_RECORD_DEFINE_OFFSET = 152;
    private final int FLASH_EXT_RECORD_DEFINE_LENGTH = 4;
    private final int FLASH_EXT_RECORD_LENGTH_DEFINE_OFFSET = 156;
    private final int FLASH_EXT_RECORD_LENGTH_DEFINE_LENGTH = 4;
    private final int FLASH_EXT_RECORDS_LENGTH = 16;
    private final int FLASH_EXT_RECORDS_LENGTH_2 = 22;
    private final int FLASH_HEADER_LENGTH = 160;
    private final int FLASH_COUNTRY_OFFSET = 59;
    private final int FLASH_COUNTRY_LENGTH = 2;
    private final int FLASH_LANGUAGE_OFFSET = 61;
    private final int FLASH_LANGUAGE_LENGTH = 3;
    private final int OEM_EXTENSION_RECORD = 1;
    private final String APPLICATION_TYPE = "A";
    private final String BOOT_TYPE = "B";
    public final int FLASH_BOOT_TYPE = 1;
    public final int FLASH_APPLIANCE_TYPE = 2;
    private String m_szVersion;
    private String m_szCountry;
    private String m_szLanguage;
    private Date m_createDateTime;
    private int m_nProductFamilyCode;
    private int m_nProductOEMCode;
    private int m_nFlashType;
    private static final int FLASH_OEM_TYPE_AVOCENT = 0;
    private static final int FLASH_OEM_TYPE_COMPAQ = 1;
    private static final int FLASH_OEM_TYPE_DELL = 2;
    private static final int FLASH_OEM_TYPE_HP = 3;
    private static final int FLASH_OEM_TYPE_IBM = 4;
    private static final int FLASH_OEM_TYPE_FSC = 5;
    private static final int FLASH_OEM_TYPE_BLACKBOX = 7;
    private static final int FLASH_PROD_PPC_HARDWARE = 16;
    private static final int FLASH_PROD_BRANCH_HARDWARE = 22;
    private static final int FLASH_PROD_FAMILY_NAUTILUS = 25;

    public FlashFileHeader(InputStream inputStream) throws IOException {
        Trace.logInfo((String)"FlashFileHeader", (String)"getting header information");
        byte[] byArray = this.getHeaderData(inputStream);
        this.m_szVersion = this.convertBytesToString(this.getByteHeaderData(120, 32, byArray));
        Trace.logInfo((String)"FlashFileHeader", (String)("version = " + this.m_szVersion));
        this.m_szCountry = this.convertBytesToString(this.getByteHeaderData(59, 2, byArray));
        Trace.logInfo((String)"FlashFileHeader", (String)("country = " + this.m_szCountry));
        this.m_szLanguage = this.convertBytesToString(this.getByteHeaderData(61, 3, byArray));
        Trace.logInfo((String)"FlashFileHeader", (String)("language = " + this.m_szLanguage));
        String string = this.getStringHeaderData(byArray, 6, 10);
        String string2 = this.getStringHeaderData(byArray, 16, 10);
        String string3 = string.trim() + " " + string2.trim();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
        this.m_createDateTime = simpleDateFormat.parse(string3, new ParsePosition(0));
        byte[] byArray2 = this.getByteHeaderData(152, 4, byArray);
        int n = this.getInt(byArray2);
        Trace.logInfo((String)"FlashFileHeader", (String)("extension record offset = " + n));
        byte[] byArray3 = this.getByteHeaderData(156, 4, byArray);
        int n2 = this.getInt(byArray3);
        Trace.logInfo((String)"FlashFileHeader", (String)("extension record length = " + n2));
        if (n2 != 16 && n2 != 22) {
            Trace.logInfo((String)"FlashFileHeader", (String)"length of extension records not correct, invalid flash file");
            throw new StreamCorruptedException();
        }
        byte[] byArray4 = new byte[n2];
        inputStream.skip(n - 160);
        inputStream.read(byArray4);
        int n3 = ((byArray4[0] & 0xFF) << 8) + (byArray4[1] & 0xFF);
        int n4 = 0;
        if (n3 == 1) {
            this.m_nProductOEMCode = ((byArray4[n4 + 4] & 0xFF) << 8) + (byArray4[n4 + 5] & 0xFF);
            Trace.logInfo((String)"FlashFileHeader", (String)("product oem code = " + this.m_nProductOEMCode));
            n4 = ((byArray4[2] & 0xFF) << 8) + (byArray4[3] & 0xFF) + 4;
        }
        this.m_nProductFamilyCode = ((byArray4[n4 + 4] & 0xFF) << 8) + (byArray4[n4 + 5] & 0xFF);
        Trace.logInfo((String)"FlashFileHeader", (String)("product family code = " + this.m_nProductFamilyCode));
        String string4 = this.convertBytesToString(this.getByteHeaderData(56, 1, byArray));
        this.m_nFlashType = string4.equalsIgnoreCase("A") ? 2 : 1;
        Trace.logInfo((String)"FlashFileHeader", (String)("flash type = " + this.m_nFlashType));
    }

    public String getVersion() throws IOException {
        return this.m_szVersion;
    }

    public String getCountry() throws IOException {
        return this.m_szCountry;
    }

    public String getLanguage() throws IOException {
        return this.m_szLanguage;
    }

    public Date getCreateDateTime() throws IOException {
        return this.m_createDateTime;
    }

    public int getProductFamilyCode() throws IOException {
        return this.m_nProductFamilyCode;
    }

    public int getProductOEMCode() throws IOException {
        return this.m_nProductOEMCode;
    }

    public int getFlashFileType() throws IOException {
        return this.m_nFlashType;
    }

    private byte[] getHeaderData(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[160];
        int n = inputStream.read(byArray);
        if (n != 160) {
            Trace.logError((String)"FlashFileHeader:getHeaderData()", (String)("The flash file header is not the correct length, length = " + n));
            throw new StreamCorruptedException();
        }
        return byArray;
    }

    private String getStringHeaderData(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (n3 = 0; n3 < n2 && byArray[n + n3] != 0; ++n3) {
        }
        Trace.logInfo((String)"FlashFileHeader", (String)("getStringHeaderData, returning " + new String(byArray, n, n3)));
        return new String(byArray, n, n3, "US-ASCII");
    }

    private byte[] getByteHeaderData(int n, int n2, byte[] byArray) throws IOException {
        Trace.logInfo((String)"FlashFileHeader:getByteHeaderData", (String)("nLength = " + n2 + " nOffset = " + n));
        if (n2 > 160) {
            Trace.logInfo((String)"FlashFileHeader:getByteHeaderData", (String)"length requested for header info is too large to be valid");
            throw new StreamCorruptedException();
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    private String convertBytesToString(byte[] byArray) throws IOException {
        return new String(byArray, "US-ASCII").trim();
    }

    private int getInt(byte[] byArray) throws IOException {
        return ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
    }

    public boolean isFirmwareFileCompatable(int n) {
        switch (this.m_nProductOEMCode) {
            case 2: {
                if (this.m_nProductFamilyCode != 25 || n != 30 && n != 31) break;
                return true;
            }
            case 4: {
                if (this.m_nProductFamilyCode != 25 || n != 32 && n != 33) break;
                return true;
            }
            case 3: {
                if (this.m_nProductFamilyCode == 25 && (n == 37 || n == 38)) {
                    return true;
                }
                if (this.m_nProductFamilyCode != 16 || n != 35 && n != 36) break;
                return true;
            }
            case 5: {
                if (this.m_nProductFamilyCode == 25 && (n == 40 || n == 41)) {
                    return true;
                }
                if (this.m_nProductFamilyCode != 22 || n != 39) break;
                return true;
            }
            case 0: 
            case 1: 
            case 7: {
                return false;
            }
        }
        return false;
    }
}

