/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.avworks.services.InterfaceInfo;
import com.avocent.lib.database.DBaseRequestQueryResults;
import com.avocent.lib.database.DatabaseUtilities;
import com.avocent.lib.database.DefaultTableDefinition;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.database.TableDefinition;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.sql.Connection;
import java.util.Vector;

public class InterfacesDb {
    private static final String TRACE_CONTEXT = "InterfacesDb";
    protected static DefaultTableDefinition m_tdTableDefinition = new DefaultTableDefinition("INTERFACES");
    public static final String INTERFACES = "INTERFACES";
    public static final String ID = "ID";
    public static final String APPLIANCE_ID = "APPLIANCE_ID";
    public static final String PORT_NUM = "PORT_NUM";
    public static final String NAME = "NAME";
    public static final String CONN_TYPE = "CONN_TYPE";
    public static final String CONN_ID = "CONN_ID";

    public static TableDefinition getTableDefinition() {
        return m_tdTableDefinition;
    }

    public static int add(InterfaceInfo interfaceInfo) throws ExceptionRequestFailed {
        if (interfaceInfo == null) {
            Trace.logError((String)"InterfacesDb:add", (String)"Invalid argument");
            throw new ExceptionRequestFailed();
        }
        Trace.logInfo((String)"InterfacesDb:add", (String)("Interface=" + interfaceInfo.getName()));
        int n = 1;
        try {
            n = InterfacesDb.getMaxID() + 1;
            Trace.logInfo((String)"InterfacesDb:add", (String)("Maximum Interface ID is " + n));
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"InterfacesDb:add", (String)"NOTE: Unable to obtain max ID");
        }
        for (int i = n; i < n + 5; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO INTERFACES ");
            stringBuffer.append("( ");
            stringBuffer.append("ID, ");
            stringBuffer.append("APPLIANCE_ID, ");
            stringBuffer.append("PORT_NUM, ");
            stringBuffer.append("NAME, ");
            stringBuffer.append("CONN_TYPE, ");
            stringBuffer.append("CONN_ID ");
            stringBuffer.append(") ");
            stringBuffer.append("VALUES");
            stringBuffer.append("( ");
            stringBuffer.append(Integer.toString(i) + ", ");
            stringBuffer.append(Integer.toString(interfaceInfo.getApplianceID()) + ", ");
            stringBuffer.append(Integer.toString(interfaceInfo.getPortNum()) + ", ");
            stringBuffer.append(SqlCmd.quote((String)interfaceInfo.getName()) + ", ");
            stringBuffer.append(Integer.toString(interfaceInfo.getConnType()) + ", ");
            stringBuffer.append(Integer.toString(interfaceInfo.getConnID()) + "  ");
            stringBuffer.append(");");
            Trace.logInfo((String)"InterfacesDb:add", (String)("Execute SQL=" + stringBuffer.toString()));
            int n2 = DatabaseSession.executeUpdate(stringBuffer.toString());
            if (n2 != 1) continue;
            return i;
        }
        Trace.logError((String)"InterfacesDb:add", (String)"ERROR : Exceeded maximum retries");
        throw new ExceptionRequestFailed();
    }

    public static int add(int n, String string) throws ExceptionRequestFailed {
        if (string == null) {
            Trace.logError((String)"InterfacesDb:add", (String)"Invalid argument");
            throw new ExceptionRequestFailed();
        }
        Trace.logInfo((String)"InterfacesDb:add", (String)("Interface=" + string));
        InterfaceInfo interfaceInfo = new InterfaceInfo(0, n, 0, string, 0, 0);
        return InterfacesDb.add(interfaceInfo);
    }

    public static int add(int n, String string, int n2) throws ExceptionRequestFailed {
        if (string == null) {
            Trace.logError((String)"InterfacesDb:add", (String)"Invalid argument");
            throw new ExceptionRequestFailed();
        }
        Trace.logInfo((String)"InterfacesDb:add", (String)("Interface=" + string));
        InterfaceInfo interfaceInfo = new InterfaceInfo(0, n, n2, string, 0, 0);
        return InterfacesDb.add(interfaceInfo);
    }

    public static int getCount() throws ExceptionRequestFailed {
        String string = "SELECT COUNT(ID) FROM INTERFACES";
        int n = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logError((String)"InterfacesDb:getCount", (String)"Unable to read maximum interface ID");
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        return n2;
    }

    public static int getMaxID() throws ExceptionRequestFailed {
        String string = "SELECT MAX(ID) FROM INTERFACES";
        int n = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        return n2;
    }

    public static boolean delete(int[] nArray) {
        int n;
        String string = "DELETE FROM INTERFACES WHERE ID IN ( ";
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            string = string + Integer.toString(n2);
            string = n == nArray.length - 1 ? string + ");" : string + ", ";
        }
        try {
            n = DatabaseSession.executeUpdate(string);
            return n > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void modify(InterfaceInfo interfaceInfo) throws ExceptionRequestFailed {
        Trace.logInfo((String)"InterfacesDb:modify", (String)("ID =" + interfaceInfo.getID()));
        Trace.logInfo((String)"InterfacesDb:modify", (String)("Name=" + interfaceInfo.getName()));
        if (interfaceInfo == null) {
            Trace.logError((String)"InterfacesDb:add", (String)"Invalid argument");
            throw new ExceptionRequestFailed();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE INTERFACES SET ");
        stringBuffer.append("APPLIANCE_ID=" + Integer.toString(interfaceInfo.getApplianceID()) + ", ");
        stringBuffer.append("PORT_NUM=" + Integer.toString(interfaceInfo.getPortNum()) + ", ");
        stringBuffer.append("NAME=" + SqlCmd.quote((String)interfaceInfo.getName()) + ", ");
        stringBuffer.append("CONN_TYPE=" + Integer.toString(interfaceInfo.getConnType()) + ", ");
        stringBuffer.append("CONN_ID=" + Integer.toString(interfaceInfo.getConnID()) + "  ");
        stringBuffer.append(" WHERE (ID=" + Integer.toString(interfaceInfo.getID()) + ");");
        int n = DatabaseSession.executeUpdate(stringBuffer.toString());
        if (n >= 1) {
            return;
        }
        Trace.logError((String)"InterfacesDb.modify", (String)"ERROR : The interface was not found");
        throw new ExceptionRequestFailed();
    }

    public static void merge(int n, int n2) throws ExceptionRequestFailed {
        Trace.logInfo((String)"InterfacesDb:merge", (String)("from =" + n + "; to =" + n2));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE INTERFACES SET CONN_ID=" + n2).append(" WHERE (CONN_TYPE = 1").append(" AND CONN_ID=" + n + ");");
        int n3 = DatabaseSession.executeUpdate(stringBuffer.toString());
        if (n3 >= 1) {
            return;
        }
        Trace.logError((String)"InterfacesDb.modify", (String)"ERROR : The interface was not found");
        throw new ExceptionRequestFailed();
    }

    public static InterfaceInfo getInterfaceInfo(int n) throws ExceptionRequestFailed, ExceptionNoValue {
        String string = "SELECT * FROM INTERFACES WHERE (ID=" + Integer.toString(n) + ");";
        int n2 = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logInfo((String)"InterfacesDb:getInterfaceInfo", (String)"NOTE : No value was available");
            throw new ExceptionNoValue();
        }
        dBaseRequestQueryResults.nextRow();
        int n3 = dBaseRequestQueryResults.getInt(ID);
        int n4 = dBaseRequestQueryResults.getInt(APPLIANCE_ID);
        int n5 = 0;
        String string2 = dBaseRequestQueryResults.getString(NAME);
        int n6 = dBaseRequestQueryResults.getInt(CONN_TYPE);
        int n7 = dBaseRequestQueryResults.getInt(CONN_ID);
        try {
            n5 = dBaseRequestQueryResults.getInt(PORT_NUM);
        }
        catch (Exception exception) {
            // empty catch block
        }
        InterfaceInfo interfaceInfo = new InterfaceInfo(n3, n4, n5, string2, n6, n7);
        return interfaceInfo;
    }

    public static InterfaceInfo[] getInterfaceInfoList() throws ExceptionRequestFailed, ExceptionNoValue {
        return InterfacesDb.getInterfaceInfoList(null);
    }

    public static InterfaceInfo[] getInterfaceInfoList(String string) throws ExceptionRequestFailed, ExceptionNoValue {
        Object[] objectArray;
        int n;
        Vector<InterfaceInfo> vector = new Vector<InterfaceInfo>();
        String string2 = string == null || string.length() == 0 ? "SELECT * FROM INTERFACES;" : "SELECT * FROM INTERFACES " + string + ";";
        int n2 = DatabaseSession.executeQuery(string2);
        while ((n = (objectArray = DatabaseSession.getQueryResults(n2, 3)).getRowCount()) != 0) {
            for (int i = 1; i <= n; ++i) {
                objectArray.nextRow();
                int n3 = objectArray.getInt(ID);
                int n4 = objectArray.getInt(APPLIANCE_ID);
                int n5 = 0;
                String string3 = objectArray.getString(NAME);
                int n6 = objectArray.getInt(CONN_TYPE);
                int n7 = objectArray.getInt(CONN_ID);
                try {
                    n5 = objectArray.getInt(PORT_NUM);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                InterfaceInfo interfaceInfo = new InterfaceInfo(n3, n4, n5, string3, n6, n7);
                vector.add(interfaceInfo);
            }
            if (objectArray.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n2);
        if (vector.size() == 0) {
            Trace.logInfo((String)"InterfacesDb:getInterfaceInfoList", (String)"NOTE : No values were available");
            throw new ExceptionNoValue();
        }
        objectArray = new InterfaceInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean createInterfacesTable() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Creating INTERFACES table");
        try {
            DatabaseUtilities.createTable((TableDefinition)m_tdTableDefinition, (Connection)AVWorksService.getConnection());
            return true;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Failed to create INTERFACES table");
            return false;
        }
    }

    public static int getNumConnectedTo(int n, int n2) throws ExceptionRequestFailed {
        try {
            String string = "WHERE (CONN_ID=" + Integer.toString(n) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(n2) + ");";
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList(string);
            return interfaceInfoArray.length;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Unable to get interface info.  No Value was available.");
            return 0;
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to get interface info.  Request Failed.");
            throw new ExceptionRequestFailed();
        }
    }

    static {
        m_tdTableDefinition.addColumn(ID, "INTEGER", null, true);
        m_tdTableDefinition.addColumn(APPLIANCE_ID, "INTEGER", null);
        m_tdTableDefinition.addColumn(PORT_NUM, "INTEGER", null);
        m_tdTableDefinition.addColumn(NAME, "VARCHAR", null);
        m_tdTableDefinition.addColumn(CONN_TYPE, "INTEGER", null);
        m_tdTableDefinition.addColumn(CONN_ID, "INTEGER", null);
    }
}

