/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.avworks.services.InterfaceAVWorksNMM;
import com.avocent.avworks.services.NmmInfo;
import com.avocent.lib.database.DBaseRequestQueryResults;
import com.avocent.lib.database.DatabaseUtilities;
import com.avocent.lib.database.DefaultTableDefinition;
import com.avocent.lib.database.TableDefinition;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class NmmDb {
    protected static DefaultTableDefinition m_tdTableDefinition = new DefaultTableDefinition("NMM");
    public static final String NMM = "NMM";
    public static final String ID = "ID";
    public static final String NAME = "NAME";
    public static final String JAR = "JAR";
    public static final String CLASS = "CLASS";
    public static final String PRIORITY = "PRIORITY";
    private static Map m_mapNmmsByID;
    private static Map m_mapNmmsByPriority;

    public static TableDefinition getTableDefinition() {
        return m_tdTableDefinition;
    }

    private static int getCount() throws ExceptionRequestFailed {
        String string = "SELECT COUNT(ID) FROM NMM";
        int n = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logError((String)"NmmDb:getCount", (String)"ERROR:Unable to read maximum NMM ID");
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        return n2;
    }

    private static NmmInfo getNmmInfo(int n) throws ExceptionRequestFailed, ExceptionNoValue {
        String string = "SELECT * FROM NMM WHERE (ID=" + Integer.toString(n) + ");";
        int n2 = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logInfo((String)"NmmDb.getNmmInfo", (String)"NOTE : No value was available");
            throw new ExceptionNoValue();
        }
        dBaseRequestQueryResults.nextRow();
        return NmmDb.makeNmmInfo(dBaseRequestQueryResults);
    }

    private static NmmInfo[] getNmmList() throws ExceptionRequestFailed, ExceptionNoValue {
        return NmmDb.getNmmList(null);
    }

    public static NmmInfo[] getNmmList(String string) throws ExceptionRequestFailed, ExceptionNoValue {
        Object[] objectArray;
        int n = NmmDb.getCount();
        if (n == 0) {
            Trace.logInfo((String)"NmmDb.getNmmList", (String)"NOTE : No values were available");
            throw new ExceptionNoValue();
        }
        Vector<NmmInfo> vector = new Vector<NmmInfo>();
        String string2 = string == null || string.length() == 0 ? "SELECT * FROM NMM;" : "SELECT * FROM NMM " + string + ";";
        int n2 = DatabaseSession.executeQuery(string2);
        do {
            objectArray = DatabaseSession.getQueryResults(n2, 3);
            while (objectArray.nextRow()) {
                vector.add(NmmDb.makeNmmInfo((DBaseRequestQueryResults)objectArray));
            }
        } while (objectArray.getRowCount() > 3);
        DatabaseSession.closeQuery(n2);
        if (vector.size() == 0) {
            Trace.logInfo((String)"NmmDb.getNmmList", (String)"NOTE : No values were available");
            throw new ExceptionNoValue();
        }
        objectArray = new NmmInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static NmmInfo makeNmmInfo(DBaseRequestQueryResults dBaseRequestQueryResults) throws ExceptionRequestFailed {
        int n = dBaseRequestQueryResults.getInt(ID);
        String string = dBaseRequestQueryResults.getString(NAME);
        String string2 = dBaseRequestQueryResults.getString(JAR);
        String string3 = dBaseRequestQueryResults.getString(CLASS);
        Integer n2 = dBaseRequestQueryResults.getInteger(PRIORITY);
        int n3 = n2 == null ? n * 10 : n2;
        return new NmmInfo(n, string, string2, string3, n3);
    }

    public static boolean createNmmTable() {
        try {
            Trace.logInfo((String)"NmmDb", (String)"Creating NMM table");
            DatabaseUtilities.createTable((TableDefinition)m_tdTableDefinition, (Connection)AVWorksService.getConnection());
            return true;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"NmmDb", (String)"Failed to create NMM table");
            return false;
        }
    }

    public static void loadNmms(Frame frame) throws ExceptionRequestFailed, ExceptionNoValue {
        NmmInfo[] nmmInfoArray = NmmDb.getNmmList(null);
        Class[] classArray = new Class[]{Integer.TYPE, Frame.class};
        Object[] objectArray = new Object[]{new Integer(0), frame};
        int n = nmmInfoArray.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            try {
                String string = nmmInfoArray[i].getNmmClass();
                object = Class.forName(string);
                Constructor<?> constructor = ((Class)object).getConstructor(classArray);
                objectArray[0] = new Integer(nmmInfoArray[i].getID());
                InterfaceAVWorksNMM interfaceAVWorksNMM = (InterfaceAVWorksNMM)constructor.newInstance(objectArray);
                Integer n2 = new Integer(nmmInfoArray[i].getID());
                Integer n3 = new Integer(nmmInfoArray[i].getPriority());
                m_mapNmmsByID.put(n2, interfaceAVWorksNMM);
                m_mapNmmsByPriority.put(n3, interfaceAVWorksNMM);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                object = nmmInfoArray[i].getName() + " is invalid: must " + "provide a public constructor that takes an int and a " + "java.awt.Frame argument.";
                throw new ExceptionRequestFailed((String)object, (Throwable)noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                object = nmmInfoArray[i].getName() + " is invalid: must " + "provide a public constructor that takes a java.awt.Frame " + "argument.";
                throw new ExceptionRequestFailed((String)object, (Throwable)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ExceptionRequestFailed(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            }
            catch (InstantiationException instantiationException) {
                object = nmmInfoArray[i].getName() + " is invalid: the NMM " + "class must not be declared abstract";
                throw new ExceptionRequestFailed((String)object, (Throwable)instantiationException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ExceptionRequestFailed(invocationTargetException.getMessage(), (Throwable)invocationTargetException);
            }
        }
    }

    public static InterfaceAVWorksNMM getNmm(int n) throws ExceptionNoValue {
        Integer n2 = new Integer(n);
        try {
            InterfaceAVWorksNMM interfaceAVWorksNMM = (InterfaceAVWorksNMM)m_mapNmmsByID.get(n2);
            if (interfaceAVWorksNMM == null) {
                throw new ExceptionNoValue("No NMM found for ID# " + n);
            }
            return interfaceAVWorksNMM;
        }
        catch (ClassCastException classCastException) {
            throw new ExceptionNoValue("Object found for ID# " + n + " is not an NMM", (Throwable)classCastException);
        }
    }

    public static Iterator iterateNmms() {
        return m_mapNmmsByPriority.values().iterator();
    }

    public static boolean isPropertySupported(String string) {
        Iterator iterator = NmmDb.iterateNmms();
        while (iterator.hasNext()) {
            InterfaceAVWorksNMM interfaceAVWorksNMM = (InterfaceAVWorksNMM)iterator.next();
            if (!interfaceAVWorksNMM.isPropertySupported(string)) continue;
            return true;
        }
        return false;
    }

    static {
        m_tdTableDefinition.addColumn(ID, "INTEGER", null);
        m_tdTableDefinition.addColumn(NAME, "VARCHAR", null);
        m_tdTableDefinition.addColumn(JAR, "VARCHAR", null);
        m_tdTableDefinition.addColumn(CLASS, "VARCHAR", null);
        m_tdTableDefinition.addColumn(PRIORITY, "INTEGER", null);
        m_mapNmmsByID = new Hashtable();
        m_mapNmmsByPriority = new TreeMap();
    }
}

