/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.avworks.services.OptionInfo;
import com.avocent.lib.database.DBaseRequestQueryResults;
import com.avocent.lib.database.DatabaseUtilities;
import com.avocent.lib.database.DefaultTableDefinition;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.database.TableDefinition;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.sql.Connection;
import java.util.Vector;

public class OptionsDb {
    private static final String TRACE_CONTEXT = "OptionsDb";
    protected static DefaultTableDefinition m_tdTableDefinition = new DefaultTableDefinition("GLOBAL_OPTIONS"){

        public String getPrimaryKeyString() {
            return "identity";
        }
    };
    public static final String OPTIONS = "GLOBAL_OPTIONS";
    public static final String ID = "ID";
    public static final String KEY = "KEY";
    public static final String VALUE = "VALUE";

    public static TableDefinition getTableDefinition() {
        return m_tdTableDefinition;
    }

    private static void add(String string, String string2) throws ExceptionRequestFailed {
        if (OptionsDb.isOptionDefined(string)) {
            Trace.logError((String)"OptionsDb:add", (String)"ERROR : Option already exists");
            throw new ExceptionRequestFailed();
        }
        OptionsDb.doAdd(string, string2);
    }

    private static void doAdd(String string, String string2) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0) {
            Trace.logError((String)"OptionsDb:add", (String)"ERROR : Invalid key argument");
            throw new ExceptionRequestFailed();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO GLOBAL_OPTIONS ");
        stringBuffer.append("( ");
        stringBuffer.append("ID, ");
        stringBuffer.append("KEY, ");
        stringBuffer.append("VALUE ");
        stringBuffer.append(") ");
        stringBuffer.append("VALUES");
        stringBuffer.append("( null, ");
        stringBuffer.append(SqlCmd.quote((String)string) + ", ");
        stringBuffer.append(SqlCmd.quote((String)string2) + " ");
        stringBuffer.append(");");
        DatabaseSession.executeUpdate(stringBuffer.toString());
    }

    public static boolean isOptionDefined(String string) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0) {
            Trace.logError((String)"OptionsDb:isOptionDefined", (String)"ERROR : Invalid key argument");
            throw new ExceptionRequestFailed();
        }
        String string2 = "SELECT KEY FROM GLOBAL_OPTIONS WHERE (KEY=" + SqlCmd.quote((String)string) + ");";
        int n = DatabaseSession.executeQuery(string2);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        return dBaseRequestQueryResults.getRowCount() > 0;
    }

    private static int getCount() throws ExceptionRequestFailed {
        String string = "SELECT COUNT(ID) FROM GLOBAL_OPTIONS";
        int n = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logError((String)"OptionsDb:getCount", (String)"ERROR : Unable to read max options count");
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        return n2;
    }

    public static void setValue(String string, String string2) throws ExceptionRequestFailed {
        CharSequence charSequence;
        if (string == null || string.length() == 0) {
            Trace.logError((String)"OptionsDb.setValue", (String)"ERROR : Invalid key argument");
            throw new ExceptionRequestFailed();
        }
        try {
            charSequence = OptionsDb.getStringValue(string);
            if (((String)charSequence).equals(string2)) {
                return;
            }
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            if (string2 == null) {
                return;
            }
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logInfo((String)"OptionsDb:setValue", (String)"NOTE: Option doesn't exist - Calling add");
            OptionsDb.add(string, string2);
            return;
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append("UPDATE GLOBAL_OPTIONS SET ");
        ((StringBuffer)charSequence).append("VALUE=" + SqlCmd.quote((String)string2) + " ");
        ((StringBuffer)charSequence).append(" WHERE (KEY=" + SqlCmd.quote((String)string) + ");");
        int n = DatabaseSession.executeUpdate(((StringBuffer)charSequence).toString());
        if (n >= 1) {
            return;
        }
        Trace.logError((String)"OptionsDb:setValue", (String)"ERROR : The option was not found");
        throw new ExceptionRequestFailed();
    }

    public static void setValue(String string, int n) throws ExceptionRequestFailed {
        OptionsDb.setValue(string, Integer.toString(n));
    }

    public static void setValue(String string, boolean bl) throws ExceptionRequestFailed {
        Boolean bl2 = new Boolean(bl);
        OptionsDb.setValue(string, bl2.toString());
    }

    public static String getStringValue(String string) throws ExceptionRequestFailed, ExceptionNoValue {
        String string2 = OptionsDb.getStringValue(string, null);
        if (string2 == null) {
            Trace.logInfo((String)"OptionsDb:getValue", (String)"NOTE : No value was available");
            throw new ExceptionNoValue();
        }
        return string2;
    }

    public static String getStringValue(String string, String string2) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0) {
            Trace.logError((String)"OptionsDb:getStringValue", (String)"ERROR : Invalid key argument");
            throw new ExceptionRequestFailed();
        }
        String string3 = "SELECT * FROM GLOBAL_OPTIONS WHERE (KEY=" + SqlCmd.quote((String)string) + ");";
        int n = DatabaseSession.executeQuery(string3);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logInfo((String)"OptionsDb:getValue", (String)("No value found for " + string + ", returning the specified default value: " + string2));
            return string2;
        }
        dBaseRequestQueryResults.nextRow();
        String string4 = dBaseRequestQueryResults.getString(VALUE);
        Trace.logInfo((String)"OptionsDb:getStringValue", (String)("Value=" + string4));
        return string4 == null ? string2 : string4;
    }

    public static int getIntegerValue(String string) throws NumberFormatException, ExceptionRequestFailed, ExceptionNoValue {
        String string2 = OptionsDb.getStringValue(string);
        return Integer.parseInt(string2);
    }

    public static int getIntegerValue(String string, int n) throws NumberFormatException, ExceptionRequestFailed, ExceptionNoValue {
        String string2 = OptionsDb.getStringValue(string, null);
        return string2 == null ? n : Integer.parseInt(string2);
    }

    public static boolean getBooleanValue(String string) throws ExceptionRequestFailed, ExceptionNoValue {
        String string2 = OptionsDb.getStringValue(string);
        Boolean bl = new Boolean(string2);
        return bl;
    }

    public static boolean getBooleanValue(String string, boolean bl) throws ExceptionRequestFailed {
        String string2 = OptionsDb.getStringValue(string, null);
        return string2 == null ? bl : new Boolean(string2);
    }

    public static void removeValue(String string) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0) {
            Trace.logError((String)"OptionsDb.removeValue", (String)("ERROR : Invalid key argument [" + string + "]"));
            throw new ExceptionRequestFailed();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM GLOBAL_OPTIONS WHERE ");
        stringBuffer.append("KEY = ");
        stringBuffer.append(SqlCmd.quote((String)string) + ";");
        int n = DatabaseSession.executeUpdate(stringBuffer.toString());
        if (n <= 0) {
            throw new ExceptionRequestFailed();
        }
        if (n > 1) {
            Trace.logError((String)"OptionsDb.removeValue", (String)("There was more than one record in OptionsDB with Key = '" + string + "'"));
        }
    }

    public static OptionInfo[] getOptionList(String string) throws ExceptionRequestFailed {
        Object[] objectArray;
        int n;
        Vector<OptionInfo> vector = new Vector<OptionInfo>();
        if (string == null || string.length() <= 0) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Null or empty wildcard key passed to getOptionList()");
            return new OptionInfo[0];
        }
        String string2 = "SELECT * FROM GLOBAL_OPTIONS WHERE KEY LIKE " + SqlCmd.quote((String)string) + ";";
        int n2 = DatabaseSession.executeQuery(string2);
        while ((n = (objectArray = DatabaseSession.getQueryResults(n2, 3)).getRowCount()) != 0) {
            for (int i = 1; i <= n; ++i) {
                objectArray.nextRow();
                int n3 = objectArray.getInt(ID);
                String string3 = objectArray.getString(KEY);
                String string4 = objectArray.getString(VALUE);
                OptionInfo optionInfo = new OptionInfo(n3, string3, string4);
                vector.add(optionInfo);
            }
            if (objectArray.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n2);
        objectArray = new OptionInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean createOptionsTable() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Creating GLOBAL_OPTIONS table");
        try {
            DatabaseUtilities.createTable((TableDefinition)m_tdTableDefinition, (Connection)AVWorksService.getConnection());
            return true;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Failed to create GLOBAL_OPTIONS table");
            return false;
        }
    }

    static {
        m_tdTableDefinition.addColumn(ID, "INTEGER", null, true);
        m_tdTableDefinition.addColumn(KEY, "VARCHAR", null);
        m_tdTableDefinition.addColumn(VALUE, "VARCHAR", null);
    }
}

