/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ProductInfo {
    private int m_nID;
    private String m_szVendor;
    private String m_szName;
    private String m_szInternalName;
    private int m_nNmmID;
    private boolean m_bAddAllowed;
    private boolean m_bEnabled;

    public ProductInfo(int n, String string, String string2, String string3, int n2, boolean bl, boolean bl2, String string4) {
        this.m_nID = n;
        this.m_szVendor = string;
        this.m_szName = string2;
        this.m_szInternalName = string3;
        this.m_nNmmID = n2;
        this.m_bAddAllowed = bl;
        try {
            String string5 = n + (bl2 ? "ENABLED" : "DISABLED");
            String string6 = ProductInfo.getDisplayableHashValue(string5);
            if (string4.equalsIgnoreCase(string6)) {
                this.m_bEnabled = bl2;
            } else {
                Trace.logError((String)"ProductInfo", (String)"Invalid Product Enabled Entry");
                this.m_bEnabled = false;
            }
        }
        catch (Exception exception) {
            this.m_bEnabled = bl2;
        }
    }

    public int getID() {
        return this.m_nID;
    }

    public String getVendor() {
        return this.m_szVendor;
    }

    public String getName() {
        return this.m_szName;
    }

    public String getInternalName() {
        return this.m_szInternalName;
    }

    public int getNmmID() {
        return this.m_nNmmID;
    }

    public void setAddAllowed(boolean bl) {
        this.m_bAddAllowed = bl;
    }

    public void setEnabled(boolean bl) {
        this.m_bEnabled = bl;
    }

    public boolean isAddAllowed() {
        return this.m_bAddAllowed;
    }

    public boolean isEnabled() {
        return this.m_bEnabled;
    }

    public static String getDisplayableHashValue(String string) throws ExceptionRequestFailed {
        if (string == null) {
            throw new ExceptionRequestFailed();
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(string.getBytes());
            byte[] byArray = messageDigest.digest();
            byte[] byArray2 = new byte[byArray.length * 2];
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                int n2 = byArray[i];
                int n3 = ((n2 &= 0xFF) & 0xF0) >> 4;
                n3 = n3 > 9 ? n3 - 10 + 65 : (n3 += 48);
                int n4 = n2 & 0xF;
                n4 = n4 > 9 ? n4 - 10 + 65 : (n4 += 48);
                byArray2[n++] = (byte)n3;
                byArray2[n++] = (byte)n4;
            }
            return new String(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Trace.logError((String)"ProductInfo", (String)("NoSuchAlgorithmException " + noSuchAlgorithmException.getMessage()));
            throw new ExceptionRequestFailed();
        }
    }
}

