/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.util.StringUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class Products {
    public static final int AVOCENT_A1000R = 1;
    public static final String AVOCENT_A1000R_SYSOBJID = "1.3.6.1.4.1.10418.3.1.5";
    public static final int AVOCENT_A2000R = 2;
    public static final String AVOCENT_A2000R_SYSOBJID = "1.3.6.1.4.1.10418.3.1.6";
    public static final int AVOCENT_A4000R = 3;
    public static final String AVOCENT_A4000R_SYSOBJID = "1.3.6.1.4.1.10418.3.1.7";
    public static final int HP_1x1x16 = 4;
    public static final String HP_1x1x16_SYSOBJID = "1.3.6.1.4.1.232.160.1.1";
    public static final int HP_3x1x16 = 5;
    public static final String HP_3x1x16_SYSOBJID = "1.3.6.1.4.1.232.160.1.2";
    public static final int DELL_2161DS = 6;
    public static final String DELL_2161DS_SYSOBJID = "1.3.6.1.4.1.10418.3.1.8";
    public static final int IBM_RCM2161 = 7;
    public static final String IBM_RCM2161_SYSOBJID = "1.3.6.1.4.1.10418.3.1.9";
    public static final int CASCADE_SWITCH_1X4 = 8;
    public static final int CASCADE_SWITCH_1X8 = 9;
    public static final int CASCADE_SWITCH_1X16 = 10;
    public static final int CASCADE_SWITCH_1X24 = 11;
    public static final int CASCADE_SWITCH_1X32 = 12;
    public static final int CASCADE_SWITCH_2X4 = 13;
    public static final int CASCADE_SWITCH_2X8 = 14;
    public static final int CASCADE_SWITCH_2X16 = 15;
    public static final int CASCADE_SWITCH_2X24 = 16;
    public static final int CASCADE_SWITCH_2X32 = 17;
    public static final int CASCADE_SWITCH_4X16 = 18;
    public static final int CASCADE_SWITCH_1X6 = 19;
    public static final int BLACK_BOX_KV120A_E = 20;
    public static final String BLACK_BOX_KV120A_E_SYSOBJID = "1.3.6.1.4.1.10418.3.1.10";
    public static final int BLACK_BOX_KV121A_E = 21;
    public static final String BLACK_BOX_KV121A_E_SYSOBJID = "1.3.6.1.4.1.10418.3.1.11";
    public static final int FSC_KVM_s21611 = 22;
    public static final String FSC_KVM_s21611_SYSOBJID = "1.3.6.1.4.1.10418.3.1.12";
    public static final int AVOCENT_CPS810 = 23;
    public static final String AVOCENT_CPS810_SYSOBJID = "1.3.6.1.4.1.10418.2.1.1";
    public static final int EQUINOX_CCM840 = 23;
    public static final String EQUINOX_CCM840_SYSOBJID = "1.3.6.1.4.1.544.8.1.1";
    public static final int EQUINOX_CCM1640 = 24;
    public static final String EQUINOX_CCM1640_SYSOBJID = "1.3.6.1.4.1.544.8.1.2";
    public static final int BLACK_BOX_KV129A_E = 25;
    public static final String BLACK_BOX_KV129A_E_SYSOBJID = "1.3.6.1.4.1.544.8.1.5";
    public static final int BLACK_BOX_KV119A_E = 26;
    public static final String BLACK_BOX_KV119A_E_SYSOBJID = "1.3.6.1.4.1.544.8.1.6";
    public static final int EQUINOX_CCM4850 = 27;
    public static final String EQUINOX_CCM4850_SYSOBJID = "1.3.6.1.4.1.544.8.1.3";
    public static final int EQUINOX_CCM850 = 28;
    public static final String EQUINOX_CCM850_SYSOBJID = "1.3.6.1.4.1.544.8.1.4";
    public static final int EQUINOX_CCM1650 = 29;
    public static final String EQUINOX_CCM1650_SYSOBJID = "1.3.6.1.4.1.544.8.1.7";
    public static final int DELL_NAUTILUS_2 = 30;
    public static final String DELL_NAUTILUS_2_SYSOBJID = "1.3.6.1.4.1.10418.3.1.14";
    public static final int DELL_NAUTILUS_4 = 31;
    public static final String DELL_NAUTILUS_4_SYSOBJID = "1.3.6.1.4.1.10418.3.1.15";
    public static final int IBM_RCM_NAUTILUS_2 = 32;
    public static final String IBM_RCM_NAUTILUS_2_SYSOBJID = "1.3.6.1.4.1.10418.3.1.16";
    public static final int IBM_RCM_NAUTILUS_4 = 33;
    public static final String IBM_RCM_NAUTILUS_4_SYSOBJID = "1.3.6.1.4.1.10418.3.1.17";
    public static final int CASCADE_SWITCH_1X10 = 34;
    public static final int HP_1600 = 35;
    public static final String HP_1600_SYSOBJID = "1.3.6.1.4.1.232.166.1.1";
    public static final int HP_4800 = 36;
    public static final String HP_4800_SYSOBJID = "1.3.6.1.4.1.232.166.1.2";
    public static final int HP_2x1x16 = 37;
    public static final String HP_2x1x16_SYSOBJID = "1.3.6.1.4.1.232.160.1.3";
    public static final int HP_4x1x16 = 38;
    public static final String HP_4x1x16_SYSOBJID = "1.3.6.1.4.1.232.160.1.4";
    public static final int FSC_KVM_s20411 = 39;
    public static final String FSC_KVM_s20411_SYSOBJID = "1.3.6.1.4.1.10418.3.1.18";
    public static final int FSC_KVM_s31621 = 40;
    public static final String FSC_KVM_s31621_SYSOBJID = "1.3.6.1.4.1.10418.3.1.19";
    public static final int FSC_KVM_s31641 = 41;
    public static final String FSC_KVM_s31641_SYSOBJID = "1.3.6.1.4.1.10418.3.1.20";
    public static final int GENERIC_DEVICE = Integer.MAX_VALUE;
    private static Hashtable m_htProductSysObjectIds = null;

    public static void main(String[] stringArray) {
        Object object;
        Closeable closeable;
        if (stringArray != null && stringArray.length > 0) {
            Products.displayProductsFile(stringArray[0]);
            return;
        }
        PrintWriter printWriter = null;
        try {
            closeable = new FileWriter("./PRODUCTS.DAT");
            object = new BufferedWriter((Writer)closeable);
            printWriter = new PrintWriter((Writer)object, true);
        }
        catch (IOException iOException) {
            Trace.logError((String)"Products:main", (String)"Unable to create output DAT file : PRODUCTS.DAT");
            return;
        }
        try {
            object = new FileReader("./Products.java");
            closeable = new BufferedReader((Reader)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.logError((String)"Products:main", (String)"Unable to open Products.java");
            return;
        }
        printWriter.println("###############################################################################");
        printWriter.println("# PRODUCTS.DAT");
        printWriter.println("# ");
        printWriter.println("# Auto Generated - DO NOT EDIT");
        printWriter.println("###############################################################################");
        try {
            String string;
            object = "// PRODUCT.DAT :";
            while (null != (string = ((BufferedReader)closeable).readLine())) {
                if (!(string = string.trim()).startsWith((String)object)) continue;
                String string2 = string.substring(((String)object).length());
                StringBuffer stringBuffer = new StringBuffer();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                String string5 = stringTokenizer.nextToken().trim();
                int n = string3.indexOf("=");
                String string6 = string3.substring(0, n);
                String string7 = string3.substring(n + 1);
                string7 = StringUtilities.toTwoByteAsciiHex((String)string7);
                string4 = StringUtilities.toTwoByteAsciiHex((String)string4);
                stringBuffer.append(string6);
                stringBuffer.append("=");
                stringBuffer.append(string7);
                stringBuffer.append(",");
                stringBuffer.append(string4);
                stringBuffer.append(",");
                stringBuffer.append(string5);
                printWriter.println(stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"Products:main", (String)("ERROR: " + exception.getMessage()));
            return;
        }
    }

    private static void displayProductsFile(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                Trace.logInfo((String)"Products:displayProductsFile", (String)("unable to open " + string));
                return;
            }
            Trace.logInfo((String)"Products:displayProductsFile", (String)("reading " + string));
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            Trace.logInfo((String)"Products:displayProductsFile", (String)"Properties successfully read");
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = properties.getProperty(string2);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                String string4 = stringTokenizer.nextToken().trim();
                String string5 = stringTokenizer.nextToken().trim();
                String string6 = stringTokenizer.nextToken().trim();
                string4 = StringUtilities.fromTwoByteAsciiHex((String)string4);
                string5 = StringUtilities.fromTwoByteAsciiHex((String)string5);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string2);
                stringBuffer.append("=");
                stringBuffer.append(string4);
                stringBuffer.append(",");
                stringBuffer.append(string5);
                stringBuffer.append(",");
                stringBuffer.append(string6);
                System.out.println(stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"Products:displayProductsFile", (String)("ERROR: " + exception.getMessage()));
            return;
        }
    }

    public static int getProductIDForModelType(int n) throws ExceptionNoValue {
        switch (n) {
            case 9: {
                return 1;
            }
            case 10: {
                return 2;
            }
            case 11: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 12: {
                return 6;
            }
            case 13: {
                return 7;
            }
            case 14: {
                return 20;
            }
            case 15: {
                return 21;
            }
            case 16: {
                return 22;
            }
            case 34: {
                return 23;
            }
            case 35: {
                return 24;
            }
            case 22: {
                return 25;
            }
            case 23: {
                return 26;
            }
            case 36: {
                return 27;
            }
            case 37: {
                return 28;
            }
            case 38: {
                return 29;
            }
            case 57: {
                return 30;
            }
            case 58: {
                return 31;
            }
            case 59: {
                return 32;
            }
            case 60: {
                return 33;
            }
            case 52: {
                return 35;
            }
            case 53: {
                return 36;
            }
            case 66: {
                return 37;
            }
            case 67: {
                return 38;
            }
            case 72: {
                return 39;
            }
            case 73: {
                return 40;
            }
            case 74: {
                return 41;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static int getProductIDForSysObjectId(String string) {
        Integer n;
        if (string == null || string.length() <= 0) {
            return Integer.MAX_VALUE;
        }
        if (m_htProductSysObjectIds == null) {
            m_htProductSysObjectIds = new Hashtable();
            m_htProductSysObjectIds.put(EQUINOX_CCM840_SYSOBJID, new Integer(23));
            m_htProductSysObjectIds.put(EQUINOX_CCM1640_SYSOBJID, new Integer(24));
            m_htProductSysObjectIds.put(AVOCENT_A1000R_SYSOBJID, new Integer(1));
            m_htProductSysObjectIds.put(AVOCENT_A2000R_SYSOBJID, new Integer(2));
            m_htProductSysObjectIds.put(AVOCENT_A4000R_SYSOBJID, new Integer(3));
            m_htProductSysObjectIds.put(HP_1x1x16_SYSOBJID, new Integer(4));
            m_htProductSysObjectIds.put(HP_3x1x16_SYSOBJID, new Integer(5));
            m_htProductSysObjectIds.put(DELL_2161DS_SYSOBJID, new Integer(6));
            m_htProductSysObjectIds.put(IBM_RCM2161_SYSOBJID, new Integer(7));
            m_htProductSysObjectIds.put(BLACK_BOX_KV120A_E_SYSOBJID, new Integer(20));
            m_htProductSysObjectIds.put(BLACK_BOX_KV121A_E_SYSOBJID, new Integer(21));
            m_htProductSysObjectIds.put(FSC_KVM_s21611_SYSOBJID, new Integer(22));
            m_htProductSysObjectIds.put(BLACK_BOX_KV129A_E_SYSOBJID, new Integer(25));
            m_htProductSysObjectIds.put(BLACK_BOX_KV119A_E_SYSOBJID, new Integer(26));
            m_htProductSysObjectIds.put(EQUINOX_CCM4850_SYSOBJID, new Integer(27));
            m_htProductSysObjectIds.put(EQUINOX_CCM850_SYSOBJID, new Integer(28));
            m_htProductSysObjectIds.put(EQUINOX_CCM1650_SYSOBJID, new Integer(29));
            m_htProductSysObjectIds.put(DELL_NAUTILUS_2_SYSOBJID, new Integer(30));
            m_htProductSysObjectIds.put(DELL_NAUTILUS_4_SYSOBJID, new Integer(31));
            m_htProductSysObjectIds.put(IBM_RCM_NAUTILUS_2_SYSOBJID, new Integer(32));
            m_htProductSysObjectIds.put(IBM_RCM_NAUTILUS_4_SYSOBJID, new Integer(33));
            m_htProductSysObjectIds.put(HP_1600_SYSOBJID, new Integer(35));
            m_htProductSysObjectIds.put(HP_4800_SYSOBJID, new Integer(36));
            m_htProductSysObjectIds.put(HP_2x1x16_SYSOBJID, new Integer(37));
            m_htProductSysObjectIds.put(HP_4x1x16_SYSOBJID, new Integer(38));
            m_htProductSysObjectIds.put(FSC_KVM_s20411_SYSOBJID, new Integer(39));
            m_htProductSysObjectIds.put(FSC_KVM_s31621_SYSOBJID, new Integer(40));
            m_htProductSysObjectIds.put(FSC_KVM_s31641_SYSOBJID, new Integer(41));
        }
        if ((n = (Integer)m_htProductSysObjectIds.get(string)) == null) {
            return Integer.MAX_VALUE;
        }
        return n;
    }

    public static boolean isCCMx50Family(int n) {
        return n == 28 || n == 29 || n == 27 || n == 35 || n == 36;
    }

    public static boolean isNautilusFamily(int n) {
        return n == 30 || n == 31 || n == 32 || n == 33 || n == 37 || n == 38 || n == 39 || n == 40 || n == 41;
    }

    public static boolean requiresStrongEncryption(int n) {
        return n == 4 || n == 5 || n == 37 || n == 38 || n == 35 || n == 36 || n == 6 || n == 30 || n == 31;
    }

    public static boolean hasUserAdminUserLevel(int n) {
        return n != 4 && n != 37 && n != 5 && n != 38;
    }
}

