/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.avworks.services.ProductInfo;
import com.avocent.lib.database.DBaseRequestQueryResults;
import com.avocent.lib.database.DatabaseUtilities;
import com.avocent.lib.database.DefaultTableDefinition;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.database.TableDefinition;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.util.StringUtilities;
import java.sql.Connection;
import java.util.Vector;

public class ProductsDb {
    protected static DefaultTableDefinition m_tdTableDefinition = new DefaultTableDefinition("PRODUCTS");
    public static final String PRODUCTS = "PRODUCTS";
    public static final String ID = "ID";
    public static final String NAME = "NAME";
    public static final String VENDOR = "VENDOR";
    public static final String NMMID = "NMMID";
    public static final String ADD = "ADD";
    public static final String OPTION1 = "OPTION1";
    public static final String OPTION2 = "OPTION2";

    public static TableDefinition getTableDefinition() {
        return m_tdTableDefinition;
    }

    public static int getCount() throws ExceptionRequestFailed {
        String string = "SELECT COUNT(ID) FROM PRODUCTS";
        int n = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logError((String)"ProductsDb:getCount", (String)"Unable to read maximum PRODUCT ID");
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        return n2;
    }

    public static ProductInfo getProductInfo(int n) throws ExceptionRequestFailed, ExceptionNoValue {
        String string = "SELECT * FROM PRODUCTS WHERE (ID=" + Integer.toString(n) + ");";
        int n2 = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logInfo((String)"ProductsDb.getProductInfo", (String)"No value was available");
            throw new ExceptionNoValue();
        }
        dBaseRequestQueryResults.nextRow();
        int n3 = dBaseRequestQueryResults.getInt(ID);
        String string2 = dBaseRequestQueryResults.getString(VENDOR);
        String string3 = dBaseRequestQueryResults.getString(NAME);
        int n4 = dBaseRequestQueryResults.getInt(NMMID);
        int n5 = dBaseRequestQueryResults.getInt(ADD);
        int n6 = dBaseRequestQueryResults.getInt(OPTION1);
        String string4 = dBaseRequestQueryResults.getString(OPTION2);
        boolean bl = false;
        if (n5 == 1) {
            bl = true;
        }
        boolean bl2 = false;
        if (n6 == 1) {
            bl2 = true;
        }
        try {
            string2 = StringUtilities.fromTwoByteAsciiHex((String)string2);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            // empty catch block
        }
        try {
            string3 = StringUtilities.fromTwoByteAsciiHex((String)string3);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            // empty catch block
        }
        ProductInfo productInfo = new ProductInfo(n3, string2, ProductsDb.determineDisplayName(n3, string3), string3, n4, bl, bl2, string4);
        return productInfo;
    }

    public static ProductInfo[] getProductList() throws ExceptionRequestFailed, ExceptionNoValue {
        return ProductsDb.getProductList(null);
    }

    public static ProductInfo[] getProductList(String string) throws ExceptionRequestFailed, ExceptionNoValue {
        Object[] objectArray;
        int n;
        int n2 = ProductsDb.getCount();
        if (n2 == 0) {
            Trace.logInfo((String)"ProductsDb.getProductList", (String)"No values were available");
            throw new ExceptionNoValue();
        }
        Vector<ProductInfo> vector = new Vector<ProductInfo>();
        String string2 = string == null || string.length() == 0 ? "SELECT * FROM PRODUCTS;" : "SELECT * FROM PRODUCTS " + string + ";";
        int n3 = DatabaseSession.executeQuery(string2);
        while ((n = (objectArray = DatabaseSession.getQueryResults(n3, 3)).getRowCount()) != 0) {
            for (int i = 1; i <= n; ++i) {
                objectArray.nextRow();
                int n4 = objectArray.getInt(ID);
                String string3 = objectArray.getString(VENDOR);
                String string4 = objectArray.getString(NAME);
                int n5 = objectArray.getInt(NMMID);
                int n6 = objectArray.getInt(ADD);
                int n7 = objectArray.getInt(OPTION1);
                String string5 = objectArray.getString(OPTION2);
                boolean bl = false;
                if (n6 == 1) {
                    bl = true;
                }
                boolean bl2 = false;
                if (n7 == 1) {
                    bl2 = true;
                }
                try {
                    string3 = StringUtilities.fromTwoByteAsciiHex((String)string3);
                }
                catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                    // empty catch block
                }
                try {
                    string4 = StringUtilities.fromTwoByteAsciiHex((String)string4);
                }
                catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                    // empty catch block
                }
                ProductInfo productInfo = new ProductInfo(n4, string3, ProductsDb.determineDisplayName(n4, string4), string4, n5, bl, bl2, string5);
                vector.add(productInfo);
            }
            if (objectArray.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n3);
        if (vector.size() == 0) {
            Trace.logInfo((String)"ProductsDb.getProductList", (String)"No values were available");
            throw new ExceptionNoValue();
        }
        objectArray = new ProductInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean createProductsTable() {
        try {
            Trace.logInfo((String)"ProductsDb", (String)"Creating PRODUCTS table");
            DatabaseUtilities.createTable((TableDefinition)m_tdTableDefinition, (Connection)AVWorksService.getConnection());
            return true;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"ProductsDb", (String)"Failed to create PRODUCTS table");
            return false;
        }
    }

    public static void modify(ProductInfo productInfo) throws ExceptionRequestFailed {
        Trace.logInfo((String)"ProductsDb:modify", (String)("Product=" + productInfo.getName()));
        if (productInfo == null) {
            Trace.logError((String)"ProductsDb:add", (String)"Invalid argument");
            throw new ExceptionRequestFailed();
        }
        int n = productInfo.isAddAllowed() ? 1 : 0;
        int n2 = productInfo.isEnabled() ? 1 : 0;
        String string = productInfo.getVendor();
        try {
            string = StringUtilities.toTwoByteAsciiHex((String)string);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            // empty catch block
        }
        String string2 = productInfo.getInternalName();
        try {
            string2 = StringUtilities.toTwoByteAsciiHex((String)string2);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("UPDATE PRODUCTS SET ");
            stringBuffer.append("ID=" + Integer.toString(productInfo.getID()) + ",");
            stringBuffer.append("VENDOR=" + SqlCmd.quote((String)string) + ",");
            stringBuffer.append("NAME=" + SqlCmd.quote((String)string2) + ",");
            stringBuffer.append("NMMID=" + Integer.toString(productInfo.getNmmID()) + ",");
            stringBuffer.append("ADD=" + Integer.toString(n) + ",");
            stringBuffer.append("OPTION1=" + Integer.toString(n2) + ",");
            stringBuffer.append("OPTION2=" + SqlCmd.quote((String)ProductInfo.getDisplayableHashValue(productInfo.getID() + "ENABLED")) + " ");
            stringBuffer.append(" WHERE (ID=" + Integer.toString(productInfo.getID()) + ");");
        }
        catch (Exception exception) {
            Trace.logError((String)"ProductsDb:modify", (String)"ERROR : SQL request to modify Products table failed.");
            throw new ExceptionRequestFailed();
        }
        int n3 = DatabaseSession.executeUpdate(stringBuffer.toString());
        if (n3 >= 1) {
            return;
        }
        Trace.logError((String)"ProductsDb.modify", (String)"ERROR : The product was not found");
        throw new ExceptionRequestFailed();
    }

    public static String determineDisplayName(int n, String string) {
        String string2 = string;
        if (n == Integer.MAX_VALUE) {
            string2 = AVWorksBranding.getString("productGenericApplianceName", string);
        }
        return string2;
    }

    static {
        m_tdTableDefinition.addColumn(ID, "INTEGER", null, true);
        m_tdTableDefinition.addColumn(VENDOR, "VARCHAR", null);
        m_tdTableDefinition.addColumn(NAME, "VARCHAR", null);
        m_tdTableDefinition.addColumn(NMMID, "INTEGER", null);
        m_tdTableDefinition.addColumn(ADD, "INTEGER", null);
        m_tdTableDefinition.addColumn(OPTION1, "INTEGER", null);
        m_tdTableDefinition.addColumn(OPTION2, "VARCHAR", null);
    }
}

