/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.CommonDatabasePropertyKeys;
import com.avocent.avworks.services.InterfaceAVWorksNMM;
import com.avocent.avworks.services.NmmDb;
import com.avocent.avworks.services.ServerPropertiesDb;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.util.Iterator;

public class ServerInfo
extends UnitInfo
implements CommonDatabasePropertyKeys {
    public static final String DEFAULT_ICON = "/com/avocent/avworks/explorer/defaultserver16.gif";
    private int m_nAppIndex = -1;

    public ServerInfo(int n, String string, String string2, String string3, int n2) {
        super(n, string, string2, string3, "");
        this.m_nAppIndex = n2;
    }

    public ServerInfo(ServerInfo serverInfo) {
        super(serverInfo, DEFAULT_ICON);
    }

    public boolean isAppliance() {
        return false;
    }

    protected String getDefaultIcon() {
        return DEFAULT_ICON;
    }

    public void setType(String string) {
        this.doSetType(string);
    }

    public boolean isPropertySupported(String string) {
        Iterator iterator = NmmDb.iterateNmms();
        if (iterator == null) {
            Trace.logError((String)"ServerInfo.isPropertySupported", (String)"Null Iterator of NMMs returned");
            return false;
        }
        while (iterator.hasNext()) {
            InterfaceAVWorksNMM interfaceAVWorksNMM = (InterfaceAVWorksNMM)iterator.next();
            try {
                if (!interfaceAVWorksNMM.isPropertySupported(this.getID(), "Device", string)) continue;
                return true;
            }
            catch (Exception exception) {
                Trace.logInfo((String)"ServerInfo.isPropertySupported", (String)("Exception " + exception.toString()));
            }
        }
        return false;
    }

    public String getAddress() {
        try {
            return ServerPropertiesDb.getStringValue(this.getID(), "TELNET_IP", "");
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ServerInfo.getAddress", (String)(exceptionRequestFailed.getMessage() + ": returning ''"));
            return "";
        }
    }

    public void setAddress(String string) throws ExceptionRequestFailed {
        super.setAddress(string);
        ServerPropertiesDb.setValue(this.getID(), "TELNET_IP", string);
    }

    public int getTelnetPort() {
        try {
            return ServerPropertiesDb.getIntegerValue(this.getID(), "TELNET_PORT", 0);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.logInfo((String)"ServerInfo.getTelnetPort", (String)("found bogus port# " + numberFormatException.getMessage() + ": returning 0"));
            return 0;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ServerInfo.getTelnetPort", (String)(exceptionRequestFailed.getMessage() + ": returning 0"));
            return 0;
        }
    }

    public void setTelnetPort(int n) throws ExceptionRequestFailed {
        if (n == 0) {
            ServerPropertiesDb.removeValue(this.getID(), "TELNET_PORT");
        } else {
            ServerPropertiesDb.setValue(this.getID(), "TELNET_PORT", n);
        }
    }

    public boolean getUseDefaultTelnet() {
        try {
            return ServerPropertiesDb.getBooleanValue(this.getID(), "TELNET_USE_DEFAULT", true);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ServerInfo.getUseDefaultTelnet", (String)"DB Request failed: returning true by default");
            return true;
        }
    }

    public void setUseDefaultTelnet(boolean bl) throws ExceptionRequestFailed {
        ServerPropertiesDb.setValue(this.getID(), "TELNET_USE_DEFAULT", bl);
    }

    public boolean getUseBuiltinTelnet() {
        try {
            return ServerPropertiesDb.getBooleanValue(this.getID(), "TELNET_USE_BUILTIN", true);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ServerInfo.getUseBuiltintTelnet", (String)"DB Request failed: returning true by default");
            return true;
        }
    }

    public void setUseBuiltinTelnet(boolean bl) throws ExceptionRequestFailed {
        ServerPropertiesDb.setValue(this.getID(), "TELNET_USE_BUILTIN", bl);
    }

    public boolean getTelnetLoginWindow() {
        try {
            return ServerPropertiesDb.getBooleanValue(this.getID(), "TELNET_SHOW_LOGIN_WINDOW", false);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ServerInfo.getUseBuiltintTelnet", (String)"DB Request failed: returning false by default");
            return false;
        }
    }

    public void setTelnetLoginWindow(boolean bl) throws ExceptionRequestFailed {
        ServerPropertiesDb.setValue(this.getID(), "TELNET_SHOW_LOGIN_WINDOW", bl);
    }

    public String getTelnetApplicationPath() {
        try {
            return ServerPropertiesDb.getStringValue(this.getID(), "TELNET_APPLICATION", null);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ServerInfo.getTelnetApplicationPath", (String)"DB Request failed: returning null by default");
            return null;
        }
    }

    public void setTelnetApplicationPath(String string) throws ExceptionRequestFailed {
        ServerPropertiesDb.setValue(this.getID(), "TELNET_APPLICATION", string);
    }

    public String getTelnetCommandLineArgs() {
        try {
            return ServerPropertiesDb.getStringValue(this.getID(), "TELNET_APPLICATION_ARGS", null);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ServerInfo.getTelnetCommandLineArgs", (String)"DB Request failed: returning null by default");
            return null;
        }
    }

    public void setTelnetCommandLineArgs(String string) throws ExceptionRequestFailed {
        ServerPropertiesDb.setValue(this.getID(), "TELNET_APPLICATION_ARGS", string);
    }

    public boolean getTelnetLaunchCommandWindow() {
        try {
            return ServerPropertiesDb.getBooleanValue(this.getID(), "TELNET_LAUNCH_IN_WINDOW", false);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ServerInfo.getTelnetLaunchCommandWindow", (String)"DB Request failed: returning false by default");
            return false;
        }
    }

    public void setTelnetLaunchCommandWindow(boolean bl) throws ExceptionRequestFailed {
        ServerPropertiesDb.setValue(this.getID(), "TELNET_LAUNCH_IN_WINDOW", bl);
    }

    public int getApplianceIndex(int n) {
        if (this.m_nAppIndex < 0) {
            try {
                this.m_nAppIndex = ServerPropertiesDb.getIntegerValue(this.getID(), "APP_INDEX_" + n, -1);
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logInfo((String)"ServerInfo.getApplianceIndex", (String)"DB Request failed: returning -1 by default");
                return -1;
            }
        }
        return this.m_nAppIndex;
    }

    public void setApplianceIndex(int n, int n2) throws ExceptionRequestFailed {
        if (n2 >= 0) {
            ServerPropertiesDb.setValue(this.getID(), "APP_INDEX_" + n, n2);
            this.m_nAppIndex = n2;
        }
    }
}

