/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.lib.database.DBaseRequestQueryResults;
import com.avocent.lib.database.DatabaseUtilities;
import com.avocent.lib.database.DefaultTableDefinition;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.database.TableDefinition;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.sql.Connection;

public class ServerPropertiesDb {
    protected static DefaultTableDefinition m_tdTableDefinition = new DefaultTableDefinition("SERVER_PROPERTIES");
    public static final String SERVER_PROPERTIES = "SERVER_PROPERTIES";
    public static final String ID = "ID";
    public static final String SERVER_ID = "SERVER_ID";
    public static final String KEY = "KEY";
    public static final String VALUE = "VALUE";
    public static final String LOG_KEY = "ServerPropertiesDb";

    public static TableDefinition getTableDefinition() {
        return m_tdTableDefinition;
    }

    private static int add(int n, String string, String string2) throws ExceptionRequestFailed {
        if (ServerPropertiesDb.isPropertyDefined(n, string)) {
            Trace.logError((String)"ServerPropertiesDb:add", (String)"ERROR : Property already exists");
            throw new ExceptionRequestFailed();
        }
        return ServerPropertiesDb.doAdd(n, string, string2);
    }

    private static int doAdd(int n, String string, String string2) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0) {
            Trace.logError((String)"ServerPropertiesDb:add", (String)"ERROR : Invalid key argument");
            throw new ExceptionRequestFailed();
        }
        int n2 = 1;
        try {
            n2 = ServerPropertiesDb.getMaxID() + 1;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)LOG_KEY, (String)"NOTE: Unable to obtain max property ID");
        }
        for (int i = n2; i < n2 + 5; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO SERVER_PROPERTIES ");
            stringBuffer.append("( ");
            stringBuffer.append("ID, ");
            stringBuffer.append("SERVER_ID, ");
            stringBuffer.append("KEY, ");
            stringBuffer.append("VALUE ");
            stringBuffer.append(") ");
            stringBuffer.append("VALUES");
            stringBuffer.append("( ");
            stringBuffer.append(Integer.toString(i) + ", ");
            stringBuffer.append(Integer.toString(n) + ", ");
            stringBuffer.append(SqlCmd.quote((String)string) + ", ");
            stringBuffer.append(SqlCmd.quote((String)string2) + " ");
            stringBuffer.append(");");
            int n3 = DatabaseSession.executeUpdate(stringBuffer.toString());
            if (n3 != 1) continue;
            return i;
        }
        Trace.logError((String)"ServerPropertiesDb:add", (String)"ERROR : Exceeded maximum retries");
        throw new ExceptionRequestFailed();
    }

    public static void removeValue(int n, String string) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0) {
            Trace.logError((String)LOG_KEY, (String)"ERROR : Invalid key argument");
            throw new ExceptionRequestFailed();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM SERVER_PROPERTIES WHERE ");
        stringBuffer.append("SERVER_ID = ");
        stringBuffer.append(Integer.toString(n) + " ");
        stringBuffer.append("AND KEY = ");
        stringBuffer.append(SqlCmd.quote((String)string) + ";");
        int n2 = DatabaseSession.executeUpdate(stringBuffer.toString());
        if (n2 <= 0) {
            throw new ExceptionRequestFailed();
        }
        if (n2 > 1) {
            Trace.logError((String)"ServerPropertiesDb.removeValue", (String)("There was more than one record in ServerDB with ID = " + n + " and Key = '" + string + "'"));
        }
    }

    public static void removeExistingValue(int n, String string) {
        try {
            ServerPropertiesDb.removeValue(n, string);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            // empty catch block
        }
    }

    public static void removeAllValues(int n) throws ExceptionRequestFailed {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM SERVER_PROPERTIES WHERE ");
        stringBuffer.append("SERVER_ID = ");
        stringBuffer.append(Integer.toString(n) + ";");
        DatabaseSession.executeUpdate(stringBuffer.toString());
    }

    public static boolean isPropertyDefined(int n, String string) throws ExceptionRequestFailed {
        Trace.logInfo((String)LOG_KEY, (String)("ServerID=" + n));
        if (string == null || string.length() == 0) {
            Trace.logError((String)"ServerPropertiesDb:isPropertyDefined", (String)"ERROR : Invalid key argument");
            throw new ExceptionRequestFailed();
        }
        Trace.logInfo((String)LOG_KEY, (String)("KEY=" + string));
        String string2 = "SELECT KEY FROM SERVER_PROPERTIES WHERE (KEY=" + SqlCmd.quote((String)string) + ")" + " AND" + " (SERVER_ID=" + Integer.toString(n) + ");";
        Trace.logInfo((String)LOG_KEY, (String)("SQL QUERY=" + string2));
        int n2 = DatabaseSession.executeQuery(string2);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() > 0) {
            Trace.logInfo((String)LOG_KEY, (String)"Key exists");
            return true;
        }
        Trace.logInfo((String)LOG_KEY, (String)"Key eoes NOT exist");
        return false;
    }

    private static int getMaxID() throws ExceptionRequestFailed {
        String string = "SELECT MAX(ID) FROM SERVER_PROPERTIES";
        int n = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            throw new ExceptionRequestFailed("Unable to read maximum property ID");
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        return n2;
    }

    private static int getCount() throws ExceptionRequestFailed {
        String string = "SELECT COUNT(ID) FROM SERVER_PROPERTIES";
        int n = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logError((String)"ServerPropertiesDb:getCount", (String)"ERROR : Unable to read max property count");
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        return n2;
    }

    public static void setValue(int n, String string, String string2) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0) {
            Trace.logError((String)"ServerPropertiesDb.setValue", (String)"ERROR : Invalid key argument");
            throw new ExceptionRequestFailed();
        }
        if (!ServerPropertiesDb.isPropertyDefined(n, string)) {
            Trace.logInfo((String)"ServerPropertiesDb:setValue", (String)"NOTE: Property doesn't exist - Calling add");
            ServerPropertiesDb.doAdd(n, string, string2);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE SERVER_PROPERTIES SET ");
        stringBuffer.append("VALUE=" + SqlCmd.quote((String)string2) + " ");
        stringBuffer.append(" WHERE (KEY=" + SqlCmd.quote((String)string) + ")");
        stringBuffer.append(" AND");
        stringBuffer.append(" (SERVER_ID=" + Integer.toString(n) + ");");
        int n2 = DatabaseSession.executeUpdate(stringBuffer.toString());
        if (n2 >= 1) {
            return;
        }
        Trace.logError((String)"ServerPropertiesDb:setValue", (String)"ERROR : The property was not found");
        throw new ExceptionRequestFailed();
    }

    public static void setValue(int n, String string, int n2) throws ExceptionRequestFailed {
        ServerPropertiesDb.setValue(n, string, Integer.toString(n2));
    }

    public static void setValue(int n, String string, boolean bl) throws ExceptionRequestFailed {
        Boolean bl2 = new Boolean(bl);
        ServerPropertiesDb.setValue(n, string, bl2.toString());
    }

    public static String getStringValue(int n, String string) throws ExceptionRequestFailed, ExceptionNoValue {
        Trace.logInfo((String)LOG_KEY, (String)("ServerID=" + n));
        if (string == null || string.length() == 0) {
            Trace.logError((String)"ServerPropertiesDb:getValue", (String)"ERROR : Invalid key argument");
            throw new ExceptionRequestFailed();
        }
        Trace.logInfo((String)LOG_KEY, (String)("Key=" + string));
        String string2 = "SELECT * FROM SERVER_PROPERTIES WHERE (KEY=" + SqlCmd.quote((String)string) + ")" + " AND" + " (SERVER_ID=" + Integer.toString(n) + ");";
        Trace.logInfo((String)LOG_KEY, (String)("SQK CMD=" + string2));
        int n2 = DatabaseSession.executeQuery(string2);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logInfo((String)LOG_KEY, (String)"NOTE : No value was available");
            throw new ExceptionNoValue();
        }
        dBaseRequestQueryResults.nextRow();
        String string3 = dBaseRequestQueryResults.getString(VALUE);
        Trace.logInfo((String)LOG_KEY, (String)("Value=" + string3));
        return string3;
    }

    public static String getStringValue(int n, String string, String string2) throws ExceptionRequestFailed {
        Trace.logInfo((String)LOG_KEY, (String)("ServerID=" + n));
        if (string == null || string.length() == 0) {
            Trace.logError((String)"ServerPropertiesDb:getValue", (String)"ERROR : Invalid key argument");
            throw new ExceptionRequestFailed();
        }
        Trace.logInfo((String)LOG_KEY, (String)("Key=" + string));
        String string3 = "SELECT * FROM SERVER_PROPERTIES WHERE (KEY=" + SqlCmd.quote((String)string) + ")" + " AND" + " (SERVER_ID=" + Integer.toString(n) + ");";
        Trace.logInfo((String)LOG_KEY, (String)("SQK CMD=" + string3));
        int n2 = DatabaseSession.executeQuery(string3);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logInfo((String)LOG_KEY, (String)"NOTE : No value was available");
            return string2;
        }
        dBaseRequestQueryResults.nextRow();
        String string4 = dBaseRequestQueryResults.getString(VALUE);
        Trace.logInfo((String)LOG_KEY, (String)("Value=" + string4));
        return string4 == null ? string2 : string4;
    }

    public static int getIntegerValue(int n, String string) throws NumberFormatException, ExceptionRequestFailed, ExceptionNoValue {
        String string2 = ServerPropertiesDb.getStringValue(n, string);
        return Integer.parseInt(string2);
    }

    public static int getIntegerValue(int n, String string, int n2) throws NumberFormatException, ExceptionRequestFailed {
        String string2 = ServerPropertiesDb.getStringValue(n, string, null);
        return string2 == null ? n2 : Integer.parseInt(string2);
    }

    public static boolean getBooleanValue(int n, String string) throws ExceptionRequestFailed, ExceptionNoValue {
        String string2 = ServerPropertiesDb.getStringValue(n, string);
        Boolean bl = new Boolean(string2);
        return bl;
    }

    public static boolean getBooleanValue(int n, String string, boolean bl) throws ExceptionRequestFailed {
        String string2 = ServerPropertiesDb.getStringValue(n, string, null);
        return string2 == null ? bl : new Boolean(string2);
    }

    public static boolean createServerPropertiesTable() {
        Trace.logInfo((String)LOG_KEY, (String)"Creating SERVER_PROPERTIES table");
        try {
            DatabaseUtilities.createTable((TableDefinition)m_tdTableDefinition, (Connection)AVWorksService.getConnection());
            return true;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)LOG_KEY, (String)"Failed to create SERVER_PROPERTIES table");
            return false;
        }
    }

    static {
        m_tdTableDefinition.addColumn(ID, "INTEGER", null, true);
        m_tdTableDefinition.addColumn(SERVER_ID, "INTEGER", null);
        m_tdTableDefinition.addColumn(KEY, "VARCHAR", null);
        m_tdTableDefinition.addColumn(VALUE, "VARCHAR", null);
    }
}

