/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.avworks.services.ServerInfo;
import com.avocent.avworks.services.Unit;
import com.avocent.lib.database.DBaseRequestQueryResults;
import com.avocent.lib.database.DatabaseUtilities;
import com.avocent.lib.database.DefaultTableDefinition;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.database.TableDefinition;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.sql.Connection;
import java.util.Vector;

public class ServersDb {
    protected static DefaultTableDefinition m_tdTableDefinition = new DefaultTableDefinition("SERVERS");
    public static final String SERVERS = "SERVERS";
    public static final String ID = "ID";
    public static final String NAME = "NAME";
    public static final String TYPE = "TYPE";
    public static final String ICON = "ICON";
    public static final String CUSTOM_FIELD1 = "CUSTOM_FIELD1";
    public static final String CUSTOM_FIELD2 = "CUSTOM_FIELD2";
    public static final String CUSTOM_FIELD3 = "CUSTOM_FIELD3";
    public static final String BROWSER_URL = "BROWSER_URL";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String CONTACT = "CONTACT";
    public static final String CONTACT_PHONE = "CONTACT_PHONE";
    public static final String COMMENT = "COMMENT";
    public static final String CACHED_CRED = "CACHED_CRED";
    public static final String APP_INDEX = "APP_INDEX";
    public static final int DB_NULL = -1;

    public static TableDefinition getTableDefinition() {
        return m_tdTableDefinition;
    }

    public static int add(ServerInfo serverInfo) throws ExceptionRequestFailed {
        if (serverInfo == null) {
            Trace.logError((String)"ServersDb:add", (String)"Invalid argument");
            throw new ExceptionRequestFailed();
        }
        Trace.logInfo((String)"ServersDb:add", (String)("Server=" + serverInfo.getName()));
        Trace.logInfo((String)"ServersDb:add", (String)("Type=" + serverInfo.getType()));
        String string = Unit.getUniqueName(serverInfo.getName());
        if (!string.equals(serverInfo.getName())) {
            serverInfo.setName(string);
        }
        Trace.logInfo((String)"ServersDb:add", (String)("Unique Server Name=" + string));
        int n = 1;
        try {
            n = ServersDb.getMaxID() + 1;
            Trace.logInfo((String)"ServersDb:add", (String)("Maximum Server ID is " + n));
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)"ServersDb:add", (String)"NOTE: Unable to obtain max ID");
        }
        for (int i = n; i < n + 5; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer.append("INSERT INTO SERVERS ");
                stringBuffer.append("( ");
                stringBuffer.append("ID, ");
                stringBuffer.append("NAME, ");
                stringBuffer.append("TYPE, ");
                stringBuffer.append("ICON, ");
                stringBuffer.append("CUSTOM_FIELD1, ");
                stringBuffer.append("CUSTOM_FIELD2, ");
                stringBuffer.append("CUSTOM_FIELD3, ");
                stringBuffer.append("BROWSER_URL, ");
                stringBuffer.append("DESCRIPTION, ");
                stringBuffer.append("CONTACT, ");
                stringBuffer.append("CONTACT_PHONE, ");
                stringBuffer.append("COMMENT, ");
                stringBuffer.append("CACHED_CRED, ");
                stringBuffer.append("APP_INDEX ");
                stringBuffer.append(") ");
                stringBuffer.append("VALUES");
                stringBuffer.append("( ");
                stringBuffer.append(Integer.toString(i) + ", ");
                stringBuffer.append(SqlCmd.quote((String)string) + ", ");
                stringBuffer.append(SqlCmd.quote((String)serverInfo.getType()) + ", ");
                stringBuffer.append(SqlCmd.quote((String)serverInfo.getIcon()) + ", ");
                stringBuffer.append(SqlCmd.quote((String)serverInfo.getCustomField(1)) + ", ");
                stringBuffer.append(SqlCmd.quote((String)serverInfo.getCustomField(2)) + ", ");
                stringBuffer.append(SqlCmd.quote((String)serverInfo.getCustomField(3)) + ", ");
                stringBuffer.append(SqlCmd.quote((String)serverInfo.getBrowserURL()) + ", ");
                stringBuffer.append(SqlCmd.quote((String)serverInfo.getDescription()) + ", ");
                stringBuffer.append(SqlCmd.quote((String)serverInfo.getContact()) + ", ");
                stringBuffer.append(SqlCmd.quote((String)serverInfo.getContactPhone()) + ", ");
                stringBuffer.append(SqlCmd.quote((String)serverInfo.getComment()) + ", ");
                stringBuffer.append(Integer.toString(serverInfo.getCredentialsCacheMode()) + ", ");
                stringBuffer.append("-1");
                stringBuffer.append(");");
            }
            catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                Trace.logError((String)"ServersDb:add", (String)"ERROR : Invalid Argument");
                continue;
            }
            Trace.logInfo((String)"ServersDb:add", (String)("Execute SQL=" + stringBuffer.toString()));
            int n2 = DatabaseSession.executeUpdate(stringBuffer.toString());
            if (n2 != 1) continue;
            return i;
        }
        Trace.logError((String)"ServersDb:add", (String)"ERROR : Exceeded maximum retries");
        throw new ExceptionRequestFailed();
    }

    public static int getCount() throws ExceptionRequestFailed {
        String string = "SELECT COUNT(ID) FROM SERVERS";
        int n = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logError((String)"ServersDb:getCount", (String)"ERROR:Unable to read maximum server ID");
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        return n2;
    }

    public static int getMaxID() throws ExceptionRequestFailed {
        String string = "SELECT MAX(ID) FROM SERVERS";
        int n = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        return n2;
    }

    public static boolean isNameDefined(String string) throws ExceptionRequestFailed {
        return ServersDb.isNameDefined(0, string);
    }

    public static boolean isNameDefined(int n, String string) throws ExceptionRequestFailed {
        Trace.logInfo((String)"ServersDb:isNameDefined", (String)("Name    =" + string));
        Trace.logInfo((String)"ServersDb:isNameDefined", (String)("IgnoreID=" + n));
        if (string == null || string.length() == 0) {
            Trace.logError((String)"ServersDb:isNameDefined", (String)"Invalid name argument");
            throw new ExceptionRequestFailed();
        }
        String string2 = "SELECT NAME FROM SERVERS WHERE (UPPER(NAME)=" + SqlCmd.quote((String)string.toUpperCase()) + ")" + " AND" + " (ID!=" + Integer.toString(n) + ");";
        Trace.logInfo((String)"ServersDb:isNameDefined", (String)("Execute SQL=" + string2));
        int n2 = DatabaseSession.executeQuery(string2);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() > 0) {
            Trace.logInfo((String)"ServersDb:isNameDefined", (String)"YES - Name exists");
            return true;
        }
        Trace.logInfo((String)"ServersDb:isNameDefined", (String)"NO - Name DOES NOT exist");
        return false;
    }

    public static boolean delete(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM SERVERS WHERE ID IN ( ");
        StringBuffer stringBuffer2 = new StringBuffer("DELETE FROM SERVER_CUSTOM_FOLDER_MAP WHERE SERVER_ID IN ( ");
        StringBuffer stringBuffer3 = new StringBuffer("DELETE FROM SERVER_PROPERTIES WHERE SERVER_ID IN ( ");
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (stringBuffer2.length() >= 118 || i == nArray.length - 1) {
                stringBuffer.append(nArray[i]);
                stringBuffer.append(" );");
                stringBuffer2.append(nArray[i]);
                stringBuffer2.append(" );");
                stringBuffer3.append(nArray[i]);
                stringBuffer3.append(" );");
                try {
                    Trace.logInfo((String)"ServersDb:delete", (String)"Deleting Servers ");
                    Trace.logInfo((String)"ServersDb:delete", (String)stringBuffer.toString());
                    int n = DatabaseSession.executeUpdate(stringBuffer.toString());
                    Trace.logInfo((String)"ServersDb:delete", (String)("Servers Deleted =" + n));
                    if (n > 0) {
                        try {
                            Trace.logInfo((String)"ServersDb:delete", (String)"Deleting Server Folder Mappings");
                            Trace.logInfo((String)"ServersDb:delete", (String)stringBuffer2.toString());
                            n = DatabaseSession.executeUpdate(stringBuffer2.toString());
                            Trace.logInfo((String)"ServersDb:delete", (String)("Folder Mappings Deleted =" + n));
                            Trace.logInfo((String)"ServersDb:delete", (String)"Deleting Session Properties associated with server");
                            Trace.logInfo((String)"ServersDb:delete", (String)stringBuffer3.toString());
                            n = DatabaseSession.executeUpdate(stringBuffer3.toString());
                            Trace.logInfo((String)"ServersDb:delete", (String)("Session Properties Deleted =" + n));
                        }
                        catch (Exception exception) {
                            Trace.logInfo((String)"ServersDb:delete", (String)"Failed Server Information Delete");
                        }
                    } else {
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    Trace.logError((String)"ServersDb:delete", (String)"Failed Server Delete", (Throwable)exception);
                    return false;
                }
                stringBuffer = null;
                stringBuffer = new StringBuffer("DELETE FROM SERVERS WHERE ID IN ( ");
                stringBuffer2 = null;
                stringBuffer2 = new StringBuffer("DELETE FROM SERVER_CUSTOM_FOLDER_MAP WHERE SERVER_ID IN ( ");
                stringBuffer3 = null;
                stringBuffer3 = new StringBuffer("DELETE FROM SERVER_PROPERTIES WHERE SERVER_ID IN ( ");
                continue;
            }
            stringBuffer.append(nArray[i]);
            stringBuffer.append(", ");
            stringBuffer2.append(nArray[i]);
            stringBuffer2.append(", ");
            stringBuffer3.append(nArray[i]);
            stringBuffer3.append(", ");
        }
        return bl;
    }

    public static void modify(ServerInfo serverInfo) throws ExceptionRequestFailed {
        Trace.logInfo((String)"ServersDb:modify", (String)("ID =" + serverInfo.getID()));
        Trace.logInfo((String)"ServersDb:modify", (String)("Server=" + serverInfo.getName()));
        Trace.logInfo((String)"ServersDb:modify", (String)("Type=" + serverInfo.getType()));
        if (serverInfo == null) {
            Trace.logError((String)"ServersDb:add", (String)"Invalid argument");
            throw new ExceptionRequestFailed();
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("UPDATE SERVERS SET ");
            stringBuffer.append("NAME=" + SqlCmd.quote((String)serverInfo.getName()) + ",");
            stringBuffer.append("TYPE=" + SqlCmd.quote((String)serverInfo.getType()) + ",");
            stringBuffer.append("ICON=" + SqlCmd.quote((String)serverInfo.getIcon()) + ",");
            stringBuffer.append("CUSTOM_FIELD1=" + SqlCmd.quote((String)serverInfo.getCustomField(1)) + ",");
            stringBuffer.append("CUSTOM_FIELD2=" + SqlCmd.quote((String)serverInfo.getCustomField(2)) + ",");
            stringBuffer.append("CUSTOM_FIELD3=" + SqlCmd.quote((String)serverInfo.getCustomField(3)) + ",");
            stringBuffer.append("BROWSER_URL=" + SqlCmd.quote((String)serverInfo.getBrowserURL()) + ",");
            stringBuffer.append("DESCRIPTION=" + SqlCmd.quote((String)serverInfo.getDescription()) + ",");
            stringBuffer.append("CONTACT=" + SqlCmd.quote((String)serverInfo.getContact()) + ",");
            stringBuffer.append("CONTACT_PHONE=" + SqlCmd.quote((String)serverInfo.getContactPhone()) + ",");
            stringBuffer.append("COMMENT=" + SqlCmd.quote((String)serverInfo.getComment()) + ",");
            stringBuffer.append("CACHED_CRED=" + Integer.toString(serverInfo.getCredentialsCacheMode()) + " ");
            stringBuffer.append(" WHERE (ID=" + Integer.toString(serverInfo.getID()) + ");");
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Trace.logError((String)"ServersDb:modify", (String)"ERROR : Invalid Argument");
            throw new ExceptionRequestFailed();
        }
        int n = DatabaseSession.executeUpdate(stringBuffer.toString());
        if (n >= 1) {
            return;
        }
        Trace.logError((String)"ServersDb.modify", (String)"ERROR : The server was not found");
        throw new ExceptionRequestFailed();
    }

    public static void rename(int n, String string) throws ExceptionRequestFailed {
        ServersDb.rename(n, string, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean rename(int n, String string, boolean bl) throws ExceptionRequestFailed {
        if (string == null) {
            Trace.logError((String)"ServersDb:rename", (String)"ERROR:Invalid name argument");
            throw new ExceptionRequestFailed();
        }
        String string2 = "";
        if (ServersDb.isNameDefined(n, string) || AppliancesDb.isNameDefined(string)) {
            if (!bl) {
                Trace.logInfo((String)"ServersDb:rename", (String)"Server not renamed, conflict and making unique not allowed");
                return false;
            }
            string2 = Unit.getUniqueName(string);
        } else {
            string2 = string;
        }
        Trace.logInfo((String)"ServersDb:rename", (String)("Unique Server Name=" + string2));
        String string3 = "UPDATE SERVERS SET NAME=" + SqlCmd.quote((String)string2) + " WHERE (ID=" + Integer.toString(n) + ");";
        int n2 = DatabaseSession.executeUpdate(string3);
        if (n2 >= 1) {
            return true;
        }
        Trace.logError((String)"ServersDb:rename", (String)"ERROR:The old name was not found");
        throw new ExceptionRequestFailed();
    }

    public static ServerInfo getServerInfo(int n) throws ExceptionRequestFailed, ExceptionNoValue {
        String string = "SELECT * FROM SERVERS WHERE (ID=" + Integer.toString(n) + ");";
        int n2 = DatabaseSession.executeQuery(string);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logInfo((String)"ServersDb:getServerInfo", (String)"No value was available");
            throw new ExceptionNoValue();
        }
        dBaseRequestQueryResults.nextRow();
        return ServersDb.createServerInfo(dBaseRequestQueryResults);
    }

    public static ServerInfo getServerInfo(int n, int n2) throws ExceptionRequestFailed {
        String string = Integer.toString(n);
        String string2 = Integer.toString(n2);
        String string3 = Integer.toString(1);
        String string4 = "SELECT " + m_tdTableDefinition.getColumnsString() + " FROM SERVERS, INTERFACES " + " WHERE ( APPLIANCE_ID=" + string + " AND PORT_NUM=" + string2 + " and CONN_TYPE=" + string3 + " AND SERVERS." + ID + "=INTERFACES.CONN_ID )";
        int n3 = DatabaseSession.executeQuery(string4);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n3, 1);
        DatabaseSession.closeQuery(n3);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logInfo((String)"ServersDb:getServerInfo", (String)"No value was available");
            return null;
        }
        dBaseRequestQueryResults.nextRow();
        return ServersDb.createServerInfo(dBaseRequestQueryResults);
    }

    public static ServerInfo getServerInfo(String string, int n) throws ExceptionRequestFailed {
        String string2 = Integer.toString(n);
        String string3 = Integer.toString(1);
        String string4 = null;
        if (n == 0) {
            string4 = "SELECT " + m_tdTableDefinition.getColumnsString() + " FROM SERVERS, INTERFACES as LI" + " WHERE ( LI.NAME=" + SqlCmd.quote((String)string) + " AND CONN_TYPE=" + string3 + " AND SERVERS." + ID + "= LI.CONN_ID )";
        } else {
            string3 = Integer.toString(2);
            string4 = "SELECT " + m_tdTableDefinition.getColumnsString() + " FROM SERVERS, INTERFACES as L1, INTERFACES as L2" + " WHERE ( L1.NAME=" + SqlCmd.quote((String)string) + " AND L1.CONN_TYPE=" + string3 + " AND L1.CONN_ID = L2.APPLIANCE_ID" + " AND L2.PORT_NUM=" + string2 + " AND SERVERS." + ID + "= L2.CONN_ID )";
        }
        int n2 = DatabaseSession.executeQuery(string4);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            Trace.logInfo((String)"ServersDb:getServerInfo", (String)"No value was available");
            return null;
        }
        dBaseRequestQueryResults.nextRow();
        return ServersDb.createServerInfo(dBaseRequestQueryResults);
    }

    public static int getServerId(String string) throws ExceptionRequestFailed {
        String string2 = "SELECT ID FROM SERVERS WHERE (NAME=" + SqlCmd.quote((String)string) + ");";
        int n = DatabaseSession.executeQuery(string2);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() > 1) {
            Trace.logInfo((String)"ServersDb:getServerId", (String)"Too many matches");
            throw new ExceptionRequestFailed();
        }
        if (dBaseRequestQueryResults.getRowCount() <= 0) {
            Trace.logInfo((String)"ServersDb:getServerId", (String)"No server of requested name");
            return 0;
        }
        dBaseRequestQueryResults.nextRow();
        return dBaseRequestQueryResults.getInt(1);
    }

    public static ServerInfo createServerInfo(DBaseRequestQueryResults dBaseRequestQueryResults) throws ExceptionRequestFailed {
        int n = dBaseRequestQueryResults.getInt(ID);
        String string = dBaseRequestQueryResults.getString(NAME);
        String string2 = dBaseRequestQueryResults.getString(TYPE);
        String string3 = dBaseRequestQueryResults.getString(ICON);
        String string4 = dBaseRequestQueryResults.getString(CUSTOM_FIELD1);
        String string5 = dBaseRequestQueryResults.getString(CUSTOM_FIELD2);
        String string6 = dBaseRequestQueryResults.getString(CUSTOM_FIELD3);
        String string7 = dBaseRequestQueryResults.getString(BROWSER_URL);
        String string8 = dBaseRequestQueryResults.getString(DESCRIPTION);
        String string9 = dBaseRequestQueryResults.getString(CONTACT);
        String string10 = dBaseRequestQueryResults.getString(CONTACT_PHONE);
        String string11 = dBaseRequestQueryResults.getString(COMMENT);
        int n2 = dBaseRequestQueryResults.getInt(CACHED_CRED);
        int n3 = dBaseRequestQueryResults.getInt(APP_INDEX);
        ServerInfo serverInfo = new ServerInfo(n, string, string2, string3, n3);
        try {
            serverInfo.setCustomField(1, string4);
            serverInfo.setCustomField(2, string5);
            serverInfo.setCustomField(3, string6);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            throw new ExceptionRequestFailed();
        }
        serverInfo.setBrowserURL(string7);
        serverInfo.setDescription(string8);
        serverInfo.setContact(string9);
        serverInfo.setContactPhone(string10);
        serverInfo.setComment(string11);
        serverInfo.setCredentialsCacheMode(n2);
        return serverInfo;
    }

    public static String getBrowserUrl(int n) throws ExceptionRequestFailed {
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        stringBuffer.append(BROWSER_URL).append(" FROM ").append(SERVERS).append(" WHERE (ID=").append(Integer.toString(n)).append(");");
        int n2 = DatabaseSession.executeQuery(stringBuffer.toString());
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            return null;
        }
        dBaseRequestQueryResults.nextRow();
        String string = dBaseRequestQueryResults.getString(1);
        return string;
    }

    public static void setBrowserUrl(int n, String string) throws ExceptionRequestFailed {
        StringBuffer stringBuffer = new StringBuffer("UPDATE ");
        stringBuffer.append(SERVERS).append(" SET ").append(BROWSER_URL).append("=").append(SqlCmd.quote((String)string)).append(" WHERE (ID=").append(Integer.toString(n)).append(");");
        int n2 = DatabaseSession.executeUpdate(stringBuffer.toString());
        if (n2 != 1) {
            throw new ExceptionRequestFailed("Unable to save browser URL value to SERVERS table.");
        }
    }

    public static void setApplinaceMibIndex(int n, int n2) throws ExceptionRequestFailed {
        StringBuffer stringBuffer = new StringBuffer("UPDATE ");
        stringBuffer.append(SERVERS).append(" SET ").append(APP_INDEX).append("=").append(Integer.toString(n2)).append(" WHERE (ID=").append(Integer.toString(n)).append(");");
        int n3 = DatabaseSession.executeUpdate(stringBuffer.toString());
        if (n3 != 1) {
            throw new ExceptionRequestFailed("Unable to save App Index value to SERVERS table.");
        }
    }

    public static ServerInfo[] getServerList() throws ExceptionRequestFailed, ExceptionNoValue {
        return ServersDb.getServerList(null);
    }

    public static ServerInfo[] getServerList(String string) throws ExceptionRequestFailed, ExceptionNoValue {
        Object[] objectArray;
        int n;
        Vector<ServerInfo> vector = new Vector<ServerInfo>();
        String string2 = string == null || string.length() == 0 ? "SELECT * FROM SERVERS;" : "SELECT * FROM SERVERS " + string + ";";
        int n2 = DatabaseSession.executeQuery(string2);
        while ((n = (objectArray = DatabaseSession.getQueryResults(n2, 3)).getRowCount()) != 0) {
            for (int i = 1; i <= n; ++i) {
                objectArray.nextRow();
                int n3 = objectArray.getInt(ID);
                String string3 = objectArray.getString(NAME);
                String string4 = objectArray.getString(TYPE);
                String string5 = objectArray.getString(ICON);
                String string6 = objectArray.getString(CUSTOM_FIELD1);
                String string7 = objectArray.getString(CUSTOM_FIELD2);
                String string8 = objectArray.getString(CUSTOM_FIELD3);
                String string9 = objectArray.getString(BROWSER_URL);
                String string10 = objectArray.getString(DESCRIPTION);
                String string11 = objectArray.getString(CONTACT);
                String string12 = objectArray.getString(CONTACT_PHONE);
                String string13 = objectArray.getString(COMMENT);
                int n4 = objectArray.getInt(CACHED_CRED);
                int n5 = objectArray.getInt(APP_INDEX);
                ServerInfo serverInfo = new ServerInfo(n3, string3, string4, string5, n5);
                try {
                    serverInfo.setCustomField(1, string6);
                    serverInfo.setCustomField(2, string7);
                    serverInfo.setCustomField(3, string8);
                }
                catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                    throw new ExceptionRequestFailed();
                }
                serverInfo.setBrowserURL(string9);
                serverInfo.setDescription(string10);
                serverInfo.setContact(string11);
                serverInfo.setContactPhone(string12);
                serverInfo.setComment(string13);
                serverInfo.setCredentialsCacheMode(n4);
                vector.add(serverInfo);
            }
            if (objectArray.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n2);
        if (vector.size() == 0) {
            Trace.logInfo((String)"ServersDb:getServerList", (String)"No values were available");
            throw new ExceptionNoValue();
        }
        objectArray = new ServerInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean createServersTable() {
        Trace.logInfo((String)"ServersDb", (String)"Creating SERVERS table");
        try {
            DatabaseUtilities.createTable((TableDefinition)m_tdTableDefinition, (Connection)AVWorksService.getConnection());
            return true;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"ServersDb", (String)"Failed to create SERVERS table");
            return false;
        }
    }

    public static String getServerName(int n) throws ExceptionRequestFailed {
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        stringBuffer.append(NAME).append(" FROM ").append(SERVERS).append(" WHERE (ID=").append(Integer.toString(n)).append(");");
        int n2 = DatabaseSession.executeQuery(stringBuffer.toString());
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            return null;
        }
        dBaseRequestQueryResults.nextRow();
        String string = dBaseRequestQueryResults.getString(1);
        return string;
    }

    public static String getValue(int n, String string) throws ExceptionRequestFailed {
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        stringBuffer.append(string).append(" FROM SERVERS WHERE (ID=").append(Integer.toString(n)).append(");");
        int n2 = DatabaseSession.executeQuery(stringBuffer.toString());
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 1);
        DatabaseSession.closeQuery(n2);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            return null;
        }
        dBaseRequestQueryResults.nextRow();
        return dBaseRequestQueryResults.getString(string);
    }

    public static void setCacheMode(int n, int n2) throws ExceptionRequestFailed {
        StringBuffer stringBuffer = new StringBuffer("UPDATE SERVERS SET ");
        stringBuffer.append(CACHED_CRED).append("=").append(Integer.toString(n2));
        if (n != -1) {
            stringBuffer.append(" WHERE (ID=").append(Integer.toString(n)).append(");");
        }
        Trace.logInfo((String)"ServersDb:setCacheMode", (String)("query: " + stringBuffer.toString()));
        int n3 = DatabaseSession.executeQuery(stringBuffer.toString());
        if (n3 < 1) {
            Trace.logError((String)"ServersDb:setCacheMode", (String)"Failed to set cache mode for all devices!");
            throw new ExceptionRequestFailed();
        }
    }

    static {
        m_tdTableDefinition.addColumn(ID, "INTEGER", null, true);
        m_tdTableDefinition.addColumn(NAME, "VARCHAR", null);
        m_tdTableDefinition.addColumn(TYPE, "VARCHAR", null);
        m_tdTableDefinition.addColumn(ICON, "VARCHAR", null);
        m_tdTableDefinition.addColumn(CUSTOM_FIELD1, "VARCHAR", null);
        m_tdTableDefinition.addColumn(CUSTOM_FIELD2, "VARCHAR", null);
        m_tdTableDefinition.addColumn(CUSTOM_FIELD3, "VARCHAR", null);
        m_tdTableDefinition.addColumn(BROWSER_URL, "VARCHAR", null);
        m_tdTableDefinition.addColumn(DESCRIPTION, "VARCHAR", null);
        m_tdTableDefinition.addColumn(CONTACT, "VARCHAR", null);
        m_tdTableDefinition.addColumn(CONTACT_PHONE, "VARCHAR", null);
        m_tdTableDefinition.addColumn(COMMENT, "VARCHAR", null);
        m_tdTableDefinition.addColumn(CACHED_CRED, "INTEGER", (Object)new Integer(1));
        m_tdTableDefinition.addColumn(APP_INDEX, "INTEGER", (Object)new Integer(0));
    }
}

