/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.AppliancePropertiesDb;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.OptionsDb;
import com.avocent.avworks.services.ServerInfo;
import com.avocent.avworks.services.ServerPropertiesDb;
import com.avocent.avworks.services.ServersDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionFileNotFound;
import com.avocent.lib.exceptions.ExceptionFileNotReadable;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionNotAFile;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.JDialogElapsedTime;
import com.avocent.lib.gui.dialogs.JDialogLogin;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.CachedCredentials;
import com.avocent.lib.util.ExecuteCmd;
import com.avocent.lib.util.ObserverHint;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.UsernamePassword;
import com.avocent.ssh2.JFrameSSH;
import com.avocent.telnet.JFrameTelnet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Observable;
import java.util.Observer;

public class TelnetHelper
extends Observable
implements Observer,
ActionListener {
    public static final String CNAME = "TelnetHelper";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.services.Res");
    private static final String TRACE_CONTEXT = "TelnetHelper";
    public static final int DEFAULT_TELNET_PORT_NUMBER = 23;
    public static final String TELNET_VIEWER_INTERFACE = "com.avocent.avworks.services.InterfaceViewerAVWorks";
    public static final String SSH_VIEWER_INTERFACE = "com.avocent.avworks.services.InterfaceViewerAVWorks";
    public static final int LAUNCH_STATUS_SUCCESS = 0;
    public static final int LAUNCH_STATUS_ERROR_HANDLED = 1;
    private static final int LAUNCH_STATUS_UNEXPECTED_ERROR = 2;
    private static final int LAUNCH_STATUS_MISSING_UNIT_PROPERTIES = 3;
    private static final int LAUNCH_STATUS_MISSING_SYSTEM_PROPERTIES = 4;
    private static final int LAUNCH_STATUS_USER_CANCELLED = 5;
    public static final String MACRO_INDICATOR = "%";
    public static final int MACRO_LENGTH = 2;
    public static final String IP_ADDRESS_MACRO = "%I";
    public static final String PORT_NUMBER_MACRO = "%P";
    public static final String USERNAME_MACRO = "%U";
    public static final String PASSWORD_MACRO = "%W";
    public static final int HINT_AUTHENTICATION_COMPLETED = 1;
    public static final int SSH_SESSION = 1;
    public static final int TELNET_SESSION = 2;
    private Frame m_fParent = null;
    private String m_szUnitId = null;
    private int m_nUnitId = -1;
    private String m_szUnitType = null;
    private String m_szIpAddress = null;
    private String m_szLoginScriptKey = null;
    private String m_szCliAccessCharacter = null;
    private boolean m_bShowFrameAtLogin = false;
    private String m_szUnitName = null;
    private UsernamePassword m_upCredentials = null;
    private int m_nPort = -1;
    private JDialogElapsedTime m_jdetProgress = null;
    private boolean m_bCancelOfProgressPressed = false;
    private boolean m_bUseBuiltIn = true;
    private boolean m_bTelnetRunning = false;
    private String m_szTelnetCmd = null;
    private String m_szTelnetArgs = null;
    private boolean m_bLaunchInCommandWindow = false;
    private boolean m_bTelnetAction = true;
    private JFrameTelnet m_jftTelnet = null;

    public TelnetHelper(Frame frame, String string, String string2, JDialogElapsedTime jDialogElapsedTime) throws ExceptionConstructorFailed {
        if (string2 == null || string2.length() <= 0 || !string2.equals("Appliance") && !string2.equals("Device") && !string2.equals("PORT")) {
            Trace.logError((String)"TelnetHelper", (String)("ERROR : Invalid Unit Type passed [" + string2 + "]"));
            throw new ExceptionConstructorFailed();
        }
        this.m_fParent = frame;
        this.m_szUnitId = string;
        this.m_szUnitType = string2;
        this.m_jdetProgress = jDialogElapsedTime;
        this.m_szLoginScriptKey = null;
        this.m_szCliAccessCharacter = null;
        this.m_szIpAddress = null;
        this.m_nPort = -1;
        if (this.m_szUnitType.equals("Appliance") || this.m_szUnitType.equals("Device")) {
            try {
                this.m_nUnitId = Integer.parseInt(this.m_szUnitId);
            }
            catch (NumberFormatException numberFormatException) {
                Trace.logError((String)"TelnetHelper", (String)("Unable to parse unit id as an integer[" + this.m_szUnitId + "]"));
                throw new ExceptionConstructorFailed("Unable to parse unit id.", (Throwable)numberFormatException);
            }
        }
        if (this.m_jdetProgress != null) {
            this.m_jdetProgress.addListener((ActionListener)this);
        }
        Trace.logInfo((String)"TelnetHelper", (String)("TelnetHelper called with UnitId[" + string + "]" + "UnitType[" + string2 + "]" + "ProgressDialog[" + jDialogElapsedTime.toString() + "]"));
    }

    public TelnetHelper(Frame frame, String string, String string2, JDialogElapsedTime jDialogElapsedTime, String string3, String string4) throws ExceptionConstructorFailed {
        if (string2 == null || string2.length() <= 0 || !string2.equals("Appliance") && !string2.equals("Device") && !string2.equals("PORT")) {
            Trace.logError((String)"TelnetHelper", (String)("ERROR : Invalid Unit Type passed [" + string2 + "]"));
            throw new ExceptionConstructorFailed();
        }
        if (string2.equals("PORT")) {
            Trace.logError((String)"TelnetHelper", (String)"Unit type of Port not supported with this constructor");
            throw new ExceptionConstructorFailed();
        }
        this.m_fParent = frame;
        this.m_szUnitId = string;
        this.m_szUnitType = string2;
        this.m_jdetProgress = jDialogElapsedTime;
        this.m_szLoginScriptKey = string3;
        this.m_szCliAccessCharacter = string4;
        this.m_szIpAddress = null;
        this.m_nPort = -1;
        if (this.m_szUnitType.equals("Appliance") || this.m_szUnitType.equals("Device")) {
            try {
                this.m_nUnitId = Integer.parseInt(this.m_szUnitId);
            }
            catch (NumberFormatException numberFormatException) {
                Trace.logError((String)"TelnetHelper", (String)("Unable to parse unit id as an integer[" + this.m_szUnitId + "]"));
                throw new ExceptionConstructorFailed("Unable to parse unit id.", (Throwable)numberFormatException);
            }
        }
        if (this.m_jdetProgress != null) {
            this.m_jdetProgress.addListener((ActionListener)this);
        }
        Trace.logInfo((String)"TelnetHelper", (String)("TelnetHelper called with UnitId[" + string + "]" + "UnitType[" + string2 + "]" + "ProgressDialog[" + jDialogElapsedTime.toString() + "]" + "LoginScriptKey[" + string3 + "]" + "CliAccessCharacter[" + string4 + "]"));
    }

    public TelnetHelper(Frame frame, String string, String string2, String string3, String string4, int n, JDialogElapsedTime jDialogElapsedTime, String string5, boolean bl, String string6) throws ExceptionConstructorFailed {
        if (string2 == null || string2.length() <= 0 || !string2.equals("Appliance") && !string2.equals("Device") && !string2.equals("PORT")) {
            Trace.logError((String)"TelnetHelper", (String)("ERROR : Invalid Unit Type passed [" + string2 + "]"));
            throw new ExceptionConstructorFailed();
        }
        if (string4 == null || string4.length() <= 0) {
            Trace.logError((String)"TelnetHelper", (String)("ERROR : Invalid IP Address passed [" + string4 + "]"));
            throw new ExceptionConstructorFailed();
        }
        if (n <= 0) {
            Trace.logError((String)"TelnetHelper", (String)("ERROR : Invalid Port passed [" + n + "]"));
            throw new ExceptionConstructorFailed();
        }
        this.m_fParent = frame;
        this.m_szUnitId = string;
        this.m_szUnitType = string2;
        this.m_szUnitName = string3;
        this.m_szIpAddress = string4;
        this.m_nPort = n;
        this.m_jdetProgress = jDialogElapsedTime;
        this.m_szLoginScriptKey = string5;
        this.m_bTelnetAction = bl;
        this.m_szCliAccessCharacter = string6;
        if (this.m_szUnitType.equals("Appliance") || this.m_szUnitType.equals("Device")) {
            try {
                this.m_nUnitId = Integer.parseInt(this.m_szUnitId);
            }
            catch (NumberFormatException numberFormatException) {
                Trace.logError((String)"TelnetHelper", (String)("Unable to parse unit id as an integer[" + this.m_szUnitId + "]"));
                throw new ExceptionConstructorFailed("Unable to parse unit id.", (Throwable)numberFormatException);
            }
        }
        if (string2.equals("PORT") && (this.m_szUnitName == null || this.m_szIpAddress == null || this.m_nPort <= 0)) {
            Trace.logError((String)"TelnetHelper", (String)"Additional data required when unit type of port used ");
            throw new ExceptionConstructorFailed();
        }
        if (this.m_jdetProgress != null) {
            this.m_jdetProgress.addListener((ActionListener)this);
        }
        Trace.logInfo((String)"TelnetHelper", (String)("TelnetHelper called with UnitId[" + string + "]" + "UnitType[" + string2 + "]" + "UnitName[" + string3 + "]" + "IpAddress[" + string4 + "]" + "Port[" + n + "]" + "ProgressDialog[" + jDialogElapsedTime.toString() + "]" + "LoginScriptKey[" + string5 + "]" + "TelnetAction[" + bl + "]" + "CliAccessCharacter[" + string6 + "]"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Trace.logInfo((String)"TelnetHelper", (String)"Cancel pressed in Progress Dialog...");
        this.m_bCancelOfProgressPressed = true;
        this.m_jdetProgress.removeListener((ActionListener)this);
        this.m_jdetProgress.setVisible(false);
    }

    public int launchViewer(boolean bl) {
        return this.launchViewer(bl, 2);
    }

    public int launchViewer(boolean bl, int n) {
        int n2;
        block26: {
            n2 = 0;
            if (this.m_bCancelOfProgressPressed) {
                Trace.logInfo((String)"TelnetHelper", (String)"User canceled operation");
                return 0;
            }
            n2 = this.determineNameIpAddressPort();
            if (n2 != 0) {
                Trace.logError((String)"TelnetHelper", (String)("ERROR : Unable to determine IP Address and Port to launch Telnet [" + n2 + "]"));
                this.showUnableToLaunch(null, null);
                return 1;
            }
            n2 = this.determineTelnetViewer();
            if (n2 == 5) {
                Trace.logInfo((String)"TelnetHelper", (String)"User canceled viewer launch");
                return 0;
            }
            if (n2 != 0) {
                Trace.logError((String)"TelnetHelper", (String)("ERROR : Unable to determine Telnet Viewer [" + n2 + "]"));
                this.showUnableToLaunch(null, null);
                return 1;
            }
            if (this.isUseBuiltIn()) {
                try {
                    if (n == 2) {
                        Trace.logInfo((String)"TelnetHelper", (String)("Launching Telnet with IPAddress[" + this.m_szIpAddress + "]" + "Port[" + this.m_nPort + "]" + "UnitName[" + this.m_szUnitName + "]" + "UnitId[" + this.m_szUnitId + "]" + "UnitType[" + this.m_szUnitType + "]" + "TelnetViewerInt[" + "com.avocent.avworks.services.InterfaceViewerAVWorks" + "]" + "LoginScriptKey[" + this.m_szLoginScriptKey + "]" + "CliAccessCharacter[" + this.m_szCliAccessCharacter + "]" + "ShowFrame[" + this.m_bShowFrameAtLogin + "]" + "TelnetAction[" + this.m_bTelnetAction + "]" + "ProgressDialog[" + this.m_jdetProgress.toString() + "]"));
                        this.m_jftTelnet = new JFrameTelnet(this.m_fParent, this.m_szIpAddress, this.m_nPort, this.m_szUnitName, this.m_szUnitId, this.m_szUnitType, "com.avocent.avworks.services.InterfaceViewerAVWorks", this.m_szLoginScriptKey, this.m_szCliAccessCharacter, this.m_bShowFrameAtLogin, this.m_bTelnetAction, this.m_jdetProgress);
                    } else {
                        if (this.m_szUnitType.equalsIgnoreCase("Device")) {
                            this.m_nPort += 100;
                        } else if (this.m_szUnitType.equalsIgnoreCase("Appliance")) {
                            --this.m_nPort;
                        }
                        Trace.logInfo((String)"TelnetHelper", (String)("Launching SSH session with IPAddress[" + this.m_szIpAddress + "]" + "Port[" + this.m_nPort + "]" + "UnitName[" + this.m_szUnitName + "]" + "UnitId[" + this.m_szUnitId + "]" + "UnitType[" + this.m_szUnitType + "]" + "TelnetViewerInt[" + "com.avocent.avworks.services.InterfaceViewerAVWorks" + "]" + "LoginScriptKey[" + this.m_szLoginScriptKey + "]" + "CliAccessCharacter[" + this.m_szCliAccessCharacter + "]" + "ShowFrame[" + this.m_bShowFrameAtLogin + "]" + "TelnetAction[" + this.m_bTelnetAction + "]" + "ProgressDialog[" + this.m_jdetProgress.toString() + "]"));
                        this.m_jftTelnet = new JFrameSSH(this.m_fParent, this.m_szIpAddress, this.m_nPort, this.m_szUnitName, this.m_szUnitId, this.m_szUnitType, "com.avocent.avworks.services.InterfaceViewerAVWorks", this.m_szLoginScriptKey, this.m_szCliAccessCharacter, this.m_bShowFrameAtLogin, this.m_bTelnetAction, this.m_jdetProgress);
                    }
                    this.m_jftTelnet.addObserver((Observer)this);
                    this.setTelnetRunning(true);
                    if (this.m_jdetProgress != null) {
                        this.m_jdetProgress.removeListener((ActionListener)this);
                    }
                    if (this.m_bCancelOfProgressPressed) {
                        Trace.logInfo((String)"TelnetHelper", (String)"User canceled the operation before calling start");
                        this.setTelnetRunning(false);
                        return 0;
                    }
                    int n3 = n == 2 ? this.m_jftTelnet.startSerialConsoleViewer(bl) : ((JFrameSSH)this.m_jftTelnet).startSSH2Shell(bl);
                    this.setTelnetRunning(false);
                    if (n3 < 0) {
                        Trace.logInfo((String)"TelnetHelper", (String)("Serial Console Viewer exited with error [" + n3 + "]"));
                        this.showUnableToLaunch(null, null);
                        return 1;
                    }
                    break block26;
                }
                catch (ExceptionConstructorFailed exceptionConstructorFailed) {
                    Trace.logError((String)"TelnetHelper", (String)"ERROR : Unable to execute built in Telnet viewer", (Throwable)exceptionConstructorFailed);
                    this.setTelnetRunning(false);
                    this.showUnableToLaunch(null, null);
                    return 1;
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)"TelnetHelper", (String)"ERROR : Unable to execute built in Telnet viewer", (Throwable)exceptionRequestFailed);
                    this.setTelnetRunning(false);
                    this.showUnableToLaunch(null, null);
                    return 1;
                }
            }
            try {
                if (this.m_jdetProgress != null) {
                    this.m_jdetProgress.setVisible(false);
                    this.m_jdetProgress.removeListener((ActionListener)this);
                }
                if (this.m_bCancelOfProgressPressed) {
                    Trace.logInfo((String)"TelnetHelper", (String)"User canceled operation");
                    return 0;
                }
                Trace.logInfo((String)"TelnetHelper", (String)("Launching 3rd Party Telnet: TelnetCmd[" + this.m_szTelnetCmd + "] Args[" + this.m_szTelnetArgs + "]"));
                Trace.logInfo((String)"TelnetHelper", (String)"Notifying all observers");
                this.setChanged();
                this.notifyObservers(new ObserverHint(1, (Object)this));
                this.setTelnetRunning(true);
                int n4 = ExecuteCmd.execute((String)this.m_szTelnetCmd, (String)this.m_szTelnetArgs, (boolean)this.m_bLaunchInCommandWindow, (boolean)true);
                Trace.logInfo((String)"TelnetHelper", (String)("3rd Party Telnet Completed with " + n4));
                this.setTelnetRunning(false);
                if (n4 != 0) {
                    Trace.logError((String)"TelnetHelper", (String)("Problem launching 3rd Party Telnet. Error[" + n4 + "]"));
                    this.showUnableToLaunch("TelnetHelper_UnableToPerform_ErrorEncountered", new File(this.m_szTelnetCmd));
                    return 1;
                }
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"TelnetHelper", (String)"ERROR : Unable to execute command", (Throwable)exceptionRequestFailed);
                this.setTelnetRunning(false);
                if (this.m_bLaunchInCommandWindow) {
                    this.showUnableToLaunch("TelnetHelper_UnableToPerform_InvalidCmdWindow", null);
                } else {
                    this.showUnableToLaunch("TelnetHelper_UnableToPerform_ErrorEncountered", new File(this.m_szTelnetCmd));
                }
                return 1;
            }
            catch (ExceptionFileNotFound exceptionFileNotFound) {
                Trace.logError((String)"TelnetHelper", (String)"ERROR : Command not found", (Throwable)exceptionFileNotFound);
                this.setTelnetRunning(false);
                this.showUnableToLaunch("TelnetHelper_UnableToPerform_FileNotFound", exceptionFileNotFound.getFile());
                return 1;
            }
            catch (ExceptionNotAFile exceptionNotAFile) {
                Trace.logError((String)"TelnetHelper", (String)"ERROR : Command not a file", (Throwable)exceptionNotAFile);
                this.setTelnetRunning(false);
                this.showUnableToLaunch("TelnetHelper_UnableToPerform_NotAFile", exceptionNotAFile.getFile());
                return 1;
            }
            catch (ExceptionFileNotReadable exceptionFileNotReadable) {
                Trace.logError((String)"TelnetHelper", (String)"ERROR : Command file not readable", (Throwable)exceptionFileNotReadable);
                this.setTelnetRunning(false);
                this.showUnableToLaunch("TelnetHelper_UnableToPerform_FileNotReadable", exceptionFileNotReadable.getFile());
                return 1;
            }
        }
        return n2;
    }

    public void update(Observable observable, Object object) {
        Trace.logInfo((String)"TelnetHelper", (String)"Observer Notification Received");
        if (object != null && object instanceof ObserverHint) {
            ObserverHint observerHint = (ObserverHint)object;
            if (this.m_jftTelnet != null && observerHint.getHintObject() == this.m_jftTelnet) {
                if (observerHint.getHint() == 1 || observerHint.getHint() == 2) {
                    Trace.logInfo((String)"TelnetHelper", (String)"Notifying all observers");
                    this.setChanged();
                    this.notifyObservers(new ObserverHint(1, (Object)this));
                } else {
                    Trace.logInfo((String)"TelnetHelper", (String)("JFrameTelnet hint=" + observerHint.getHint()));
                }
            }
        } else {
            Trace.logInfo((String)"TelnetHelper", (String)"Unexpected object passed with Notification");
        }
    }

    public boolean isUserSpecifiedRunning() {
        return this.isTelnetRunning() && !this.isUseBuiltIn();
    }

    private void setUseBuiltIn(boolean bl) {
        this.m_bUseBuiltIn = bl;
    }

    private boolean isUseBuiltIn() {
        return this.m_bUseBuiltIn;
    }

    private void setTelnetRunning(boolean bl) {
        this.m_bTelnetRunning = bl;
    }

    private boolean isTelnetRunning() {
        return this.m_bTelnetRunning;
    }

    private int determineNameIpAddressPort() {
        try {
            if (this.m_szUnitType.equals("Appliance")) {
                ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo(this.m_nUnitId);
                if (this.m_szUnitName == null) {
                    this.m_szUnitName = applianceInfo.getName();
                }
                if (this.m_nPort <= 0) {
                    this.m_nPort = AppliancePropertiesDb.getIntegerValue(this.m_nUnitId, "TELNET_PORT", 23);
                    this.m_szIpAddress = applianceInfo.getAddress();
                }
            } else if (this.m_szUnitType.equals("Device")) {
                ServerInfo serverInfo = ServersDb.getServerInfo(this.m_nUnitId);
                if (this.m_szUnitName == null) {
                    this.m_szUnitName = serverInfo.getName();
                }
                if (this.m_nPort <= 0) {
                    this.m_nPort = ServerPropertiesDb.getIntegerValue(this.m_nUnitId, "TELNET_PORT", 23);
                    this.m_szIpAddress = ServerPropertiesDb.getStringValue(this.m_nUnitId, "TELNET_IP", null);
                }
            } else if (!this.m_szUnitType.equals("PORT")) {
                Trace.logError((String)"TelnetHelper", (String)("ERROR : Invalid Unit Type [" + this.m_szUnitType + "]"));
                return 2;
            }
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logError((String)"TelnetHelper", (String)"ERROR : Unable to get unit information", (Throwable)exceptionNoValue);
            return 2;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"TelnetHelper", (String)"ERROR : Request Failed, unable to get properties", (Throwable)exceptionRequestFailed);
            return 3;
        }
        if (this.m_szUnitName == null || this.m_szIpAddress == null || this.m_nPort <= 0) {
            Trace.logError((String)"TelnetHelper", (String)"ERROR : Invalid properties for Telnet");
            return 3;
        }
        return 0;
    }

    private int determineTelnetViewer() {
        boolean bl;
        int n;
        block6: {
            n = 0;
            bl = false;
            try {
                if (this.m_szUnitType.equals("Appliance")) {
                    bl = AppliancePropertiesDb.getBooleanValue(this.m_nUnitId, "TELNET_USE_DEFAULT", true);
                    break block6;
                }
                if (this.m_szUnitType.equals("Device")) {
                    bl = ServerPropertiesDb.getBooleanValue(this.m_nUnitId, "TELNET_USE_DEFAULT", true);
                    break block6;
                }
                if (this.m_szUnitType.equals("PORT")) {
                    bl = true;
                    break block6;
                }
                Trace.logError((String)"TelnetHelper", (String)("ERROR : Invalid Unit Type [" + this.m_szUnitType + "]"));
                return 2;
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"TelnetHelper", (String)"ERROR : Request Failed, unable to unit property - UseDefault", (Throwable)exceptionRequestFailed);
                return 3;
            }
        }
        n = bl ? this.getSystemDefinedTelnetProperties() : this.getUnitDefinedTelnetProperties();
        if (n == 0 && !this.isUseBuiltIn()) {
            n = this.expandCommandLineMacros();
        }
        return n;
    }

    private int expandCommandLineMacros() {
        int n;
        StringBuffer stringBuffer;
        block16: {
            if (this.m_szTelnetArgs == null) {
                Trace.logInfo((String)"TelnetHelper", (String)"No Telnet Arguments, no substitution");
                return 0;
            }
            stringBuffer = new StringBuffer(this.m_szTelnetArgs);
            if ((stringBuffer.indexOf(USERNAME_MACRO) >= 0 || stringBuffer.indexOf(PASSWORD_MACRO) >= 0) && this.m_upCredentials == null) {
                if (CachedCredentials.getUsername().length() <= 0) {
                    this.m_upCredentials = new UsernamePassword();
                    try {
                        JDialogLogin jDialogLogin = new JDialogLogin(this.m_fParent, res.getString("TelnetHelper_UserLoginTitle"), this.m_upCredentials);
                        jDialogLogin.setModal(true);
                        jDialogLogin.setVisible(true);
                        if (!jDialogLogin.wasOkPressed()) {
                            Trace.logInfo((String)"TelnetHelper", (String)"User cancelled login");
                            return 5;
                        }
                        break block16;
                    }
                    catch (ExceptionConstructorFailed exceptionConstructorFailed) {
                        Trace.logError((String)"TelnetHelper", (String)"ERROR : Unable to prompt for User Credentials", (Throwable)exceptionConstructorFailed);
                        return 2;
                    }
                }
                this.m_upCredentials = CachedCredentials.getCredentials();
            }
        }
        if (this.m_upCredentials == null) {
            this.m_upCredentials = new UsernamePassword("", "");
        }
        Trace.logInfo((String)"TelnetHelper", (String)("Arg String before substitution [" + this.m_szTelnetArgs + "]"));
        int n2 = 0;
        String string = null;
        while ((n = stringBuffer.indexOf(MACRO_INDICATOR, n2)) >= 0) {
            String string2;
            try {
                string = stringBuffer.substring(n, n + 2);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                Trace.logInfo((String)"TelnetHelper", (String)("Index out of bounds % at end. Index[" + n + "] length[" + stringBuffer.length() + "]"));
                break;
            }
            Trace.logInfo((String)"TelnetHelper", (String)("Processing macro [" + string + "]"));
            if (string.equals(IP_ADDRESS_MACRO)) {
                stringBuffer = stringBuffer.replace(n, n + 2, this.m_szIpAddress);
                n2 = n + this.m_szIpAddress.length();
                continue;
            }
            if (string.equals(PORT_NUMBER_MACRO)) {
                string2 = String.valueOf(this.m_nPort);
                stringBuffer = stringBuffer.replace(n, n + 2, string2);
                n2 = n + string2.length();
                continue;
            }
            if (string.equals(USERNAME_MACRO)) {
                string2 = this.m_upCredentials.getUsername();
                if (string2 == null) {
                    string2 = "";
                }
                stringBuffer = stringBuffer.replace(n, n + 2, string2);
                n2 = n + string2.length();
                continue;
            }
            if (string.equals(PASSWORD_MACRO)) {
                string2 = this.m_upCredentials.getPassword();
                if (string2 == null) {
                    string2 = "";
                }
                stringBuffer = stringBuffer.replace(n, n + 2, string2);
                n2 = n + string2.length();
                continue;
            }
            n2 = n + string.length();
        }
        this.m_szTelnetArgs = stringBuffer.toString();
        Trace.logInfo((String)"TelnetHelper", (String)("Arg String after substitution [" + this.m_szTelnetArgs + "]"));
        return 0;
    }

    public static String getDefaultLaunchString() throws ExceptionRequestFailed {
        return OptionsDb.getStringValue("TELNET_APPLICATION", null);
    }

    public static void setDefaultLaunchString(String string) throws ExceptionRequestFailed {
        OptionsDb.setValue("TELNET_APPLICATION", string);
    }

    public static String getDefaultCommandLine() throws ExceptionRequestFailed {
        return OptionsDb.getStringValue("TELNET_APPLICATION_ARGS", null);
    }

    public static void setDefaultCommandLine(String string) throws ExceptionRequestFailed {
        OptionsDb.setValue("TELNET_APPLICATION_ARGS", string);
    }

    public static String getUnitLaunchString(String string, String string2) throws ExceptionRequestFailed {
        String string3 = null;
        int n = -1;
        if (string2 == null) {
            Trace.logError((String)"TelnetHelper", (String)"ERROR : Unit Type passed is null");
            throw new ExceptionRequestFailed();
        }
        if (string2.equals("PORT")) {
            Trace.logInfo((String)"TelnetHelper", (String)"Port Type, no launch strings, null returned");
            return null;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.logError((String)"TelnetHelper", (String)("Unable to parse unit id as an integer[" + string + "]"));
            throw new ExceptionRequestFailed((Throwable)numberFormatException);
        }
        if (string2.equals("Appliance")) {
            string3 = AppliancePropertiesDb.getStringValue(n, "TELNET_APPLICATION", null);
        } else if (string2.equals("Device")) {
            string3 = ServerPropertiesDb.getStringValue(n, "TELNET_APPLICATION", null);
        } else {
            Trace.logError((String)"TelnetHelper", (String)("ERROR : Invalid Unit Type [" + string2 + "]"));
            throw new ExceptionRequestFailed();
        }
        return string3;
    }

    public static void setUnitLaunchString(String string, String string2, String string3) throws ExceptionRequestFailed {
        int n = -1;
        if (string2 == null) {
            Trace.logError((String)"TelnetHelper", (String)"ERROR : Unit Type passed is null");
            throw new ExceptionRequestFailed();
        }
        if (string2.equals("PORT")) {
            Trace.logError((String)"TelnetHelper", (String)"Port Type, storage of launch strings not supported");
            throw new ExceptionRequestFailed();
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.logError((String)"TelnetHelper", (String)("Unable to parse unit id as an integer[" + string + "]"));
            throw new ExceptionRequestFailed((Throwable)numberFormatException);
        }
        if (string2.equals("Appliance")) {
            AppliancePropertiesDb.setValue(n, "TELNET_APPLICATION", string3);
        } else if (string2.equals("Device")) {
            ServerPropertiesDb.setValue(n, "TELNET_APPLICATION", string3);
        } else {
            Trace.logError((String)"TelnetHelper", (String)("ERROR : Invalid Unit Type [" + string2 + "]"));
            throw new ExceptionRequestFailed();
        }
    }

    public static String getUnitCommandLine(String string, String string2) throws ExceptionRequestFailed {
        String string3 = null;
        int n = -1;
        if (string2 == null) {
            Trace.logError((String)"TelnetHelper", (String)"ERROR : Unit Type passed is null");
            throw new ExceptionRequestFailed();
        }
        if (string2.equals("PORT")) {
            Trace.logInfo((String)"TelnetHelper", (String)"Port Type, no command line strings, null returned");
            return null;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.logError((String)"TelnetHelper", (String)("Unable to parse unit id as an integer[" + string + "]"));
            throw new ExceptionRequestFailed((Throwable)numberFormatException);
        }
        if (string2.equals("Appliance")) {
            string3 = AppliancePropertiesDb.getStringValue(n, "TELNET_APPLICATION_ARGS", null);
        } else if (string2.equals("Device")) {
            string3 = ServerPropertiesDb.getStringValue(n, "TELNET_APPLICATION_ARGS", null);
        } else {
            Trace.logError((String)"TelnetHelper", (String)("ERROR : Invalid Unit Type [" + string2 + "]"));
            throw new ExceptionRequestFailed();
        }
        return string3;
    }

    public static void setUnitCommandLine(String string, String string2, String string3) throws ExceptionRequestFailed {
        int n = -1;
        if (string2 == null) {
            Trace.logError((String)"TelnetHelper", (String)"ERROR : Unit Type passed is null");
            throw new ExceptionRequestFailed();
        }
        if (string2.equals("PORT")) {
            Trace.logError((String)"TelnetHelper", (String)"Port Type, storage of command line strings not supported");
            throw new ExceptionRequestFailed();
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.logError((String)"TelnetHelper", (String)("Unable to parse unit id as an integer[" + string + "]"));
            throw new ExceptionRequestFailed((Throwable)numberFormatException);
        }
        if (string2.equals("Appliance")) {
            AppliancePropertiesDb.setValue(n, "TELNET_APPLICATION_ARGS", string3);
        } else if (string2.equals("Device")) {
            ServerPropertiesDb.setValue(n, "TELNET_APPLICATION_ARGS", string3);
        } else {
            Trace.logError((String)"TelnetHelper", (String)("ERROR : Invalid Unit Type [" + string2 + "]"));
            throw new ExceptionRequestFailed();
        }
    }

    private int getSystemDefinedTelnetProperties() {
        try {
            this.setUseBuiltIn(OptionsDb.getBooleanValue("TELNET_USE_BUILTIN", true));
            if (!this.isUseBuiltIn()) {
                this.m_szTelnetCmd = TelnetHelper.getDefaultLaunchString();
                this.m_szTelnetArgs = TelnetHelper.getDefaultCommandLine();
                this.m_bLaunchInCommandWindow = OptionsDb.getBooleanValue("TELNET_LAUNCH_IN_WINDOW", false);
            } else {
                this.m_bShowFrameAtLogin = OptionsDb.getBooleanValue("TELNET_SHOW_LOGIN_WINDOW", false);
            }
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"TelnetHelper", (String)"ERROR : Request Failed, unable to system option proterties for Telnet", (Throwable)exceptionRequestFailed);
            return 4;
        }
        if (!this.isUseBuiltIn() && this.m_szTelnetCmd == null) {
            Trace.logError((String)"TelnetHelper", (String)"ERROR : Request Failed, unable to system option properties for Telnet");
            return 4;
        }
        return 0;
    }

    private int getUnitDefinedTelnetProperties() {
        block9: {
            try {
                if (this.m_szUnitType.equals("Appliance")) {
                    this.setUseBuiltIn(AppliancePropertiesDb.getBooleanValue(this.m_nUnitId, "TELNET_USE_BUILTIN", true));
                    if (!this.isUseBuiltIn()) {
                        this.m_szTelnetCmd = TelnetHelper.getUnitLaunchString(this.m_szUnitId, this.m_szUnitType);
                        this.m_szTelnetArgs = TelnetHelper.getUnitCommandLine(this.m_szUnitId, this.m_szUnitType);
                        this.m_bLaunchInCommandWindow = AppliancePropertiesDb.getBooleanValue(this.m_nUnitId, "TELNET_LAUNCH_IN_WINDOW", false);
                    } else {
                        this.m_bShowFrameAtLogin = AppliancePropertiesDb.getBooleanValue(this.m_nUnitId, "TELNET_SHOW_LOGIN_WINDOW", false);
                    }
                    break block9;
                }
                if (this.m_szUnitType.equals("Device")) {
                    this.setUseBuiltIn(ServerPropertiesDb.getBooleanValue(this.m_nUnitId, "TELNET_USE_BUILTIN", true));
                    if (!this.isUseBuiltIn()) {
                        this.m_szTelnetCmd = TelnetHelper.getUnitLaunchString(this.m_szUnitId, this.m_szUnitType);
                        this.m_szTelnetArgs = TelnetHelper.getUnitCommandLine(this.m_szUnitId, this.m_szUnitType);
                        this.m_bLaunchInCommandWindow = ServerPropertiesDb.getBooleanValue(this.m_nUnitId, "TELNET_LAUNCH_IN_WINDOW", false);
                    } else {
                        this.m_bShowFrameAtLogin = ServerPropertiesDb.getBooleanValue(this.m_nUnitId, "TELNET_SHOW_LOGIN_WINDOW", false);
                    }
                    break block9;
                }
                Trace.logError((String)"TelnetHelper", (String)("ERROR : Invalid Unit Type [" + this.m_szUnitType + "]"));
                return 2;
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"TelnetHelper", (String)"ERROR : Request Failed, unable to unit properties for Telnet", (Throwable)exceptionRequestFailed);
                return 3;
            }
        }
        if (!this.isUseBuiltIn() && this.m_szTelnetCmd == null) {
            Trace.logError((String)"TelnetHelper", (String)"ERROR : Request Failed, unable to unit properties for Telnet");
            return 3;
        }
        return 0;
    }

    private void showUnableToLaunch(String string, File file) {
        Object[] objectArray = null;
        Trace.logInfo((String)"TelnetHelper", (String)"Problem launching Telnet/SCV via Telnet Helper");
        if (string == null) {
            string = "TelnetHelper_UnableToConnect";
        }
        if (this.m_bCancelOfProgressPressed) {
            Trace.logInfo((String)"TelnetHelper", (String)("User canceled operation, no need to show error [" + string + "]"));
            return;
        }
        String string2 = res.getString(string);
        String string3 = null;
        string3 = this.m_bTelnetAction ? res.getString("TelnetHelper_TelnetAction") : AVWorksBranding.getString("ConnectSerialLabel", res.getString("TelnetHelper_Default_ConnectSerialLabel"));
        if (this.m_jdetProgress != null) {
            this.m_jdetProgress.setVisible(false);
        }
        objectArray = file == null ? new Object[]{string3} : new Object[]{string3, file.getPath()};
        string2 = MessageFormat.format(string2, objectArray);
        Message.show((Component)this.m_fParent, (String)string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Trace.startLogging(null);
        try {
            AVWorksService.start();
            JDialogElapsedTime jDialogElapsedTime = new JDialogElapsedTime(null, "It me!!", "We be busy..");
            int n = 17;
            String string = "Device";
            TelnetHelper telnetHelper = new TelnetHelper(null, "" + n, string, jDialogElapsedTime);
            telnetHelper.launchViewer(false);
            string = "did we exit launch...";
        }
        catch (Exception exception) {
            Trace.logError((String)"TelnetHelper", (String)("Error Reason = " + exception.getMessage()));
        }
        finally {
            AVWorksService.shutdown();
        }
    }
}

