/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.ServersDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.net.MacAddress;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Vector;

public class Unit {
    private static final String TRACE_CONTEXT = "Unit";
    private static final String ESCAPE_STRING = "\\";

    public static String getUniqueName(String string) throws ExceptionRequestFailed {
        return Unit.getUniqueName(string, new String[0]);
    }

    public static String getUniqueName(String string, String[] stringArray) throws ExceptionRequestFailed {
        String string2 = string;
        if (string2.length() > 32) {
            string2 = string2.substring(0, 32);
        }
        if (Unit.isUnique(string2, stringArray)) {
            return string2;
        }
        int n = 0;
        int n2 = 200;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(2);
        do {
            String string3;
            String string4;
            if (n++ < 99) {
                string4 = "~" + numberFormat.format(n);
            } else {
                Date date = new Date();
                long l = date.getTime();
                string4 = "~" + l;
            }
            int n3 = string2.length() + string4.length();
            if (n3 > 32) {
                int n4 = 32 - string4.length();
                String string5 = string2.substring(0, n4);
                string3 = string5 + string4;
            } else {
                string3 = string2 + string4;
            }
            if (!Unit.isUnique(string3, stringArray)) continue;
            return string3;
        } while (n <= n2);
        throw new ExceptionRequestFailed();
    }

    public static boolean isUnique(String string, String[] stringArray) throws ExceptionRequestFailed {
        if (string.length() == 0) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return false;
        }
        if (AppliancesDb.isNameDefined(string)) {
            return false;
        }
        return !ServersDb.isNameDefined(string);
    }

    public static String createDefaultApplianceName(String string, MacAddress macAddress) {
        String string2 = macAddress.getString().substring(9);
        string2 = string2.replace(':', '-');
        String string3 = string + " " + string2;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Default Appliance Name=" + string3));
        return string3;
    }

    public static String escapeCharacters(String string, String string2) {
        if (string2 == null) {
            return string2;
        }
        String string3 = string + ESCAPE_STRING;
        StringBuffer stringBuffer = new StringBuffer(string2);
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (string3.indexOf(stringBuffer.charAt(i)) >= 0) {
                stringBuffer2.append(ESCAPE_STRING);
            }
            stringBuffer2.append(stringBuffer.charAt(i));
        }
        return stringBuffer2.toString();
    }

    public static String unescapeCharacters(String string) {
        if (string == null) {
            return string;
        }
        String string2 = ESCAPE_STRING;
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (bl) {
                bl = false;
            } else if (string2.indexOf(stringBuffer.charAt(i)) >= 0) {
                bl = true;
                continue;
            }
            stringBuffer2.append(stringBuffer.charAt(i));
        }
        return stringBuffer2.toString();
    }

    public static String[] splitEscapedString(char c, String string) {
        if (string == null) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        String string2 = ESCAPE_STRING;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (bl) {
                bl = false;
                continue;
            }
            if (string2.indexOf(stringBuffer.charAt(i)) >= 0) {
                bl = true;
                continue;
            }
            if (stringBuffer.charAt(i) != c) continue;
            if (i == n) {
                vector.add(new String(""));
            } else {
                vector.add(stringBuffer.substring(n, i));
            }
            n = i + 1;
        }
        if (n < stringBuffer.length()) {
            vector.add(stringBuffer.substring(n));
        } else if (n == stringBuffer.length()) {
            vector.add(new String(""));
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = Unit.unescapeCharacters((String)vector.get(i));
        }
        return stringArray;
    }

    public static String createUnitIdForPort(int n, String string) {
        String string2 = Unit.escapeCharacters(":", string);
        return String.valueOf(n) + ":" + string2;
    }

    public static String createPreferenceKeyForPort(String string, String string2) {
        String string3 = Unit.escapeCharacters(":", string);
        String string4 = Unit.escapeCharacters(":", string2);
        return string3 + ":" + string4;
    }

    public static String parsePortPreferenceKeyForKey(String string) {
        if (string == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Null Port Preference Key passed");
            return null;
        }
        String[] stringArray = Unit.splitEscapedString(':', string);
        if (stringArray.length != 2) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable to split Port Preference Key " + string));
            return null;
        }
        return stringArray[1];
    }

    public static int parsePortUnitIdForAppId(String string) {
        if (string == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Null Unit Id passed");
            return -1;
        }
        String[] stringArray = Unit.splitEscapedString(':', string);
        if (stringArray.length != 2) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable to split Unit Id " + string));
            return -1;
        }
        try {
            return Integer.valueOf(stringArray[0]);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable parse appliance id " + stringArray[0]));
            return -1;
        }
    }

    public static String parsePortUnitIdForConnPath(String string) {
        if (string == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Null Unit Id passed");
            return null;
        }
        String[] stringArray = Unit.splitEscapedString(':', string);
        if (stringArray.length != 2) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable to split Unit Id " + string));
            return null;
        }
        return stringArray[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Trace.startLogging(null);
        try {
            String string = Unit.escapeCharacters(":", "ab:cd");
            int n = string.length();
            string = Unit.escapeCharacters(":", string);
            n = string.length();
            string = Unit.unescapeCharacters(string);
            n = string.length();
            string = Unit.unescapeCharacters(string);
            String string2 = "a:a";
            String string3 = "B:B";
            String string4 = "c:C";
            String string5 = Unit.escapeCharacters(":", string2) + ":" + Unit.escapeCharacters(":", string3) + ":" + Unit.escapeCharacters(":", string4) + ":";
            String[] stringArray2 = Unit.splitEscapedString(':', string5);
            stringArray2 = Unit.splitEscapedString(':', "xx:zz:zz");
            int n2 = stringArray2.length;
            stringArray2 = Unit.splitEscapedString(':', ":");
            n2 = stringArray2.length;
            stringArray2 = Unit.splitEscapedString(':', "xx::zz");
            n2 = stringArray2.length;
            stringArray2 = Unit.splitEscapedString(':', "xx:yy:zz:");
            n2 = stringArray2.length;
            stringArray2 = Unit.splitEscapedString(':', "");
            n2 = stringArray2.length;
            stringArray2 = Unit.splitEscapedString(':', null);
            n2 = stringArray2.length;
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Error Reason = " + exception.getMessage()));
        }
    }
}

